/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Shuffle$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.RandomIndicesGenerator;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array) - Returns a random permutation of the given array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 20, 3, 5));\n       [3,1,5,20]\n      > SELECT _FUNC_(array(1, 20, null, 3));\n       [20,null,3,1]\n  ", note="\n    The function is non-deterministic.\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tec\u0001B\u0014)\u0001VB\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003U\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015Y\u0006\u0001\"\u0001a\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u00159\u0007\u0001\"\u0011N\u0011\u0015A\u0007\u0001\"\u0011j\u0011!a\u0007\u0001#b\u0001\n\u0003\u001a\u0007\"B7\u0001\t\u0003r\u0007bBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\u0007\u0003\u001b\u0001A\u0011B2\t\u0015\u0005=\u0001\u0001#b\u0001\n\u0003\t)\u0001C\u0006\u0002\u001a\u0001\u0001\r\u0011!Q!\n\u0005m\u0001bBA\u0015\u0001\u0011E\u00131\u0006\u0005\b\u0003{\u0001A\u0011KA \u0011\u001d\t\u0019\u0006\u0001C)\u0003+Bq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002\u000e\u0002!\t%a$\t\u0013\u0005U\u0005!!A\u0005\u0002\u0005]\u0005\"CAO\u0001E\u0005I\u0011AAP\u0011%\t)\fAI\u0001\n\u0003\t9\fC\u0005\u0002<\u0002\t\t\u0011\"\u0011\u0002>\"I\u0011Q\u001a\u0001\u0002\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003#\u0004\u0011\u0011!C\u0001\u0003'D\u0011\"!7\u0001\u0003\u0003%\t%a7\t\u0013\u0005%\b!!A\u0005\u0002\u0005-\b\"CAx\u0001\u0005\u0005I\u0011IAy\u000f%\u0011Y\u0002KA\u0001\u0012\u0003\u0011iB\u0002\u0005(Q\u0005\u0005\t\u0012\u0001B\u0010\u0011\u0019Yv\u0004\"\u0001\u0003.!I!qF\u0010\u0002\u0002\u0013\u0015#\u0011\u0007\u0005\n\u0005gy\u0012\u0011!CA\u0005kA\u0011Ba\u000f #\u0003%\t!a.\t\u0013\tur$!A\u0005\u0002\n}\u0002\"\u0003B'?E\u0005I\u0011AA\\\u0011%\u0011yeHA\u0001\n\u0013\u0011\tFA\u0004TQV4g\r\\3\u000b\u0005%R\u0013aC3yaJ,7o]5p]NT!a\u000b\u0017\u0002\u0011\r\fG/\u00197zgRT!!\f\u0018\u0002\u0007M\fHN\u0003\u00020a\u0005)1\u000f]1sW*\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h\u0007\u0001\u0019r\u0001\u0001\u001c;{\u0001\u001b\u0015\n\u0005\u00028q5\t\u0001&\u0003\u0002:Q\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00028w%\u0011A\b\u000b\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001c?\u0013\ty\u0004F\u0001\tO_:$W\r^3s[&t\u0017n\u001d;jGB\u0011q'Q\u0005\u0003\u0005\"\u0012\u0001$\u0012=qe\u0016\u001c8/[8o/&$\bNU1oI>l7+Z3e!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0012&\n\u0005-+%\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#\u0001(\u0011\u0005]z\u0015B\u0001))\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u0015I\fg\u000eZ8n'\u0016,G-F\u0001U!\r!UkV\u0005\u0003-\u0016\u0013aa\u00149uS>t\u0007C\u0001#Y\u0013\tIVI\u0001\u0003M_:<\u0017a\u0003:b]\u0012|WnU3fI\u0002\na\u0001P5oSRtDcA/_?B\u0011q\u0007\u0001\u0005\u0006\u0019\u0016\u0001\rA\u0014\u0005\b%\u0016\u0001\n\u00111\u0001U)\ti\u0016\rC\u0003M\r\u0001\u0007a*\u0001\u0005ti\u0006$XMZ;m+\u0005!\u0007C\u0001#f\u0013\t1WIA\u0004C_>dW-\u00198\u0002\u001dM,W\rZ#yaJ,7o]5p]\u0006Yq/\u001b;i\u001d\u0016<8+Z3e)\ti&\u000eC\u0003l\u0013\u0001\u0007q+\u0001\u0003tK\u0016$\u0017\u0001\u0003:fg>dg/\u001a3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001p!\r\u0001\bp\u001f\b\u0003cZt!A];\u000e\u0003MT!\u0001\u001e\u001b\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0015BA<F\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001f>\u0003\u0007M+\u0017O\u0003\u0002x\u000bB\u0011Ap`\u0007\u0002{*\u0011a\u0010L\u0001\u0006if\u0004Xm]\u0005\u0004\u0003\u0003i(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,WCAA\u0004!\ra\u0018\u0011B\u0005\u0004\u0003\u0017i(\u0001\u0003#bi\u0006$\u0016\u0010]3\u00025I,7/\u001e7u\u0003J\u0014\u0018-_#mK6,g\u000e\u001e(vY2\f'\r\\3\u0002\u0017\u0015dW-\\3oiRK\b/\u001a\u0015\u0004\u001d\u0005M\u0001c\u0001#\u0002\u0016%\u0019\u0011qC#\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018A\u0002:b]\u0012|W\u000e\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\tCK\u0001\u0005kRLG.\u0003\u0003\u0002&\u0005}!A\u0006*b]\u0012|W.\u00138eS\u000e,7oR3oKJ\fGo\u001c:)\u0007=\t\u0019\"\u0001\nj]&$\u0018.\u00197ju\u0016Le\u000e^3s]\u0006dG\u0003BA\u0017\u0003g\u00012\u0001RA\u0018\u0013\r\t\t$\u0012\u0002\u0005+:LG\u000fC\u0004\u00026A\u0001\r!a\u000e\u0002\u001dA\f'\u000f^5uS>t\u0017J\u001c3fqB\u0019A)!\u000f\n\u0007\u0005mRIA\u0002J]R\fA\"\u001a<bY&sG/\u001a:oC2$B!!\u0011\u0002HA\u0019A)a\u0011\n\u0007\u0005\u0015SIA\u0002B]fDq!!\u0013\u0012\u0001\u0004\tY%A\u0003j]B,H\u000f\u0005\u0003\u0002N\u0005=S\"\u0001\u0016\n\u0007\u0005E#FA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t9&a\u0019\u0002nA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^!\nqaY8eK\u001e,g.\u0003\u0003\u0002b\u0005m#\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u0015$\u00031\u0001\u0002h\u0005\u00191\r\u001e=\u0011\t\u0005e\u0013\u0011N\u0005\u0005\u0003W\nYF\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005=$\u00031\u0001\u0002X\u0005\u0011QM^\u0001\u0014g\",hM\u001a7f\u0003J\u0014\u0018-_\"pI\u0016<UM\u001c\u000b\t\u0003k\n))a\"\u0002\nB!\u0011qOA@\u001d\u0011\tI(a\u001f\u0011\u0005I,\u0015bAA?\u000b\u00061\u0001K]3eK\u001aLA!!!\u0002\u0004\n11\u000b\u001e:j]\u001eT1!! F\u0011\u001d\t)g\u0005a\u0001\u0003OBq!a\u001c\u0014\u0001\u0004\t9\u0006C\u0004\u0002\fN\u0001\r!!\u001e\u0002\u0013\rD\u0017\u000e\u001c3OC6,\u0017\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002^\u0003#Ca!a%\u0015\u0001\u0004q\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0006;\u0006e\u00151\u0014\u0005\b\u0019V\u0001\n\u00111\u0001O\u0011\u001d\u0011V\u0003%AA\u0002Q\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\"*\u001aa*a),\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a,F\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\u000bIKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002:*\u001aA+a)\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\f\u0005\u0003\u0002B\u0006-WBAAb\u0015\u0011\t)-a2\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\fAA[1wC&!\u0011\u0011QAb\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u0013Q\u001b\u0005\n\u0003/T\u0012\u0011!a\u0001\u0003o\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAo!\u0019\ty.!:\u0002B5\u0011\u0011\u0011\u001d\u0006\u0004\u0003G,\u0015AC2pY2,7\r^5p]&!\u0011q]Aq\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0011\fi\u000fC\u0005\u0002Xr\t\t\u00111\u0001\u0002B\u00051Q-];bYN$2\u0001ZAz\u0011%\t9.HA\u0001\u0002\u0004\t\t\u0005K\f\u0001\u0003o\fi0a@\u0003\u0004\t\u0015!\u0011\u0002B\u0006\u0005\u001f\u0011\tB!\u0006\u0003\u0018A\u0019q'!?\n\u0007\u0005m\bFA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t\u0005\u0011\u0001Q0G+:\u001bu\fK1se\u0006L\u0018\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004#/\u00198e_6\u0004\u0003/\u001a:nkR\fG/[8oA=4\u0007\u0005\u001e5fA\u001dLg/\u001a8!CJ\u0014\u0018-\u001f\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\u0002\u0002\u0003GQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113a1\u00023\u0007\f\u00116S%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u001a-c1*DF\r\u0019^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0019-A9,H\u000e\u001c\u0017!g%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.3a1rW\u000f\u001c7-g1\nTL\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\t5\u0011A\u000b\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG:R\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005'\t1\"\u0019:sCf|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!\u0011D\u0001\u0006e9\"d\u0006M\u0001\b'\",hM\u001a7f!\t9td\u0005\u0003 \u0005CI\u0005c\u0002B\u0012\u0005SqE+X\u0007\u0003\u0005KQ1Aa\nF\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u000b\u0003&\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\tu\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0016!B1qa2LH#B/\u00038\te\u0002\"\u0002'#\u0001\u0004q\u0005b\u0002*#!\u0003\u0005\r\u0001V\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003\u0002B!\u0005\u0013\u0002B\u0001R+\u0003DA)AI!\u0012O)&\u0019!qI#\u0003\rQ+\b\u000f\\33\u0011!\u0011Y\u0005JA\u0001\u0002\u0004i\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1B]3bIJ+7o\u001c7wKR\u0011!1\u000b\t\u0005\u0003\u0003\u0014)&\u0003\u0003\u0003X\u0005\r'AB(cU\u0016\u001cG\u000f")
public class Shuffle
extends UnaryExpression
implements ExpectsInputTypes,
Nondeterministic,
ExpressionWithRandomSeed,
scala.Serializable {
    private boolean resolved;
    private transient DataType elementType;
    private final Expression child;
    private final Option<Object> randomSeed;
    private transient RandomIndicesGenerator random;
    private final Seq<Enumeration.Value> nodePatterns;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Object> $lessinit$greater$default$2() {
        return Shuffle$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Object>>> unapply(Shuffle shuffle) {
        return Shuffle$.MODULE$.unapply(shuffle);
    }

    public static Option<Object> apply$default$2() {
        return Shuffle$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Option<Object>>, Shuffle> tupled() {
        return Shuffle$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Object>, Shuffle>> curried() {
        return Shuffle$.MODULE$.curried();
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private boolean deterministic$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Expression seedExpression() {
        return (Expression)this.randomSeed().map((Function1 & Serializable & scala.Serializable)v -> Literal$.MODULE$.apply(v)).getOrElse((Function0 & Serializable & scala.Serializable)() -> UnresolvedSeed$.MODULE$);
    }

    @Override
    public Shuffle withNewSeed(long seed) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)seed));
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<Object>)x$1);
    }

    private boolean resolved$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.dataType()).containsNull();
    }

    private DataType elementType$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (!this.bitmap$trans$0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = true;
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        if (!this.bitmap$trans$0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.random = new RandomIndicesGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        Object value = this.child().eval(input);
        if (value == null) {
            return null;
        }
        ArrayData source = (ArrayData)value;
        int numElements = source.numElements();
        int[] indices = this.random.getNextIndices(numElements);
        return new GenericArrayData(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).map((Function1 & Serializable & scala.Serializable)x$26 -> source.get(BoxesRunTime.unboxToInt((Object)x$26), this.elementType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object())));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> this.shuffleArrayCodeGen(ctx, ev, (String)c));
    }

    private String shuffleArrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String randomClass;
        String x$1 = randomClass = RandomIndicesGenerator.class.getName();
        String x$2 = "rand";
        boolean x$3 = true;
        Function1<String, String> x$4 = ctx.addMutableState$default$3();
        boolean x$5 = ctx.addMutableState$default$5();
        String rand = ctx.addMutableState(x$1, x$2, x$4, x$3, x$5);
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rand).append(" = new ").append(randomClass).append("(").append(this.randomSeed().get()).append("L + partitionIndex);").toString());
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String indices = ctx.freshName("indices");
        String i = ctx.freshName("i");
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, this.elementType(), numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, this.elementType(), childName, i, new StringBuilder(2).append(indices).append("[").append(i).append("]").toString(), this.resultArrayElementNullable());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n       |int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |int[] ").append(indices).append(" = ").append(rand).append(".getNextIndices(").append(numElements).append(");\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public Shuffle withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Shuffle copy(Expression child, Option<Object> randomSeed) {
        return new Shuffle(child, randomSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Object> copy$default$2() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Shuffle";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.randomSeed();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Shuffle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Shuffle)) return false;
        boolean bl = true;
        if (!bl) return false;
        Shuffle shuffle = (Shuffle)x$1;
        Expression expression = this.child();
        Expression expression2 = shuffle.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = shuffle.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!shuffle.canEqual(this)) return false;
        return true;
    }

    public Shuffle(Expression child, Option<Object> randomSeed) {
        this.child = child;
        this.randomSeed = randomSeed;
        ExpectsInputTypes.$init$(this);
        Nondeterministic.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
    }

    public Shuffle(Expression child) {
        this(child, (Option<Object>)None$.MODULE$);
    }
}

