/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Reverse$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array) - Returns a reversed string or an array with reverse order of elements.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       LQS krapS\n      > SELECT _FUNC_(array(2, 1, 4, 3));\n       [3,4,1,2]\n  ", group="collection_funcs", since="1.5.0", note="\n    Reverse logic for arrays is available since 2.4.0.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u000f\u001f\u0001.B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\")\u0011\n\u0001C\u0001\u0015\")Q\n\u0001C!\u001d\")\u0001\r\u0001C!C\")Q\r\u0001C\u0005M\")!\u000e\u0001C!W\"A\u0011\u000f\u0001EC\u0002\u0013%!\u000fC\u0003{\u0001\u0011\u00053\u0010C\u0004\u0002\u0014\u0001!I!!\u0006\t\u000f\u00055\u0002\u0001\"\u0003\u00020!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA\u001e\u0001\u0011E\u0013Q\b\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000bB\u0011\"!\u0013\u0001#\u0003%\t!a\u0013\t\u0013\u0005\u0005\u0004!!A\u0005B\u0005\r\u0004\"CA:\u0001\u0005\u0005I\u0011AA;\u0011%\ti\bAA\u0001\n\u0003\ty\bC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0011\u0002\b\"I\u0011Q\u0013\u0001\u0002\u0002\u0013\u0005\u0011q\u0013\u0005\n\u00037\u0003\u0011\u0011!C!\u0003;;\u0011\"a2\u001f\u0003\u0003E\t!!3\u0007\u0011uq\u0012\u0011!E\u0001\u0003\u0017Da!S\f\u0005\u0002\u0005e\u0007\"CAn/\u0005\u0005IQIAo\u0011%\tynFA\u0001\n\u0003\u000b\t\u000fC\u0005\u0002f^\t\t\u0011\"!\u0002h\"I\u00111_\f\u0002\u0002\u0013%\u0011Q\u001f\u0002\b%\u00164XM]:f\u0015\ty\u0002%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0011#\u0003!\u0019\u0017\r^1msN$(BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011C\u0002\u0001-aMR\u0004\t\u0005\u0002.]5\ta$\u0003\u00020=\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002.c%\u0011!G\b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011Ag\u000e\b\u0003[UJ!A\u000e\u0010\u0002\u000fA\f7m[1hK&\u0011\u0001(\u000f\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t1d\u0004\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDHA\u0004Qe>$Wo\u0019;\u0011\u0005m\n\u0015B\u0001\"=\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005)\u0005CA\u0017G\u0013\t9eD\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002L\u0019B\u0011Q\u0006\u0001\u0005\u0006\u0007\u000e\u0001\r!R\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A(\u0011\u0007A;&L\u0004\u0002R-:\u0011!+V\u0007\u0002'*\u0011AKK\u0001\u0007yI|w\u000e\u001e \n\u0003uJ!A\u000e\u001f\n\u0005aK&aA*fc*\u0011a\u0007\u0010\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\n\nQ\u0001^=qKNL!a\u0018/\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\t\u0004\"aW2\n\u0005\u0011d&\u0001\u0003#bi\u0006$\u0016\u0010]3\u00025I,7/\u001e7u\u0003J\u0014\u0018-_#mK6,g\u000e\u001e(vY2\f'\r\\3\u0016\u0003\u001d\u0004\"a\u000f5\n\u0005%d$a\u0002\"p_2,\u0017M\\\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0003Y>\u0004\"aO7\n\u00059d$aA!os\")\u0001o\u0002a\u0001Y\u0006)\u0011N\u001c9vi\u0006IAm\u001c*fm\u0016\u00148/Z\u000b\u0002gB!1\b\u001e7m\u0013\t)HHA\u0005Gk:\u001cG/[8oc!\u0012\u0001b\u001e\t\u0003waL!!\u001f\u001f\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0015a\u0018QAA\b!\ri\u0018\u0011A\u0007\u0002}*\u0011qPH\u0001\bG>$WmZ3o\u0013\r\t\u0019A \u0002\t\u000bb\u0004(oQ8eK\"9\u0011qA\u0005A\u0002\u0005%\u0011aA2uqB\u0019Q0a\u0003\n\u0007\u00055aP\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005E\u0011\u00021\u0001}\u0003\t)g/A\u0007tiJLgnZ\"pI\u0016<UM\u001c\u000b\u0007\u0003/\t9#!\u000b\u0011\t\u0005e\u0011\u0011\u0005\b\u0005\u00037\ti\u0002\u0005\u0002Sy%\u0019\u0011q\u0004\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#!\n\u0003\rM#(/\u001b8h\u0015\r\ty\u0002\u0010\u0005\u0007\u0003#Q\u0001\u0019\u0001?\t\u000f\u0005-\"\u00021\u0001\u0002\u0018\u0005I1\r[5mI:\u000bW.Z\u0001\rCJ\u0014\u0018-_\"pI\u0016<UM\u001c\u000b\t\u0003/\t\t$a\r\u00026!9\u0011qA\u0006A\u0002\u0005%\u0001BBA\t\u0017\u0001\u0007A\u0010C\u0004\u0002,-\u0001\r!a\u0006\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u0018\u0005!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2aSA \u0011\u0019\t\t%\u0004a\u0001\u000b\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHcA&\u0002H!91I\u0004I\u0001\u0002\u0004)\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001bR3!RA(W\t\t\t\u0006\u0005\u0003\u0002T\u0005uSBAA+\u0015\u0011\t9&!\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAA.y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0013Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002fA!\u0011qMA9\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014\u0001\u00027b]\u001eT!!a\u001c\u0002\t)\fg/Y\u0005\u0005\u0003G\tI'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002xA\u00191(!\u001f\n\u0007\u0005mDHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002m\u0003\u0003C\u0011\"a!\u0013\u0003\u0003\u0005\r!a\u001e\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\tE\u0003\u0002\f\u0006EE.\u0004\u0002\u0002\u000e*\u0019\u0011q\u0012\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0014\u00065%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2aZAM\u0011!\t\u0019\tFA\u0001\u0002\u0004a\u0017AB3rk\u0006d7\u000fF\u0002h\u0003?C\u0001\"a!\u0016\u0003\u0003\u0005\r\u0001\u001c\u0015\u0018\u0001\u0005\r\u0016\u0011VAV\u0003_\u000b\t,!.\u00028\u0006m\u0016QXAa\u0003\u0007\u00042!LAS\u0013\r\t9K\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti+A+`\rVs5i\u0018\u0015beJ\f\u00170\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007E]3wKJ\u001cX\r\u001a\u0011tiJLgn\u001a\u0011pe\u0002\ng\u000eI1se\u0006L\be^5uQ\u0002\u0012XM^3sg\u0016\u0004sN\u001d3fe\u0002zg\rI3mK6,g\u000e^:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAZ\u0003\u0005\r!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t'R'\u0002Z'/\u00199T\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQIb\u0003%\r\u0017!i1\u00023'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u001bD\u0006\u000e\u00172YIj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005e\u0016\u0001E2pY2,7\r^5p]~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\ty,A\u00032]Ur\u0003'\u0001\u0003o_R,\u0017EAAc\u0003iR\u0001\u0005\t\u0011!%\u00164XM]:fA1|w-[2!M>\u0014\b%\u0019:sCf\u001c\b%[:!CZ\f\u0017\u000e\\1cY\u0016\u00043/\u001b8dK\u0002\u0012d\u0006\u000e\u00181])\u0001\u0003%A\u0004SKZ,'o]3\u0011\u00055:2\u0003B\f\u0002N\u0002\u0003b!a4\u0002V\u0016[UBAAi\u0015\r\t\u0019\u000eP\u0001\beVtG/[7f\u0013\u0011\t9.!5\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0002J\u0006AAo\\*ue&tw\r\u0006\u0002\u0002f\u0005)\u0011\r\u001d9msR\u00191*a9\t\u000b\rS\u0002\u0019A#\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011^Ax!\u0011Y\u00141^#\n\u0007\u00055HH\u0001\u0004PaRLwN\u001c\u0005\t\u0003c\\\u0012\u0011!a\u0001\u0017\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003o\u0004B!a\u001a\u0002z&!\u00111`A5\u0005\u0019y%M[3di\u0002")
public class Reverse
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Function1<Object, Object> doReverse;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(Reverse reverse) {
        return Reverse$.MODULE$.unapply(reverse);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Reverse, A> function1) {
        return Reverse$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Reverse> compose(Function1<A, Expression> function1) {
        return Reverse$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, ArrayType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.dataType()).containsNull();
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.doReverse().apply(input);
    }

    private Function1<Object, Object> doReverse$lzycompute() {
        Reverse reverse = this;
        synchronized (reverse) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.dataType();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        ArrayData arrayData = (ArrayData)input;
                        return new GenericArrayData(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(arrayData.toObjectArray(elementType))).reverse());
                    };
                } else if (StringType$.MODULE$.equals(dataType)) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$27 -> ((UTF8String)x$27).reverse();
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doReverse = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.doReverse;
    }

    private Function1<Object, Object> doReverse() {
        if (!this.bitmap$trans$0) {
            return this.doReverse$lzycompute();
        }
        return this.doReverse;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            DataType dataType = this.dataType();
            if (dataType instanceof StringType) {
                return this.stringCodeGen(ev, (String)c);
            }
            if (dataType instanceof ArrayType) {
                return this.arrayCodeGen(ctx, ev, (String)c);
            }
            throw new MatchError((Object)dataType);
        });
    }

    private String stringCodeGen(ExprCode ev, String childName) {
        return new StringBuilder(16).append(ev.value()).append(" = (").append(childName).append(").reverse();").toString();
    }

    private String arrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        DataType elementType = ((ArrayType)this.dataType()).elementType();
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, childName, i, j, this.resultArrayElementNullable());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n       |final int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  int ").append(j).append(" = ").append(numElements).append(" - ").append(i).append(" - 1;\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "reverse";
    }

    @Override
    public Reverse withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Reverse copy(Expression child) {
        return new Reverse(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Reverse";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Reverse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Reverse)) return false;
        boolean bl = true;
        if (!bl) return false;
        Reverse reverse = (Reverse)x$1;
        Expression expression = this.child();
        Expression expression2 = reverse.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!reverse.canEqual(this)) return false;
        return true;
    }

    public Reverse(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

