/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Mask$;
import org.apache.spark.sql.catalyst.expressions.QuinaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(input[, upperChar, lowerChar, digitChar, otherChar]) - masks the given string value.\n       The function replaces characters with 'X' or 'x', and numbers with 'n'.\n       This can be useful for creating copies of tables with sensitive information removed.\n      ", arguments="\n    Arguments:\n      * input      - string value to mask. Supported types: STRING, VARCHAR, CHAR\n      * upperChar  - character to replace upper-case characters with. Specify NULL to retain original character. Default value: 'X'\n      * lowerChar  - character to replace lower-case characters with. Specify NULL to retain original character. Default value: 'x'\n      * digitChar  - character to replace digit characters with. Specify NULL to retain original character. Default value: 'n'\n      * otherChar  - character to replace all other characters with. Specify NULL to retain original character. Default value: NULL\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('abcd-EFGH-8765-4321');\n        xxxx-XXXX-nnnn-nnnn\n      > SELECT _FUNC_('abcd-EFGH-8765-4321', 'Q');\n        xxxx-QQQQ-nnnn-nnnn\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q');\n        QqQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#');\n        XxXXnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q');\n        QxQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q');\n        QqQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q', 'd');\n        QqQQddd-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q', 'd', 'o');\n        QqQQdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, 'q', 'd', 'o');\n        AqCDdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, 'd', 'o');\n        AbCDdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, NULL, 'o');\n        AbCD123oooo\n      > SELECT _FUNC_(NULL, NULL, NULL, NULL, 'o');\n        NULL\n      > SELECT _FUNC_(NULL);\n        NULL\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, NULL, NULL);\n        AbCD123-@$#\n  ", since="3.4.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\tMg\u0001B\u001b7\u0001\u000eC\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\t?\u0002\u0011\t\u0012)A\u00059\"A\u0001\r\u0001BK\u0002\u0013\u00051\f\u0003\u0005b\u0001\tE\t\u0015!\u0003]\u0011!\u0011\u0007A!f\u0001\n\u0003Y\u0006\u0002C2\u0001\u0005#\u0005\u000b\u0011\u0002/\t\u0011\u0011\u0004!Q3A\u0005\u0002mC\u0001\"\u001a\u0001\u0003\u0012\u0003\u0006I\u0001\u0018\u0005\tM\u0002\u0011)\u001a!C\u00017\"Aq\r\u0001B\tB\u0003%A\fC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003i\u0001\u0011\u0005\u0001\u000fC\u0003i\u0001\u0011\u0005!\u000fC\u0003i\u0001\u0011\u0005Q\u000fC\u0003i\u0001\u0011\u0005\u0011\u0010C\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\u000e\u0001!\t%a\u0004\t\u000f\u0005U\u0002\u0001\"\u0011\u00028!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA*\u0001\u0011E\u0013Q\u000b\u0005\b\u0003c\u0002A\u0011KA:\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!!(\u0001\t\u0003\ny\nC\u0004\u0002$\u0002!\t&!*\t\u0013\u0005E\u0006!!A\u0005\u0002\u0005M\u0006\"CA`\u0001E\u0005I\u0011AAa\u0011%\t9\u000eAI\u0001\n\u0003\t\t\rC\u0005\u0002Z\u0002\t\n\u0011\"\u0001\u0002B\"I\u00111\u001c\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0019\u0005\n\u0003;\u0004\u0011\u0013!C\u0001\u0003\u0003D\u0011\"a8\u0001\u0003\u0003%\t%!9\t\u0013\u0005E\b!!A\u0005\u0002\u0005M\b\"CA~\u0001\u0005\u0005I\u0011AA\u007f\u0011%\u0011\u0019\u0001AA\u0001\n\u0003\u0012)\u0001C\u0005\u0003\u0014\u0001\t\t\u0011\"\u0001\u0003\u0016!I!\u0011\u0004\u0001\u0002\u0002\u0013\u0005#1D\u0004\b\u0005\u000b2\u0004\u0012\u0001B$\r\u0019)d\u0007#\u0001\u0003J!1\u0001N\nC\u0001\u0005#B\u0011Ba\u0015'\u0005\u0004%IA!\u0016\t\u0011\tuc\u0005)A\u0005\u0005/B\u0011Ba\u0018'\u0005\u0004%IA!\u0016\t\u0011\t\u0005d\u0005)A\u0005\u0005/B\u0011Ba\u0019'\u0005\u0004%IA!\u0016\t\u0011\t\u0015d\u0005)A\u0005\u0005/B\u0011Ba\u001a'\u0005\u0004%IA!\u001b\t\u0011\tEd\u0005)A\u0005\u0005WBqAa\u001d'\t\u0003\u0011)\bC\u0004\u0003\u0018\u001a\"IA!'\t\u0013\t\u001df%!A\u0005\u0002\n%\u0006\"\u0003B[M\u0005\u0005I\u0011\u0011B\\\u0011%\u0011IMJA\u0001\n\u0013\u0011YM\u0001\u0003NCN\\'BA\u001c9\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005eR\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005mb\u0014aA:rY*\u0011QHP\u0001\u0006gB\f'o\u001b\u0006\u0003\u007f\u0001\u000ba!\u00199bG\",'\"A!\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001!\u0005jS)X!\t)e)D\u00017\u0013\t9eGA\tRk&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!R%\n\u0005)3$!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011AjT\u0007\u0002\u001b*\u0011aJO\u0001\u0007KJ\u0014xN]:\n\u0005Ak%aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005I+V\"A*\u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0003\u000fA\u0013x\u000eZ;diB\u0011!\u000bW\u0005\u00033N\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fQ!\u001b8qkR,\u0012\u0001\u0018\t\u0003\u000bvK!A\u0018\u001c\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004j]B,H\u000fI\u0001\nkB\u0004XM]\"iCJ\f!\"\u001e9qKJ\u001c\u0005.\u0019:!\u0003%awn^3s\u0007\"\f'/\u0001\u0006m_^,'o\u00115be\u0002\n\u0011\u0002Z5hSR\u001c\u0005.\u0019:\u0002\u0015\u0011Lw-\u001b;DQ\u0006\u0014\b%A\u0005pi\",'o\u00115be\u0006Qq\u000e\u001e5fe\u000eC\u0017M\u001d\u0011\u0002\rqJg.\u001b;?)\u0019Q7\u000e\\7o_B\u0011Q\t\u0001\u0005\u00065.\u0001\r\u0001\u0018\u0005\u0006A.\u0001\r\u0001\u0018\u0005\u0006E.\u0001\r\u0001\u0018\u0005\u0006I.\u0001\r\u0001\u0018\u0005\u0006M.\u0001\r\u0001\u0018\u000b\u0003UFDQA\u0017\u0007A\u0002q#2A[:u\u0011\u0015QV\u00021\u0001]\u0011\u0015\u0001W\u00021\u0001])\u0011Qgo\u001e=\t\u000bis\u0001\u0019\u0001/\t\u000b\u0001t\u0001\u0019\u0001/\t\u000b\tt\u0001\u0019\u0001/\u0015\u000b)T8\u0010`?\t\u000bi{\u0001\u0019\u0001/\t\u000b\u0001|\u0001\u0019\u0001/\t\u000b\t|\u0001\u0019\u0001/\t\u000b\u0011|\u0001\u0019\u0001/\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d\u0001(\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tY!!\u0002\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t\t\u0002\u0005\u0004\u0002\u0014\u0005\r\u0012\u0011\u0006\b\u0005\u0003+\tyB\u0004\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYBQ\u0001\u0007yI|w\u000e\u001e \n\u0003QK1!!\tT\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\n\u0002(\t\u00191+Z9\u000b\u0007\u0005\u00052\u000b\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\tyCO\u0001\u0006if\u0004Xm]\u0005\u0005\u0003g\tiC\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-\u0006\u0002\u0002:A\u0019!+a\u000f\n\u0007\u0005u2KA\u0004C_>dW-\u00198\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003\u0007\nI\u0005E\u0002S\u0003\u000bJ1!a\u0012T\u0005\r\te.\u001f\u0005\t5N\u0001\n\u00111\u0001\u0002LA!\u0011QJA(\u001b\u0005A\u0014bAA)q\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002X\u0005\r\u0014Q\u000e\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011Q\f\u001c\u0002\u000f\r|G-Z4f]&!\u0011\u0011MA.\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA3)\u0001\u0007\u0011qM\u0001\u0004GRD\b\u0003BA-\u0003SJA!a\u001b\u0002\\\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA8)\u0001\u0007\u0011qK\u0001\u0003KZ\fqB\\;mYN\u000bg-Z\"pI\u0016<UM\u001c\u000b\t\u0003/\n)(a\u001e\u0002z!9\u0011QM\u000bA\u0002\u0005\u001d\u0004bBA8+\u0001\u0007\u0011q\u000b\u0005\b\u0003w*\u0002\u0019AA?\u0003\u00051\u0007c\u0004*\u0002\u0000\u0005\r\u00151QAB\u0003\u0007\u000b\u0019)a!\n\u0007\u0005\u00055KA\u0005Gk:\u001cG/[8okA!\u0011QQAG\u001d\u0011\t9)!#\u0011\u0007\u0005]1+C\u0002\u0002\fN\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAH\u0003#\u0013aa\u0015;sS:<'bAAF'\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u0018B!\u00111FAM\u0013\u0011\tY*!\f\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0003C\u0003R!a\u0005\u0002$q\u000bqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007)\f9\u000bC\u0004\u0002*b\u0001\r!a+\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0006\u0003'\ti\u000bX\u0005\u0005\u0003_\u000b9C\u0001\u0006J]\u0012,\u00070\u001a3TKF\fAaY8qsRY!.!.\u00028\u0006e\u00161XA_\u0011\u001dQ\u0016\u0004%AA\u0002qCq\u0001Y\r\u0011\u0002\u0003\u0007A\fC\u0004c3A\u0005\t\u0019\u0001/\t\u000f\u0011L\u0002\u0013!a\u00019\"9a-\u0007I\u0001\u0002\u0004a\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0007T3\u0001XAcW\t\t9\r\u0005\u0003\u0002J\u0006MWBAAf\u0015\u0011\ti-a4\u0002\u0013Ut7\r[3dW\u0016$'bAAi'\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00171\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nabY8qs\u0012\"WMZ1vYR$S'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003G\u0004B!!:\u0002p6\u0011\u0011q\u001d\u0006\u0005\u0003S\fY/\u0001\u0003mC:<'BAAw\u0003\u0011Q\u0017M^1\n\t\u0005=\u0015q]\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003k\u00042AUA|\u0013\r\tIp\u0015\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0007\ny\u0010C\u0005\u0003\u0002\u0005\n\t\u00111\u0001\u0002v\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0002\u0011\r\t%!qBA\"\u001b\t\u0011YAC\u0002\u0003\u000eM\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tBa\u0003\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003s\u00119\u0002C\u0005\u0003\u0002\r\n\t\u00111\u0001\u0002D\u00051Q-];bYN$B!!\u000f\u0003\u001e!I!\u0011\u0001\u0013\u0002\u0002\u0003\u0007\u00111\t\u0015\u0018\u0001\t\u0005\"q\u0005B\u0015\u0005[\u0011yCa\r\u00036\te\"1\bB \u0005\u0003\u00022!\u0012B\u0012\u0013\r\u0011)C\u000e\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011Y#\u0001B\u000e?\u001a+fjQ0)S:\u0004X\u000f^.-AU\u0004\b/\u001a:DQ\u0006\u0014H\u0006\t7po\u0016\u00148\t[1sY\u0001\"\u0017nZ5u\u0007\"\f'\u000f\f\u0011pi\",'o\u00115bevK\u0003%\f\u0011nCN\\7\u000f\t;iK\u0002:\u0017N^3oAM$(/\u001b8hAY\fG.^3/\u0015\u0001\u0002\u0003\u0005\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!e\u0016\u0004H.Y2fg\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011xSRD\u0007e\n-(A=\u0014\be\n=(Y\u0001\ng\u000e\u001a\u0011ok6\u0014WM]:!o&$\b\u000eI\u0014oO9R\u0001\u0005\t\u0011!A\u0001\u0002C\u000b[5tA\r\fg\u000e\t2fAU\u001cXMZ;mA\u0019|'\u000fI2sK\u0006$\u0018N\\4!G>\u0004\u0018.Z:!_\u001a\u0004C/\u00192mKN\u0004s/\u001b;iAM,gn]5uSZ,\u0007%\u001b8g_Jl\u0017\r^5p]\u0002\u0012X-\\8wK\u0012t#\u0002\t\u0011!A\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\u0011\t$\u0001Cp\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u0013N\u001c9vi\u0002\u0002\u0003\u0005\t\u0011![\u0001\u001aHO]5oO\u00022\u0018\r\\;fAQ|\u0007%\\1tW:\u00023+\u001e9q_J$X\r\u001a\u0011usB,7O\u000f\u0011T)JKej\u0012\u0017!-\u0006\u00136\tS!SY\u0001\u001a\u0005*\u0011*\u000bA\u0001\u0002\u0003\u0005\t\u0011+AU\u0004\b/\u001a:DQ\u0006\u0014\b\u0005I\u0017!G\"\f'/Y2uKJ\u0004Co\u001c\u0011sKBd\u0017mY3!kB\u0004XM]\u0017dCN,\u0007e\u00195be\u0006\u001cG/\u001a:tA]LG\u000f\u001b\u0018!'B,7-\u001b4zA9+F\n\u0014\u0011u_\u0002\u0012X\r^1j]\u0002z'/[4j]\u0006d\u0007e\u00195be\u0006\u001cG/\u001a:/A\u0011+g-Y;mi\u00022\u0018\r\\;fu\u0001:\u0003l\n\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Y><XM]\"iCJ\u0004\u0003%\f\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002\"x\u000e\t:fa2\f7-\u001a\u0011m_^,'/L2bg\u0016\u00043\r[1sC\u000e$XM]:!o&$\bN\f\u0011Ta\u0016\u001c\u0017NZ=!\u001dVcE\n\t;pAI,G/Y5oA=\u0014\u0018nZ5oC2\u00043\r[1sC\u000e$XM\u001d\u0018!\t\u00164\u0017-\u001e7uAY\fG.^3;A\u001dBxE\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011eS\u001eLGo\u00115be\u0002\u0002S\u0006I2iCJ\f7\r^3sAQ|\u0007E]3qY\u0006\u001cW\r\t3jO&$\be\u00195be\u0006\u001cG/\u001a:tA]LG\u000f\u001b\u0018!'B,7-\u001b4zA9+F\n\u0014\u0011u_\u0002\u0012X\r^1j]\u0002z'/[4j]\u0006d\u0007e\u00195be\u0006\u001cG/\u001a:/A\u0011+g-Y;mi\u00022\u0018\r\\;fu\u0001:cn\n\u0006!A\u0001\u0002\u0003\u0005\t\u0016!_RDWM]\"iCJ\u0004\u0003%\f\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002\"x\u000e\t:fa2\f7-\u001a\u0011bY2\u0004s\u000e\u001e5fe\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011xSRDg\u0006I*qK\u000eLg-\u001f\u0011O+2c\u0005\u0005^8!e\u0016$\u0018-\u001b8!_JLw-\u001b8bY\u0002\u001a\u0007.\u0019:bGR,'O\f\u0011EK\u001a\fW\u000f\u001c;!m\u0006dW/\u001a\u001e!\u001dVcEJ\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B\u001c\u0003\u001d}'\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014bE\u000e$W&\u0012$H\u00116BtGN\u001b.iM\u0012\u0014gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001B\b\u0010\u001f=.1bC\u0006,\f8o]:lcN\u001c8o\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013MY2e[\u00153u\tS\u00179oY*T\u0006N\u001a3c\u001db\u0003eJ)(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u001f=yq6\n\u0016+U).]:tg.\f8o]:T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ!c\u0007\u0012\u000b$gM\u0017AI\r:C\u0006I\u0014RO1\u0002s%]\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013+])R]:tW\u0006\u0011\u0013$\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013IY\"EcI\u001aT\u0006\u0011\u0013$O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t-y1bsgN\\\u0017AI\rR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ!c\u0007\u0012\u000b$gM\u0017AI\r:C\u0006I\u0014RO%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I)y#FsgN\\\u0017AI\rR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ!c\u0007\u0012\u000b$gM\u0017AI\r:C\u0006I\u0014RO1\u0002s%]\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013+])R]:tW\u0006\u0011\u0013$\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013IY\"EcI\u001aT\u0006\u0011\u0013$O1\u0002s%U\u0014-A\u001d\nx\u0005\f\u0011(I\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011RcF\u000bF\r\u001a3.\u0001\u0012\u001a#\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014BE\u000e#\u0015GM\u001a.\u0001\u0012\u001as\u0005\f\u0011(#\u001eb\u0003eJ9(Y\u0001:Cm\n\u0017!O=<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!#F\f\u0016\u000b\u001a3e_>|wN\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0003\n\u001cE)\r\u001a4[\u0001#3e\n\u0017!\u001dVcE\n\f\u0011(c\u001eb\u0003e\n3(Y\u0001:snJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n\u0015o\u0011#eI\u0012|wn\\8\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n%m\u0011#2eMj\u0003\tJ\u0012(Y\u0001rU\u000b\u0014'-A9+F\n\u0014\u0017!O\u0011<C\u0006I\u0014pO%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I!c\u0007\u0012#G\rZ8p_>T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ!c\u0007\u0012\u000b$gM\u0017AI\r:C\u0006\t(V\u00192c\u0003ET+M\u00192\u0002c*\u0016'MY\u0001:snJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n%m\u0011#2eMzwn\\8\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q9+F\n\u0014\u0017!\u001dVcE\n\f\u0011O+2cE\u0006\t(V\u00192c\u0003eJ8(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc*\u0016'MSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\u00112D\tF\u00124'\f!%G\u001db\u0003ET+M\u00192\u0002c*\u0016'MY\u0001rU\u000b\u0014'-A9+F\nT\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n%m\u0011#2eMj\u0003\tJ\u0012\u000bA\u0001\nQa]5oG\u0016\f#A!\u0010\u0002\u000bMrCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t\r\u0013\u0001D:ue&twm\u00184v]\u000e\u001c\u0018\u0001B'bg.\u0004\"!\u0012\u0014\u0014\t\u0019\u0012Ye\u0016\t\u0004%\n5\u0013b\u0001B('\n1\u0011I\\=SK\u001a$\"Aa\u0012\u0002!5\u000b5kS#E?V\u0003\u0006+\u0012*D\u0003N+UC\u0001B,!\r\u0011&\u0011L\u0005\u0004\u00057\u001a&\u0001B\"iCJ\f\u0011#T!T\u0017\u0016#u,\u0016)Q\u000bJ\u001b\u0015iU#!\u0003Ai\u0015iU&F\t~cujV#S\u0007\u0006\u001bV)A\tN\u0003N[U\tR0M\u001f^+%kQ!T\u000b\u0002\nA\"T!T\u0017\u0016#u\fR%H\u0013R\u000bQ\"T!T\u0017\u0016#u\fR%H\u0013R\u0003\u0013!D'B'.+EiX%H\u001d>\u0013V)\u0006\u0002\u0003lA\u0019!K!\u001c\n\u0007\t=4K\u0001\u0003Ok2d\u0017AD'B'.+EiX%H\u001d>\u0013V\tI\u0001\u000fiJ\fgn\u001d4pe6Le\u000e];u)1\u00119H!\"\u0003\b\n-%q\u0012BJ!\u0011\u0011IH!!\u000e\u0005\tm$\u0002BA\u0018\u0005{R1Aa =\u0003\u0019)hn]1gK&!!1\u0011B>\u0005))FK\u0012\u001dTiJLgn\u001a\u0005\u00075B\u0002\r!a\u0011\t\u000f\t%\u0005\u00071\u0001\u0002D\u0005IQ.Y:l+B\u0004XM\u001d\u0005\b\u0005\u001b\u0003\u0004\u0019AA\"\u0003%i\u0017m]6M_^,'\u000fC\u0004\u0003\u0012B\u0002\r!a\u0011\u0002\u00135\f7o\u001b#jO&$\bb\u0002BKa\u0001\u0007\u00111I\u0001\n[\u0006\u001c8n\u0014;iKJ\fQ\u0002\u001e:b]N4wN]7DQ\u0006\u0014H\u0003DA{\u00057\u0013yJ!)\u0003$\n\u0015\u0006b\u0002BOc\u0001\u0007!qK\u0001\u0002G\"9!\u0011R\u0019A\u0002\u0005\r\u0003b\u0002BGc\u0001\u0007\u00111\t\u0005\b\u0005#\u000b\u0004\u0019AA\"\u0011\u001d\u0011)*\ra\u0001\u0003\u0007\nQ!\u00199qYf$2B\u001bBV\u0005[\u0013yK!-\u00034\")!L\ra\u00019\")\u0001M\ra\u00019\")!M\ra\u00019\")AM\ra\u00019\")aM\ra\u00019\u00069QO\\1qa2LH\u0003\u0002B]\u0005\u000b\u0004RA\u0015B^\u0005\u007fK1A!0T\u0005\u0019y\u0005\u000f^5p]BA!K!1]9rcF,C\u0002\u0003DN\u0013a\u0001V;qY\u0016,\u0004\u0002\u0003Bdg\u0005\u0005\t\u0019\u00016\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bg!\u0011\t)Oa4\n\t\tE\u0017q\u001d\u0002\u0007\u001f\nTWm\u0019;")
public class Mask
extends QuinaryExpression
implements ExpectsInputTypes,
QueryErrorsBase,
scala.Serializable {
    private final Expression input;
    private final Expression upperChar;
    private final Expression lowerChar;
    private final Expression digitChar;
    private final Expression otherChar;

    public static Option<Tuple5<Expression, Expression, Expression, Expression, Expression>> unapply(Mask mask) {
        return Mask$.MODULE$.unapply(mask);
    }

    public static UTF8String transformInput(Object object, Object object2, Object object3, Object object4, Object object5) {
        return Mask$.MODULE$.transformInput(object, object2, object3, object4, object5);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    public Expression input() {
        return this.input;
    }

    public Expression upperChar() {
        return this.upperChar;
    }

    public Expression lowerChar() {
        return this.lowerChar;
    }

    public Expression digitChar() {
        return this.digitChar;
    }

    public Expression otherChar() {
        return this.otherChar;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheckResult = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheckResult.isSuccess()) {
            return (TypeCheckResult)((TraversableLike)((TraversableLike)new .colon.colon((Object)new Tuple2((Object)this.upperChar(), (Object)"upperChar"), (List)new .colon.colon((Object)new Tuple2((Object)this.lowerChar(), (Object)"lowerChar"), (List)new .colon.colon((Object)new Tuple2((Object)this.digitChar(), (Object)"digitChar"), (List)new .colon.colon((Object)new Tuple2((Object)this.otherChar(), (Object)"otherChar"), (List)Nil$.MODULE$))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Expression exp = (Expression)tuple2._1();
                    String message = (String)tuple2._2();
                    if (exp != null) {
                        Expression expression = exp;
                        if (message != null) {
                            String string = message;
                            return Option$.MODULE$.option2Iterable(this.checkInputDataType$1(expression, string));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultCheckResult);
        }
        return defaultCheckResult;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)))));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object eval(InternalRow input) {
        return Mask$.MODULE$.transformInput(((Expression)this.children().apply(0)).eval(input), ((Expression)this.children().apply(1)).eval(input), ((Expression)this.children().apply(2)).eval(input), ((Expression)this.children().apply(3)).eval(input), ((Expression)this.children().apply(4)).eval(input));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function5<String, String, String, String, String, String>)(Function5 & Serializable & scala.Serializable)(input, upperChar, lowerChar, digitChar, otherChar) -> new StringBuilder(72).append("org.apache.spark.sql.catalyst.expressions.Mask.").append("transformInput(").append((String)input).append(", ").append((String)upperChar).append(", ").append((String)lowerChar).append(", ").append((String)digitChar).append(", ").append((String)otherChar).append(");").toString());
    }

    @Override
    public ExprCode nullSafeCodeGen(CodegenContext ctx, ExprCode ev, Function5<String, String, String, String, String, String> f) {
        ExprCode firstGen = ((Expression)this.children().apply(0)).genCode(ctx);
        ExprCode secondGen = ((Expression)this.children().apply(1)).genCode(ctx);
        ExprCode thirdGen = ((Expression)this.children().apply(2)).genCode(ctx);
        ExprCode fourthGen = ((Expression)this.children().apply(3)).genCode(ctx);
        ExprCode fifthGen = ((Expression)this.children().apply(4)).genCode(ctx);
        String resultCode = (String)f.apply((Object)ExprValue$.MODULE$.exprValueToString(firstGen.value()), (Object)ExprValue$.MODULE$.exprValueToString(secondGen.value()), (Object)ExprValue$.MODULE$.exprValueToString(thirdGen.value()), (Object)ExprValue$.MODULE$.exprValueToString(fourthGen.value()), (Object)ExprValue$.MODULE$.exprValueToString(fifthGen.value()));
        if (this.nullable()) {
            String nullSafeEval = ctx.nullSafeExec(((Expression)this.children().apply(0)).nullable(), ExprValue$.MODULE$.exprValueToString(firstGen.isNull()), resultCode);
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n        ", "\n        ", "\n        boolean ", " = ", ";\n        ", " ", " = ", ";\n        ", "\n      "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstGen.code(), secondGen.code(), thirdGen.code(), fourthGen.code(), fifthGen.code(), ev.isNull(), firstGen.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n        ", "\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstGen.code(), secondGen.code(), thirdGen.code(), fourthGen.code(), fifthGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)new .colon.colon((Object)this.input(), (List)new .colon.colon((Object)this.upperChar(), (List)new .colon.colon((Object)this.lowerChar(), (List)new .colon.colon((Object)this.digitChar(), (List)new .colon.colon((Object)this.otherChar(), (List)Nil$.MODULE$)))));
    }

    @Override
    public Mask withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4));
    }

    public Mask copy(Expression input, Expression upperChar, Expression lowerChar, Expression digitChar, Expression otherChar) {
        return new Mask(input, upperChar, lowerChar, digitChar, otherChar);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.upperChar();
    }

    public Expression copy$default$3() {
        return this.lowerChar();
    }

    public Expression copy$default$4() {
        return this.digitChar();
    }

    public Expression copy$default$5() {
        return this.otherChar();
    }

    @Override
    public String productPrefix() {
        return "Mask";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.input();
            }
            case 1: {
                return this.upperChar();
            }
            case 2: {
                return this.lowerChar();
            }
            case 3: {
                return this.digitChar();
            }
            case 4: {
                return this.otherChar();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Mask;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Mask)) return false;
        boolean bl = true;
        if (!bl) return false;
        Mask mask = (Mask)x$1;
        Expression expression = this.input();
        Expression expression2 = mask.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.upperChar();
        Expression expression4 = mask.upperChar();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.lowerChar();
        Expression expression6 = mask.lowerChar();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.digitChar();
        Expression expression8 = mask.digitChar();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.otherChar();
        Expression expression10 = mask.otherChar();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        if (!mask.canEqual(this)) return false;
        return true;
    }

    private final Option checkInputDataType$1(Expression exp, String message) {
        if (!exp.foldable()) {
            return new Some((Object)new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)message), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType(exp.dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(exp))})))));
        }
        Object replaceChar = exp.eval(exp.eval$default$1());
        if (replaceChar != null && ((UTF8String)replaceChar).numChars() != 1) {
            return new Some((Object)new TypeCheckResult.DataTypeMismatch("INPUT_SIZE_NOT_ONE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)message)})))));
        }
        return None$.MODULE$;
    }

    public Mask(Expression input, Expression upperChar, Expression lowerChar, Expression digitChar, Expression otherChar) {
        this.input = input;
        this.upperChar = upperChar;
        this.lowerChar = lowerChar;
        this.digitChar = digitChar;
        this.otherChar = otherChar;
        ExpectsInputTypes.$init$(this);
        QueryErrorsBase.$init$(this);
    }

    public Mask(Expression input) {
        Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_UPPERCASE()));
        Literal literal2 = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_LOWERCASE()));
        Literal literal3 = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_DIGIT()));
        Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_IGNORE();
        this(input, literal, literal2, literal3, new Literal(null, StringType$.MODULE$));
    }

    public Mask(Expression input, Expression upperChar) {
        Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_LOWERCASE()));
        Literal literal2 = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_DIGIT()));
        Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_IGNORE();
        this(input, upperChar, literal, literal2, new Literal(null, StringType$.MODULE$));
    }

    public Mask(Expression input, Expression upperChar, Expression lowerChar) {
        Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_DIGIT()));
        Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_IGNORE();
        this(input, upperChar, lowerChar, literal, new Literal(null, StringType$.MODULE$));
    }

    public Mask(Expression input, Expression upperChar, Expression lowerChar, Expression digitChar) {
        Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_IGNORE();
        this(input, upperChar, lowerChar, digitChar, new Literal(null, StringType$.MODULE$));
    }
}

