/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayInsert$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(x, pos, val) - Places val into index pos of array x.\n      Array indices start at 1, or start from the end if index is negative.\n      Index above array size appends the array, or prepends the array if index is negative,\n      with 'null' elements.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, 4), 5, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(array(5, 3, 2, 1), -3, 4);\n       [5,4,3,2,1]\n  ", group="array_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001B\u0014)\u0001VB\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011!Q\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C.\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u000bq\u0003A\u0011A/\t\u000b\t\u0004A\u0011I2\t\u000bY\u0004A\u0011I<\t\u000by\u0004A\u0011I@\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002BBA!\u0001\u0011\u00053\u000b\u0003\u0004\u0002D\u0001!\te\u0015\u0005\u0007\u0003\u000b\u0002A\u0011I*\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J!9\u00111\f\u0001\u0005B\u0005u\u0003bBA3\u0001\u0011\u0005\u0013q\r\u0005\u000b\u0003_\u0002\u0001R1A\u0005\n\u0005u\u0003bBA=\u0001\u0011E\u00131\u0010\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011%\ty\nAA\u0001\n\u0003\t\t\u000bC\u0005\u0002*\u0002\t\n\u0011\"\u0001\u0002,\"I\u0011\u0011\u0019\u0001\u0012\u0002\u0013\u0005\u00111\u0016\u0005\n\u0003\u0007\u0004\u0011\u0013!C\u0001\u0003WC\u0011\"!2\u0001\u0003\u0003%\t%a2\t\u0013\u0005]\u0007!!A\u0005\u0002\u0005e\u0007\"CAq\u0001\u0005\u0005I\u0011AAr\u0011%\tI\u000fAA\u0001\n\u0003\nY\u000fC\u0005\u0002z\u0002\t\t\u0011\"\u0001\u0002|\"I\u0011q \u0001\u0002\u0002\u0013\u0005#\u0011A\u0004\n\u0005KA\u0013\u0011!E\u0001\u0005O1\u0001b\n\u0015\u0002\u0002#\u0005!\u0011\u0006\u0005\u00079\u0006\"\tAa\u000e\t\u0013\te\u0012%!A\u0005F\tm\u0002\"\u0003B\u001fC\u0005\u0005I\u0011\u0011B \u0011%\u00119%IA\u0001\n\u0003\u0013I\u0005C\u0005\u0003X\u0005\n\t\u0011\"\u0003\u0003Z\tY\u0011I\u001d:bs&s7/\u001a:u\u0015\tI#&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0016-\u0003!\u0019\u0017\r^1msN$(BA\u0017/\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003_A\nQa\u001d9be.T!!\r\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0014aA8sO\u000e\u00011\u0003\u0003\u00017uu\u0002e)S(\u0011\u0005]BT\"\u0001\u0015\n\u0005eB#!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011qgO\u0005\u0003y!\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003oyJ!a\u0010\u0015\u00039\r{W\u000e\u001d7fqRK\b/Z'fe\u001eLgnZ#yaJ,7o]5p]B\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tL\u0001\u0007KJ\u0014xN]:\n\u0005\u0015\u0013%aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005]:\u0015B\u0001%)\u0005M\u0019V\u000f\u001d9peR\fV/\u001a:z\u0007>tG/\u001a=u!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0013)\n\u0005E[%\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001D:sG\u0006\u0013(/Y=FqB\u0014X#\u0001+\u0011\u0005]*\u0016B\u0001,)\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u000egJ\u001c\u0017I\u001d:bs\u0016C\bO\u001d\u0011\u0002\u000fA|7/\u0012=qe\u0006A\u0001o\\:FqB\u0014\b%\u0001\u0005ji\u0016lW\t\u001f9s\u0003%IG/Z7FqB\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0005=~\u0003\u0017\r\u0005\u00028\u0001!)!k\u0002a\u0001)\")\u0001l\u0002a\u0001)\")!l\u0002a\u0001)\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\u0011\u00042!Z7q\u001d\t17N\u0004\u0002hU6\t\u0001N\u0003\u0002ji\u00051AH]8pizJ\u0011\u0001T\u0005\u0003Y.\u000bq\u0001]1dW\u0006<W-\u0003\u0002o_\n\u00191+Z9\u000b\u00051\\\u0005CA9u\u001b\u0005\u0011(BA:-\u0003\u0015!\u0018\u0010]3t\u0013\t)(O\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t\u0001\u0010\u0005\u0002zy6\t!P\u0003\u0002|U\u0005A\u0011M\\1msNL7/\u0003\u0002~u\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0003fm\u0006dG\u0003BA\u0001\u0003\u000f\u00012ASA\u0002\u0013\r\t)a\u0013\u0002\u0004\u0003:L\b\"CA\u0005\u0015A\u0005\t\u0019AA\u0006\u0003\u0015Ig\u000e];u!\u0011\ti!a\u0004\u000e\u0003)J1!!\u0005+\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0011\u0005\u0005\u0011qCA\u000e\u0003?Aq!!\u0007\f\u0001\u0004\t\t!A\u0002beJDq!!\b\f\u0001\u0004\t\t!A\u0002q_NDq!!\t\f\u0001\u0004\t\t!\u0001\u0003ji\u0016l\u0017!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t9#a\r\u0002>A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.!\nqaY8eK\u001e,g.\u0003\u0003\u00022\u0005-\"\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005UB\u00021\u0001\u00028\u0005\u00191\r\u001e=\u0011\t\u0005%\u0012\u0011H\u0005\u0005\u0003w\tYC\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005}B\u00021\u0001\u0002(\u0005\u0011QM^\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002LA!\u0011QJA+\u001d\u0011\ty%!\u0015\u0011\u0005\u001d\\\u0015bAA*\u0017\u00061\u0001K]3eK\u001aLA!a\u0016\u0002Z\t11\u000b\u001e:j]\u001eT1!a\u0015L\u0003!!\u0017\r^1UsB,WCAA0!\r\t\u0018\u0011M\u0005\u0004\u0003G\u0012(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016,\"!!\u001b\u0011\u0007)\u000bY'C\u0002\u0002n-\u0013qAQ8pY\u0016\fg.A\u0006fY\u0016lWM\u001c;UsB,\u0007fA\n\u0002tA\u0019!*!\u001e\n\u0007\u0005]4JA\u0005ue\u0006t7/[3oi\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\b=\u0006u\u0014\u0011QAC\u0011\u0019\ty\b\u0006a\u0001)\u0006ya.Z<Te\u000e\f%O]1z\u000bb\u0004(\u000f\u0003\u0004\u0002\u0004R\u0001\r\u0001V\u0001\u000b]\u0016<\bk\\:FqB\u0014\bBBAD)\u0001\u0007A+A\u0006oK^LE/Z7FqB\u0014\u0018\u0001E5oSR\fV/\u001a:z\u0007>tG/\u001a=u)\t\ti\tE\u0003K\u0003\u001f\u000b\u0019*C\u0002\u0002\u0012.\u0013aa\u00149uS>t\u0007\u0003BAK\u00037k!!a&\u000b\u0007\u0005e%&A\u0003ue\u0016,7/\u0003\u0003\u0002\u001e\u0006]%aD*R\u0019F+XM]=D_:$X\r\u001f;\u0002\t\r|\u0007/\u001f\u000b\b=\u0006\r\u0016QUAT\u0011\u001d\u0011f\u0003%AA\u0002QCq\u0001\u0017\f\u0011\u0002\u0003\u0007A\u000bC\u0004[-A\u0005\t\u0019\u0001+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0016\u0016\u0004)\u0006=6FAAY!\u0011\t\u0019,!0\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m6*\u0001\u0006b]:|G/\u0019;j_:LA!a0\u00026\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017\u0001\u00027b]\u001eT!!a5\u0002\t)\fg/Y\u0005\u0005\u0003/\ni-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\\B\u0019!*!8\n\u0007\u0005}7JA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0002\u0005\u0015\b\"CAt9\u0005\u0005\t\u0019AAn\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u001e\t\u0007\u0003_\f)0!\u0001\u000e\u0005\u0005E(bAAz\u0017\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0018\u0011\u001f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002j\u0005u\b\"CAt=\u0005\u0005\t\u0019AA\u0001\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u000eB\u0002\u0011%\t9oHA\u0001\u0002\u0004\t\t\u0001K\n\u0001\u0005\u000f\u0011iAa\u0004\u0003\u0014\tU!\u0011\u0004B\u000e\u0005?\u0011\t\u0003E\u00028\u0005\u0013I1Aa\u0003)\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\u0005\u0002\u0005\u001fQ\u0001\u0005\t\u0011!?\u001a+fjQ0)q2\u0002\u0003o\\:-AY\fG.\u000b\u0011.AAc\u0017mY3tAY\fG\u000eI5oi>\u0004\u0013N\u001c3fq\u0002\u0002xn\u001d\u0011pM\u0002\n'O]1zAat#\u0002\t\u0011!A\u0001\u0002\u0013I\u001d:bs\u0002Jg\u000eZ5dKN\u00043\u000f^1si\u0002\nG\u000fI\u0019-A=\u0014\be\u001d;beR\u0004cM]8nAQDW\rI3oI\u0002Jg\rI5oI\u0016D\b%[:!]\u0016<\u0017\r^5wK:R\u0001\u0005\t\u0011!A\u0001Je\u000eZ3yA\u0005\u0014wN^3!CJ\u0014\u0018-\u001f\u0011tSj,\u0007%\u00199qK:$7\u000f\t;iK\u0002\n'O]1zY\u0001z'\u000f\t9sKB,g\u000eZ:!i\",\u0007%\u0019:sCf\u0004\u0013N\u001a\u0011j]\u0012,\u0007\u0010I5tA9,w-\u0019;jm\u0016d#\u0002\t\u0011!A\u0001\u0002s/\u001b;iA\u001drW\u000f\u001c7(A\u0015dW-\\3oiNt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\u0006\u0002\u0003cQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001aD\u0006\t\u001b*Y\u0001*D\u0006I\u001b*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0016\u0007\f\u001a-g1\"D&N/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)k1\u00023\u0007\f\u00113Y\u0001\n\u0014\u0006\f\u0011.g1\u0002C'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7VbC\u0007L\u001a-e1\nTL\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011i\"A\u0006beJ\f\u0017p\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\u0012\u0003\u0015\u0019d\u0006\u000e\u00181\u0003-\t%O]1z\u0013:\u001cXM\u001d;\u0011\u0005]\n3\u0003B\u0011\u0003,=\u0003\u0002B!\f\u00034Q#FKX\u0007\u0003\u0005_Q1A!\rL\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u000e\u00030\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\t\u001d\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0017!B1qa2LHc\u00020\u0003B\t\r#Q\t\u0005\u0006%\u0012\u0002\r\u0001\u0016\u0005\u00061\u0012\u0002\r\u0001\u0016\u0005\u00065\u0012\u0002\r\u0001V\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YEa\u0015\u0011\u000b)\u000byI!\u0014\u0011\r)\u0013y\u0005\u0016+U\u0013\r\u0011\tf\u0013\u0002\u0007)V\u0004H.Z\u001a\t\u0011\tUS%!AA\u0002y\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tm\u0003\u0003BAf\u0005;JAAa\u0018\u0002N\n1qJ\u00196fGR\u0004")
public class ArrayInsert
extends TernaryExpression
implements ImplicitCastInputTypes,
ComplexTypeMergingExpression,
QueryErrorsBase,
SupportQueryContext {
    private transient DataType elementType;
    private final Expression srcArrayExpr;
    private final Expression posExpr;
    private final Expression itemExpr;
    private Option<SQLQueryContext> queryContext;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(ArrayInsert arrayInsert) {
        return ArrayInsert$.MODULE$.unapply(arrayInsert);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, ArrayInsert> tupled() {
        return ArrayInsert$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, ArrayInsert>>> curried() {
        return ArrayInsert$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if (!this.bitmap$0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Expression srcArrayExpr() {
        return this.srcArrayExpr;
    }

    public Expression posExpr() {
        return this.posExpr;
    }

    public Expression itemExpr() {
        return this.itemExpr;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple3 tuple3 = new Tuple3((Object)this.srcArrayExpr().dataType(), (Object)this.posExpr().dataType(), (Object)this.itemExpr().dataType());
        if (tuple3 != null) {
            DataType dataType = (DataType)tuple3._1();
            DataType e2 = (DataType)tuple3._2();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e3);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            DataType dt = (DataType)some.value();
                            Seq cfr_ignored_0 = (Seq)new .colon.colon((Object)new ArrayType(dt, hasNull), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$)));
                            return (Seq)Nil$.MODULE$;
                        }
                        Seq cfr_ignored_1 = (Seq)Nil$.MODULE$;
                        return (Seq)Nil$.MODULE$;
                    }
                }
            }
        }
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        Seq cfr_ignored_2 = (Seq)Nil$.MODULE$;
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple3 tuple3 = new Tuple3((Object)this.first().dataType(), (Object)this.second().dataType(), (Object)this.third().dataType());
        if (tuple3 != null) {
            DataType e2 = (DataType)tuple3._2();
            if (tuple3._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType(IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.second())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType(this.second().dataType()))}))));
                }
            }
        }
        if (tuple3 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType = (DataType)tuple3._1();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType && (e1 = (arrayType = (ArrayType)dataType).elementType()).sameType(e3)) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
        }
        return new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType(ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType(this.first().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType(this.third().dataType()))}))));
    }

    @Override
    public Object eval(InternalRow input) {
        Object value2;
        Object value1 = this.first().eval(input);
        if (value1 != null && (value2 = this.second().eval(input)) != null) {
            Object value3 = this.third().eval(input);
            return this.nullSafeEval(value1, value2, value3);
        }
        return null;
    }

    @Override
    public Object nullSafeEval(Object arr, Object pos, Object item) {
        boolean newPosExtendsArrayLeft;
        IntRef posInt = IntRef.create((int)BoxesRunTime.unboxToInt((Object)pos));
        if (posInt.elem == 0) {
            throw QueryExecutionErrors$.MODULE$.invalidIndexOfZeroError(this.getContextOrNull());
        }
        ArrayData baseArr = (ArrayData)arr;
        DataType arrayElementType = ((ArrayType)this.dataType()).elementType();
        boolean bl = newPosExtendsArrayLeft = posInt.elem < 0 && -posInt.elem > baseArr.numElements();
        if (newPosExtendsArrayLeft) {
            int newArrayLength = -posInt.elem + 1;
            if (newArrayLength > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
            }
            Object[] newArray = new Object[newArrayLength];
            baseArr.foreach(arrayElementType, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
                ArrayInsert.$anonfun$nullSafeEval$9(posInt, baseArr, newArray, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            newArray[0] = item;
            return new GenericArrayData(newArray);
        }
        if (posInt.elem < 0) {
            posInt.elem += baseArr.numElements();
        } else if (posInt.elem > 0) {
            --posInt.elem;
        }
        int newArrayLength = package$.MODULE$.max(baseArr.numElements() + 1, posInt.elem + 1);
        if (newArrayLength > 0x7FFFFFF0) {
            throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
        }
        Object[] newArray = new Object[newArrayLength];
        baseArr.foreach(arrayElementType, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
            ArrayInsert.$anonfun$nullSafeEval$10(posInt, newArray, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        newArray[posInt.elem] = item;
        return new GenericArrayData(newArray);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Function3 & Serializable & scala.Serializable f = (Function3 & Serializable & scala.Serializable)(arrExpr, posExpr, itemExpr) -> {
            ExprValue arr = arrExpr.value();
            ExprValue pos = posExpr.value();
            ExprValue item = itemExpr.value();
            String itemInsertionIndex = ctx.freshName("itemInsertionIndex");
            String adjustedAllocIdx = ctx.freshName("adjustedAllocIdx");
            String resLength = ctx.freshName("resLength");
            String insertedItemIsNull = ctx.freshName("insertedItemIsNull");
            String i = ctx.freshName("i");
            String j = ctx.freshName("j");
            String values = ctx.freshName("values");
            String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), resLength, new StringBuilder(8).append(this.prettyName()).append(" failed.").toString());
            String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), ExprValue$.MODULE$.exprValueToString(arr), adjustedAllocIdx, i, ((ArrayType)this.first().dataType()).containsNull());
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1537).append("\n         |int ").append(itemInsertionIndex).append(" = 0;\n         |int ").append(resLength).append(" = 0;\n         |int ").append(adjustedAllocIdx).append(" = 0;\n         |boolean ").append(insertedItemIsNull).append(" = ").append(itemExpr.isNull()).append(";\n         |\n         |if (").append(pos).append(" == 0) {\n         |  throw QueryExecutionErrors.invalidIndexOfZeroError(").append(errorContext).append(");\n         |}\n         |\n         |if (").append(pos).append(" < 0 && (java.lang.Math.abs(").append(pos).append(") > ").append(arr).append(".numElements())) {\n         |\n         |  ").append(resLength).append(" = java.lang.Math.abs(").append(pos).append(") + 1;\n         |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n         |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n         |  }\n         |\n         |  ").append(allocation).append("\n         |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n         |    ").append(adjustedAllocIdx).append(" = ").append(i).append(" + 1 + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements());\n         |    ").append(assignment).append("\n         |  }\n         |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n         |\n         |  for (int ").append(j).append(" = ").append(pos).append(" + ").append(arr).append(".numElements(); ").append(j).append(" < 0; ").append(j).append(" ++) {\n         |    ").append(values).append(".setNullAt(").append(j).append(" + 1 + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements()));\n         |  }\n         |\n         |  ").append(ev.value()).append(" = ").append(values).append(";\n         |} else {\n         |\n         |  ").append(itemInsertionIndex).append(" = 0;\n         |  if (").append(pos).append(" < 0) {\n         |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" + ").append(arr).append(".numElements();\n         |  } else if (").append(pos).append(" > 0) {\n         |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" - 1;\n         |  }\n         |\n         |  ").append(resLength).append(" = java.lang.Math.max(").append(arr).append(".numElements() + 1, ").append(itemInsertionIndex).append(" + 1);\n         |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n         |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n         |  }\n         |\n         |  ").append(allocation).append("\n         |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n         |    ").append(adjustedAllocIdx).append(" = ").append(i).append(";\n         |    if (").append(i).append(" >= ").append(itemInsertionIndex).append(") {\n         |      ").append(adjustedAllocIdx).append(" = ").append(adjustedAllocIdx).append(" + 1;\n         |    }\n         |    ").append(assignment).append("\n         |  }\n         |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n         |\n         |  for (int ").append(j).append(" = ").append(arr).append(".numElements(); ").append(j).append(" < ").append(resLength).append(" - 1; ").append(j).append(" ++) {\n         |    ").append(values).append(".setNullAt(").append(j).append(");\n         |  }\n         |\n         |  ").append(ev.value()).append(" = ").append(values).append(";\n         |}\n      ").toString())).stripMargin();
        };
        ExprCode leftGen = this.first().genCode(ctx);
        ExprCode midGen = this.second().genCode(ctx);
        ExprCode rightGen = this.third().genCode(ctx);
        String resultCode = (String)f.apply((Object)leftGen, (Object)midGen, (Object)rightGen);
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)leftGen.code()), ctx.nullSafeExec(this.first().nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)midGen.code()), ctx.nullSafeExec(this.second().nullable(), ExprValue$.MODULE$.exprValueToString(midGen.isNull()), new StringBuilder(67).append("\n              ").append(rightGen.code()).append("\n              ").append(ev.isNull()).append(" = false;\n              ").append(resultCode).append("\n            ").toString()))));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), midGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Expression first() {
        return this.srcArrayExpr();
    }

    @Override
    public Expression second() {
        return this.posExpr();
    }

    @Override
    public Expression third() {
        return this.itemExpr();
    }

    @Override
    public String prettyName() {
        return "array_insert";
    }

    @Override
    public DataType dataType() {
        return this.first().dataType().asNullable();
    }

    @Override
    public boolean nullable() {
        return this.first().nullable() | this.second().nullable();
    }

    private DataType elementType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.srcArrayExpr().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public ArrayInsert withNewChildrenInternal(Expression newSrcArrayExpr, Expression newPosExpr, Expression newItemExpr) {
        return this.copy(newSrcArrayExpr, newPosExpr, newItemExpr);
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        return new Some((Object)this.origin().context());
    }

    public ArrayInsert copy(Expression srcArrayExpr, Expression posExpr, Expression itemExpr) {
        return new ArrayInsert(srcArrayExpr, posExpr, itemExpr);
    }

    public Expression copy$default$1() {
        return this.srcArrayExpr();
    }

    public Expression copy$default$2() {
        return this.posExpr();
    }

    public Expression copy$default$3() {
        return this.itemExpr();
    }

    @Override
    public String productPrefix() {
        return "ArrayInsert";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcArrayExpr();
            }
            case 1: {
                return this.posExpr();
            }
            case 2: {
                return this.itemExpr();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayInsert;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayInsert)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayInsert arrayInsert = (ArrayInsert)x$1;
        Expression expression = this.srcArrayExpr();
        Expression expression2 = arrayInsert.srcArrayExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.posExpr();
        Expression expression4 = arrayInsert.posExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.itemExpr();
        Expression expression6 = arrayInsert.itemExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!arrayInsert.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$9(IntRef posInt$1, ArrayData baseArr$1, Object[] newArray$2, int i, Object v) {
        int elementPosition = i + 1 + package$.MODULE$.abs(posInt$1.elem + baseArr$1.numElements());
        newArray$2[elementPosition] = v;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$10(IntRef posInt$1, Object[] newArray$3, int i, Object v) {
        if (i >= posInt$1.elem) {
            newArray$3[i + 1] = v;
            return;
        }
        newArray$3[i] = v;
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr) {
        this.srcArrayExpr = srcArrayExpr;
        this.posExpr = posExpr;
        this.itemExpr = itemExpr;
        ExpectsInputTypes.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
        QueryErrorsBase.$init$(this);
        SupportQueryContext.$init$(this);
    }
}

