/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Random;
import org.apache.spark.sql.catalyst.expressions.XXH64;
import org.apache.spark.unsafe.Platform;
import org.junit.Assert;
import org.junit.Test;

public class XXH64Suite {
    private static final XXH64 hasher = new XXH64(0L);
    private static final int SIZE = 101;
    private static final long PRIME = 2654435761L;
    private static final byte[] BUFFER = new byte[101];
    private static final int TEST_INT = 1260388254;
    private static final long TEST_LONG = -2508694802969657442L;

    @Test
    public void testKnownIntegerInputs() {
        Assert.assertEquals((long)-7901876112562082063L, (long)hasher.hashInt(1260388254));
        Assert.assertEquals((long)708753852729961291L, (long)XXH64.hashInt((int)1260388254, (long)2654435761L));
    }

    @Test
    public void testKnownLongInputs() {
        Assert.assertEquals((long)-626931337744172849L, (long)hasher.hashLong(-2508694802969657442L));
        Assert.assertEquals((long)-7186417346120842555L, (long)XXH64.hashLong((long)-2508694802969657442L, (long)2654435761L));
    }

    @Test
    public void testKnownByteArrayInputs() {
        Assert.assertEquals((long)-1205034819632174695L, (long)hasher.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 0));
        Assert.assertEquals((long)-6019626452224632849L, (long)XXH64.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)0, (long)2654435761L));
        Assert.assertEquals((long)5750596776143442648L, (long)hasher.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 1));
        Assert.assertEquals((long)8329478753618994979L, (long)XXH64.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)1, (long)2654435761L));
        Assert.assertEquals((long)-7901876112562082063L, (long)hasher.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 4));
        Assert.assertEquals((long)708753852729961291L, (long)XXH64.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)4, (long)2654435761L));
        Assert.assertEquals((long)-626931337744172849L, (long)hasher.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 8));
        Assert.assertEquals((long)-7186417346120842555L, (long)XXH64.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)8, (long)2654435761L));
        Assert.assertEquals((long)-3460297540090709443L, (long)hasher.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 14));
        Assert.assertEquals((long)6599481375206459851L, (long)XXH64.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)14, (long)2654435761L));
        Assert.assertEquals((long)1057031117799454893L, (long)hasher.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 101));
        Assert.assertEquals((long)-3844287129753543135L, (long)XXH64.hashUnsafeBytes((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)101, (long)2654435761L));
    }

    @Test
    public void testKnownWordArrayInputs() {
        Assert.assertEquals((long)-1205034819632174695L, (long)hasher.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 0));
        Assert.assertEquals((long)-6019626452224632849L, (long)XXH64.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)0, (long)2654435761L));
        Assert.assertEquals((long)-626931337744172849L, (long)hasher.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 8));
        Assert.assertEquals((long)-7186417346120842555L, (long)XXH64.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)8, (long)2654435761L));
        Assert.assertEquals((long)1626208099793713961L, (long)hasher.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 16));
        Assert.assertEquals((long)-6866209862840928010L, (long)XXH64.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)16, (long)2654435761L));
        Assert.assertEquals((long)-3533688218998672826L, (long)hasher.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 24));
        Assert.assertEquals((long)2279558773760986487L, (long)XXH64.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)24, (long)2654435761L));
        Assert.assertEquals((long)-5812084625956540946L, (long)hasher.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 32));
        Assert.assertEquals((long)-2545780413506618609L, (long)XXH64.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)32, (long)2654435761L));
        Assert.assertEquals((long)840771063770419219L, (long)hasher.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 40));
        Assert.assertEquals((long)2388942360948264176L, (long)XXH64.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)40, (long)2654435761L));
        Assert.assertEquals((long)-5523917770470460191L, (long)hasher.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 48));
        Assert.assertEquals((long)-8758241595436736172L, (long)XXH64.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)48, (long)2654435761L));
        Assert.assertEquals((long)-6641181984939962294L, (long)hasher.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 56));
        Assert.assertEquals((long)6192172603846427863L, (long)XXH64.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)56, (long)2654435761L));
        Assert.assertEquals((long)1798405813525258380L, (long)hasher.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, 64));
        Assert.assertEquals((long)5160686484195024928L, (long)XXH64.hashUnsafeWords((Object)BUFFER, (long)Platform.BYTE_ARRAY_OFFSET, (int)64, (long)2654435761L));
    }

    @Test
    public void randomizedStressTest() {
        int size = 65536;
        Random rand = new Random();
        HashSet<Long> hashcodes = new HashSet<Long>();
        for (int i = 0; i < size; ++i) {
            int vint = rand.nextInt();
            long lint = rand.nextLong();
            Assert.assertEquals((long)hasher.hashInt(vint), (long)hasher.hashInt(vint));
            Assert.assertEquals((long)hasher.hashLong(lint), (long)hasher.hashLong(lint));
            hashcodes.add(hasher.hashLong(lint));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }

    @Test
    public void randomizedStressTestBytes() {
        int size = 65536;
        Random rand = new Random();
        HashSet<Long> hashcodes = new HashSet<Long>();
        for (int i = 0; i < size; ++i) {
            int byteArrSize = rand.nextInt(100) * 8;
            byte[] bytes = new byte[byteArrSize];
            rand.nextBytes(bytes);
            Assert.assertEquals((long)hasher.hashUnsafeWords((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize), (long)hasher.hashUnsafeWords((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
            hashcodes.add(hasher.hashUnsafeWords((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }

    @Test
    public void randomizedStressTestPaddedStrings() {
        int size = 64000;
        HashSet<Long> hashcodes = new HashSet<Long>();
        for (int i = 0; i < size; ++i) {
            int byteArrSize = 8;
            byte[] strBytes = String.valueOf(i).getBytes(StandardCharsets.UTF_8);
            byte[] paddedBytes = new byte[byteArrSize];
            System.arraycopy(strBytes, 0, paddedBytes, 0, strBytes.length);
            Assert.assertEquals((long)hasher.hashUnsafeWords((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize), (long)hasher.hashUnsafeWords((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
            hashcodes.add(hasher.hashUnsafeWords((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }

    static {
        long seed = 2654435761L;
        for (int i = 0; i < 101; ++i) {
            XXH64Suite.BUFFER[i] = (byte)(seed >> 24);
            seed *= seed;
        }
    }
}

