/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import org.apache.spark.sql.errors.QueryExecutionErrors$;
import scala.Function1;
import scala.Some;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;

public final class ByteExactNumeric$
implements Numeric.ByteIsIntegral,
Ordering.ByteOrdering {
    public static ByteExactNumeric$ MODULE$;

    static {
        new ByteExactNumeric$();
    }

    public int compare(byte x, byte y) {
        return Ordering.ByteOrdering.compare$((Ordering.ByteOrdering)this, (byte)x, (byte)y);
    }

    public byte quot(byte x, byte y) {
        return Numeric.ByteIsIntegral.quot$((Numeric.ByteIsIntegral)this, (byte)x, (byte)y);
    }

    public byte rem(byte x, byte y) {
        return Numeric.ByteIsIntegral.rem$((Numeric.ByteIsIntegral)this, (byte)x, (byte)y);
    }

    public byte fromInt(int x) {
        return Numeric.ByteIsIntegral.fromInt$((Numeric.ByteIsIntegral)this, (int)x);
    }

    public int toInt(byte x) {
        return Numeric.ByteIsIntegral.toInt$((Numeric.ByteIsIntegral)this, (byte)x);
    }

    public long toLong(byte x) {
        return Numeric.ByteIsIntegral.toLong$((Numeric.ByteIsIntegral)this, (byte)x);
    }

    public float toFloat(byte x) {
        return Numeric.ByteIsIntegral.toFloat$((Numeric.ByteIsIntegral)this, (byte)x);
    }

    public double toDouble(byte x) {
        return Numeric.ByteIsIntegral.toDouble$((Numeric.ByteIsIntegral)this, (byte)x);
    }

    public Integral.IntegralOps mkNumericOps(Object lhs) {
        return Integral.mkNumericOps$((Integral)this, (Object)lhs);
    }

    public Object zero() {
        return Numeric.zero$((Numeric)this);
    }

    public Object one() {
        return Numeric.one$((Numeric)this);
    }

    public Object abs(Object x) {
        return Numeric.abs$((Numeric)this, (Object)x);
    }

    public int signum(Object x) {
        return Numeric.signum$((Numeric)this, (Object)x);
    }

    public Some tryCompare(Object x, Object y) {
        return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lteq(Object x, Object y) {
        return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gteq(Object x, Object y) {
        return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lt(Object x, Object y) {
        return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gt(Object x, Object y) {
        return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean equiv(Object x, Object y) {
        return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
    }

    public Object max(Object x, Object y) {
        return Ordering.max$((Ordering)this, (Object)x, (Object)y);
    }

    public Object min(Object x, Object y) {
        return Ordering.min$((Ordering)this, (Object)x, (Object)y);
    }

    public Ordering<Object> reverse() {
        return Ordering.reverse$((Ordering)this);
    }

    public <U> Ordering<U> on(Function1<U, Object> f) {
        return Ordering.on$((Ordering)this, f);
    }

    public Ordering.Ops mkOrderingOps(Object lhs) {
        return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
    }

    private void checkOverflow(int res, byte x, byte y, String op) {
        if (res > 127 || res < -128) {
            throw QueryExecutionErrors$.MODULE$.binaryArithmeticCauseOverflowError(x, op, y);
        }
    }

    public byte plus(byte x, byte y) {
        int tmp = x + y;
        this.checkOverflow(tmp, x, y, "+");
        return (byte)tmp;
    }

    public byte minus(byte x, byte y) {
        int tmp = x - y;
        this.checkOverflow(tmp, x, y, "-");
        return (byte)tmp;
    }

    public byte times(byte x, byte y) {
        int tmp = x * y;
        this.checkOverflow(tmp, x, y, "*");
        return (byte)tmp;
    }

    public byte negate(byte x) {
        if (x == -128) {
            throw QueryExecutionErrors$.MODULE$.unaryMinusCauseOverflowError(x);
        }
        return -x;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ByteExactNumeric$() {
        MODULE$ = this;
        PartialOrdering.$init$((PartialOrdering)this);
        Ordering.$init$((Ordering)this);
        Numeric.$init$((Numeric)this);
        Integral.$init$((Integral)this);
        Numeric.ByteIsIntegral.$init$((Numeric.ByteIsIntegral)this);
        Ordering.ByteOrdering.$init$((Ordering.ByteOrdering)this);
    }
}

