/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetArrayItemUtil;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If index < 0,\n      accesses elements from the last to the first. The function returns NULL\n      if the index exceeds the length of the array and `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws ArrayIndexOutOfBoundsException\n      for invalid indices.\n\n    _FUNC_(map, key) - Returns value for given key. The function returns NULL\n      if the key is not contained in the map and `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws NoSuchElementException instead.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0001\t5d\u0001\u0002\u0016,\u0001bB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005+\"A\u0011\f\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003V\u0011!Y\u0006A!f\u0001\n\u0003a\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011B/\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u0005\u0004A\u0011A4\t\u0011)\u0004\u0001R1A\u0005\n-D\u0001B\u001e\u0001\t\u0006\u0004%I\u0001\u0018\u0005\tq\u0002A)\u0019!C\u00059\"A!\u0010\u0001EC\u0002\u0013%1\u0010C\u0005\u0002\u0018\u0001A)\u0019!C!W\"9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003w\u0001A\u0011BA\u001f\u0011\u0019\ty\u0005\u0001C!9\"9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003BCA.\u0001!\u0015\r\u0011\"\u0003\u0002^!9\u0011q\r\u0001\u0005B\u0005%\u0004bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u00033\u0003A\u0011KAN\u0011%\t)\u000bAA\u0001\n\u0003\t9\u000bC\u0005\u00020\u0002\t\n\u0011\"\u0001\u00022\"I\u0011q\u0019\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003\u0013\u0004\u0011\u0013!C\u0001\u0003\u0017D\u0011\"a4\u0001\u0003\u0003%\t%!5\t\u0013\u0005\u0005\b!!A\u0005\u0002\u0005\r\b\"CAs\u0001\u0005\u0005I\u0011AAt\u0011%\ti\u000fAA\u0001\n\u0003\ny\u000fC\u0005\u0002~\u0002\t\t\u0011\"\u0001\u0002\u0000\"I!1\u0001\u0001\u0002\u0002\u0013\u0005#QA\u0004\n\u0005SY\u0013\u0011!E\u0001\u0005W1\u0001BK\u0016\u0002\u0002#\u0005!Q\u0006\u0005\u0007C\n\"\tAa\u000f\t\u0013\tu\"%!A\u0005F\t}\u0002\"\u0003B!E\u0005\u0005I\u0011\u0011B\"\u0011%\u0011YEII\u0001\n\u0003\tY\rC\u0005\u0003N\t\n\t\u0011\"!\u0003P!I!\u0011\r\u0012\u0012\u0002\u0013\u0005\u00111\u001a\u0005\n\u0005G\u0012\u0013\u0011!C\u0005\u0005K\u0012\u0011\"\u00127f[\u0016tG/\u0011;\u000b\u00051j\u0013aC3yaJ,7o]5p]NT!AL\u0018\u0002\u0011\r\fG/\u00197zgRT!\u0001M\u0019\u0002\u0007M\fHN\u0003\u00023g\u0005)1\u000f]1sW*\u0011A'N\u0001\u0007CB\f7\r[3\u000b\u0003Y\n1a\u001c:h\u0007\u0001\u0019r\u0001A\u001d>\u0001\u000eS\u0005\u000b\u0005\u0002;w5\t1&\u0003\u0002=W\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003uyJ!aP\u0016\u0003\u001f\u001d+G/T1q-\u0006dW/Z+uS2\u0004\"AO!\n\u0005\t[#\u0001E$fi\u0006\u0013(/Y=Ji\u0016lW\u000b^5m!\t!uI\u0004\u0002;\u000b&\u0011aiK\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015J\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005\u0019[\u0003CA&O\u001b\u0005a%\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0017FK!A\u0015'\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t1,g\r^\u000b\u0002+B\u0011!HV\u0005\u0003/.\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u0005Ya-Y5m\u001f:,%O]8s+\u0005i\u0006CA&_\u0013\tyFJA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\u0011\u0019G-\u001a4\u0011\u0005i\u0002\u0001\"B*\b\u0001\u0004)\u0006\"B-\b\u0001\u0004)\u0006bB.\b!\u0003\u0005\r!\u0018\u000b\u0004G\"L\u0007\"B*\t\u0001\u0004)\u0006\"B-\t\u0001\u0004)\u0016AC7ba.+\u0017\u0010V=qKV\tA\u000e\u0005\u0002na6\taN\u0003\u0002p_\u0005)A/\u001f9fg&\u0011\u0011O\u001c\u0002\t\t\u0006$\u0018\rV=qK\"\u0012\u0011b\u001d\t\u0003\u0017RL!!\u001e'\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001F7baZ\u000bG.^3D_:$\u0018-\u001b8t\u001dVdG\u000e\u000b\u0002\u000bg\u0006\t\u0012M\u001d:bs\u000e{g\u000e^1j]NtU\u000f\u001c7)\u0005-\u0019\u0018\u0001C8sI\u0016\u0014\u0018N\\4\u0016\u0003q\u0004R!`A\u0005\u0003\u001fq1A`A\u0004\u001d\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u00018\u0003\u0019a$o\\8u}%\tQ*\u0003\u0002G\u0019&!\u00111BA\u0007\u0005!y%\u000fZ3sS:<'B\u0001$M!\rY\u0015\u0011C\u0005\u0004\u0003'a%aA!os\"\u0012Ab]\u0001\tI\u0006$\u0018\rV=qK\"\u0012Qb]\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA\u0010!\u0015i\u0018\u0011EA\u0013\u0013\u0011\t\u0019#!\u0004\u0003\u0007M+\u0017\u000fE\u0002n\u0003OI1!!\u000bo\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u00020A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u000265\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003s\t\u0019DA\bUsB,7\t[3dWJ+7/\u001e7u\u0003-qW\u000f\u001c7bE&d\u0017\u000e^=\u0015\u000bu\u000by$!\u0012\t\u000f\u0005\u0005\u0003\u00031\u0001\u0002D\u0005AQ\r\\3nK:$8\u000f\u0005\u0003~\u0003C)\u0006bBA$!\u0001\u0007\u0011\u0011J\u0001\b_J$\u0017N\\1m!\rY\u00151J\u0005\u0004\u0003\u001bb%aA%oi\u0006Aa.\u001e7mC\ndW-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002\u0010\u0005U\u0013\u0011\f\u0005\b\u0003/\u0012\u0002\u0019AA\b\u0003\u00151\u0018\r\\;f\u0011\u001d\t9E\u0005a\u0001\u0003\u001f\t1\u0002Z8FY\u0016lWM\u001c;BiV\u0011\u0011q\f\t\n\u0017\u0006\u0005\u0014qBA\b\u0003\u001fI1!a\u0019M\u0005%1UO\\2uS>t'\u0007\u000b\u0002\u0014g\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003W\n9(!!\u0011\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d,\u0003\u001d\u0019w\u000eZ3hK:LA!!\u001e\u0002p\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002zQ\u0001\r!a\u001f\u0002\u0007\r$\b\u0010\u0005\u0003\u0002n\u0005u\u0014\u0002BA@\u0003_\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002\u0004R\u0001\r!a\u001b\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\u0012\t\u0005\u0003\u0017\u000b\u0019J\u0004\u0003\u0002\u000e\u0006=\u0005CA@M\u0013\r\t\t\nT\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0015q\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005EE*A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)1-!(\u0002\"\"1\u0011q\u0014\fA\u0002U\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002$Z\u0001\r!V\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u001d\u0019\u0017\u0011VAV\u0003[CqaU\f\u0011\u0002\u0003\u0007Q\u000bC\u0004Z/A\u0005\t\u0019A+\t\u000fm;\u0002\u0013!a\u0001;\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAZU\r)\u0016QW\u0016\u0003\u0003o\u0003B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0019'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0006m&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001bT3!XA[\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u001b\t\u0005\u0003+\fy.\u0004\u0002\u0002X*!\u0011\u0011\\An\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0017\u0001\u00026bm\u0006LA!!&\u0002X\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011J\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty!!;\t\u0013\u0005-X$!AA\u0002\u0005%\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002rB1\u00111_A}\u0003\u001fi!!!>\u000b\u0007\u0005]H*\u0001\u0006d_2dWm\u0019;j_:LA!a?\u0002v\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ri&\u0011\u0001\u0005\n\u0003W|\u0012\u0011!a\u0001\u0003\u001f\ta!Z9vC2\u001cHcA/\u0003\b!I\u00111\u001e\u0011\u0002\u0002\u0003\u0007\u0011q\u0002\u0015\u0014\u0001\t-!\u0011\u0003B\n\u0005/\u0011IB!\b\u0003 \t\r\"Q\u0005\t\u0004u\t5\u0011b\u0001B\bW\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u000b\u0003\u0015U!\u0002\t\u0011!A}3UKT\"`Q\u0005\u0014(/Y=-A%tG-\u001a=*A5\u0002#+\u001a;ve:\u001c\b%\u001a7f[\u0016tG\u000fI8gA\u0005\u0014(/Y=!CR\u0004s-\u001b<f]\u0002B\u0013'\f2bg\u0016$\u0017\u0006I5oI\u0016Dh\u0006I%gA%tG-\u001a=!y\u0001\u0002DF\u0003\u0011!A\u0001\u0002\u0003%Y2dKN\u001cXm\u001d\u0011fY\u0016lWM\u001c;tA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004C.Y:uAQ|\u0007\u0005\u001e5fA\u0019L'o\u001d;/AQCW\r\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA9+F\n\u0014\u0006!A\u0001\u0002\u0003\u0005I5gAQDW\rI5oI\u0016D\b%\u001a=dK\u0016$7\u000f\t;iK\u0002bWM\\4uQ\u0002zg\r\t;iK\u0002\n'O]1zA\u0005tG\r\t1ta\u0006\u00148NL:rY:\ngn]5/K:\f'\r\\3eA\u0002J7\u000fI:fi\u0002\"x\u000e\t4bYN,gF\u0003\u0011!A\u0001\u0002\u0003%\u00134!AN\u0004\u0018M]6/gFdg&\u00198tS:*g.\u00192mK\u0012\u0004\u0007%[:!g\u0016$\b\u0005^8!iJ,X\r\f\u0011ji\u0002\"\bN]8xg\u0002\n%O]1z\u0013:$W\r_(vi>3'i\\;oIN,\u0005pY3qi&|gN\u0003\u0011!A\u0001\u0002\u0003EZ8sA%tg/\u00197jI\u0002Jg\u000eZ5dKNt#B\u0003\u0011!A\u0001zf)\u0016(D?\"j\u0017\r\u001d\u0017!W\u0016L\u0018\u0006I\u0017!%\u0016$XO\u001d8tAY\fG.^3!M>\u0014\beZ5wK:\u00043.Z=/AQCW\r\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA9+F\n\u0014\u0006!A\u0001\u0002\u0003\u0005I5gAQDW\rI6fs\u0002J7\u000f\t8pi\u0002\u001awN\u001c;bS:,G\rI5oAQDW\rI7ba\u0002\ng\u000e\u001a\u0011agB\f'o\u001b\u0018tc2t\u0013M\\:j]\u0015t\u0017M\u00197fI\u0002\u0004\u0013n\u001d\u0011tKR\u0004Co\u001c\u0011gC2\u001cXM\f\u0006!A\u0001\u0002\u0003\u0005I%gA\u0001\u001c\b/\u0019:l]M\fHNL1og&tSM\\1cY\u0016$\u0007\rI5tAM,G\u000f\t;pAQ\u0014X/\u001a\u0017!SR\u0004C\u000f\u001b:poN\u0004cj\\*vG\",E.Z7f]R,\u0005pY3qi&|g\u000eI5ogR,\u0017\r\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00057\tAP\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AIb\u0003eM\u0015-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\f\u0007\u000fK\u0019-A\u001d\nw\u0005\f\u00113Y\u0001:#mJ\u0015-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t2\u000bA\u0001\nQa]5oG\u0016\f#A!\t\u0002\u000bIrCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t\u001d\u0012!C7ba~3WO\\2t\u0003%)E.Z7f]R\fE\u000f\u0005\u0002;EM!!Ea\fQ!!\u0011\tDa\u000eV+v\u001bWB\u0001B\u001a\u0015\r\u0011)\u0004T\u0001\beVtG/[7f\u0013\u0011\u0011IDa\r\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003,\u0005AAo\\*ue&tw\r\u0006\u0002\u0002T\u0006)\u0011\r\u001d9msR91M!\u0012\u0003H\t%\u0003\"B*&\u0001\u0004)\u0006\"B-&\u0001\u0004)\u0006bB.&!\u0003\u0005\r!X\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003\u0002B)\u0005;\u0002Ra\u0013B*\u0005/J1A!\u0016M\u0005\u0019y\u0005\u000f^5p]B11J!\u0017V+vK1Aa\u0017M\u0005\u0019!V\u000f\u001d7fg!A!qL\u0014\u0002\u0002\u0003\u00071-A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u001a\u0011\t\u0005U'\u0011N\u0005\u0005\u0005W\n9N\u0001\u0004PE*,7\r\u001e")
public class ElementAt
extends BinaryExpression
implements GetMapValueUtil,
GetArrayItemUtil,
package.NullIntolerant,
scala.Serializable {
    private transient DataType mapKeyType;
    private transient boolean mapValueContainsNull;
    private transient boolean arrayContainsNull;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private final boolean failOnError;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$3() {
        return ElementAt$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(ElementAt elementAt) {
        return ElementAt$.MODULE$.unapply(elementAt);
    }

    public static boolean apply$default$3() {
        return ElementAt$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, ElementAt>>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public boolean computeNullabilityFromArray(Expression child, Expression ordinal, boolean failOnError, Function2<Seq<Expression>, Object, Object> nullability) {
        return GetArrayItemUtil.computeNullabilityFromArray$(this, child, ordinal, failOnError, nullability);
    }

    @Override
    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering, boolean failOnError) {
        return GetMapValueUtil.getValueEval$(this, value, ordinal, keyType, ordering, failOnError);
    }

    @Override
    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType, boolean failOnError) {
        return GetMapValueUtil.doGetValueGenCode$(this, ctx, ev, mapType, failOnError);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.mapKeyType$lzycompute() : this.mapKeyType;
    }

    private boolean mapValueContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.mapValueContainsNull = ((MapType)this.left().dataType()).valueContainsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.mapValueContainsNull;
    }

    private boolean mapValueContainsNull() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.mapValueContainsNull$lzycompute() : this.mapValueContainsNull;
    }

    private boolean arrayContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.arrayContainsNull = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.arrayContainsNull;
    }

    private boolean arrayContainsNull() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.arrayContainsNull$lzycompute() : this.arrayContainsNull;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return (Seq)new .colon.colon((Object)arrayType, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                Seq seq;
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    seq = (Seq)new .colon.colon((Object)new MapType(dt, valueType, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
                    return seq;
                } else {
                    seq = (Seq)Nil$.MODULE$;
                }
                return seq;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return (Seq)Nil$.MODULE$;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        void var1_8;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(67).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a ").append(IntegerType$.MODULE$.simpleString()).append(", but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                    return var1_8;
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !e2.sameType(e12 = (mapType = (MapType)dataType).keyType())) {
                TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(89).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(MapType$.MODULE$.simpleString()).append(" followed by a value of same key type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                return var1_8;
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(74).append("The first argument to function ").append(this.prettyName()).append(" should ").append("have been ").append(ArrayType$.MODULE$.simpleString()).append(" or ").append(MapType$.MODULE$.simpleString()).append(" type, but its ").append(this.left().dataType().catalogString()).append(" type.").toString());
            return var1_8;
        }
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        return var1_8;
    }

    private boolean nullability(Seq<Expression> elements, int ordinal) {
        return ordinal == 0 ? false : (elements.length() < package$.MODULE$.abs(ordinal) ? !this.failOnError() : (ordinal < 0 ? ((Expression)elements.apply(elements.length() + ordinal)).nullable() : ((Expression)elements.apply(ordinal - 1)).nullable()));
    }

    @Override
    public boolean nullable() {
        boolean bl;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            bl = this.computeNullabilityFromArray(this.left(), this.right(), this.failOnError(), (Function2<Seq<Expression>, Object, Object>)(Function2 & Serializable & scala.Serializable)(elements, ordinal) -> BoxesRunTime.boxToBoolean((boolean)this.nullability((Seq<Expression>)elements, BoxesRunTime.unboxToInt((Object)ordinal))));
        } else if (dataType instanceof MapType) {
            bl = this.failOnError() ? this.mapValueContainsNull() : true;
        } else {
            throw new MatchError((Object)dataType);
        }
        return bl;
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                Function2 & Serializable & scala.Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> {
                        Object object;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < package$.MODULE$.abs(index)) {
                            if (this.failOnError()) {
                                throw QueryExecutionErrors$.MODULE$.invalidArrayIndexError(index, array.numElements());
                            }
                            object = null;
                        } else {
                            if (index == 0) {
                                throw QueryExecutionErrors$.MODULE$.sqlArrayIndexNotStartAtOneError();
                            }
                            int idx = index > 0 ? index - 1 : array.numElements() + index;
                            object = this.arrayContainsNull() && array.isNullAt(idx) ? null : array.get(idx, this.dataType());
                        }
                        return object;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering(), this.failOnError());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        return (byte)(this.bitmap$trans$0 & 0x20) == 0 ? this.doElementAt$lzycompute() : this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                String index = ctx.freshName("elementAtIndex");
                String nullCheck = this.arrayContainsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n               |if (").append((String)eval1).append(".isNullAt(").append(index).append(")) {\n               |  ").append(ev.isNull()).append(" = true;\n               |} else\n             ").toString())).stripMargin() : "";
                String indexOutOfBoundBranch = this.failOnError() ? new StringBuilder(68).append("throw QueryExecutionErrors.invalidArrayIndexError(").append(index).append(", ").append((String)eval1).append(".numElements());").toString() : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(469).append("\n             |int ").append(index).append(" = (int) ").append((String)eval2).append(";\n             |if (").append((String)eval1).append(".numElements() < Math.abs(").append(index).append(")) {\n             |  ").append(indexOutOfBoundBranch).append("\n             |} else {\n             |  if (").append(index).append(" == 0) {\n             |    throw QueryExecutionErrors.sqlArrayIndexNotStartAtOneError();\n             |  } else if (").append(index).append(" > 0) {\n             |    ").append(index).append("--;\n             |  } else {\n             |    ").append(index).append(" += ").append((String)eval1).append(".numElements();\n             |  }\n             |  ").append(nullCheck).append("\n             |  {\n             |    ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index)).append(";\n             |  }\n             |}\n           ").toString())).stripMargin();
            });
        } else if (dataType instanceof MapType) {
            exprCode = this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType(), this.failOnError());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    @Override
    public ElementAt withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public ElementAt copy(Expression left, Expression right, boolean failOnError) {
        return new ElementAt(left, right, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.failOnError() != elementAt.failOnError()) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        GetMapValueUtil.$init$(this);
        GetArrayItemUtil.$init$(this);
    }

    public ElementAt(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

