/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Size$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the size of an array or a map.\n    The function returns null for null input if spark.sql.legacy.sizeOfNull is set to false or\n    spark.sql.ansi.enabled is set to true. Otherwise, the function returns -1 for null input.\n    With the default settings, the function returns -1 for null input.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'));\n       4\n      > SELECT _FUNC_(map('a', 1, 'b', 2));\n       2\n      > SELECT _FUNC_(NULL);\n       -1\n  ", since="1.5.0", group="collection_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u00051\t\u0003\u0005H\u0001\tE\t\u0015!\u0003E\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015A\u0005\u0001\"\u0001N\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015A\u0007\u0001\"\u0011D\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015!\b\u0001\"\u0011v\u0011\u001d\t9\u0001\u0001C)\u0003\u0013A\u0011\"a\u0004\u0001\u0003\u0003%\t!!\u0005\t\u0013\u0005]\u0001!%A\u0005\u0002\u0005e\u0001\"CA\u0018\u0001E\u0005I\u0011AA\u0019\u0011%\t)\u0004AA\u0001\n\u0003\n9\u0004C\u0005\u0002J\u0001\t\t\u0011\"\u0001\u0002L!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u00037\u0002\u0011\u0011!C!\u0003;B\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005E\u0004!!A\u0005B\u0005MtaBAL=!\u0005\u0011\u0011\u0014\u0004\u0007;yA\t!a'\t\r!;B\u0011AAR\u0011\u001d\t)k\u0006C\u0001\u0003OC\u0011\"!*\u0018\u0003\u0003%\t)a+\t\u0013\u0005Ev#!A\u0005\u0002\u0006M\u0006\"CAc/\u0005\u0005I\u0011BAd\u0005\u0011\u0019\u0016N_3\u000b\u0005}\u0001\u0013aC3yaJ,7o]5p]NT!!\t\u0012\u0002\u0011\r\fG/\u00197zgRT!a\t\u0013\u0002\u0007M\fHN\u0003\u0002&M\u0005)1\u000f]1sW*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00171ge\u0002\"!\f\u0018\u000e\u0003yI!a\f\u0010\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!L\u0019\n\u0005Ir\"!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t9\u0001K]8ek\u000e$\bC\u0001\u001b;\u0013\tYTG\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001?!\tis(\u0003\u0002A=\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003AaWmZ1dsNK'0Z(g\u001dVdG.F\u0001E!\t!T)\u0003\u0002Gk\t9!i\\8mK\u0006t\u0017!\u00057fO\u0006\u001c\u0017pU5{K>3g*\u001e7mA\u00051A(\u001b8jiz\"2AS&M!\ti\u0003\u0001C\u0003=\u000b\u0001\u0007a\bC\u0003C\u000b\u0001\u0007A\t\u0006\u0002K\u001d\")AH\u0002a\u0001}\u0005AA-\u0019;b)f\u0004X-F\u0001R!\t\u0011V+D\u0001T\u0015\t!&%A\u0003usB,7/\u0003\u0002W'\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0017\t\u00045\n,gBA.a\u001d\tav,D\u0001^\u0015\tq&&\u0001\u0004=e>|GOP\u0005\u0002m%\u0011\u0011-N\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019GMA\u0002TKFT!!Y\u001b\u0011\u0005I3\u0017BA4T\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f\u0003\u0011)g/\u00197\u0015\u0005-t\u0007C\u0001\u001bm\u0013\tiWGA\u0002B]fDqa\u001c\u0006\u0011\u0002\u0003\u0007\u0001/A\u0003j]B,H\u000f\u0005\u0002re6\t\u0001%\u0003\u0002tA\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\r\u0006\u0003wy\u0006\r\u0001CA<{\u001b\u0005A(BA=\u001f\u0003\u001d\u0019w\u000eZ3hK:L!a\u001f=\u0003\u0011\u0015C\bO]\"pI\u0016DQ!`\u0006A\u0002y\f1a\u0019;y!\t9x0C\u0002\u0002\u0002a\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u0006-\u0001\rA^\u0001\u0003KZ\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGc\u0001&\u0002\f!1\u0011Q\u0002\u0007A\u0002y\n\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0003K\u0003'\t)\u0002C\u0004=\u001bA\u0005\t\u0019\u0001 \t\u000f\tk\u0001\u0013!a\u0001\t\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u000eU\rq\u0014QD\u0016\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011F\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0005\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u001aU\r!\u0015QD\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0005Y\u0006twM\u0003\u0002\u0002D\u0005!!.\u0019<b\u0013\u0011\t9%!\u0010\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0005E\u00025\u0003\u001fJ1!!\u00156\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rY\u0017q\u000b\u0005\n\u00033\u0012\u0012\u0011!a\u0001\u0003\u001b\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA0!\u0015\t\t'a\u001al\u001b\t\t\u0019GC\u0002\u0002fU\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI'a\u0019\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\t\u0006=\u0004\u0002CA-)\u0005\u0005\t\u0019A6\u0002\r\u0015\fX/\u00197t)\r!\u0015Q\u000f\u0005\t\u00033*\u0012\u0011!a\u0001W\"\u001a\u0002!!\u001f\u0002\u0000\u0005\u0005\u0015QQAD\u0003\u0017\u000bi)!%\u0002\u0014B\u0019Q&a\u001f\n\u0007\u0005udDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\r\u0015Aa!\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043/\u001b>fA=4\u0007%\u00198!CJ\u0014\u0018-\u001f\u0011pe\u0002\n\u0007%\\1q])\u0001\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000e\t:fiV\u0014hn\u001d\u0011ok2d\u0007EZ8sA9,H\u000e\u001c\u0011j]B,H\u000fI5gAM\u0004\u0018M]6/gFdg\u0006\\3hC\u000eLhf]5{K>3g*\u001e7mA%\u001c\be]3uAQ|\u0007EZ1mg\u0016\u0004sN\u001d\u0006!A\u0001\u00023\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\rI5tAM,G\u000f\t;pAQ\u0014X/\u001a\u0018!\u001fRDWM]<jg\u0016d\u0003\u0005\u001e5fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\b%L\u0019!M>\u0014\bE\\;mY\u0002Jg\u000e];u])\u0001\u0003\u0005\t\u0011XSRD\u0007\u0005\u001e5fA\u0011,g-Y;mi\u0002\u001aX\r\u001e;j]\u001e\u001cH\u0006\t;iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000fI\u00172A\u0019|'\u000f\t8vY2\u0004\u0013N\u001c9vi:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011R\u0001\u0002R)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\":#m\n\u0017!O\u0011<C\u0006I\u0014dO1\u0002s%Y\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u0002CG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015nCBDs%Y\u0014-AEb\u0003e\n2(Y\u0001\u0012\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!e)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc*\u0016'MSmR\u0001\u0005\t\u0011!A\u0001\u0002S&\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qR\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003+\u000b\u0001cY8mY\u0016\u001cG/[8o?\u001a,hnY:\u0002\tMK'0\u001a\t\u0003[]\u0019BaFAOsA\u0019A'a(\n\u0007\u0005\u0005VG\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u00033\u000bQ!\u00199qYf$2ASAU\u0011\u0015a\u0014\u00041\u0001?)\u0015Q\u0015QVAX\u0011\u0015a$\u00041\u0001?\u0011\u0015\u0011%\u00041\u0001E\u0003\u001d)h.\u00199qYf$B!!.\u0002BB)A'a.\u0002<&\u0019\u0011\u0011X\u001b\u0003\r=\u0003H/[8o!\u0015!\u0014Q\u0018 E\u0013\r\ty,\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005\r7$!AA\u0002)\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005%\u0007\u0003BA\u001e\u0003\u0017LA!!4\u0002>\t1qJ\u00196fGR\u0004")
public class Size
extends UnaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression child;
    private final boolean legacySizeOfNull;

    public static Option<Tuple2<Expression, Object>> unapply(Size size) {
        return Size$.MODULE$.unapply(size);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean legacySizeOfNull() {
        return this.legacySizeOfNull;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public boolean nullable() {
        return this.legacySizeOfNull() ? false : super.nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        Integer n;
        Object value = this.child().eval(input);
        if (value == null) {
            n = this.legacySizeOfNull() ? BoxesRunTime.boxToInteger((int)-1) : null;
        } else {
            Integer n2;
            DataType dataType = this.child().dataType();
            if (dataType instanceof ArrayType) {
                n2 = BoxesRunTime.boxToInteger((int)((ArrayData)value).numElements());
            } else if (dataType instanceof MapType) {
                n2 = BoxesRunTime.boxToInteger((int)((MapData)value).numElements());
            } else {
                throw QueryExecutionErrors$.MODULE$.unsupportedOperandTypeForSizeFunctionError(dataType);
            }
            n = n2;
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        if (this.legacySizeOfNull()) {
            ExprCode childGen = this.child().genCode(ctx);
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      boolean ", " = false;\n      ", "\n      ", " ", " = ", " ? -1 :\n        (", ").numElements();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), childGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), childGen.isNull(), childGen.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(16).append("(").append((String)c).append(").numElements()").toString());
        }
        return exprCode;
    }

    @Override
    public Size withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Size copy(Expression child, boolean legacySizeOfNull) {
        return new Size(child, legacySizeOfNull);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.legacySizeOfNull();
    }

    @Override
    public String productPrefix() {
        return "Size";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.legacySizeOfNull());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Size)) return false;
        boolean bl = true;
        if (!bl) return false;
        Size size = (Size)x$1;
        Expression expression = this.child();
        Expression expression2 = size.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.legacySizeOfNull() != size.legacySizeOfNull()) return false;
        if (!size.canEqual(this)) return false;
        return true;
    }

    public Size(Expression child, boolean legacySizeOfNull) {
        this.child = child;
        this.legacySizeOfNull = legacySizeOfNull;
        ExpectsInputTypes.$init$(this);
    }

    public Size(Expression child) {
        this(child, SQLConf$.MODULE$.get().legacySizeOfNull());
    }
}

