/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n      _FUNC_(col, percentage [, frequency]) - Returns the exact percentile value of numeric column\n       `col` at the given percentage. The value of percentage must be between 0.0 and 1.0. The\n       value of frequency should be positive integral\n\n      _FUNC_(col, array(percentage1 [, percentage2]...) [, frequency]) - Returns the exact\n      percentile value array of numeric column `col` at the given percentage(s). Each value\n      of the percentage array must be between 0.0 and 1.0. The value of frequency should be\n      positive integral\n\n      ", examples="\n    Examples:\n      > SELECT _FUNC_(col, 0.3) FROM VALUES (0), (10) AS tab(col);\n       3.0\n      > SELECT _FUNC_(col, array(0.25, 0.75)) FROM VALUES (0), (10) AS tab(col);\n       [2.5,7.5]\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0001\r%b\u0001B\u001f?\u00016C\u0001B\u001e\u0001\u0003\u0016\u0004%\ta\u001e\u0005\tq\u0002\u0011\t\u0012)A\u0005[\"A\u0011\u0010\u0001BK\u0002\u0013\u0005q\u000f\u0003\u0005{\u0001\tE\t\u0015!\u0003n\u0011!Y\bA!f\u0001\n\u00039\b\u0002\u0003?\u0001\u0005#\u0005\u000b\u0011B7\t\u0011u\u0004!Q3A\u0005\u0002yD\u0011\"!\u0002\u0001\u0005#\u0005\u000b\u0011B@\t\u0013\u0005\u001d\u0001A!f\u0001\n\u0003q\b\"CA\u0005\u0001\tE\t\u0015!\u0003\u0000\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!a\u0003\u0001\t\u0003\tY\u0002C\u0004\u0002\f\u0001!\t!!\t\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0003bBA'\u0001\u0011\u0005\u0013q\n\u0005\u000b\u0003+\u0002\u0001R1A\u0005\n\u0005]\u0003BCA4\u0001!\u0015\r\u0011\"\u0003\u0002j!1\u0011\u0011\u0010\u0001\u0005B]Da!a\u001f\u0001\t\u0003:\bBBA?\u0001\u0011\u0005s\u000fC\u0004\u0002\u0000\u0001!\t%a\u0016\t\u0015\u0005\u0005\u0005\u0001#b\u0001\n\u0003\n\u0019\tC\u0004\u0002\u0012\u0002!\t%a%\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u0011Q\u0018\u0001\u0005\n\u0005}\u0006bBAf\u0001\u0011\u0005\u0013Q\u001a\u0005\b\u0003\u001f\u0004A\u0011IAi\u0011\u001d\t\u0019\u000f\u0001C!\u0003KDq!!<\u0001\t\u0003\ny\u000fC\u0004\u0002t\u0002!I!!>\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!1\u0001\u0001\u0005\n\t\u0015\u0001b\u0002B\f\u0001\u0011%!\u0011\u0004\u0005\b\u0005[\u0001A\u0011\tB\u0018\u0011\u001d\u0011i\u0004\u0001C!\u0005\u007fAqA!\u0012\u0001\t#\u00129\u0005C\u0005\u0003V\u0001\t\t\u0011\"\u0001\u0003X!I!1\r\u0001\u0012\u0002\u0013\u0005!Q\r\u0005\n\u0005w\u0002\u0011\u0013!C\u0001\u0005KB\u0011B! \u0001#\u0003%\tA!\u001a\t\u0013\t}\u0004!%A\u0005\u0002\t\u0005\u0005\"\u0003BC\u0001E\u0005I\u0011\u0001BA\u0011%\u00119\tAA\u0001\n\u0003\u0012I\t\u0003\u0005\u0003\u001a\u0002\t\t\u0011\"\u0001\u007f\u0011%\u0011Y\nAA\u0001\n\u0003\u0011i\nC\u0005\u0003$\u0002\t\t\u0011\"\u0011\u0003&\"I!\u0011\u0017\u0001\u0002\u0002\u0013\u0005!1\u0017\u0005\n\u0005o\u0003\u0011\u0011!C!\u0005s;\u0011B!8?\u0003\u0003E\tAa8\u0007\u0011ur\u0014\u0011!E\u0001\u0005CDq!a\u00034\t\u0003\u0011y\u000fC\u0005\u0003rN\n\t\u0011\"\u0012\u0003t\"I!Q_\u001a\u0002\u0002\u0013\u0005%q\u001f\u0005\n\u0007\u0007\u0019\u0014\u0013!C\u0001\u0005\u0003C\u0011b!\u00024#\u0003%\tA!!\t\u0013\r\u001d1'!A\u0005\u0002\u000e%\u0001\"CB\u000egE\u0005I\u0011\u0001BA\u0011%\u0019ibMI\u0001\n\u0003\u0011\t\tC\u0005\u0004 M\n\t\u0011\"\u0003\u0004\"\tQ\u0001+\u001a:dK:$\u0018\u000e\\3\u000b\u0005}\u0002\u0015!C1hOJ,w-\u0019;f\u0015\t\t%)A\u0006fqB\u0014Xm]:j_:\u001c(BA\"E\u0003!\u0019\u0017\r^1msN$(BA#G\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f\"\u000bQa\u001d9be.T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO\u000e\u00011C\u0002\u0001OG\u001e\u00048\u000fE\u0002P!Jk\u0011AP\u0005\u0003#z\u0012\u0001\u0004V=qK\u0012LU\u000e]3sCRLg/Z!hOJ,w-\u0019;f!\u0011\u0019\u0006L\u00171\u000e\u0003QS!!\u0016,\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002X\r\u0006!Q\u000f^5m\u0013\tIFKA\u0006Pa\u0016t\u0007*Y:i\u001b\u0006\u0004\bCA._\u001b\u0005a&\"A/\u0002\u000bM\u001c\u0017\r\\1\n\u0005}c&AB!osJ+g\r\u0005\u0002\\C&\u0011!\r\u0018\u0002\u0005\u0019>tw\r\u0005\u0002eK6\t\u0001)\u0003\u0002g\u0001\n1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000fE\u0002iW6l\u0011!\u001b\u0006\u0003U\n\u000bQ\u0001\u001e:fKNL!\u0001\\5\u0003\u0017Q+'O\\1ss2K7.\u001a\t\u0003I:L!a\u001c!\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002\\c&\u0011!\u000f\u0018\u0002\b!J|G-^2u!\tYF/\u0003\u0002v9\na1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\tQ.\u0001\u0004dQ&dG\rI\u0001\u0015a\u0016\u00148-\u001a8uC\u001e,W\t\u001f9sKN\u001c\u0018n\u001c8\u0002+A,'oY3oi\u0006<W-\u0012=qe\u0016\u001c8/[8oA\u0005\u0019bM]3rk\u0016t7-_#yaJ,7o]5p]\u0006!bM]3rk\u0016t7-_#yaJ,7o]5p]\u0002\na#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u000b\u0002\u007fB\u00191,!\u0001\n\u0007\u0005\rALA\u0002J]R\fq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002)%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003UIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002\na\u0001P5oSRtD\u0003DA\b\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u0001CA(\u0001\u0011\u001518\u00021\u0001n\u0011\u0015I8\u00021\u0001n\u0011\u0015Y8\u00021\u0001n\u0011\u001di8\u0002%AA\u0002}D\u0001\"a\u0002\f!\u0003\u0005\ra \u000b\u0007\u0003\u001f\ti\"a\b\t\u000bYd\u0001\u0019A7\t\u000bed\u0001\u0019A7\u0015\u0011\u0005=\u00111EA\u0013\u0003OAQA^\u0007A\u00025DQ!_\u0007A\u00025Da!!\u000b\u000e\u0001\u0004i\u0017!\u00034sKF,XM\\2z\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003_\u0001B!!\r\u0002@9!\u00111GA\u001e!\r\t)\u0004X\u0007\u0003\u0003oQ1!!\u000fM\u0003\u0019a$o\\8u}%\u0019\u0011Q\b/\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t%a\u0011\u0003\rM#(/\u001b8h\u0015\r\ti\u0004X\u0001\u001eo&$\bNT3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiR!\u0011qBA%\u0011\u0019\tYe\u0004a\u0001\u007f\u0006Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR!\u0011qBA)\u0011\u0019\t\u0019\u0006\u0005a\u0001\u007f\u00069b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0016e\u0016$XO\u001d8QKJ\u001cWM\u001c;jY\u0016\f%O]1z+\t\tI\u0006E\u0002\\\u00037J1!!\u0018]\u0005\u001d\u0011un\u001c7fC:D3!EA1!\rY\u00161M\u0005\u0004\u0003Kb&!\u0003;sC:\u001c\u0018.\u001a8u\u0003-\u0001XM]2f]R\fw-Z:\u0016\u0005\u0005-\u0004#B.\u0002n\u0005E\u0014bAA89\n)\u0011I\u001d:bsB\u00191,a\u001d\n\u0007\u0005UDL\u0001\u0004E_V\u0014G.\u001a\u0015\u0004%\u0005\u0005\u0014!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0005ok2d\u0017M\u00197f\u0003!!\u0017\r^1UsB,WCAAC!\u0011\t9)!$\u000e\u0005\u0005%%bAAF\t\u0006)A/\u001f9fg&!\u0011qRAE\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\u0011\u0011Q\u0013\t\u0007\u0003/\u000b\t+a*\u000f\t\u0005e\u0015Q\u0014\b\u0005\u0003k\tY*C\u0001^\u0013\r\ty\nX\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019+!*\u0003\u0007M+\u0017OC\u0002\u0002 r\u0003B!a\"\u0002*&!\u00111VAE\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u00022B!\u00111WA]\u001b\t\t)LC\u0002\u00028\n\u000b\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003w\u000b)LA\bUsB,7\t[3dWJ+7/\u001e7u\u00035!x\u000eR8vE2,g+\u00197vKR!\u0011\u0011OAa\u0011\u001d\t\u0019M\u0007a\u0001\u0003\u000b\f\u0011\u0001\u001a\t\u00047\u0006\u001d\u0017bAAe9\n\u0019\u0011I\\=\u0002/\r\u0014X-\u0019;f\u0003\u001e<'/Z4bi&|gNQ;gM\u0016\u0014H#\u0001*\u0002\rU\u0004H-\u0019;f)\u0015\u0011\u00161[Al\u0011\u0019\t)\u000e\ba\u0001%\u00061!-\u001e4gKJDq!!7\u001d\u0001\u0004\tY.A\u0003j]B,H\u000f\u0005\u0003\u0002^\u0006}W\"\u0001\"\n\u0007\u0005\u0005(IA\u0006J]R,'O\\1m%><\u0018!B7fe\u001e,G#\u0002*\u0002h\u0006%\bBBAk;\u0001\u0007!\u000b\u0003\u0004\u0002lv\u0001\rAU\u0001\u0006_RDWM]\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002F\u0006E\bBBAk=\u0001\u0007!+\u0001\bhKR\u0004VM]2f]RLG.Z:\u0015\t\u0005]\u0018\u0011 \t\u0007\u0003/\u000b\t+!\u001d\t\r\u0005Uw\u00041\u0001S\u000399WM\\3sCR,w*\u001e;qkR$B!!2\u0002\u0000\"9!\u0011\u0001\u0011A\u0002\u0005]\u0018a\u0002:fgVdGo]\u0001\u000eO\u0016$\b+\u001a:dK:$\u0018\u000e\\3\u0015\r\u0005E$q\u0001B\n\u0011\u001d\u0011I!\ta\u0001\u0005\u0017\t1\"Y4he\u0016\u001cu.\u001e8ugB1\u0011qSAQ\u0005\u001b\u0001Ra\u0017B\b5\u0002L1A!\u0005]\u0005\u0019!V\u000f\u001d7fe!9!QC\u0011A\u0002\u0005E\u0014\u0001\u00039pg&$\u0018n\u001c8\u0002#\tLg.\u0019:z'\u0016\f'o\u00195D_VtG\u000fF\u0005\u0000\u00057\u0011\tC!\n\u0003*!9!Q\u0004\u0012A\u0002\t}\u0011aC2pk:$8/\u0011:sCf\u0004BaWA7A\"1!1\u0005\u0012A\u0002}\fQa\u001d;beRDaAa\n#\u0001\u0004y\u0018aA3oI\"1!1\u0006\u0012A\u0002\u0001\fQA^1mk\u0016\f\u0011b]3sS\u0006d\u0017N_3\u0015\t\tE\"\u0011\b\t\u00067\u00065$1\u0007\t\u00047\nU\u0012b\u0001B\u001c9\n!!)\u001f;f\u0011\u0019\u0011Yd\ta\u0001%\u0006\u0019qN\u00196\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004%\n\u0005\u0003b\u0002B\"I\u0001\u0007!\u0011G\u0001\u0006Ef$Xm]\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$\u0002\"a\u0004\u0003J\t5#\u0011\u000b\u0005\u0007\u0005\u0017*\u0003\u0019A7\u0002\u00119,wOR5sgRDaAa\u0014&\u0001\u0004i\u0017!\u00038foN+7m\u001c8e\u0011\u0019\u0011\u0019&\na\u0001[\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLH\u0003DA\b\u00053\u0012YF!\u0018\u0003`\t\u0005\u0004b\u0002<'!\u0003\u0005\r!\u001c\u0005\bs\u001a\u0002\n\u00111\u0001n\u0011\u001dYh\u0005%AA\u00025Dq! \u0014\u0011\u0002\u0003\u0007q\u0010\u0003\u0005\u0002\b\u0019\u0002\n\u00111\u0001\u0000\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u001a+\u00075\u0014Ig\u000b\u0002\u0003lA!!Q\u000eB<\u001b\t\u0011yG\u0003\u0003\u0003r\tM\u0014!C;oG\",7m[3e\u0015\r\u0011)\bX\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B=\u0005_\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\r%fA@\u0003j\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\fB!!Q\u0012BL\u001b\t\u0011yI\u0003\u0003\u0003\u0012\nM\u0015\u0001\u00027b]\u001eT!A!&\u0002\t)\fg/Y\u0005\u0005\u0003\u0003\u0012y)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015'q\u0014\u0005\t\u0005Cs\u0013\u0011!a\u0001\u007f\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa*\u0011\r\t%&QVAc\u001b\t\u0011YK\u0003\u0002V9&!!q\u0016BV\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e#Q\u0017\u0005\n\u0005C\u0003\u0014\u0011!a\u0001\u0003\u000b\fa!Z9vC2\u001cH\u0003BA-\u0005wC\u0011B!)2\u0003\u0003\u0005\r!!2)'\u0001\u0011yL!2\u0003H\n-'Q\u001aBi\u0005'\u00149N!7\u0011\u0007\u0011\u0014\t-C\u0002\u0003D\u0002\u0013Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003J\u0006!IF\u0003\u0011!A\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006fY8mY\u0001\u0002XM]2f]R\fw-\u001a\u0011\\Y\u00012'/Z9vK:\u001c\u00170X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!Kb\f7\r\u001e\u0011qKJ\u001cWM\u001c;jY\u0016\u0004c/\u00197vK\u0002zg\r\t8v[\u0016\u0014\u0018n\u0019\u0011d_2,XN\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0011aG>d\u0007\rI1uAQDW\rI4jm\u0016t\u0007\u0005]3sG\u0016tG/Y4f]\u0001\"\u0006.\u001a\u0011wC2,X\rI8gAA,'oY3oi\u0006<W\rI7vgR\u0004#-\u001a\u0011cKR<X-\u001a8!a9\u0002\u0004%\u00198eAEr\u0003G\f\u0011UQ\u0016T\u0001\u0005\t\u0011!A\u0001\u0002c/\u00197vK\u0002zg\r\t4sKF,XM\\2zAMDw.\u001e7eA\t,\u0007\u0005]8tSRLg/\u001a\u0011j]R,wM]1m\u0015)\u0001\u0003\u0005\t\u0011!A}3UKT\"`Q\r|G\u000e\f\u0011beJ\f\u0017\u0010\u000b9fe\u000e,g\u000e^1hKF\u00023\f\f\u0011qKJ\u001cWM\u001c;bO\u0016\u0014TL\f\u0018/S\u0001ZF\u0006\t4sKF,XM\\2z;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004S\r_1di*\u0001\u0003\u0005\t\u0011!AA,'oY3oi&dW\r\t<bYV,\u0007%\u0019:sCf\u0004sN\u001a\u0011ok6,'/[2!G>dW/\u001c8!A\u000e|G\u000e\u0019\u0011bi\u0002\"\b.\u001a\u0011hSZ,g\u000e\t9fe\u000e,g\u000e^1hK\"\u001a\u0018F\f\u0011FC\u000eD\u0007E^1mk\u0016T\u0001\u0005\t\u0011!A\u0001zg\r\t;iK\u0002\u0002XM]2f]R\fw-\u001a\u0011beJ\f\u0017\u0010I7vgR\u0004#-\u001a\u0011cKR<X-\u001a8!a9\u0002\u0004%\u00198eAEr\u0003G\f\u0011UQ\u0016\u0004c/\u00197vK\u0002zg\r\t4sKF,XM\\2zAMDw.\u001e7eA\t,'\u0002\t\u0011!A\u0001\u0002\u0003o\\:ji&4X\rI5oi\u0016<'/\u00197\u000b\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001Bh\u0003\u0005\r%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0003GL\u001a*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005K\u00191S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMr\u0003G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2d\u0003%\u0019:sCfD\u0003G\f\u001a6Y\u0001\u0002dfN\u001b*S\u00012%kT'!-\u0006cU+R*!QAJC\u0006\t\u00152a%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&GL\u001b-o9*TL\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011).A\u0005bO\u001e|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!1\\\u0001\u0006e9\nd\u0006M\u0001\u000b!\u0016\u00148-\u001a8uS2,\u0007CA(4'\u0011\u0019$1]:\u0011\u0017\t\u0015(1^7n[~|\u0018qB\u0007\u0003\u0005OT1A!;]\u0003\u001d\u0011XO\u001c;j[\u0016LAA!<\u0003h\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001b\u0015\u0005\t}\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t-\u0015!B1qa2LH\u0003DA\b\u0005s\u0014YP!@\u0003\u0000\u000e\u0005\u0001\"\u0002<7\u0001\u0004i\u0007\"B=7\u0001\u0004i\u0007\"B>7\u0001\u0004i\u0007bB?7!\u0003\u0005\ra \u0005\t\u0003\u000f1\u0004\u0013!a\u0001\u007f\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0003\u001d)h.\u00199qYf$Baa\u0003\u0004\u0018A)1l!\u0004\u0004\u0012%\u00191q\u0002/\u0003\r=\u0003H/[8o!!Y61C7n[~|\u0018bAB\u000b9\n1A+\u001e9mKVB\u0011b!\u0007:\u0003\u0003\u0005\r!a\u0004\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007G\u0001BA!$\u0004&%!1q\u0005BH\u0005\u0019y%M[3di\u0002")
public class Percentile
extends TypedImperativeAggregate<OpenHashMap<Object, Object>>
implements ImplicitCastInputTypes,
TernaryLike<Expression>,
scala.Serializable {
    private transient boolean returnPercentileArray;
    private transient double[] percentages;
    private DataType dataType;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression frequencyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$5() {
        return Percentile$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return Percentile$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(Percentile percentile) {
        return Percentile$.MODULE$.unapply(percentile);
    }

    public static int apply$default$5() {
        return Percentile$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return Percentile$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<Expression, Expression, Expression, Object, Object>, Percentile> tupled() {
        return Percentile$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, Percentile>>>>> curried() {
        return Percentile$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.children$lzycompute() : this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression frequencyExpression() {
        return this.frequencyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "percentile";
    }

    @Override
    public Percentile withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public Percentile withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    private boolean returnPercentileArray$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.returnPercentileArray = this.percentageExpression().dataType() instanceof ArrayType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                double[] dArray;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object == null) {
                    dArray = null;
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    dArray = new double[]{d};
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    dArray = arrayData.toDoubleArray();
                } else {
                    throw new MatchError(object);
                }
                this.percentages = dArray;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.percentageExpression();
    }

    @Override
    public Expression third() {
        return this.frequencyExpression();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private DataType dataType$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if (!this.bitmap$0) {
                DataType dataType = this.percentageExpression().dataType();
                DataType dataType2 = dataType instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
                this.dataType = dataType2;
                this.bitmap$0 = true;
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return !this.bitmap$0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        DataType dataType = this.percentageExpression().dataType();
        DataType dataType2 = dataType instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
        DoubleType$ percentageExpType = dataType2;
        return (Seq)new .colon.colon((Object)NumericType$.MODULE$, (List)new .colon.colon((Object)percentageExpType, (List)new .colon.colon((Object)IntegralType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(54).append("The percentage(s) must be a constant literal, ").append("but got ").append(this.percentageExpression()).toString()) : (this.percentages() == null ? new TypeCheckResult.TypeCheckFailure("Percentage value must not be null") : (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(51).append("Percentage(s) must be between 0.0 and 1.0, ").append("but got ").append(this.percentageExpression()).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$)));
    }

    private double toDoubleValue(Object d) {
        double d2;
        Object object = d;
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            d2 = decimal.toDouble();
        } else if (object instanceof Number) {
            Number number = (Number)object;
            d2 = number.doubleValue();
        } else {
            throw new MatchError(object);
        }
        return d2;
    }

    @Override
    public OpenHashMap<Object, Object> createAggregationBuffer() {
        return new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
    }

    @Override
    public OpenHashMap<Object, Object> update(OpenHashMap<Object, Object> buffer, InternalRow input) {
        Object object;
        Object key = this.child().eval(input);
        Object frqValue = this.frequencyExpression().eval(input);
        if (key != null && frqValue != null) {
            long frqLong = ((Number)frqValue).longValue();
            if (frqLong > 0L) {
                object = BoxesRunTime.boxToLong((long)buffer.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> frqLong, (Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$1 -> x$1 + frqLong));
            } else {
                if (frqLong < 0L) {
                    throw QueryExecutionErrors$.MODULE$.negativeValueUnexpectedError(this.frequencyExpression());
                }
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return buffer;
    }

    @Override
    public OpenHashMap<Object, Object> merge(OpenHashMap<Object, Object> buffer, OpenHashMap<Object, Object> other) {
        other.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)Percentile.$anonfun$merge$1(buffer, x0$1)));
        return buffer;
    }

    @Override
    public Object eval(OpenHashMap<Object, Object> buffer) {
        return this.generateOutput(this.getPercentiles(buffer));
    }

    private Seq<Object> getPercentiles(OpenHashMap<Object, Object> buffer) {
        if (buffer.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        Seq sortedCounts = (Seq)buffer.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3._1(), ((NumericType)this.child().dataType()).ordering());
        Seq accumulatedCounts = (Seq)((TraversableLike)sortedCounts.scanLeft((Object)new Tuple2(((Tuple2)sortedCounts.head())._1(), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            long count1;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    count1 = tuple23._2$mcJ$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Object key2 = tuple2._1();
            long count2 = tuple2._2$mcJ$sp();
            Tuple2 tuple24 = new Tuple2(key2, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
            return tuple24;
        }, Seq$.MODULE$.canBuildFrom())).tail();
        long maxPosition = ((Tuple2)accumulatedCounts.last())._2$mcJ$sp() - 1L;
        return (Seq)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)percentile -> this.getPercentile((Seq<Tuple2<Object, Object>>)accumulatedCounts, (double)maxPosition * percentile), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private Object generateOutput(Seq<Object> results) {
        return results.isEmpty() ? null : (this.returnPercentileArray() ? new GenericArrayData(results) : results.head());
    }

    private double getPercentile(Seq<Tuple2<Object, Object>> aggreCounts, double position) {
        long lower = (long)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(position));
        long higher = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(position));
        long[] countsArray = (long[])((TraversableOnce)aggreCounts.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
        int lowerIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), lower + 1L);
        int higherIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), higher + 1L);
        Object lowerKey = ((Tuple2)aggreCounts.apply(lowerIndex))._1();
        if (higher == lower) {
            return this.toDoubleValue(lowerKey);
        }
        Object higherKey = ((Tuple2)aggreCounts.apply(higherIndex))._1();
        if (BoxesRunTime.equals((Object)higherKey, (Object)lowerKey)) {
            return this.toDoubleValue(lowerKey);
        }
        return ((double)higher - position) * this.toDoubleValue(lowerKey) + (position - (double)lower) * this.toDoubleValue(higherKey);
    }

    private int binarySearchCount(long[] countsArray, int start, int end, long value) {
        int n = Arrays.binarySearch(countsArray, 0, end, value);
        switch (n) {
            default: 
        }
        return n < 0 ? -(n + 1) : n;
    }

    @Override
    public byte[] serialize(OpenHashMap<Object, Object> obj) {
        byte[] byArray;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        try {
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{this.child().dataType(), LongType$.MODULE$}));
            obj.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Percentile.$anonfun$serialize$1(projection, out, buffer, x0$1);
                return BoxedUnit.UNIT;
            });
            out.writeInt(-1);
            out.flush();
            byArray = bos.toByteArray();
        }
        finally {
            out.close();
            bos.close();
        }
        return byArray;
    }

    @Override
    public OpenHashMap<Object, Object> deserialize(byte[] bytes) {
        OpenHashMap.mcJ.sp sp2;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream ins = new DataInputStream(bis);
        try {
            OpenHashMap.mcJ.sp counts = new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
            int sizeOfNextRow = ins.readInt();
            while (sizeOfNextRow >= 0) {
                byte[] bs = new byte[sizeOfNextRow];
                ins.readFully(bs);
                UnsafeRow row = new UnsafeRow(2);
                row.pointTo(bs, sizeOfNextRow);
                Object key = row.get(0, this.child().dataType());
                long count = BoxesRunTime.unboxToLong((Object)row.get(1, LongType$.MODULE$));
                counts.update$mcJ$sp(key, count);
                sizeOfNextRow = ins.readInt();
            }
            sp2 = counts;
        }
        finally {
            ins.close();
            bis.close();
        }
        return sp2;
    }

    @Override
    public Percentile withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4(), this.copy$default$5());
    }

    public Percentile copy(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new Percentile(child, percentageExpression, frequencyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.frequencyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "Percentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.frequencyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Percentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Percentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        Percentile percentile = (Percentile)x$1;
        Expression expression = this.child();
        Expression expression2 = percentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = percentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.frequencyExpression();
        Expression expression6 = percentile.frequencyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != percentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != percentile.inputAggBufferOffset()) return false;
        if (!percentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$merge$1(OpenHashMap buffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        long count = tuple2._2$mcJ$sp();
        long l = buffer$1.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> count, (Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$2 -> x$2 + count);
        return l;
    }

    public static final /* synthetic */ void $anonfun$serialize$1(UnsafeProjection projection$1, DataOutputStream out$1, byte[] buffer$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        long count = tuple2._2$mcJ$sp();
        InternalRow row = InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)count)}));
        UnsafeRow unsafeRow = projection$1.apply(row);
        out$1.writeInt(unsafeRow.getSizeInBytes());
        unsafeRow.writeToStream(out$1, buffer$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.frequencyExpression = frequencyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        TernaryLike.$init$(this);
    }

    public Percentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L)), 0, 0);
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequency) {
        this(child, percentageExpression, frequency, 0, 0);
    }
}

