/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.UserDefinedExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.CentralMomentAgg;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.optimizer.EliminateSorts$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Repartition;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class EliminateSorts$
extends Rule<LogicalPlan> {
    public static EliminateSorts$ MODULE$;
    private final PartialFunction<LogicalPlan, LogicalPlan> org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally;

    static {
        new EliminateSorts$();
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.transform(this.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally());
    }

    public PartialFunction<LogicalPlan, LogicalPlan> org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally() {
        return this.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally;
    }

    public LogicalPlan org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort(LogicalPlan plan3) {
        LogicalPlan logicalPlan;
        while ((logicalPlan = plan3) instanceof Sort) {
            LogicalPlan child;
            Sort sort = (Sort)logicalPlan;
            plan3 = child = sort.child();
        }
        LogicalPlan logicalPlan2 = this.canEliminateSort(logicalPlan) ? (LogicalPlan)logicalPlan.withNewChildren((Seq)logicalPlan.children().map((Function1 & Serializable & scala.Serializable)plan2 -> MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort((LogicalPlan)plan2), Seq$.MODULE$.canBuildFrom())) : plan3;
        return logicalPlan2;
    }

    private boolean canEliminateSort(LogicalPlan plan2) {
        boolean bl;
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            bl = project.projectList().forall((Function1 & Serializable & scala.Serializable)x$63 -> BoxesRunTime.boxToBoolean((boolean)EliminateSorts$.$anonfun$canEliminateSort$1(x$63)));
        } else if (logicalPlan instanceof Filter) {
            Filter filter = (Filter)logicalPlan;
            bl = filter.condition().deterministic();
        } else if (logicalPlan instanceof RepartitionByExpression) {
            RepartitionByExpression repartitionByExpression = (RepartitionByExpression)logicalPlan;
            bl = repartitionByExpression.partitionExpressions().forall((Function1 & Serializable & scala.Serializable)x$64 -> BoxesRunTime.boxToBoolean((boolean)x$64.deterministic()));
        } else {
            bl = logicalPlan instanceof Repartition;
        }
        return bl;
    }

    public boolean org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$isOrderIrrelevantAggs(Seq<NamedExpression> aggs) {
        return aggs.forall((Function1 & Serializable & scala.Serializable)expr -> BoxesRunTime.boxToBoolean((boolean)EliminateSorts$.checkValidAggregateExpression$1(expr)));
    }

    public static final /* synthetic */ boolean $anonfun$canEliminateSort$1(NamedExpression x$63) {
        return ((Expression)((Object)x$63)).deterministic();
    }

    private static final boolean isOrderIrrelevantAggFunction$1(AggregateFunction func) {
        boolean bl;
        AggregateFunction aggregateFunction = func;
        boolean bl2 = aggregateFunction instanceof Min ? true : (aggregateFunction instanceof Max ? true : (aggregateFunction instanceof Count ? true : aggregateFunction instanceof BitAggregate));
        boolean bl3 = bl2 ? true : ((bl = aggregateFunction instanceof Sum ? true : (aggregateFunction instanceof Average ? true : aggregateFunction instanceof CentralMomentAgg)) ? !((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FractionalType[]{FloatType$.MODULE$, DoubleType$.MODULE$}))).exists((Function1 & Serializable & scala.Serializable)x$65 -> BoxesRunTime.boxToBoolean((boolean)x$65.sameType(((Expression)func.children().head()).dataType()))) : false);
        return bl3;
    }

    private static final boolean checkValidAggregateExpression$1(Expression expr2) {
        boolean bl;
        Expression expression = expr2;
        if (expression instanceof AttributeReference) {
            bl = true;
        } else if (expression instanceof AggregateExpression) {
            AggregateExpression aggregateExpression = (AggregateExpression)expression;
            bl = EliminateSorts$.isOrderIrrelevantAggFunction$1(aggregateExpression.aggregateFunction());
        } else {
            bl = expression instanceof UserDefinedExpression ? false : expression.children().forall((Function1 & Serializable & scala.Serializable)expr -> BoxesRunTime.boxToBoolean((boolean)EliminateSorts$.checkValidAggregateExpression$1(expr)));
        }
        return bl;
    }

    private EliminateSorts$() {
        MODULE$ = this;
        this.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                Sort sort = null;
                A1 A1 = x1;
                if (A1 instanceof Sort) {
                    bl = true;
                    sort = (Sort)A1;
                    Seq<SortOrder> orders = sort.order();
                    LogicalPlan child = sort.child();
                    if (orders.isEmpty() || orders.exists((Function1 & Serializable & scala.Serializable)x$60 -> BoxesRunTime.boxToBoolean((boolean)anonfun.3.$anonfun$applyOrElse$28(x$60)))) {
                        Seq newOrders = (Seq)orders.filterNot((Function1 & Serializable & scala.Serializable)x$61 -> BoxesRunTime.boxToBoolean((boolean)anonfun.3.$anonfun$applyOrElse$29(x$61)));
                        object = newOrders.isEmpty() ? ((Option)EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally().lift().apply((Object)child)).getOrElse((Function0 & Serializable & scala.Serializable)() -> child) : sort.copy((Seq<SortOrder>)newOrders, sort.copy$default$2(), sort.copy$default$3());
                        return (B1)object;
                    }
                }
                if (bl) {
                    Seq<SortOrder> orders = sort.order();
                    boolean bl2 = sort.global();
                    LogicalPlan child = sort.child();
                    if (!bl2 && SortOrder$.MODULE$.orderingSatisfies(child.outputOrdering(), orders)) {
                        object = ((Option)EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$applyLocally().lift().apply((Object)child)).getOrElse((Function0 & Serializable & scala.Serializable)() -> child);
                        return (B1)object;
                    }
                }
                if (bl) {
                    LogicalPlan child = sort.child();
                    LogicalPlan x$1 = EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort(child);
                    Seq<SortOrder> x$2 = sort.copy$default$1();
                    boolean x$3 = sort.copy$default$2();
                    object = sort.copy(x$2, x$3, x$1);
                    return (B1)object;
                }
                if (A1 instanceof Join) {
                    Join join = (Join)A1;
                    LogicalPlan originLeft = join.left();
                    LogicalPlan originRight = join.right();
                    Option<Expression> cond = join.condition();
                    if (cond.forall((Function1 & Serializable & scala.Serializable)x$62 -> BoxesRunTime.boxToBoolean((boolean)anonfun.3.$anonfun$applyOrElse$32(x$62)))) {
                        object = join.copy(EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort(originLeft), EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort(originRight), join.copy$default$3(), join.copy$default$4(), join.copy$default$5());
                        return (B1)object;
                    }
                }
                if (A1 instanceof Aggregate) {
                    Aggregate aggregate = (Aggregate)A1;
                    Seq<NamedExpression> aggs = aggregate.aggregateExpressions();
                    LogicalPlan originChild = aggregate.child();
                    if (EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$isOrderIrrelevantAggs(aggs)) {
                        LogicalPlan x$4 = EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$recursiveRemoveSort(originChild);
                        Seq<Expression> x$5 = aggregate.copy$default$1();
                        Seq<NamedExpression> x$6 = aggregate.copy$default$2();
                        object = aggregate.copy(x$5, x$6, x$4);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                Join join;
                Option<Expression> cond;
                boolean bl = false;
                Sort sort = null;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof Sort) {
                    bl = true;
                    sort = (Sort)logicalPlan;
                    Seq<SortOrder> orders = sort.order();
                    if (orders.isEmpty()) return true;
                    if (orders.exists((Function1 & Serializable & scala.Serializable)x$60 -> BoxesRunTime.boxToBoolean((boolean)anonfun.3.$anonfun$isDefinedAt$4(x$60)))) {
                        return true;
                    }
                }
                if (bl) {
                    Seq<SortOrder> orders = sort.order();
                    boolean bl2 = sort.global();
                    LogicalPlan child = sort.child();
                    if (!bl2 && SortOrder$.MODULE$.orderingSatisfies(child.outputOrdering(), orders)) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (logicalPlan instanceof Join && (cond = (join = (Join)logicalPlan).condition()).forall((Function1 & Serializable & scala.Serializable)x$62 -> BoxesRunTime.boxToBoolean((boolean)anonfun.3.$anonfun$isDefinedAt$5(x$62)))) {
                    return true;
                }
                if (!(logicalPlan instanceof Aggregate)) return false;
                Aggregate aggregate = (Aggregate)logicalPlan;
                Seq<NamedExpression> aggs = aggregate.aggregateExpressions();
                if (!EliminateSorts$.MODULE$.org$apache$spark$sql$catalyst$optimizer$EliminateSorts$$isOrderIrrelevantAggs(aggs)) return false;
                return true;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$28(SortOrder x$60) {
                return x$60.child().foldable();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$29(SortOrder x$61) {
                return x$61.child().foldable();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$32(Expression x$62) {
                return x$62.deterministic();
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$4(SortOrder x$60) {
                return x$60.child().foldable();
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$5(Expression x$62) {
                return x$62.deterministic();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$28$adapted(org.apache.spark.sql.catalyst.expressions.SortOrder ), $anonfun$applyOrElse$29$adapted(org.apache.spark.sql.catalyst.expressions.SortOrder ), $anonfun$applyOrElse$30(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$31(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$32$adapted(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$isDefinedAt$4$adapted(org.apache.spark.sql.catalyst.expressions.SortOrder ), $anonfun$isDefinedAt$5$adapted(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        };
    }
}

