/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.WidthBucket$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(value, min_value, max_value, num_bucket) - Returns the bucket number to which\n      `value` would be assigned in an equiwidth histogram with `num_bucket` buckets,\n      in the range `min_value` to `max_value`.\"\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(5.3, 0.2, 10.6, 5);\n       3\n      > SELECT _FUNC_(-2.1, 1.3, 3.4, 3);\n       0\n      > SELECT _FUNC_(8.1, 0.0, 5.7, 4);\n       5\n      > SELECT _FUNC_(-0.9, 5.2, 0.5, 2);\n       3\n  ", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0001\t]r!B\u0013'\u0011\u0003\u0019d!B\u001b'\u0011\u00031\u0004\"\u0002!\u0002\t\u0003\t\u0005\"\u0002\"\u0002\t\u0003\u0019\u0005\"B-\u0002\t\u0003Q\u0006\"\u00022\u0002\t\u0003\u0019\u0007b\u00025\u0002\u0003\u0003%\t)\u001b\u0005\n\u00053\t\u0011\u0011!CA\u00057A\u0011B!\f\u0002\u0003\u0003%IAa\f\u0007\tU2\u0003i\u001b\u0005\t\u001b&\u0011)\u001a!C\u0001y\"I\u0011\u0011A\u0005\u0003\u0012\u0003\u0006I! \u0005\n\u0003\u0007I!Q3A\u0005\u0002qD\u0011\"!\u0002\n\u0005#\u0005\u000b\u0011B?\t\u0013\u0005\u001d\u0011B!f\u0001\n\u0003a\b\"CA\u0005\u0013\tE\t\u0015!\u0003~\u0011!1\u0016B!f\u0001\n\u0003a\b\"CA\u0006\u0013\tE\t\u0015!\u0003~\u0011\u0019\u0001\u0015\u0002\"\u0001\u0002\u000e!9\u0011qC\u0005\u0005B\u0005e\u0001bBA\u0019\u0013\u0011\u0005\u00131\u0007\u0005\b\u0003\u0007JA\u0011IA#\u0011\u001d\ti%\u0003C!\u0003\u001fBq!!\u0015\n\t\u0003\n\u0019\u0006C\u0004\u0002f%!\t&a\u001a\t\u000f\u0005e\u0014\u0002\"\u0011\u0002|!I\u0011qS\u0005\u0002\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003GK\u0011\u0013!C\u0001\u0003KC\u0011\"a/\n#\u0003%\t!!*\t\u0013\u0005u\u0016\"%A\u0005\u0002\u0005\u0015\u0006\"CA`\u0013E\u0005I\u0011AAS\u0011%\t\t-CA\u0001\n\u0003\n\u0019\rC\u0005\u0002J&\t\t\u0011\"\u0001\u0002L\"I\u00111[\u0005\u0002\u0002\u0013\u0005\u0011Q\u001b\u0005\n\u00037L\u0011\u0011!C!\u0003;D\u0011\"a;\n\u0003\u0003%\t!!<\t\u0013\u0005E\u0018\"!A\u0005B\u0005M\u0018aC,jIRD')^2lKRT!a\n\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003S)\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003W1\n1a]9m\u0015\tic&A\u0003ta\u0006\u00148N\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<7\u0001\u0001\t\u0003i\u0005i\u0011A\n\u0002\f/&$G\u000f\u001b\"vG.,GoE\u0002\u0002ou\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a!\u00118z%\u00164\u0007C\u0001\u001d?\u0013\ty\u0014H\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002g\u0005\u00192m\\7qkR,')^2lKRtU/\u001c2feR)A\tT)T+B\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0005Y\u0006twMC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-3%\u0001\u0002'p]\u001eDQ!T\u0002A\u00029\u000bQA^1mk\u0016\u0004\"\u0001O(\n\u0005AK$A\u0002#pk\ndW\rC\u0003S\u0007\u0001\u0007a*A\u0002nS:DQ\u0001V\u0002A\u00029\u000b1!\\1y\u0011\u001516\u00011\u0001X\u0003%qW/\u001c\"vG.,G\u000f\u0005\u000291&\u00111*O\u0001\u0007SNtU\u000f\u001c7\u0015\u000bmsv\fY1\u0011\u0005ab\u0016BA/:\u0005\u001d\u0011un\u001c7fC:DQ!\u0014\u0003A\u00029CQA\u0015\u0003A\u00029CQ\u0001\u0016\u0003A\u00029CQA\u0016\u0003A\u0002]\u000b!dY8naV$XMQ;dW\u0016$h*^7cKJtu\u000e\u001e(vY2$R\u0001\u00123fM\u001eDQ!T\u0003A\u00029CQAU\u0003A\u00029CQ\u0001V\u0003A\u00029CQAV\u0003A\u0002]\u000bQ!\u00199qYf$\u0012B\u001bB\t\u0005'\u0011)Ba\u0006\u0011\u0005QJ1CB\u0005m_JLX\b\u0005\u00025[&\u0011aN\n\u0002\u0015#V\fG/\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005Q\u0002\u0018BA9'\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA:w\u001d\t!D/\u0003\u0002vM\u00059\u0001/Y2lC\u001e,\u0017BA<y\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!!\u001e\u0014\u0011\u0005aR\u0018BA>:\u0005\u001d\u0001&o\u001c3vGR,\u0012! \t\u0003iyL!a \u0014\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004wC2,X\rI\u0001\t[&tg+\u00197vK\u0006IQ.\u001b8WC2,X\rI\u0001\t[\u0006Dh+\u00197vK\u0006IQ.\u0019=WC2,X\rI\u0001\u000b]Vl')^2lKR\u0004C#\u00036\u0002\u0010\u0005E\u00111CA\u000b\u0011\u0015i%\u00031\u0001~\u0011\u0019\t\u0019A\u0005a\u0001{\"1\u0011q\u0001\nA\u0002uDQA\u0016\nA\u0002u\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u00037\u0001R!!\b\u0002,utA!a\b\u0002*9!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&I\na\u0001\u0010:p_Rt\u0014\"\u0001\u001e\n\u0005UL\u0014\u0002BA\u0017\u0003_\u00111aU3r\u0015\t)\u0018(\u0001\u0006j]B,H\u000fV=qKN,\"!!\u000e\u0011\r\u0005u\u00111FA\u001c!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001fU\u0005)A/\u001f9fg&!\u0011\u0011IA\u001e\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\t9\u0005\u0005\u0003\u0002:\u0005%\u0013\u0002BA&\u0003w\u0011\u0001\u0002R1uCRK\b/Z\u0001\t]VdG.\u00192mKV\t1,\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0016\u0011\t\u0005]\u0013q\f\b\u0005\u00033\nY\u0006E\u0002\u0002\"eJ1!!\u0018:\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011MA2\u0005\u0019\u0019FO]5oO*\u0019\u0011QL\u001d\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0015\u0005%\u0014qNA:\u0003k\n9\bE\u00029\u0003WJ1!!\u001c:\u0005\r\te.\u001f\u0005\b\u0003cB\u0002\u0019AA5\u0003\u0015Ig\u000e];u\u0011\u0019\u0011\u0006\u00041\u0001\u0002j!1A\u000b\u0007a\u0001\u0003SBaA\u0016\rA\u0002\u0005%\u0014!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ti(!#\u0002\u0014B!\u0011qPAC\u001b\t\t\tIC\u0002\u0002\u0004\u001a\nqaY8eK\u001e,g.\u0003\u0003\u0002\b\u0006\u0005%\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005-\u0015\u00041\u0001\u0002\u000e\u0006\u00191\r\u001e=\u0011\t\u0005}\u0014qR\u0005\u0005\u0003#\u000b\tI\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005U\u0015\u00041\u0001\u0002~\u0005\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0005k\u00037\u000bi*a(\u0002\"\"9QJ\u0007I\u0001\u0002\u0004i\b\u0002CA\u00025A\u0005\t\u0019A?\t\u0011\u0005\u001d!\u0004%AA\u0002uDqA\u0016\u000e\u0011\u0002\u0003\u0007Q0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d&fA?\u0002*.\u0012\u00111\u0016\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003%)hn\u00195fG.,GMC\u0002\u00026f\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI,a,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002FB\u0019Q)a2\n\u0007\u0005\u0005d)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002NB\u0019\u0001(a4\n\u0007\u0005E\u0017HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002j\u0005]\u0007\"CAmC\u0005\u0005\t\u0019AAg\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u001c\t\u0007\u0003C\f9/!\u001b\u000e\u0005\u0005\r(bAAss\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00181\u001d\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002\\\u0003_D\u0011\"!7$\u0003\u0003\u0005\r!!\u001b\u0002\r\u0015\fX/\u00197t)\rY\u0016Q\u001f\u0005\n\u00033$\u0013\u0011!a\u0001\u0003SBs\"CA}\u0003\u007f\u0014\tA!\u0002\u0003\b\t-!Q\u0002\t\u0004i\u0005m\u0018bAA\u007fM\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u0002\u0003\u0005\r'\u0002\t\u0011!A}3UKT\"`QY\fG.^3-A5Lgn\u0018<bYV,G\u0006I7bq~3\u0018\r\\;fY\u0001rW/\\0ck\u000e\\W\r^\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!EV\u001c7.\u001a;!]Vl'-\u001a:!i>\u0004s\u000f[5dQ*\u0001\u0003\u0005\t\u0011!A\u00014\u0018\r\\;fA\u0002:x.\u001e7eA\t,\u0007%Y:tS\u001etW\r\u001a\u0011j]\u0002\ng\u000eI3rk&<\u0018\u000e\u001a;iA!L7\u000f^8he\u0006l\u0007e^5uQ\u0002\u0002g.^7`EV\u001c7.\u001a;aA\t,8m[3ug2R\u0001\u0005\t\u0011!A\u0001Jg\u000e\t;iK\u0002\u0012\u0018M\\4fA\u0001l\u0017N\\0wC2,X\r\u0019\u0011u_\u0002\u0002W.\u0019=`m\u0006dW/\u001a1/E)\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011I!AA]\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"*df\r\u0017!a9\u0012D\u0006I\u00191]Yb\u0003%N\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\f\u001a/c1\u0002\u0013GL\u001a-AMrC\u0007\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00159]Eb\u0003\u0005\r\u00181Y\u0001*df\u000e\u0017!i%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)[Ar\u0013\b\f\u00116]Ib\u0003\u0005\r\u00186Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00114\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B\b\u0003\u0015\u0019d&\r\u00181\u0011\u0015ie\u00011\u0001~\u0011\u0019\t\u0019A\u0002a\u0001{\"1\u0011q\u0001\u0004A\u0002uDQA\u0016\u0004A\u0002u\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001e\t%\u0002#\u0002\u001d\u0003 \t\r\u0012b\u0001B\u0011s\t1q\n\u001d;j_:\u0004r\u0001\u000fB\u0013{vlX0C\u0002\u0003(e\u0012a\u0001V;qY\u0016$\u0004\u0002\u0003B\u0016\u000f\u0005\u0005\t\u0019\u00016\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0019!\r)%1G\u0005\u0004\u0005k1%AB(cU\u0016\u001cG\u000f")
public class WidthBucket
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression value;
    private final Expression minValue;
    private final Expression maxValue;
    private final Expression numBucket;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(WidthBucket widthBucket) {
        return WidthBucket$.MODULE$.unapply(widthBucket);
    }

    public static Long computeBucketNumberNotNull(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.computeBucketNumberNotNull(d, d2, d3, l);
    }

    public static boolean isNull(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.isNull(d, d2, d3, l);
    }

    public static Long computeBucketNumber(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.computeBucketNumber(d, d2, d3, l);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression value() {
        return this.value;
    }

    public Expression minValue() {
        return this.minValue;
    }

    public Expression maxValue() {
        return this.maxValue;
    }

    public Expression numBucket() {
        return this.numBucket;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.value(), this.minValue(), this.maxValue(), this.numBucket()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{DoubleType$.MODULE$, DoubleType$.MODULE$, DoubleType$.MODULE$, LongType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "width_bucket";
    }

    @Override
    public Object nullSafeEval(Object input, Object min, Object max, Object numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumber(BoxesRunTime.unboxToDouble((Object)input), BoxesRunTime.unboxToDouble((Object)min), BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToLong((Object)numBucket));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable & scala.Serializable)(input, min, max, numBucket) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(236).append(ev.isNull()).append(" = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |  .isNull(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(");\n         |if (!").append(ev.isNull()).append(") {\n         |  ").append(ev.value()).append(" = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |    .computeBucketNumberNotNull(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(");\n         |}").toString())).stripMargin());
    }

    public WidthBucket copy(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        return new WidthBucket(value, minValue, maxValue, numBucket);
    }

    public Expression copy$default$1() {
        return this.value();
    }

    public Expression copy$default$2() {
        return this.minValue();
    }

    public Expression copy$default$3() {
        return this.maxValue();
    }

    public Expression copy$default$4() {
        return this.numBucket();
    }

    @Override
    public String productPrefix() {
        return "WidthBucket";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.value();
                break;
            }
            case 1: {
                expression = this.minValue();
                break;
            }
            case 2: {
                expression = this.maxValue();
                break;
            }
            case 3: {
                expression = this.numBucket();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WidthBucket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WidthBucket)) return false;
        boolean bl = true;
        if (!bl) return false;
        WidthBucket widthBucket = (WidthBucket)x$1;
        Expression expression = this.value();
        Expression expression2 = widthBucket.value();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.minValue();
        Expression expression4 = widthBucket.minValue();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.maxValue();
        Expression expression6 = widthBucket.maxValue();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.numBucket();
        Expression expression8 = widthBucket.numBucket();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!widthBucket.canEqual(this)) return false;
        return true;
    }

    public WidthBucket(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numBucket = numBucket;
        ExpectsInputTypes.$init$(this);
    }
}

