/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.MapZipWith$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.LinkedHashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n      _FUNC_(map1, map2, function) - Merges two given maps into a single map by applying\n      function to the pair of values with the same key. For keys only presented in one map,\n      NULL will be passed as the value for the missing key. If an input map contains duplicated\n      keys, only the first entry of the duplicated key is passed into the lambda function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), map(1, 'x', 2, 'y'), (k, v1, v2) -> concat(v1, v2));\n       {1:\"ax\",2:\"by\"}\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\t%h\u0001B\u001c9\u0001\u0016C\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\t=\u0002\u0011\t\u0012)A\u0005\r\"Aq\f\u0001BK\u0002\u0013\u0005Q\f\u0003\u0005a\u0001\tE\t\u0015!\u0003G\u0011!\t\u0007A!f\u0001\n\u0003i\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011\u0002$\t\u000b\r\u0004A\u0011\u00013\t\u000b%\u0004A\u0011A/\t\u0015)\u0004\u0001\u0013!EDB\u0013%1\u000e\u0003\u0005y\u0001!\u0015\r\u0011\"\u0001z\u0011!q\b\u0001#b\u0001\n\u0003I\bBCA\u0001\u0001!\u0015\r\u0011\"\u0001\u0002\u0004!Y\u0011q\u0001\u0001\u0011\u0002#\u001d\r\u0015\"\u0003l\u0011%\tI\u0001\u0001EC\u0002\u0013\u0005\u0011\u0010C\u0005\u0002\u000e\u0001A)\u0019!C\u0001s\"Q\u0011\u0011\u0003\u0001\t\u0006\u0004%\t!a\u0001\t\u0013\u0005U\u0001\u0001#b\u0001\n\u0003I\bBCA\r\u0001!\u0015\r\u0011\"\u0001\u0002\u001c!9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003'\u0002A\u0011IA \u0011\u001d\t)\u0006\u0001C!\u0003\u0013Ba!a\u0016\u0001\t\u0003J\bbBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003k\u0002A\u0011IA<\u0011\u001d\t)\t\u0001C!\u0003oBq!a\"\u0001\t\u0003\nI\t\u0003\u0007\u0002\u0018\u0002\u0001\n\u0011cb!\n\u0013\tI\n\u0003\u0006\u0002$\u0002A)\u0019!C\u0001\u0003KC!\"!+\u0001\u0011\u000b\u0007I\u0011AAS\u0011)\ti\u000b\u0001EC\u0002\u0013\u0005\u0011Q\u0015\u0005\u000b\u0003c\u0003\u0001R1A\u0005\n\u0005M\u0006bBAu\u0001\u0011%\u00111\u001e\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\u0011I\u0001\u0001C\u0005\u0005\u0017AqAa\u0006\u0001\t\u0013\u0011I\u0002C\u0004\u0003(\u0001!\tE!\u000b\t\u0013\tm\u0002!!A\u0005\u0002\tu\u0002\"\u0003B#\u0001E\u0005I\u0011\u0001B$\u0011%\u0011i\u0006AI\u0001\n\u0003\u00119\u0005C\u0005\u0003`\u0001\t\n\u0011\"\u0001\u0003H!I!\u0011\r\u0001\u0002\u0002\u0013\u0005#1\r\u0005\n\u0005g\u0002\u0011\u0011!C\u0001\u0005kB\u0011Ba\u001e\u0001\u0003\u0003%\tA!\u001f\t\u0013\t}\u0004!!A\u0005B\t\u0005\u0005\"\u0003BF\u0001\u0005\u0005I\u0011\u0001BG\u0011%\u0011\t\nAA\u0001\n\u0003\u0012\u0019jB\u0005\u00032b\n\t\u0011#\u0001\u00034\u001aAq\u0007OA\u0001\u0012\u0003\u0011)\f\u0003\u0004dc\u0011\u0005!1\u0019\u0005\n\u0005\u000b\f\u0014\u0011!C#\u0005\u000fD\u0011B!32\u0003\u0003%\tIa3\t\u0013\tM\u0017'!A\u0005\u0002\nU\u0007\"\u0003Bpc\u0005\u0005I\u0011\u0002Bq\u0005)i\u0015\r\u001d.ja^KG\u000f\u001b\u0006\u0003si\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\bP\u0001\tG\u0006$\u0018\r\\=ti*\u0011QHP\u0001\u0004gFd'BA A\u0003\u0015\u0019\b/\u0019:l\u0015\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\u0004\u0001M1\u0001A\u0012&N'f\u0003\"a\u0012%\u000e\u0003aJ!!\u0013\u001d\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002H\u0017&\u0011A\n\u000f\u0002\u0014\u0011&<\u0007.\u001a:Pe\u0012,'OR;oGRLwN\u001c\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!b\nqaY8eK\u001e,g.\u0003\u0002S\u001f\ny1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u0002U/6\tQKC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAVKA\u0004Qe>$Wo\u0019;\u0011\u0005QS\u0016BA.V\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003\u0019\u000bQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013\u0001\u00034v]\u000e$\u0018n\u001c8\u0002\u0013\u0019,hn\u0019;j_:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003fM\u001eD\u0007CA$\u0001\u0011\u0015av\u00011\u0001G\u0011\u0015yv\u00011\u0001G\u0011\u0015\tw\u00011\u0001G\u0003=1WO\\2uS>tgi\u001c:Fm\u0006d\u0017\u0001\u0002=%kY*\u0012\u0001\u001c\t\u0006)6|w.^\u0005\u0003]V\u0013a\u0001V;qY\u0016\u001c\u0004C\u00019t\u001b\u0005\t(B\u0001:=\u0003\u0015!\u0018\u0010]3t\u0013\t!\u0018O\u0001\u0005ECR\fG+\u001f9f!\t!f/\u0003\u0002x+\n9!i\\8mK\u0006t\u0017a\u00037fMR\\U-\u001f+za\u0016,\u0012a\u001c\u0015\u0003\u0015m\u0004\"\u0001\u0016?\n\u0005u,&!\u0003;sC:\u001c\u0018.\u001a8u\u00035aWM\u001a;WC2,X\rV=qK\"\u00121b_\u0001\u0016Y\u00164GOV1mk\u0016\u001cuN\u001c;bS:\u001ch*\u001e7m+\u0005)\bF\u0001\u0007|\u0003\u0011AH%N\u001c\u0002\u0019ILw\r\u001b;LKf$\u0016\u0010]3)\u00059Y\u0018A\u0004:jO\"$h+\u00197vKRK\b/\u001a\u0015\u0003\u001fm\faC]5hQR4\u0016\r\\;f\u0007>tG/Y5og:+H\u000e\u001c\u0015\u0003!m\fqa[3z)f\u0004X\r\u000b\u0002\u0012w\u0006AqN\u001d3fe&tw-\u0006\u0002\u0002\u001eA1\u0011qDA\u0018\u0003kqA!!\t\u0002,9!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(\u0011\u000ba\u0001\u0010:p_Rt\u0014\"\u0001,\n\u0007\u00055R+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00121\u0007\u0002\t\u001fJ$WM]5oO*\u0019\u0011QF+\u0011\u0007Q\u000b9$C\u0002\u0002:U\u00131!\u00118zQ\t\u001120A\u0005be\u001e,X.\u001a8ugV\u0011\u0011\u0011\t\t\u0006\u0003?\t\u0019ER\u0005\u0005\u0003\u000b\n\u0019DA\u0002TKF\fQ\"\u0019:hk6,g\u000e\u001e+za\u0016\u001cXCAA&!\u0019\ty\"a\u0011\u0002NA\u0019\u0001/a\u0014\n\u0007\u0005E\u0013O\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Ia-\u001e8di&|gn]\u0001\u000eMVt7\r^5p]RK\b/Z:\u0002\u0011\u0011\fG/\u0019+za\u0016\fAAY5oIR\u0019Q-!\u0018\t\u000f\u0005}\u0003\u00041\u0001\u0002b\u0005\ta\r\u0005\u0005U\u0003G2\u0015qMA8\u0013\r\t)'\u0016\u0002\n\rVt7\r^5p]J\u0002b!a\b\u0002D\u0005%\u0004#\u0002+\u0002l=,\u0018bAA7+\n1A+\u001e9mKJ\u00022aRA9\u0013\r\t\u0019\b\u000f\u0002\u000f\u0019\u0006l'\rZ1Gk:\u001cG/[8o\u0003Y\u0019\u0007.Z2l\u0003J<W/\\3oi\u0012\u000bG/\u0019+za\u0016\u001cHCAA=!\u0011\tY(!!\u000e\u0005\u0005u$bAA@u\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u0004\u0006u$a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003k\tY\tC\u0005\u0002\u000en\u0001\n\u00111\u0001\u0002\u0010\u0006)\u0011N\u001c9viB!\u0011\u0011SAJ\u001b\u0005Q\u0014bAAKu\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0011AHE\u000e\u001b\u0016\u0005\u0005m\u0005\u0003\u0003+n\u0003;\u000bi*!(\u0011\u0007\u001d\u000by*C\u0002\u0002\"b\u00121CT1nK\u0012d\u0015-\u001c2eCZ\u000b'/[1cY\u0016\faa[3z-\u0006\u0014XCAAOQ\ti20A\u0005wC2,X-\r,be\"\u0012ad_\u0001\nm\u0006dW/\u001a\u001aWCJD#aH>\u0002/\u001d,GoS3zg^KG\u000f\u001b,bYV,\u0017J\u001c3fq\u0016\u001cXCAA[!%!\u00161MA\\\u0003o\u000b\u0019\r\u0005\u0003\u0002:\u0006}VBAA^\u0015\r\tiLO\u0001\u0005kRLG.\u0003\u0003\u0002B\u0006m&!C!se\u0006LH)\u0019;b!\u0019\t)-a4\u0002T6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY-A\u0004nkR\f'\r\\3\u000b\u0007\u00055W+\u0001\u0006d_2dWm\u0019;j_:LA!!5\u0002H\nA\u0011\n^3sC\ndW\rE\u0004U\u0003W\n)$!6\u0011\u000bQ\u000b9.a7\n\u0007\u0005eWKA\u0003BeJ\f\u0017\u0010E\u0003U\u0003;\f\t/C\u0002\u0002`V\u0013aa\u00149uS>t\u0007c\u0001+\u0002d&\u0019\u0011Q]+\u0003\u0007%sG\u000f\u000b\u0002!w\u00069\u0012m]:feR\u001c\u0016N_3PM\u0006\u0013(/Y=Ck\u001a4WM\u001d\u000b\u0005\u0003[\f\u0019\u0010E\u0002U\u0003_L1!!=V\u0005\u0011)f.\u001b;\t\u000f\u0005U\u0018\u00051\u0001\u0002b\u0006!1/\u001b>f\u0003Y9W\r^&fsN<\u0016\u000e\u001e5J]\u0012,\u00070Z:GCN$HCBA~\u0005\u0003\u0011)\u0001\u0005\u0005\u0002F\u0006u\u0018QGAk\u0013\u0011\ty0a2\u0003\u001b1Kgn[3e\u0011\u0006\u001c\b.T1q\u0011\u001d\u0011\u0019A\ta\u0001\u0003o\u000bQa[3zgFBqAa\u0002#\u0001\u0004\t9,A\u0003lKf\u001c('\u0001\u000fhKR\\U-_:XSRD\u0017J\u001c3fq\u0016\u001c(I];uK\u001a{'oY3\u0015\r\t5!1\u0003B\u000b!\u0019\t)Ma\u0004\u0002T&!!\u0011CAd\u0005-\t%O]1z\u0005V4g-\u001a:\t\u000f\t\r1\u00051\u0001\u00028\"9!qA\u0012A\u0002\u0005]\u0016\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003CA\u001b\u00057\u0011yBa\t\t\u000f\tuA\u00051\u0001\u0002\u0010\u0006A\u0011N\u001c9viJ{w\u000fC\u0004\u0003\"\u0011\u0002\r!!\u000e\u0002\rY\fG.^32\u0011\u001d\u0011)\u0003\na\u0001\u0003k\taA^1mk\u0016\u0014\u0014A\u00039sKR$\u0018PT1nKV\u0011!1\u0006\t\u0005\u0005[\u0011)D\u0004\u0003\u00030\tE\u0002cAA\u0012+&\u0019!1G+\u0002\rA\u0013X\rZ3g\u0013\u0011\u00119D!\u000f\u0003\rM#(/\u001b8h\u0015\r\u0011\u0019$V\u0001\u0005G>\u0004\u0018\u0010F\u0004f\u0005\u007f\u0011\tEa\u0011\t\u000fq3\u0003\u0013!a\u0001\r\"9qL\nI\u0001\u0002\u00041\u0005bB1'!\u0003\u0005\rAR\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011IEK\u0002G\u0005\u0017Z#A!\u0014\u0011\t\t=#\u0011L\u0007\u0003\u0005#RAAa\u0015\u0003V\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005/*\u0016AC1o]>$\u0018\r^5p]&!!1\fB)\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B3!\u0011\u00119G!\u001d\u000e\u0005\t%$\u0002\u0002B6\u0005[\nA\u0001\\1oO*\u0011!qN\u0001\u0005U\u00064\u0018-\u0003\u0003\u00038\t%\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAAq\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u000e\u0003|!I!Q\u0010\u0017\u0002\u0002\u0003\u0007\u0011\u0011]\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\r\u0005C\u0002BC\u0005\u000f\u000b)$\u0004\u0002\u0002L&!!\u0011RAf\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007U\u0014y\tC\u0005\u0003~9\n\t\u00111\u0001\u00026\u00051Q-];bYN$2!\u001eBK\u0011%\u0011ihLA\u0001\u0002\u0004\t)\u0004K\b\u0001\u00053\u0013yJ!)\u0003&\n\u001d&1\u0016BW!\r9%1T\u0005\u0004\u0005;C$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005G\u000b!1\u001e\u0006!A\u0001\u0002\u0003\u0005I0G+:\u001bu\fK7baFb\u0003%\\1qe1\u0002c-\u001e8di&|g.\u000b\u0011.A5+'oZ3tAQ<x\u000eI4jm\u0016t\u0007%\\1qg\u0002Jg\u000e^8!C\u0002\u001a\u0018N\\4mK\u0002j\u0017\r\u001d\u0011cs\u0002\n\u0007\u000f\u001d7zS:<'\u0002\t\u0011!A\u0001\u0002c-\u001e8di&|g\u000e\t;pAQDW\r\t9bSJ\u0004sN\u001a\u0011wC2,Xm\u001d\u0011xSRD\u0007\u0005\u001e5fAM\fW.\u001a\u0011lKft\u0003ER8sA-,\u0017p\u001d\u0011p]2L\b\u0005\u001d:fg\u0016tG/\u001a3!S:\u0004sN\\3![\u0006\u0004HF\u0003\u0011!A\u0001\u0002\u0003ET+M\u0019\u0002:\u0018\u000e\u001c7!E\u0016\u0004\u0003/Y:tK\u0012\u0004\u0013m\u001d\u0011uQ\u0016\u0004c/\u00197vK\u00022wN\u001d\u0011uQ\u0016\u0004S.[:tS:<\u0007e[3z]\u0001Je\rI1oA%t\u0007/\u001e;![\u0006\u0004\beY8oi\u0006Lgn\u001d\u0011ekBd\u0017nY1uK\u0012T\u0001\u0005\t\u0011!A\u0001ZW-_:-A=tG.\u001f\u0011uQ\u0016\u0004c-\u001b:ti\u0002*g\u000e\u001e:zA=4\u0007\u0005\u001e5fA\u0011,\b\u000f\\5dCR,G\rI6fs\u0002J7\u000f\t9bgN,G\rI5oi>\u0004C\u000f[3!Y\u0006l'\rZ1!MVt7\r^5p]:R\u0001\u0005\t\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001BU\u0003\u0005E!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK7ba\"\nD\u0006I\u0014bO1\u0002#\u0007\f\u0011(E\u001eJC\u0006I7ba\"\nD\u0006I\u0014yO1\u0002#\u0007\f\u0011(s\u001eJC\u0006\t\u0015lY\u00012\u0018\u0007\f\u0011we%\u0002SF\u0010\u0011d_:\u001c\u0017\r\u001e\u0015wc1\u0002cOM\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0018G\u000f\u0012bq\nb#G\u000f\u0012cs\nj(\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t=\u0016!B\u001a/a9\u0002\u0014AC'bajK\u0007oV5uQB\u0011q)M\n\u0005c\t]\u0016\f\u0005\u0005\u0003:\n}fI\u0012$f\u001b\t\u0011YLC\u0002\u0003>V\u000bqA];oi&lW-\u0003\u0003\u0003B\nm&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011!1W\u0001\ti>\u001cFO]5oOR\u0011!QM\u0001\u0006CB\u0004H.\u001f\u000b\bK\n5'q\u001aBi\u0011\u0015aF\u00071\u0001G\u0011\u0015yF\u00071\u0001G\u0011\u0015\tG\u00071\u0001G\u0003\u001d)h.\u00199qYf$BAa6\u0003\\B)A+!8\u0003ZB)A+\u001c$G\r\"A!Q\\\u001b\u0002\u0002\u0003\u0007Q-A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!1\u001d\t\u0005\u0005O\u0012)/\u0003\u0003\u0003h\n%$AB(cU\u0016\u001cG\u000f")
public class MapZipWith
extends Expression
implements HigherOrderFunction,
CodegenFallback,
scala.Serializable {
    private Tuple3<DataType, DataType, Object> x$56;
    private transient DataType leftKeyType;
    private transient DataType leftValueType;
    private transient boolean leftValueContainsNull;
    private Tuple3<DataType, DataType, Object> x$57;
    private transient DataType rightKeyType;
    private transient DataType rightValueType;
    private transient boolean rightValueContainsNull;
    private transient DataType keyType;
    private transient Ordering<Object> ordering;
    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$64;
    private transient NamedLambdaVariable keyVar;
    private transient NamedLambdaVariable value1Var;
    private transient NamedLambdaVariable value2Var;
    private transient Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes;
    private final Expression left;
    private final Expression right;
    private final Expression function;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private volatile transient int bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(MapZipWith mapZipWith) {
        return MapZipWith$.MODULE$.unapply(mapZipWith);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, MapZipWith> tupled() {
        return MapZipWith$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, MapZipWith>>> curried() {
        return MapZipWith$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public Seq<Expression> children() {
        return HigherOrderFunction.children$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    private boolean argumentsResolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x1000) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 |= 0x1000;
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (this.bitmap$trans$0 & 0x1000) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Expression function() {
        return this.function;
    }

    public Expression functionForEval() {
        return (Expression)this.functionsForEval().head();
    }

    private Tuple3<DataType, DataType, Object> x$56$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType = this.left().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType leftKeyType = mapType.keyType();
                DataType leftValueType = mapType.valueType();
                boolean leftValueContainsNull = mapType.valueContainsNull();
                Tuple3 tuple3 = new Tuple3((Object)leftKeyType, (Object)leftValueType, (Object)BoxesRunTime.boxToBoolean((boolean)leftValueContainsNull));
                this.x$56 = tuple3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$56;
    }

    private /* synthetic */ Tuple3 x$56() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$56$lzycompute() : this.x$56;
    }

    private DataType leftKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.leftKeyType = (DataType)this.x$56()._1();
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.leftKeyType;
    }

    public DataType leftKeyType() {
        return (this.bitmap$trans$0 & 1) == 0 ? this.leftKeyType$lzycompute() : this.leftKeyType;
    }

    private DataType leftValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.leftValueType = (DataType)this.x$56()._2();
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.leftValueType;
    }

    public DataType leftValueType() {
        return (this.bitmap$trans$0 & 2) == 0 ? this.leftValueType$lzycompute() : this.leftValueType;
    }

    private boolean leftValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.leftValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$56()._3());
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.leftValueContainsNull;
    }

    public boolean leftValueContainsNull() {
        return (this.bitmap$trans$0 & 4) == 0 ? this.leftValueContainsNull$lzycompute() : this.leftValueContainsNull;
    }

    private Tuple3<DataType, DataType, Object> x$57$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                DataType dataType = this.right().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType rightKeyType = mapType.keyType();
                DataType rightValueType = mapType.valueType();
                boolean rightValueContainsNull = mapType.valueContainsNull();
                Tuple3 tuple3 = new Tuple3((Object)rightKeyType, (Object)rightValueType, (Object)BoxesRunTime.boxToBoolean((boolean)rightValueContainsNull));
                this.x$57 = tuple3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$57;
    }

    private /* synthetic */ Tuple3 x$57() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$57$lzycompute() : this.x$57;
    }

    private DataType rightKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.rightKeyType = (DataType)this.x$57()._1();
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.rightKeyType;
    }

    public DataType rightKeyType() {
        return (this.bitmap$trans$0 & 8) == 0 ? this.rightKeyType$lzycompute() : this.rightKeyType;
    }

    private DataType rightValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.rightValueType = (DataType)this.x$57()._2();
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.rightValueType;
    }

    public DataType rightValueType() {
        return (this.bitmap$trans$0 & 0x10) == 0 ? this.rightValueType$lzycompute() : this.rightValueType;
    }

    private boolean rightValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.rightValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$57()._3());
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.rightValueContainsNull;
    }

    public boolean rightValueContainsNull() {
        return (this.bitmap$trans$0 & 0x20) == 0 ? this.rightValueContainsNull$lzycompute() : this.rightValueContainsNull;
    }

    private DataType keyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.keyType = (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags(this.leftKeyType(), this.rightKeyType()).get();
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.keyType;
    }

    public DataType keyType() {
        return (this.bitmap$trans$0 & 0x40) == 0 ? this.keyType$lzycompute() : this.keyType;
    }

    private Ordering<Object> ordering$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.keyType());
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.ordering;
    }

    public Ordering<Object> ordering() {
        return (this.bitmap$trans$0 & 0x80) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public Seq<Expression> arguments() {
        Expression expression = this.left();
        Expression expression2 = this.right();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        MapType$ mapType$ = MapType$.MODULE$;
        MapType$ mapType$2 = MapType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)mapType$2).$colon$colon((Object)mapType$);
    }

    @Override
    public Seq<Expression> functions() {
        Expression expression = this.function();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)anyDataType$);
    }

    @Override
    public DataType dataType() {
        return new MapType(this.keyType(), this.function().dataType(), this.function().nullable());
    }

    @Override
    public MapZipWith bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.keyType(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple2((Object)this.leftValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple2((Object)this.rightValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true))}));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)arguments);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        TypeCheckResult typeCheckResult = HigherOrderFunction.checkArgumentDataTypes$(this);
        TypeCheckResult typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult) ? (this.leftKeyType().sameType(this.rightKeyType()) ? TypeUtils$.MODULE$.checkForOrderingExpr(this.leftKeyType(), new StringBuilder(9).append("function ").append(this.prettyName()).toString()) : new TypeCheckResult.TypeCheckFailure(new StringBuilder(100).append("The input to function ").append(this.prettyName()).append(" should have ").append("been two ").append(MapType$.MODULE$.simpleString()).append("s with compatible key types, but the key types are ").append("[").append(this.leftKeyType().catalogString()).append(", ").append(this.rightKeyType().catalogString()).append("].").toString())) : typeCheckResult;
        return typeCheckResult2;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.checkArgumentDataTypes();
    }

    @Override
    public Object eval(InternalRow input) {
        Object value2;
        Object value1 = this.left().eval(input);
        return value1 == null ? null : ((value2 = this.right().eval(input)) == null ? null : this.nullSafeEval(input, value1, value2));
    }

    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$64$lzycompute() {
        block5: {
            MapZipWith mapZipWith = this;
            synchronized (mapZipWith) {
                NamedLambdaVariable namedLambdaVariable;
                NamedLambdaVariable namedLambdaVariable2;
                NamedExpression value2Var;
                block7: {
                    Expression expression;
                    block6: {
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        Some some;
                        if ((byte)(this.bitmap$0 & 4) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block6;
                        NamedExpression keyVar = (NamedExpression)((SeqLike)some.get()).apply(0);
                        NamedExpression value1Var = (NamedExpression)((SeqLike)some.get()).apply(1);
                        value2Var = (NamedExpression)((SeqLike)some.get()).apply(2);
                        if (!(keyVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable2 = (NamedLambdaVariable)keyVar;
                        if (!(value1Var instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)value1Var;
                        if (value2Var instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable3 = (NamedLambdaVariable)value2Var;
                Tuple3 tuple3 = new Tuple3((Object)namedLambdaVariable2, (Object)namedLambdaVariable, (Object)namedLambdaVariable3);
                this.x$64 = tuple3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.x$64;
    }

    private /* synthetic */ Tuple3 x$64() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.x$64$lzycompute() : this.x$64;
    }

    private NamedLambdaVariable keyVar$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.keyVar = (NamedLambdaVariable)this.x$64()._1();
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.keyVar;
    }

    public NamedLambdaVariable keyVar() {
        return (this.bitmap$trans$0 & 0x100) == 0 ? this.keyVar$lzycompute() : this.keyVar;
    }

    private NamedLambdaVariable value1Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x200) == 0) {
                this.value1Var = (NamedLambdaVariable)this.x$64()._2();
                this.bitmap$trans$0 |= 0x200;
            }
        }
        return this.value1Var;
    }

    public NamedLambdaVariable value1Var() {
        return (this.bitmap$trans$0 & 0x200) == 0 ? this.value1Var$lzycompute() : this.value1Var;
    }

    private NamedLambdaVariable value2Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x400) == 0) {
                this.value2Var = (NamedLambdaVariable)this.x$64()._3();
                this.bitmap$trans$0 |= 0x400;
            }
        }
        return this.value2Var;
    }

    public NamedLambdaVariable value2Var() {
        return (this.bitmap$trans$0 & 0x400) == 0 ? this.value2Var$lzycompute() : this.value2Var;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x800) == 0) {
                this.getKeysWithValueIndexes = TypeUtils$.MODULE$.typeWithProperEquals(this.keyType()) ? (Function2 & Serializable & scala.Serializable)(keys1, keys2) -> this.getKeysWithIndexesFast((ArrayData)keys1, (ArrayData)keys2) : (Function2 & Serializable & scala.Serializable)(keys1, keys2) -> this.getKeysWithIndexesBruteForce((ArrayData)keys1, (ArrayData)keys2);
                this.bitmap$trans$0 |= 0x800;
            }
        }
        return this.getKeysWithValueIndexes;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes() {
        return (this.bitmap$trans$0 & 0x800) == 0 ? this.getKeysWithValueIndexes$lzycompute() : this.getKeysWithValueIndexes;
    }

    private void assertSizeOfArrayBuffer(int size) {
        if (size > ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
            throw new RuntimeException(new StringBuilder(86).append("Unsuccessful try to zip maps with ").append(size).append(" ").append("unique keys due to exceeding the array size limit ").append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(".").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private LinkedHashMap<Object, Option<Object>[]> getKeysWithIndexesFast(ArrayData keys1, ArrayData keys2) {
        void var3_3;
        LinkedHashMap hashMap = new LinkedHashMap();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)})).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesFast$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$65 -> {
            MapZipWith.$anonfun$getKeysWithIndexesFast$2(this, hashMap, x$65);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayBuffer<Tuple2<Object, Option<Object>[]>> getKeysWithIndexesBruteForce(ArrayData keys1, ArrayData keys2) {
        void var3_3;
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)})).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesBruteForce$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$67 -> {
            MapZipWith.$anonfun$getKeysWithIndexesBruteForce$2(this, arrayBuffer, x$67);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private Object nullSafeEval(InternalRow inputRow, Object value1, Object value2) {
        MapData mapData1 = (MapData)value1;
        MapData mapData2 = (MapData)value2;
        Iterable keysWithIndexes = (Iterable)this.getKeysWithValueIndexes().apply((Object)mapData1.keyArray(), (Object)mapData2.keyArray());
        int size = keysWithIndexes.size();
        GenericArrayData keys = new GenericArrayData(new Object[size]);
        GenericArrayData values = new GenericArrayData(new Object[size]);
        ArrayData valueData1 = mapData1.valueArray();
        ArrayData valueData2 = mapData2.valueArray();
        IntRef i = IntRef.create((int)0);
        keysWithIndexes.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$nullSafeEval$2(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$70 -> {
            MapZipWith.$anonfun$nullSafeEval$3(this, valueData1, valueData2, keys, i, inputRow, values, x$70);
            return BoxedUnit.UNIT;
        });
        return new ArrayBasedMapData(keys, values);
    }

    @Override
    public String prettyName() {
        return "map_zip_with";
    }

    public MapZipWith copy(Expression left, Expression right, Expression function) {
        return new MapZipWith(left, right, function);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Expression copy$default$3() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "MapZipWith";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 2: {
                expression = this.function();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapZipWith;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapZipWith)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapZipWith mapZipWith = (MapZipWith)x$1;
        Expression expression = this.left();
        Expression expression2 = mapZipWith.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapZipWith.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.function();
        Expression expression6 = mapZipWith.function();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!mapZipWith.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesFast$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesFast$2(MapZipWith $this, LinkedHashMap hashMap$1, Tuple2 x$65) {
        Tuple2 tuple2 = x$65;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                Object key = array.get(i, $this.keyType());
                Option option = hashMap$1.get(key);
                if (option instanceof Some) {
                    BoxedUnit boxedUnit2;
                    Some some = (Some)option;
                    Option[] indexes = (Option[])some.value();
                    if (indexes[z].isEmpty()) {
                        indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = hashMap$1.put(key, (Object)indexes);
                    continue;
                }
                throw new MatchError((Object)option);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesBruteForce$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesBruteForce$2(MapZipWith $this, ArrayBuffer arrayBuffer$1, Tuple2 x$67) {
        Tuple2 tuple2 = x$67;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                Object key = array.get(i, $this.keyType());
                boolean found = false;
                for (int j = 0; !found && j < arrayBuffer$1.size(); ++j) {
                    Tuple2 tuple22 = (Tuple2)arrayBuffer$1.apply(j);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Object bufferKey = tuple22._1();
                    Option[] indexes = (Option[])tuple22._2();
                    Tuple2 tuple23 = new Tuple2(bufferKey, (Object)indexes);
                    Tuple2 tuple24 = tuple23;
                    Object bufferKey2 = tuple24._1();
                    Option[] indexes2 = (Option[])tuple24._2();
                    if (!$this.ordering().equiv(bufferKey2, key)) continue;
                    found = true;
                    if (!indexes2[z].isEmpty()) continue;
                    indexes2[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                }
                if (!found) {
                    $this.assertSizeOfArrayBuffer(arrayBuffer$1.size());
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = arrayBuffer$1.$plus$eq((Object)new Tuple2(key, (Object)indexes));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeEval$2(Tuple2 check$ifrefutable$3) {
        Option[] optionArray;
        Option option;
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null && !(option = Array$.MODULE$.unapplySeq((Object)(optionArray = (Option[])tuple2._2()))).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$nullSafeEval$3(MapZipWith $this, ArrayData valueData1$1, ArrayData valueData2$1, GenericArrayData keys$1, IntRef i$1, InternalRow inputRow$3, GenericArrayData values$1, Tuple2 x$70) {
        Tuple2 tuple2 = x$70;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object key = tuple2._1();
        Option[] optionArray = (Option[])tuple2._2();
        Option option = Array$.MODULE$.unapplySeq((Object)optionArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) throw new MatchError((Object)tuple2);
        Option index1 = (Option)((SeqLike)option.get()).apply(0);
        Option index2 = (Option)((SeqLike)option.get()).apply(1);
        Object v1 = index1.map((Function1 & Serializable & scala.Serializable)x$68 -> valueData1$1.get(BoxesRunTime.unboxToInt((Object)x$68), $this.leftValueType())).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        Object v2 = index2.map((Function1 & Serializable & scala.Serializable)x$69 -> valueData2$1.get(BoxesRunTime.unboxToInt((Object)x$69), $this.rightValueType())).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        $this.keyVar().value().set(key);
        $this.value1Var().value().set(v1);
        $this.value2Var().value().set(v2);
        keys$1.update(i$1.elem, key);
        Object v = InternalRow$.MODULE$.copyValue($this.functionForEval().eval(inputRow$3));
        values$1.update(i$1.elem, v);
        ++i$1.elem;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public MapZipWith(Expression left, Expression right, Expression function) {
        this.left = left;
        this.right = right;
        this.function = function;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
    }
}

