/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001\u0002\u0010 \u00012B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005A\t\u0003\u0005I\u0001\tE\t\u0015!\u0003F\u0011!I\u0005A!f\u0001\n\u0003q\u0004\u0002\u0003&\u0001\u0005#\u0005\u000b\u0011B \t\u000b-\u0003A\u0011\u0001'\t\u000b-\u0003A\u0011A)\t\u000b-\u0003A\u0011\u0001+\t\u000bY\u0003A\u0011I,\t\u000b\u0011\u0004A\u0011I3\t\u000b1\u0004A\u0011I7\t\u000fY\u0004\u0011\u0011!C\u0001o\"91\u0010AI\u0001\n\u0003a\b\"CA\b\u0001E\u0005I\u0011AA\t\u0011!\t)\u0002AI\u0001\n\u0003a\b\"CA\f\u0001\u0005\u0005I\u0011IA\r\u0011%\tI\u0003AA\u0001\n\u0003\tY\u0003C\u0005\u00024\u0001\t\t\u0011\"\u0001\u00026!I\u00111\b\u0001\u0002\u0002\u0013\u0005\u0013Q\b\u0005\n\u0003\u0013\u0002\u0011\u0011!C\u0001\u0003\u0017B\u0011\"!\u0016\u0001\u0003\u0003%\t%a\u0016\b\u0013\u0005\u0005u$!A\t\u0002\u0005\re\u0001\u0003\u0010 \u0003\u0003E\t!!\"\t\r-CB\u0011AAJ\u0011%\t)\nGA\u0001\n\u000b\n9\nC\u0005\u0002\u001ab\t\t\u0011\"!\u0002\u001c\"I\u00111\u0015\r\u0002\u0002\u0013\u0005\u0015Q\u0015\u0005\n\u0003gC\u0012\u0011!C\u0005\u0003k\u00131\u0002U1sg\u0016$v\u000eR1uK*\u0011\u0001%I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002#G\u0005A1-\u0019;bYf\u001cHO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001[E\"$\b\u0005\u0002/_5\tq$\u0003\u00021?\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002/e%\u00111g\b\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdGA\u0004Qe>$Wo\u0019;\u0011\u0005UZ\u0014B\u0001\u001f7\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003}\u0002\"A\f!\n\u0005\u0005{\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u00051am\u001c:nCR,\u0012!\u0012\t\u0004k\u0019{\u0014BA$7\u0005\u0019y\u0005\u000f^5p]\u00069am\u001c:nCR\u0004\u0013!B2iS2$\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001b:{\u0005\u000b\u0005\u0002/\u0001!)Qh\u0002a\u0001\u007f!)1i\u0002a\u0001\u000b\")\u0011j\u0002a\u0001\u007fQ\u0019QJU*\t\u000buB\u0001\u0019A \t\u000b\rC\u0001\u0019A \u0015\u00055+\u0006\"B\u001f\n\u0001\u0004y\u0014!D3yaJ\u001c(+\u001a9mC\u000e,G-F\u0001Y!\rI\u0016m\u0010\b\u00035~s!a\u00170\u000e\u0003qS!!X\u0016\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014B\u000117\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\u0007M+\u0017O\u0003\u0002am\u0005ia\r\\1u\u0003J<W/\\3oiN,\u0012A\u001a\t\u00043\u001eL\u0017B\u00015d\u0005!IE/\u001a:bi>\u0014\bCA\u001bk\u0013\tYgGA\u0002B]f\f!\u0002\u001d:fiRLh*Y7f+\u0005q\u0007CA8t\u001d\t\u0001\u0018\u000f\u0005\u0002\\m%\u0011!ON\u0001\u0007!J,G-\u001a4\n\u0005Q,(AB*ue&twM\u0003\u0002sm\u0005!1m\u001c9z)\u0011i\u00050\u001f>\t\u000fuj\u0001\u0013!a\u0001\u007f!91)\u0004I\u0001\u0002\u0004)\u0005bB%\u000e!\u0003\u0005\raP\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005i(FA \u007fW\u0005y\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00037\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001b\t\u0019AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0014)\u0012QI`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0004\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006L1\u0001^A\u0010\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0003E\u00026\u0003_I1!!\r7\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rI\u0017q\u0007\u0005\n\u0003s\u0019\u0012\u0011!a\u0001\u0003[\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA !\u0015\t\t%a\u0012j\u001b\t\t\u0019EC\u0002\u0002FY\n!bY8mY\u0016\u001cG/[8o\u0013\rA\u00171I\u0001\tG\u0006tW)];bYR!\u0011QJA*!\r)\u0014qJ\u0005\u0004\u0003#2$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003s)\u0012\u0011!a\u0001S\u00061Q-];bYN$B!!\u0014\u0002Z!A\u0011\u0011\b\f\u0002\u0002\u0003\u0007\u0011\u000eK\f\u0001\u0003;\n\u0019'!\u001a\u0002j\u0005-\u0014qNA9\u0003k\n9(a\u001f\u0002~A\u0019a&a\u0018\n\u0007\u0005\u0005tDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u001d\u0014!!/\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006Z1uK~\u001bHO].-A\u0019lG/X\u0015![\u0001\u0002\u0016M]:fg\u0002\"\b.\u001a\u0011aI\u0006$XmX:ue\u0002\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!o&$\b\u000e\t;iK\u0002\u0002g-\u001c;aA\u0015D\bO]3tg&|g\u000e\t;p\u0015\u0001\u0002\u0003\u0005\t\u0011!C\u0002\"\u0017\r^3/AI+G/\u001e:og\u0002rW\u000f\u001c7!o&$\b\u000eI5om\u0006d\u0017\u000e\u001a\u0011j]B,HO\f\u0011Cs\u0002\"WMZ1vYRd\u0003%\u001b;!M>dGn\\<tA\r\f7\u000f^5oO\u0002\u0012X\u000f\\3tAQ|\u0007%\u0019\u0011eCR,\u0007%\u001b4\u000bA\u0001\u0002\u0003\u0005\t\u0011uQ\u0016\u0004\u0003MZ7uA\u0002J7\u000fI8nSR$X\r\u001a\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u00055\u0014Aa\b\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0017\r^3`gR\u0014\b%\f\u0011BAM$(/\u001b8hAQ|\u0007EY3!a\u0006\u00148/\u001a3!i>\u0004C-\u0019;f])\u0001\u0003\u0005\t\u0011!A)\u0002c-\u001c;![\u0001\"\u0015\r^3!M>\u0014X.\u0019;!a\u0006$H/\u001a:oAQ|\u0007EZ8mY><h\u0006I*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.I\u0006$X\r^5nK6\u0002\u0018\r\u001e;fe:t\u0003\u000e^7mEy\"\u0015\r^3uS6,\u0007\u0005U1ui\u0016\u0014hn\u001d\u001f0Cz\u0002cm\u001c:!m\u0006d\u0017\u000e\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011eCR,\u0007%\u00198eAQLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019(AA\u0017\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1aej\u0003gN\u00174a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\n$'L\u001a2O1\u0002s%_=zs6jU*\f3eO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m5\n$'L\u001a2\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAA=\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!a \u0002\u000bErSG\f\u0019\u0002\u0017A\u000b'o]3U_\u0012\u000bG/\u001a\t\u0003]a\u0019B\u0001GADuAA\u0011\u0011RAH\u007f\u0015{T*\u0004\u0002\u0002\f*\u0019\u0011Q\u0012\u001c\u0002\u000fI,h\u000e^5nK&!\u0011\u0011SAF\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003\u0007\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037\tQ!\u00199qYf$r!TAO\u0003?\u000b\t\u000bC\u0003>7\u0001\u0007q\bC\u0003D7\u0001\u0007Q\tC\u0003J7\u0001\u0007q(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u001d\u0016q\u0016\t\u0005k\u0019\u000bI\u000b\u0005\u00046\u0003W{TiP\u0005\u0004\u0003[3$A\u0002+va2,7\u0007\u0003\u0005\u00022r\t\t\u00111\u0001N\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00028B!\u0011QDA]\u0013\u0011\tY,a\b\u0003\r=\u0013'.Z2u\u0001")
public class ParseToDate
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToDate parseToDate) {
        return ParseToDate$.MODULE$.unapply(parseToDate);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToDate>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public String prettyName() {
        return "to_date";
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToDate(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToDate.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new Cast(new GetTimestamp(left, format, GetTimestamp$.MODULE$.apply$default$3(), GetTimestamp$.MODULE$.apply$default$4()), DateType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, DateType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }
}

