/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AggregateWindowFunction;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NthValue$;
import org.apache.spark.sql.catalyst.expressions.OffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExpressionDescription(usage="\n    _FUNC_(input[, offset]) - Returns the value of `input` at the row that is the `offset`th row\n      from beginning of the window frame. Offset starts at 1. If ignoreNulls=true, we will skip\n      nulls when finding the `offset`th row. Otherwise, every row counts for the `offset`. If\n      there is no such an `offset`th row (e.g., when the offset is 10, size of the window frame\n      is less than 10), null is returned.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b, 2) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t1\n       A2\t3\tNULL\n  ", arguments="\n    Arguments:\n      * input - the target column or expression that the function operates on.\n      * offset - a positive int literal to indicate the offset in the window frame. It starts\n          with 1.\n      * ignoreNulls - an optional specification that indicates the NthValue should skip null\n          values in the determination of which row to use.\n  ", since="3.1.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\t]b\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011!!\u0006A!f\u0001\n\u0003)\u0006\u0002C-\u0001\u0005#\u0005\u000b\u0011\u0002,\t\u000bi\u0003A\u0011A.\t\u000bi\u0003A\u0011\u00011\t\u0011\u0011\u0004\u0001R1A\u0005B\u0015DQ!\u001b\u0001\u0005B)Dqa\u001e\u0001C\u0002\u0013\u0005\u0003\u0010\u0003\u0004}\u0001\u0001\u0006I!\u001f\u0005\u0006{\u0002!\tE \u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\t9\u0002\u0001C!\u00033A!\"a\n\u0001\u0011\u000b\u0007I\u0011BA\u0015\u0011)\t\t\u0004\u0001EC\u0002\u0013%\u00111\u0007\u0005\u000b\u0003w\u0001\u0001R1A\u0005\n\u0005M\u0002BCA\u001f\u0001!\u0015\r\u0011\"\u0011\u0002@!Q\u00111\t\u0001\t\u0006\u0004%\t%!\u0012\t\u0013\u0005%\u0003\u0001#b\u0001\n\u0003R\u0007BCA&\u0001!\u0015\r\u0011\"\u0011\u00024!9\u0011Q\n\u0001\u0005B\u0005=\u0003B\u0002\u0019\u0001\t\u0003\ny\u0005C\u0005\u0002b\u0001\t\t\u0011\"\u0001\u0002d!I\u00111\u000e\u0001\u0012\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003\u0007\u0003\u0011\u0013!C\u0001\u0003[B\u0011\"!\"\u0001#\u0003%\t!a\"\t\u0013\u0005-\u0005!!A\u0005B\u00055\u0005\"CAO\u0001\u0005\u0005I\u0011AAP\u0011%\t9\u000bAA\u0001\n\u0003\tI\u000bC\u0005\u00026\u0002\t\t\u0011\"\u0011\u00028\"I\u0011Q\u0019\u0001\u0002\u0002\u0013\u0005\u0011q\u0019\u0005\n\u0003\u0017\u0004\u0011\u0011!C!\u0003\u001b<\u0011\"a>,\u0003\u0003E\t!!?\u0007\u0011)Z\u0013\u0011!E\u0001\u0003wDaA\u0017\u0013\u0005\u0002\t%\u0001\"\u0003B\u0006I\u0005\u0005IQ\tB\u0007\u0011%\u0011y\u0001JA\u0001\n\u0003\u0013\t\u0002C\u0005\u0003\u001a\u0011\n\t\u0011\"!\u0003\u001c!I!Q\u0006\u0013\u0002\u0002\u0013%!q\u0006\u0002\t\u001dRDg+\u00197vK*\u0011A&L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002/_\u0005A1-\u0019;bYf\u001cHO\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001su\u00025)\u0013\t\u0003umj\u0011aK\u0005\u0003y-\u0012q#Q4he\u0016<\u0017\r^3XS:$wn\u001e$v]\u000e$\u0018n\u001c8\u0011\u0005ir\u0014BA ,\u0005QyeMZ:fi^Kg\u000eZ8x\rVt7\r^5p]B\u0011!(Q\u0005\u0003\u0005.\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\b!J|G-^2u!\t!%*\u0003\u0002L\u000b\na1+\u001a:jC2L'0\u00192mK\u0006)\u0011N\u001c9viV\ta\n\u0005\u0002;\u001f&\u0011\u0001k\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB5oaV$\b%\u0001\u0004pM\u001a\u001cX\r^\u0001\b_\u001a47/\u001a;!\u0003-IwM\\8sK:+H\u000e\\:\u0016\u0003Y\u0003\"\u0001R,\n\u0005a+%a\u0002\"p_2,\u0017M\\\u0001\rS\u001etwN]3Ok2d7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tqkfl\u0018\t\u0003u\u0001AQ\u0001T\u0004A\u00029CQAU\u0004A\u00029CQ\u0001V\u0004A\u0002Y#2\u0001X1d\u0011\u0015\u0011\u0007\u00021\u0001O\u0003\u0015\u0019\u0007.\u001b7e\u0011\u0015\u0011\u0006\u00021\u0001O\u0003\u001d!WMZ1vYR,\u0012A\u001a\t\u0003u\u001dL!\u0001[\u0016\u0003\u000f1KG/\u001a:bY\u0006A1\r[5mIJ,g.F\u0001l!\raGO\u0014\b\u0003[Jt!A\\9\u000e\u0003=T!\u0001]\u001c\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0015BA:F\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001e<\u0003\u0007M+\u0017O\u0003\u0002t\u000b\u0006)aM]1nKV\t\u0011\u0010\u0005\u0002;u&\u00111p\u000b\u0002\f/&tGm\\<Ge\u0006lW-\u0001\u0004ge\u0006lW\rI\u0001\tI\u0006$\u0018\rV=qKV\tq\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)aL\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003\u001f\u0001B\u0001\u001c;\u0002\u0012A!\u0011\u0011AA\n\u0013\u0011\t)\"a\u0001\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011[\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002&\u0005}!a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0013=4gm]3u-\u0006dWCAA\u0016!\r!\u0015QF\u0005\u0004\u0003_)%\u0001\u0002'p]\u001e\faA]3tk2$XCAA\u001b!\rQ\u0014qG\u0005\u0004\u0003sY#AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016\fQaY8v]R\f1#Y4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN,\"!!\u0011\u0011\t1$\u0018QG\u0001\u000eS:LG/[1m-\u0006dW/Z:\u0016\u0005\u0005\u001d\u0003c\u00017uM\u0006\tR\u000f\u001d3bi\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0002%\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\\\u0001\u000baJ,G\u000f^=OC6,WCAA)!\u0011\t\u0019&a\u0017\u000f\t\u0005U\u0013q\u000b\t\u0003]\u0016K1!!\u0017F\u0003\u0019\u0001&/\u001a3fM&!\u0011QLA0\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011L#\u0002\t\r|\u0007/\u001f\u000b\b9\u0006\u0015\u0014qMA5\u0011\u001da\u0015\u0004%AA\u00029CqAU\r\u0011\u0002\u0003\u0007a\nC\u0004U3A\u0005\t\u0019\u0001,\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u000e\u0016\u0004\u001d\u0006E4FAA:!\u0011\t)(a \u000e\u0005\u0005]$\u0002BA=\u0003w\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uT)\u0001\u0006b]:|G/\u0019;j_:LA!!!\u0002x\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAEU\r1\u0016\u0011O\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0005\u0003BAI\u00037k!!a%\u000b\t\u0005U\u0015qS\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001a\u0006!!.\u0019<b\u0013\u0011\ti&a%\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0005\u0006c\u0001#\u0002$&\u0019\u0011QU#\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005-\u0016\u0011\u0017\t\u0004\t\u00065\u0016bAAX\u000b\n\u0019\u0011I\\=\t\u0013\u0005Mv$!AA\u0002\u0005\u0005\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002:B1\u00111XAa\u0003Wk!!!0\u000b\u0007\u0005}V)\u0001\u0006d_2dWm\u0019;j_:LA!a1\u0002>\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r1\u0016\u0011\u001a\u0005\n\u0003g\u000b\u0013\u0011!a\u0001\u0003W\u000ba!Z9vC2\u001cHc\u0001,\u0002P\"I\u00111\u0017\u0012\u0002\u0002\u0003\u0007\u00111\u0016\u0015\u0018\u0001\u0005M\u0017\u0011\\An\u0003?\f\t/!:\u0002h\u0006-\u0018Q^Ay\u0003g\u00042AOAk\u0013\r\t9n\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti.AB-\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK5oaV$8\f\f\u0011pM\u001a\u001cX\r^/*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAY\fG.^3!_\u001a\u0004\u0003-\u001b8qkR\u0004\u0007%\u0019;!i\",\u0007E]8xAQD\u0017\r\u001e\u0011jg\u0002\"\b.\u001a\u0011a_\u001a47/\u001a;ai\"\u0004#o\\<\u000bA\u0001\u0002\u0003\u0005\t\u0011ge>l\u0007EY3hS:t\u0017N\\4!_\u001a\u0004C\u000f[3!o&tGm\\<!MJ\fW.\u001a\u0018!\u001f\u001a47/\u001a;!gR\f'\u000f^:!CR\u0004\u0013G\f\u0011JM\u0002JwM\\8sK:+H\u000e\\:>iJ,X\r\f\u0011xK\u0002:\u0018\u000e\u001c7!g.L\u0007O\u0003\u0011!A\u0001\u0002\u0003E\\;mYN\u0004s\u000f[3oA\u0019Lg\u000eZ5oO\u0002\"\b.\u001a\u0011a_\u001a47/\u001a;ai\"\u0004#o\\</A=#\b.\u001a:xSN,G\u0006I3wKJL\bE]8xA\r|WO\u001c;tA\u0019|'\u000f\t;iK\u0002\u0002wN\u001a4tKR\u0004g\u0006I%g\u0015\u0001\u0002\u0003\u0005\t\u0011!i\",'/\u001a\u0011jg\u0002rw\u000eI:vG\"\u0004\u0013M\u001c\u0011a_\u001a47/\u001a;ai\"\u0004#o\\<!Q\u0015tsM\f\u0017!o\",g\u000e\t;iK\u0002zgMZ:fi\u0002J7\u000fI\u00191Y\u0001\u001a\u0018N_3!_\u001a\u0004C\u000f[3!o&tGm\\<!MJ\fW.\u001a\u0006!A\u0001\u0002\u0003\u0005I5tA1,7o\u001d\u0011uQ\u0006t\u0007%\r\u0019*Y\u0001rW\u000f\u001c7!SN\u0004#/\u001a;ve:,GM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002d\u0006\t\u0019K\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011bY\u0001\u0012G\u0006I0G+:\u001bu\f\u000b2-AIJ\u0003e\u0014,F%\u0002B\u0003+\u0011*U\u0013RKuJ\u0014\u0011C3\u0002\n\u0007e\u0014*E\u000bJ\u0003#)\u0017\u0011cS\u00012%kT'!-\u0006cU+R*!Q\u001d\n\u0015g\n\u0017!e%b\u0003\u0005K\u0014Bc\u001db\u0003%M\u0015-A!:\u0013IM\u0014-AMJC\u0006\t\u0015(\u0003F:C\u0006I\u0019*AQ\f'\rK1-A\tL3H\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013EJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013EJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013IJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005I!3\u0013MJa*\u0016'M\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\tI/\u0001Bj\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u0013N\u001c9vi\u0002j\u0003\u0005\u001e5fAQ\f'oZ3uA\r|G.^7oA=\u0014\b%\u001a=qe\u0016\u001c8/[8oAQD\u0017\r\u001e\u0011uQ\u0016\u0004c-\u001e8di&|g\u000eI8qKJ\fG/Z:!_:t#\u0002\t\u0011!A\u0001\u0002#\u0006I8gMN,G\u000fI\u0017!C\u0002\u0002xn]5uSZ,\u0007%\u001b8uA1LG/\u001a:bY\u0002\"x\u000eI5oI&\u001c\u0017\r^3!i\",\u0007e\u001c4gg\u0016$\b%\u001b8!i\",\u0007e^5oI><\bE\u001a:b[\u0016t\u0003%\u0013;!gR\f'\u000f^:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002s/\u001b;iAEr#\u0002\t\u0011!A\u0001\u0002#\u0006I5h]>\u0014XMT;mYN\u0004S\u0006I1oA=\u0004H/[8oC2\u00043\u000f]3dS\u001aL7-\u0019;j_:\u0004C\u000f[1uA%tG-[2bi\u0016\u001c\b\u0005\u001e5fA9#\bNV1mk\u0016\u00043\u000f[8vY\u0012\u00043o[5qA9,H\u000e\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012\u0018\r\\;fg\u0002Jg\u000e\t;iK\u0002\"W\r^3s[&t\u0017\r^5p]\u0002zg\rI<iS\u000eD\u0007E]8xAQ|\u0007%^:f])\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002p\u0006)1GL\u0019/a\u0005)qM]8va\u0006\u0012\u0011Q_\u0001\ro&tGm\\<`MVt7m]\u0001\t\u001dRDg+\u00197vKB\u0011!\bJ\n\u0005I\u0005u\u0018\n\u0005\u0005\u0002\u0000\n\u0015aJ\u0014,]\u001b\t\u0011\tAC\u0002\u0003\u0004\u0015\u000bqA];oi&lW-\u0003\u0003\u0003\b\t\u0005!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011\u0011`\u0001\ti>\u001cFO]5oOR\u0011\u0011qR\u0001\u0006CB\u0004H.\u001f\u000b\b9\nM!Q\u0003B\f\u0011\u0015au\u00051\u0001O\u0011\u0015\u0011v\u00051\u0001O\u0011\u0015!v\u00051\u0001W\u0003\u001d)h.\u00199qYf$BA!\b\u0003*A)AIa\b\u0003$%\u0019!\u0011E#\u0003\r=\u0003H/[8o!\u0019!%Q\u0005(O-&\u0019!qE#\u0003\rQ+\b\u000f\\34\u0011!\u0011Y\u0003KA\u0001\u0002\u0004a\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0004\u0005\u0003\u0002\u0012\nM\u0012\u0002\u0002B\u001b\u0003'\u0013aa\u00142kK\u000e$\b")
public class NthValue
extends AggregateWindowFunction
implements OffsetWindowFunction,
ImplicitCastInputTypes {
    private Literal default;
    private long offsetVal;
    private AttributeReference result;
    private AttributeReference count;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> updateExpressions;
    private AttributeReference evaluateExpression;
    private final Expression input;
    private final Expression offset;
    private final boolean ignoreNulls;
    private final WindowFrame frame;
    private SpecifiedWindowFrame fakeFrame;
    private volatile int bitmap$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(NthValue nthValue) {
        return NthValue$.MODULE$.unapply(nthValue);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, NthValue> tupled() {
        return NthValue$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, NthValue>>> curried() {
        return NthValue$.MODULE$.curried();
    }

    private SpecifiedWindowFrame fakeFrame$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.fakeFrame = OffsetWindowFunction.fakeFrame$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.fakeFrame;
    }

    @Override
    public SpecifiedWindowFrame fakeFrame() {
        return (this.bitmap$0 & 0x100) == 0 ? this.fakeFrame$lzycompute() : this.fakeFrame;
    }

    @Override
    public Expression input() {
        return this.input;
    }

    @Override
    public Expression offset() {
        return this.offset;
    }

    @Override
    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    private Literal default$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 1) == 0) {
                this.default = Literal$.MODULE$.create(null, this.input().dataType());
                this.bitmap$0 |= 1;
            }
        }
        return this.default;
    }

    @Override
    public Literal default() {
        return (this.bitmap$0 & 1) == 0 ? this.default$lzycompute() : this.default;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.input();
        Expression expression2 = this.offset();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public WindowFrame frame() {
        return this.frame;
    }

    @Override
    public DataType dataType() {
        return this.input().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyDataType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult check = ExpectsInputTypes.checkInputDataTypes$(this);
        return check.isFailure() ? check : (!this.offset().foldable() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(39).append("Offset expression '").append(this.offset()).append("' must be a literal.").toString()) : (this.offsetVal() <= 0L ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("The 'offset' argument of nth_value must be greater than zero but it is ").append(this.offsetVal()).append(".").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$));
    }

    private long offsetVal$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 2) == 0) {
                this.offsetVal = BoxesRunTime.unboxToInt((Object)this.offset().eval(this.offset().eval$default$1()));
                this.bitmap$0 |= 2;
            }
        }
        return this.offsetVal;
    }

    private long offsetVal() {
        return (this.bitmap$0 & 2) == 0 ? this.offsetVal$lzycompute() : this.offsetVal;
    }

    private AttributeReference result$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "result";
                DataType x$2 = this.input().dataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.result = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.result;
    }

    private AttributeReference result() {
        return (this.bitmap$0 & 4) == 0 ? this.result$lzycompute() : this.result;
    }

    private AttributeReference count$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 8) == 0) {
                String x$1 = "count";
                LongType$ x$2 = LongType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.count = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 8;
            }
        }
        return this.count;
    }

    private AttributeReference count() {
        return (this.bitmap$0 & 8) == 0 ? this.count$lzycompute() : this.count;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x10) == 0) {
                AttributeReference attributeReference = this.result();
                AttributeReference attributeReference2 = this.count();
                this.aggBufferAttributes = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{this.default(), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L))}));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.updateExpressions = this.ignoreNulls() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new If[]{new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal())))).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNotNull()))), this.input(), this.result()), new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNull()), this.count(), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L)))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal()))), this.input(), this.result()), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L))}));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private AttributeReference evaluateExpression$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.evaluateExpression = this.result();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return (this.bitmap$0 & 0x80) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    @Override
    public String prettyName() {
        return "nth_value";
    }

    @Override
    public String sql() {
        return new StringBuilder(4).append(this.prettyName()).append("(").append(this.input().sql()).append(", ").append(this.offset().sql()).append(")").append((Object)(this.ignoreNulls() ? " ignore nulls" : "")).toString();
    }

    public NthValue copy(Expression input, Expression offset, boolean ignoreNulls) {
        return new NthValue(input, offset, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.offset();
    }

    public boolean copy$default$3() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "NthValue";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.input();
                break;
            }
            case 1: {
                object = this.offset();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NthValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NthValue)) return false;
        boolean bl = true;
        if (!bl) return false;
        NthValue nthValue = (NthValue)x$1;
        Expression expression = this.input();
        Expression expression2 = nthValue.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.offset();
        Expression expression4 = nthValue.offset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.ignoreNulls() != nthValue.ignoreNulls()) return false;
        if (!nthValue.canEqual(this)) return false;
        return true;
    }

    public NthValue(Expression input, Expression offset, boolean ignoreNulls) {
        this.input = input;
        this.offset = offset;
        this.ignoreNulls = ignoreNulls;
        OffsetWindowFunction.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.frame = UnspecifiedFrame$.MODULE$;
    }

    public NthValue(Expression child, Expression offset) {
        this(child, offset, false);
    }
}

