/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.runtime.java8.JFunction1;

public final class ExprUtils$ {
    public static ExprUtils$ MODULE$;

    static {
        new ExprUtils$();
    }

    public DataType evalTypeExpr(Expression exp) {
        UTF8String uTF8String;
        if (exp.foldable()) {
            Object object = exp.eval(exp.eval$default$1());
            if (!(object instanceof UTF8String) || (uTF8String = (UTF8String)object) == null) {
                throw new AnalysisException(new StringBuilder(47).append("The expression '").append(exp.sql()).append("' is not a valid schema string.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        } else {
            throw new AnalysisException(new StringBuilder(128).append("Schema should be specified in DDL format as a string literal or output of ").append("the schema_of_json/schema_of_csv functions instead of ").append(exp.sql()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        DataType dataType = DataType$.MODULE$.fromDDL(uTF8String.toString());
        DataType dataType2 = CharVarcharUtils$.MODULE$.failIfHasCharVarchar(dataType);
        return dataType2;
    }

    public StructType evalSchemaExpr(Expression exp) {
        DataType dataType = this.evalTypeExpr(exp);
        if (!(dataType instanceof StructType)) {
            throw new AnalysisException(new StringBuilder(38).append("Schema should be struct type but got ").append(dataType.sql()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return (StructType)dataType;
    }

    public Map<String, String> convertToMapData(Expression exp) {
        CreateMap createMap;
        block5: {
            boolean bl;
            block4: {
                bl = false;
                createMap = null;
                Expression expression = exp;
                if (!(expression instanceof CreateMap)) break block4;
                bl = true;
                createMap = (CreateMap)expression;
                if (createMap.dataType().acceptsType(new MapType(StringType$.MODULE$, StringType$.MODULE$, false))) break block5;
            }
            if (bl) {
                throw new AnalysisException(new StringBuilder(59).append("A type of keys and values in map() must be string, but got ").append(createMap.dataType().catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new AnalysisException("Must use a map() function for options", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        ArrayBasedMapData arrayMap = (ArrayBasedMapData)createMap.eval(createMap.eval$default$1());
        Map map = (Map)ArrayBasedMapData$.MODULE$.toScalaMap(arrayMap).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toString()), (Object)value.toString());
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return map;
    }

    public void verifyColumnNameOfCorruptRecord(StructType schema, String columnNameOfCorruptRecord) {
        schema.getFieldIndex(columnNameOfCorruptRecord).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)corruptFieldIndex -> {
            StructField f = schema.apply(corruptFieldIndex);
            DataType dataType = f.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !f.nullable()) {
                throw new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        });
    }

    public Function1<String, BigDecimal> getDecimalParser(Locale locale) {
        Function1 & Serializable & scala.Serializable intersect;
        Locale locale2 = locale;
        Locale locale3 = Locale.US;
        if (!(locale2 != null ? !((Object)locale2).equals(locale3) : locale3 != null)) {
            intersect = (Function1 & Serializable & scala.Serializable)s -> new BigDecimal(s.replaceAll(",", ""));
        } else {
            DecimalFormat decimalFormat = new DecimalFormat("", new DecimalFormatSymbols(locale));
            decimalFormat.setParseBigDecimal(true);
            intersect = (Function1 & Serializable & scala.Serializable)s -> {
                void var3_3;
                ParsePosition pos = new ParsePosition(0);
                BigDecimal result = (BigDecimal)decimalFormat.parse((String)s, pos);
                if (pos.getIndex() != s.length() || pos.getErrorIndex() != -1) {
                    throw new IllegalArgumentException("Cannot parse any decimal");
                }
                return var3_3;
            };
        }
        return intersect;
    }

    private ExprUtils$() {
        MODULE$ = this;
    }
}

