/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayRemove$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array, element) - Remove all elements that equal to element from array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, null, 3), 3);\n       [1,2,null]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tUa\u0001B\u0010!\u00016B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015\u0011\b\u0001\"\u0003T\u0011!\u0019\b\u0001#b\u0001\n\u0013!\bBB@\u0001\t\u0003\n\t\u0001C\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,!9\u00111\n\u0001\u0005B\u00055\u0003\"CA(\u0001\u0005\u0005I\u0011AA)\u0011%\t9\u0006AI\u0001\n\u0003\tI\u0006C\u0005\u0002p\u0001\t\n\u0011\"\u0001\u0002Z!I\u0011\u0011\u000f\u0001\u0002\u0002\u0013\u0005\u00131\u000f\u0005\n\u0003\u0007\u0003\u0011\u0011!C\u0001\u0003\u000bC\u0011\"!$\u0001\u0003\u0003%\t!a$\t\u0013\u0005U\u0005!!A\u0005B\u0005]\u0005\"CAS\u0001\u0005\u0005I\u0011AAT\u0011%\t\t\fAA\u0001\n\u0003\n\u0019lB\u0005\u0002X\u0002\n\t\u0011#\u0001\u0002Z\u001aAq\u0004IA\u0001\u0012\u0003\tY\u000e\u0003\u0004N3\u0011\u0005\u0011\u0011\u001e\u0005\n\u0003WL\u0012\u0011!C#\u0003[D\u0011\"a<\u001a\u0003\u0003%\t)!=\t\u0013\u0005]\u0018$!A\u0005\u0002\u0006e\b\"\u0003B\u00063\u0005\u0005I\u0011\u0002B\u0007\u0005-\t%O]1z%\u0016lwN^3\u000b\u0005\u0005\u0012\u0013aC3yaJ,7o]5p]NT!a\t\u0013\u0002\u0011\r\fG/\u00197zgRT!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u00183kq\u0012\u0005CA\u00181\u001b\u0005\u0001\u0013BA\u0019!\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00020g%\u0011A\u0007\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011a'\u000f\b\u0003_]J!\u0001\u000f\u0011\u0002\u000fA\f7m[1hK&\u0011!h\u000f\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tA\u0004\u0005\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teHA\u0004Qe>$Wo\u0019;\u0011\u0005u\u001a\u0015B\u0001#?\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003\u001d\u0003\"a\f%\n\u0005%\u0003#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA(Q#B\u0011q\u0006\u0001\u0005\u0006\u000b\u0016\u0001\ra\u0012\u0005\u0006\u0017\u0016\u0001\raR\u0001\tI\u0006$\u0018\rV=qKV\tA\u000b\u0005\u0002V16\taK\u0003\u0002XI\u0005)A/\u001f9fg&\u0011\u0011L\u0016\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003q\u00032!\u00183h\u001d\tq6M\u0004\u0002`E6\t\u0001M\u0003\u0002bY\u00051AH]8pizJ\u0011aP\u0005\u0003qyJ!!\u001a4\u0003\u0007M+\u0017O\u0003\u00029}A\u0011Q\u000b[\u0005\u0003SZ\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u00031\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0012\u0002\u0011\u0005t\u0017\r\\=tSNL!!\u001d8\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f1\"\u001a7f[\u0016tG\u000fV=qK\u0006AqN\u001d3fe&tw-F\u0001v!\rif\u000f_\u0005\u0003o\u001a\u0014\u0001b\u0014:eKJLgn\u001a\t\u0003{eL!A\u001f \u0003\u0007\u0005s\u0017\u0010\u000b\u0002\u000byB\u0011Q(`\u0005\u0003}z\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u000ba\f\u0019!a\u0002\t\r\u0005\u00151\u00021\u0001y\u0003\r\t'O\u001d\u0005\u0007\u0003\u0013Y\u0001\u0019\u0001=\u0002\u000bY\fG.^3\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\b\u00037\t)\u0003\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002I\u0001\bG>$WmZ3o\u0013\u0011\tI\"a\u0005\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\b\r\u0001\u0004\ty\"A\u0002dib\u0004B!!\u0005\u0002\"%!\u00111EA\n\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a\n\r\u0001\u0004\ty!\u0001\u0002fm\u0006\u0001r-\u001a8D_\u0012,gi\u001c:SKN,H\u000e\u001e\u000b\r\u0003[\ti$a\u0010\u0002B\u0005\u0015\u0013q\t\t\u0005\u0003_\t9D\u0004\u0003\u00022\u0005M\u0002CA0?\u0013\r\t)DP\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00121\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Ub\bC\u0004\u0002\u001e5\u0001\r!a\b\t\u000f\u0005\u001dR\u00021\u0001\u0002\u0010!9\u00111I\u0007A\u0002\u00055\u0012AC5oaV$\u0018I\u001d:bs\"9\u0011\u0011B\u0007A\u0002\u00055\u0002bBA%\u001b\u0001\u0007\u0011QF\u0001\r]\u0016<\u0018I\u001d:bsNK'0Z\u0001\u000baJ,G\u000f^=OC6,WCAA\u0017\u0003\u0011\u0019w\u000e]=\u0015\u000b=\u000b\u0019&!\u0016\t\u000f\u0015{\u0001\u0013!a\u0001\u000f\"91j\u0004I\u0001\u0002\u00049\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00037R3aRA/W\t\ty\u0006\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\u0013Ut7\r[3dW\u0016$'bAA5}\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00141\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0004\u0003BA<\u0003\u0003k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0000\u0005!!.\u0019<b\u0013\u0011\tI$!\u001f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0005cA\u001f\u0002\n&\u0019\u00111\u0012 \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007a\f\t\nC\u0005\u0002\u0014R\t\t\u00111\u0001\u0002\b\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!'\u0011\u000b\u0005m\u0015\u0011\u0015=\u000e\u0005\u0005u%bAAP}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0016Q\u0014\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002*\u0006=\u0006cA\u001f\u0002,&\u0019\u0011Q\u0016 \u0003\u000f\t{w\u000e\\3b]\"A\u00111\u0013\f\u0002\u0002\u0003\u0007\u00010\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003S\u000b)\f\u0003\u0005\u0002\u0014^\t\t\u00111\u0001yQM\u0001\u0011\u0011XA`\u0003\u0003\f)-a2\u0002L\u00065\u0017\u0011[Aj!\ry\u00131X\u0005\u0004\u0003{\u0003#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0007\faj\u0018$V\u001d\u000e{\u0006&\u0019:sCfd\u0003%\u001a7f[\u0016tG/\u000b\u0011.AI+Wn\u001c<fA\u0005dG\u000eI3mK6,g\u000e^:!i\"\fG\u000fI3rk\u0006d\u0007\u0005^8!K2,W.\u001a8uA\u0019\u0014x.\u001c\u0011beJ\f\u0017PL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011Z\u0001W\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0017!g1\u0002c.\u001e7mY\u0001\u001a\u0014\u0006\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u00173Y9,H\u000e\\/\u000bA\u0001\nQa\u001a:pkB\f#!a4\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003+\fQA\r\u00185]A\n1\"\u0011:sCf\u0014V-\\8wKB\u0011q&G\n\u00053\u0005u'\tE\u0004\u0002`\u0006\u0015xiR(\u000e\u0005\u0005\u0005(bAAr}\u00059!/\u001e8uS6,\u0017\u0002BAt\u0003C\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\tI.\u0001\u0005u_N#(/\u001b8h)\t\t)(A\u0003baBd\u0017\u0010F\u0003P\u0003g\f)\u0010C\u0003F9\u0001\u0007q\tC\u0003L9\u0001\u0007q)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005m(q\u0001\t\u0006{\u0005u(\u0011A\u0005\u0004\u0003\u007ft$AB(qi&|g\u000eE\u0003>\u0005\u00079u)C\u0002\u0003\u0006y\u0012a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\u0005;\u0005\u0005\t\u0019A(\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\b!\u0011\t9H!\u0005\n\t\tM\u0011\u0011\u0010\u0002\u0007\u001f\nTWm\u0019;")
public class ArrayRemove
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRemove arrayRemove) {
        return ArrayRemove$.MODULE$.unapply(arrayRemove);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRemove> tupled() {
        return ArrayRemove$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRemove>> curried() {
        return ArrayRemove$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return (Seq)Seq$.MODULE$.empty();
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return (Seq)Seq$.MODULE$.empty();
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        boolean hasNull = arrayType.containsNull();
        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType dt = (DataType)some.value();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), dt}));
            return seq;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        if (!e1.sameType(e2)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        return TypeUtils$.MODULE$.checkForOrderingExpr(e2, new StringBuilder(9).append("function ").append(this.prettyName()).toString());
    }

    private DataType elementType() {
        return ((ArrayType)this.left().dataType()).elementType();
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayRemove arrayRemove = this;
        synchronized (arrayRemove) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return !this.bitmap$trans$0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object[] newArray = new Object[((ArrayData)arr).numElements()];
        IntRef pos = IntRef.create((int)0);
        ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
            ArrayRemove.$anonfun$nullSafeEval$8(this, value, newArray, pos, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        return new GenericArrayData((Object[])Predef$.MODULE$.genericArrayOps((Object)newArray).slice(0, pos.elem));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(arr, value) -> {
            String numsToRemove = ctx.freshName("numsToRemove");
            String newArraySize = ctx.freshName("newArraySize");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.elementType(), i);
            String isEqual = ctx.genEqual(this.elementType(), (String)value, getValue);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(211).append("\n         |int ").append(numsToRemove).append(" = 0;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)arr).append(".numElements(); ").append(i).append(" ++) {\n         |  if (!").append((String)arr).append(".isNullAt(").append(i).append(") && ").append(isEqual).append(") {\n         |    ").append(numsToRemove).append(" = ").append(numsToRemove).append(" + 1;\n         |  }\n         |}\n         |int ").append(newArraySize).append(" = ").append((String)arr).append(".numElements() - ").append(numsToRemove).append(";\n         |").append(this.genCodeForResult(ctx, ev, (String)arr, (String)value, newArraySize)).append("\n       ").toString())).stripMargin();
        });
    }

    public String genCodeForResult(CodegenContext ctx, ExprCode ev, String inputArray, String value, String newArraySize) {
        String values = ctx.freshName("values");
        String i = ctx.freshName("i");
        String pos = ctx.freshName("pos");
        String getValue = CodeGenerator$.MODULE$.getValue(inputArray, this.elementType(), i);
        String isEqual = ctx.genEqual(this.elementType(), value, getValue);
        String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), newArraySize, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), inputArray, pos, i, false);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(297).append("\n       |").append(allocation).append("\n       |int ").append(pos).append(" = 0;\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(inputArray).append(".numElements(); ").append(i).append(" ++) {\n       |  if (").append(inputArray).append(".isNullAt(").append(i).append(")) {\n       |    ").append(values).append(".setNullAt(").append(pos).append(");\n       |    ").append(pos).append(" = ").append(pos).append(" + 1;\n       |  }\n       |  else {\n       |    if (!(").append(isEqual).append(")) {\n       |      ").append(assignment).append("\n       |      ").append(pos).append(" = ").append(pos).append(" + 1;\n       |    }\n       |  }\n       |}\n       |").append(ev.value()).append(" = ").append(values).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "array_remove";
    }

    public ArrayRemove copy(Expression left, Expression right) {
        return new ArrayRemove(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRemove";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRemove;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRemove)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRemove arrayRemove = (ArrayRemove)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRemove.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRemove.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRemove.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$8(ArrayRemove $this, Object value$3, Object[] newArray$1, IntRef pos$1, int i, Object v) {
        block0: {
            if (v != null && $this.ordering().equiv(v, value$3)) break block0;
            newArray$1[pos$1.elem] = v;
            ++pos$1.elem;
        }
    }

    public ArrayRemove(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

