/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NextDay$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(start_date, day_of_week) - Returns the first date which is later than `start_date` and named as indicated.", examples="\n    Examples:\n      > SELECT _FUNC_('2015-01-14', 'TU');\n       2015-01-20\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001\u0002\u0010 \u00012B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005a\b\u0003\u0005E\u0001\tE\t\u0015!\u0003@\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Q\u0005\u0001\"\u0011?\u0011\u0015Y\u0005\u0001\"\u0011?\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015\u0019\b\u0001\"\u0015u\u0011\u001d\t)\u0001\u0001C!\u0003\u000fA\u0011\"!\u0007\u0001\u0003\u0003%\t!a\u0007\t\u0013\u0005\u0005\u0002!%A\u0005\u0002\u0005\r\u0002\"CA\u001d\u0001E\u0005I\u0011AA\u0012\u0011%\tY\u0004AA\u0001\n\u0003\ni\u0004C\u0005\u0002N\u0001\t\t\u0011\"\u0001\u0002P!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003?\u0002\u0011\u0011!C!\u0003CB\u0011\"a\u001c\u0001\u0003\u0003%\t!!\u001d\t\u0013\u0005U\u0004!!A\u0005B\u0005]t!CAN?\u0005\u0005\t\u0012AAO\r!qr$!A\t\u0002\u0005}\u0005BB#\u0019\t\u0003\ti\u000bC\u0005\u00020b\t\t\u0011\"\u0012\u00022\"I\u00111\u0017\r\u0002\u0002\u0013\u0005\u0015Q\u0017\u0005\n\u0003wC\u0012\u0011!CA\u0003{C\u0011\"a4\u0019\u0003\u0003%I!!5\u0003\u000f9+\u0007\u0010\u001e#bs*\u0011\u0001%I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002#G\u0005A1-\u0019;bYf\u001cHO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001[E\"$\b\u0005\u0002/_5\tq$\u0003\u00021?\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003]IJ!aM\u0010\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00026w%\u0011AH\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\ngR\f'\u000f\u001e#bi\u0016,\u0012a\u0010\t\u0003]\u0001K!!Q\u0010\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0006ti\u0006\u0014H\u000fR1uK\u0002\n\u0011\u0002Z1z\u001f\u001a<V-Z6\u0002\u0015\u0011\f\u0017p\u00144XK\u0016\\\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004\u000f\"K\u0005C\u0001\u0018\u0001\u0011\u0015iT\u00011\u0001@\u0011\u0015\u0019U\u00011\u0001@\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001O!\ryuK\u0017\b\u0003!Vs!!\u0015+\u000e\u0003IS!aU\u0016\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014B\u0001,7\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001W-\u0003\u0007M+\u0017O\u0003\u0002WmA\u00111LX\u0007\u00029*\u0011QlI\u0001\u0006if\u0004Xm]\u0005\u0003?r\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u0019\t\u00037\u000eL!\u0001\u001a/\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002OB\u0011Q\u0007[\u0005\u0003SZ\u0012qAQ8pY\u0016\fg.\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002m_F\u0004\"!N7\n\u000594$aA!os\")\u0001o\u0003a\u0001Y\u0006)1\u000f^1si\")!o\u0003a\u0001Y\u00061A-Y=PM^\u000b\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\tU\\\u0018\u0011\u0001\t\u0003mfl\u0011a\u001e\u0006\u0003q~\tqaY8eK\u001e,g.\u0003\u0002{o\nAQ\t\u001f9s\u0007>$W\rC\u0003}\u0019\u0001\u0007Q0A\u0002dib\u0004\"A\u001e@\n\u0005}<(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u0007a\u0001\u0019A;\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t\u0019B\u0004\u0003\u0002\u000e\u0005=\u0001CA)7\u0013\r\t\tBN\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0011q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Ea'\u0001\u0003d_BLH#B$\u0002\u001e\u0005}\u0001bB\u001f\u000f!\u0003\u0005\ra\u0010\u0005\b\u0007:\u0001\n\u00111\u0001@\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\n+\u0007}\n9c\u000b\u0002\u0002*A!\u00111FA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012!C;oG\",7m[3e\u0015\r\t\u0019DN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001c\u0003[\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA !\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\nA\u0001\\1oO*\u0011\u0011\u0011J\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0016\u0005\r\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA)!\r)\u00141K\u0005\u0004\u0003+2$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00017\u0002\\!I\u0011QL\n\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0004#BA3\u0003WbWBAA4\u0015\r\tIGN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA7\u0003O\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019q-a\u001d\t\u0011\u0005uS#!AA\u00021\fa!Z9vC2\u001cHcA4\u0002z!A\u0011Q\f\f\u0002\u0002\u0003\u0007A\u000eK\n\u0001\u0003{\n\u0019)!\"\u0002\n\u0006-\u0015qRAI\u0003+\u000b9\nE\u0002/\u0003\u007fJ1!!! \u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\"\u0002c~3UKT\"`QM$\u0018M\u001d;`I\u0006$X\r\f\u0011eCf|vNZ0xK\u0016\\\u0017\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t4jeN$\b\u0005Z1uK\u0002:\b.[2iA%\u001c\b\u0005\\1uKJ\u0004C\u000f[1oA\u0001\u001cH/\u0019:u?\u0012\fG/\u001a1!C:$\u0007E\\1nK\u0012\u0004\u0013m\u001d\u0011j]\u0012L7-\u0019;fI:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u001b\u000baJ\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nT'\f\u00192[E\"t\u0005\f\u0011()V;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE*T\u0006M\u0019.eAR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003'\u000ba\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002\u001a\u0006)\u0011GL\u001b/a\u00059a*\u001a=u\t\u0006L\bC\u0001\u0018\u0019'\u0011A\u0012\u0011\u0015\u001e\u0011\u000f\u0005\r\u0016\u0011V @\u000f6\u0011\u0011Q\u0015\u0006\u0004\u0003O3\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003W\u000b)KA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!(\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0010\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u001d\u000b9,!/\t\u000buZ\u0002\u0019A \t\u000b\r[\u0002\u0019A \u0002\u000fUt\u0017\r\u001d9msR!\u0011qXAf!\u0015)\u0014\u0011YAc\u0013\r\t\u0019M\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bU\n9mP \n\u0007\u0005%gG\u0001\u0004UkBdWM\r\u0005\t\u0003\u001bd\u0012\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003'\u0004B!!\u0011\u0002V&!\u0011q[A\"\u0005\u0019y%M[3di\u0002")
public class NextDay
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression startDate;
    private final Expression dayOfWeek;

    public static Option<Tuple2<Expression, Expression>> unapply(NextDay nextDay) {
        return NextDay$.MODULE$.unapply(nextDay);
    }

    public static Function1<Tuple2<Expression, Expression>, NextDay> tupled() {
        return NextDay$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NextDay>> curried() {
        return NextDay$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression dayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.dayOfWeek();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object start, Object dayOfW) {
        Integer n;
        int dow = DateTimeUtils$.MODULE$.getDayOfWeekFromString((UTF8String)dayOfW);
        if (dow == -1) {
            n = null;
        } else {
            int sd = BoxesRunTime.unboxToInt((Object)start);
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getNextDateForDayOfWeek(sd, dow));
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(sd, dowS) -> {
            String string;
            String dateTimeUtilClass = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
            String dayOfWeekTerm = ctx.freshName("dayOfWeek");
            if (this.dayOfWeek().foldable()) {
                UTF8String input = (UTF8String)this.dayOfWeek().eval(this.dayOfWeek().eval$default$1());
                if (input == null || DateTimeUtils$.MODULE$.getDayOfWeekFromString(input) == -1) {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(35).append("\n             |").append(ev.isNull()).append(" = true;\n           ").toString())).stripMargin();
                } else {
                    int dayOfWeekValue = DateTimeUtils$.MODULE$.getDayOfWeekFromString(input);
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n             |").append(ev.value()).append(" = ").append(dateTimeUtilClass).append(".getNextDateForDayOfWeek(").append((String)sd).append(", ").append(dayOfWeekValue).append(");\n           ").toString())).stripMargin();
                }
            } else {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(187).append("\n           |int ").append(dayOfWeekTerm).append(" = ").append(dateTimeUtilClass).append(".getDayOfWeekFromString(").append((String)dowS).append(");\n           |if (").append(dayOfWeekTerm).append(" == -1) {\n           |  ").append(ev.isNull()).append(" = true;\n           |} else {\n           |  ").append(ev.value()).append(" = ").append(dateTimeUtilClass).append(".getNextDateForDayOfWeek(").append((String)sd).append(", ").append(dayOfWeekTerm).append(");\n           |}\n         ").toString())).stripMargin();
            }
            return string;
        });
    }

    @Override
    public String prettyName() {
        return "next_day";
    }

    public NextDay copy(Expression startDate, Expression dayOfWeek) {
        return new NextDay(startDate, dayOfWeek);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.dayOfWeek();
    }

    @Override
    public String productPrefix() {
        return "NextDay";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.startDate();
                break;
            }
            case 1: {
                expression = this.dayOfWeek();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NextDay;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NextDay)) return false;
        boolean bl = true;
        if (!bl) return false;
        NextDay nextDay = (NextDay)x$1;
        Expression expression = this.startDate();
        Expression expression2 = nextDay.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.dayOfWeek();
        Expression expression4 = nextDay.dayOfWeek();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!nextDay.canEqual(this)) return false;
        return true;
    }

    public NextDay(Expression startDate, Expression dayOfWeek) {
        this.startDate = startDate;
        this.dayOfWeek = dayOfWeek;
        ExpectsInputTypes.$init$(this);
    }
}

