/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FormatNumber$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr1, expr2) - Formats the number `expr1` like '#,###,###.##', rounded to `expr2`\n      decimal places. If `expr2` is 0, the result has no decimal point or fractional part.\n      `expr2` also accept a user specified format.\n      This is supposed to function like MySQL's FORMAT.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(12332.123456, 4);\n       12,332.1235\n      > SELECT _FUNC_(12332.123456, '##################.###');\n       12332.123\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\tUb\u0001\u0002\u0015*\u0001ZB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005O\u0001\tE\t\u0015!\u0003J\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015!\u0006\u0001\"\u0011I\u0011\u0015)\u0006\u0001\"\u0011I\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u001d!\bA1A\u0005\nUDaA \u0001!\u0002\u00131\b\u0002C@\u0001\u0001\u0004%I!!\u0001\t\u0013\u0005=\u0001\u00011A\u0005\n\u0005E\u0001\u0002CA\u000f\u0001\u0001\u0006K!a\u0001\t\u0013\u0005\u001d\u0002\u00011A\u0005\n\u0005%\u0002\"CA\u001e\u0001\u0001\u0007I\u0011BA\u001f\u0011!\t\t\u0005\u0001Q!\n\u0005-\u0002BCA#\u0001!\u0015\r\u0011\"\u0003\u0002H!Q\u0011\u0011\u000b\u0001\t\u0006\u0004%I!a\u0015\t\u000f\u0005\r\u0004\u0001\"\u0015\u0002f!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBAJ\u0001\u0011\u0005\u0013Q\u0013\u0005\n\u0003/\u0003\u0011\u0011!C\u0001\u00033C\u0011\"a(\u0001#\u0003%\t!!)\t\u0013\u0005]\u0006!%A\u0005\u0002\u0005\u0005\u0006\u0002CA]\u0001\u0005\u0005I\u0011I;\t\u0013\u0005m\u0006!!A\u0005\u0002\u0005u\u0006\"CA`\u0001\u0005\u0005I\u0011AAa\u0011%\t)\rAA\u0001\n\u0003\n9\rC\u0005\u0002V\u0002\t\t\u0011\"\u0001\u0002X\"I\u00111\u001c\u0001\u0002\u0002\u0013\u0005\u0013Q\\\u0004\n\u0003wL\u0013\u0011!E\u0001\u0003{4\u0001\u0002K\u0015\u0002\u0002#\u0005\u0011q \u0005\u0007\u001f\n\"\tA!\u0004\t\u0013\t=!%!A\u0005F\tE\u0001\"\u0003B\nE\u0005\u0005I\u0011\u0011B\u000b\u0011%\u0011YBIA\u0001\n\u0003\u0013i\u0002C\u0005\u0003,\t\n\t\u0011\"\u0003\u0003.\taai\u001c:nCRtU/\u001c2fe*\u0011!fK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002-[\u0005A1-\u0019;bYf\u001cHO\u0003\u0002/_\u0005\u00191/\u001d7\u000b\u0005A\n\u0014!B:qCJ\\'B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001omrD\t\u0005\u00029s5\t\u0011&\u0003\u0002;S\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003qqJ!!P\u0015\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005IA\u0004Qe>$Wo\u0019;\u0011\u0005}*\u0015B\u0001$A\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0005AX#A%\u0011\u0005aR\u0015BA&*\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0003q\u0002\n\u0011\u0001Z\u0001\u0003I\u0002\na\u0001P5oSRtDcA)S'B\u0011\u0001\b\u0001\u0005\u0006\u000f\u0016\u0001\r!\u0013\u0005\u0006\u001b\u0016\u0001\r!S\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0005eCR\fG+\u001f9f+\u0005A\u0006CA-]\u001b\u0005Q&BA..\u0003\u0015!\u0018\u0010]3t\u0013\ti&L\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,W#\u00011\u0011\u0005}\n\u0017B\u00012A\u0005\u001d\u0011un\u001c7fC:\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005)\u0007c\u00014oc:\u0011q\r\u001c\b\u0003Q.l\u0011!\u001b\u0006\u0003UV\na\u0001\u0010:p_Rt\u0014\"A!\n\u00055\u0004\u0015a\u00029bG.\fw-Z\u0005\u0003_B\u00141aU3r\u0015\ti\u0007\t\u0005\u0002Ze&\u00111O\u0017\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fQ\u0002Z3gCVdGOR8s[\u0006$X#\u0001<\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018\u0001\u00027b]\u001eT\u0011a_\u0001\u0005U\u00064\u0018-\u0003\u0002~q\n11\u000b\u001e:j]\u001e\fa\u0002Z3gCVdGOR8s[\u0006$\b%A\u0007mCN$H)\u00138u-\u0006dW/Z\u000b\u0003\u0003\u0007\u0001RaPA\u0003\u0003\u0013I1!a\u0002A\u0005\u0019y\u0005\u000f^5p]B\u0019q(a\u0003\n\u0007\u00055\u0001IA\u0002J]R\f\u0011\u0003\\1ti\u0012Ke\u000e\u001e,bYV,w\fJ3r)\u0011\t\u0019\"!\u0007\u0011\u0007}\n)\"C\u0002\u0002\u0018\u0001\u0013A!\u00168ji\"I\u00111\u0004\b\u0002\u0002\u0003\u0007\u00111A\u0001\u0004q\u0012\n\u0014A\u00047bgR$\u0015J\u001c;WC2,X\r\t\u0015\u0004\u001f\u0005\u0005\u0002cA \u0002$%\u0019\u0011Q\u0005!\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001\u00057bgR$5\u000b\u001e:j]\u001e4\u0016\r\\;f+\t\tY\u0003E\u0003@\u0003\u000b\ti\u0003\u0005\u0003\u00020\u0005]b\u0002BA\u0019\u0003g\u0001\"\u0001\u001b!\n\u0007\u0005U\u0002)\u0001\u0004Qe\u0016$WMZ\u0005\u0004{\u0006e\"bAA\u001b\u0001\u0006!B.Y:u\tN#(/\u001b8h-\u0006dW/Z0%KF$B!a\u0005\u0002@!I\u00111D\t\u0002\u0002\u0003\u0007\u00111F\u0001\u0012Y\u0006\u001cH\u000fR*ue&twMV1mk\u0016\u0004\u0003f\u0001\n\u0002\"\u00059\u0001/\u0019;uKJtWCAA%!\r9\u00181J\u0005\u0004\u0003\u001bB(\u0001D*ue&twMQ;gM\u0016\u0014\bfA\n\u0002\"\u0005aa.^7cKJ4uN]7biV\u0011\u0011Q\u000b\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111\f>\u0002\tQ,\u0007\u0010^\u0005\u0005\u0003?\nIFA\u0007EK\u000eLW.\u00197G_Jl\u0017\r\u001e\u0015\u0004)\u0005\u0005\u0012\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCBA4\u0003[\n\t\bE\u0002@\u0003SJ1!a\u001bA\u0005\r\te.\u001f\u0005\b\u0003_*\u0002\u0019AA4\u0003\u001dAxJ\u00196fGRDq!a\u001d\u0016\u0001\u0004\t9'A\u0004e\u001f\nTWm\u0019;\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA=\u0003\u000b\u000by\t\u0005\u0003\u0002|\u0005\u0005UBAA?\u0015\r\ty(K\u0001\bG>$WmZ3o\u0013\u0011\t\u0019)! \u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\"\u0017\u0001\u0004\tI)A\u0002dib\u0004B!a\u001f\u0002\f&!\u0011QRA?\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!%\u0017\u0001\u0004\tI(\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u00055\u0012\u0001B2paf$R!UAN\u0003;Cqa\u0012\r\u0011\u0002\u0003\u0007\u0011\nC\u0004N1A\u0005\t\u0019A%\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0015\u0016\u0004\u0013\u0006\u00156FAAT!\u0011\tI+a-\u000e\u0005\u0005-&\u0002BAW\u0003_\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E\u0006)\u0001\u0006b]:|G/\u0019;j_:LA!!.\u0002,\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0003\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qMAb\u0011%\tY\"HA\u0001\u0002\u0004\tI!A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\r\u0005\u0004\u0002L\u0006E\u0017qM\u0007\u0003\u0003\u001bT1!a4A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\fiM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00011\u0002Z\"I\u00111D\u0010\u0002\u0002\u0003\u0007\u0011qM\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0001\fy\u000eC\u0005\u0002\u001c\u0001\n\t\u00111\u0001\u0002h!z\u0001!a9\u0002j\u0006-\u0018q^Ay\u0003k\f9\u0010E\u00029\u0003KL1!a:*\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!<\u0002\u0005\u001fR\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(/\r\u0017!Kb\u0004(OM\u0015![\u00012uN]7biN\u0004C\u000f[3!]Vl'-\u001a:!A\u0016D\bO]\u0019aA1L7.\u001a\u0011(G1\u001a3e\t\u0017$G\rr3eI\u0014-AI|WO\u001c3fI\u0002\"x\u000e\t1fqB\u0014(\u0007\u0019\u0006!A\u0001\u0002\u0003\u0005\t3fG&l\u0017\r\u001c\u0011qY\u0006\u001cWm\u001d\u0018!\u0013\u001a\u0004\u0003-\u001a=qeJ\u0002\u0007%[:!a1\u0002C\u000f[3!e\u0016\u001cX\u000f\u001c;!Q\u0006\u001c\bE\\8!I\u0016\u001c\u0017.\\1mAA|\u0017N\u001c;!_J\u0004cM]1di&|g.\u00197!a\u0006\u0014HO\f\u0006!A\u0001\u0002\u0003\u0005\t1fqB\u0014(\u0007\u0019\u0011bYN|\u0007%Y2dKB$\b%\u0019\u0011vg\u0016\u0014\be\u001d9fG&4\u0017.\u001a3!M>\u0014X.\u0019;/\u0015\u0001\u0002\u0003\u0005\t\u0011!)\"L7\u000fI5tAM,\b\u000f]8tK\u0012\u0004Co\u001c\u0011gk:\u001cG/[8oA1L7.\u001a\u0011NsN\u000bFjJ:!\r>\u0013V*\u0011+/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005M\u0018!!\u000f\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QE\u00124g\r\u001a/cI\u001aD'\u000e\u001c-AQJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00193YM\u001a$GL\u00193gUR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u001a4gIr\u0013GM\u001a5kYb\u0003eJ\u0012$G\r\u001a3eI\u0012$G\r\u001a3eI\u0012$G\rr3eI\u0012(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013GM\u001a4e9\n$g\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011\u0011`\u0001\u0006c9*d\u0006M\u0001\r\r>\u0014X.\u0019;Ok6\u0014WM\u001d\t\u0003q\t\u001aBA\tB\u0001\tB9!1\u0001B\u0005\u0013&\u000bVB\u0001B\u0003\u0015\r\u00119\u0001Q\u0001\beVtG/[7f\u0013\u0011\u0011YA!\u0002\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002~\u0006AAo\\*ue&tw\rF\u0001w\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\t&q\u0003B\r\u0011\u00159U\u00051\u0001J\u0011\u0015iU\u00051\u0001J\u0003\u001d)h.\u00199qYf$BAa\b\u0003(A)q(!\u0002\u0003\"A)qHa\tJ\u0013&\u0019!Q\u0005!\u0003\rQ+\b\u000f\\33\u0011!\u0011ICJA\u0001\u0002\u0004\t\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\u0003E\u0002x\u0005cI1Aa\ry\u0005\u0019y%M[3di\u0002")
public class FormatNumber
extends BinaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private transient StringBuffer pattern;
    private transient DecimalFormat numberFormat;
    private final Expression x;
    private final Expression d;
    private final String defaultFormat;
    private transient Option<Object> lastDIntValue;
    private transient Option<String> lastDStringValue;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(FormatNumber formatNumber) {
        return FormatNumber$.MODULE$.unapply(formatNumber);
    }

    public static Function1<Tuple2<Expression, Expression>, FormatNumber> tupled() {
        return FormatNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FormatNumber>> curried() {
        return FormatNumber$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression x() {
        return this.x;
    }

    public Expression d() {
        return this.d;
    }

    @Override
    public Expression left() {
        return this.x();
    }

    @Override
    public Expression right() {
        return this.d();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, StringType$.MODULE$}))}));
    }

    private String defaultFormat() {
        return this.defaultFormat;
    }

    private Option<Object> lastDIntValue() {
        return this.lastDIntValue;
    }

    private void lastDIntValue_$eq(Option<Object> x$1) {
        this.lastDIntValue = x$1;
    }

    private Option<String> lastDStringValue() {
        return this.lastDStringValue;
    }

    private void lastDStringValue_$eq(Option<String> x$1) {
        this.lastDStringValue = x$1;
    }

    private StringBuffer pattern$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.pattern = new StringBuffer();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.pattern;
    }

    private StringBuffer pattern() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.pattern$lzycompute() : this.pattern;
    }

    private DecimalFormat numberFormat$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numberFormat = new DecimalFormat("", new DecimalFormatSymbols(Locale.US));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.numberFormat;
    }

    private DecimalFormat numberFormat() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.numberFormat$lzycompute() : this.numberFormat;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object nullSafeEval(Object xObject, Object dObject) {
        block24: {
            block25: {
                block23: {
                    var7_3 = this.right().dataType();
                    if (!IntegerType$.MODULE$.equals(var7_3)) break block23;
                    dValue = BoxesRunTime.unboxToInt((Object)dObject);
                    if (dValue < 0) {
                        return null;
                    }
                    var9_5 = this.lastDIntValue();
                    if (var9_5 instanceof Some && (last = BoxesRunTime.unboxToInt((Object)(var10_6 = (Some)var9_5).value())) == dValue) {
                        var6_8 = BoxedUnit.UNIT;
                    } else {
                        this.pattern().delete(0, this.pattern().length());
                        this.pattern().append(this.defaultFormat());
                        if (dValue > 0) {
                            this.pattern().append(".");
                            for (i = 0; i < dValue; ++i) {
                                this.pattern().append("0");
                            }
                        }
                        this.lastDIntValue_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)dValue)));
                        this.numberFormat().applyLocalizedPattern(this.pattern().toString());
                        var6_9 = BoxedUnit.UNIT;
                    }
                    var4_11 = BoxedUnit.UNIT;
                    break block24;
                }
                if (!StringType$.MODULE$.equals(var7_3)) break block25;
                dValue = ((UTF8String)dObject).toString();
                var14_14 = this.lastDStringValue();
                if (!(var14_14 instanceof Some)) ** GOTO lbl-1000
                var15_15 = (Some)var14_14;
                v0 = last = (String)var15_15.value();
                var17_17 = dValue;
                if (!(v0 != null ? v0.equals(var17_17) == false : var17_17 != null)) {
                    var5_18 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    this.pattern().delete(0, this.pattern().length());
                    this.lastDStringValue_$eq((Option<String>)new Some((Object)dValue));
                    if (dValue.isEmpty()) {
                        this.numberFormat().applyLocalizedPattern(this.defaultFormat());
                        v1 = BoxedUnit.UNIT;
                    } else {
                        this.numberFormat().applyLocalizedPattern(dValue);
                        v1 = BoxedUnit.UNIT;
                    }
                    var5_19 = v1;
                }
                var4_12 = BoxedUnit.UNIT;
                break block24;
            }
            throw new MatchError((Object)var7_3);
        }
        var18_20 = this.x().dataType();
        if (ByteType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToByte((Object)xObject)));
        } else if (ShortType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToShort((Object)xObject)));
        } else if (FloatType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToFloat((Object)xObject)));
        } else if (IntegerType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToInt((Object)xObject)));
        } else if (LongType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToLong((Object)xObject)));
        } else if (DoubleType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToDouble((Object)xObject)));
        } else if (var18_20 instanceof DecimalType) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(((Decimal)xObject).toJavaBigDecimal()));
        } else {
            throw new MatchError((Object)var18_20);
        }
        return var3_21;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(num, d) -> {
            String string;
            String sb = StringBuffer.class.getName();
            String df = DecimalFormat.class.getName();
            String dfs = DecimalFormatSymbols.class.getName();
            String l = Locale.class.getName();
            String usLocale = "US";
            String numberFormat = ctx.addMutableState(df, "numberFormat", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(21).append((String)v).append(" = new ").append(df).append("(\"\", new ").append(dfs).append("(").append(l).append(".").append(usLocale).append("));").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
            DataType dataType = this.right().dataType();
            if (IntegerType$.MODULE$.equals(dataType)) {
                String pattern = ctx.addMutableState(sb, "pattern", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(10).append((String)v).append(" = new ").append(sb).append("();").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String i = ctx.freshName("i");
                String lastDValue = ctx.addMutableState("int", "lastDValue", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(8).append((String)v).append(" = -100;").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                string = new StringBuilder(528).append("\n            if (").append((String)d).append(" >= 0) {\n              ").append(pattern).append(".delete(0, ").append(pattern).append(".length());\n              if (").append((String)d).append(" != ").append(lastDValue).append(") {\n                ").append(pattern).append(".append(\"").append(this.defaultFormat()).append("\");\n\n                if (").append((String)d).append(" > 0) {\n                  ").append(pattern).append(".append(\".\");\n                  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)d).append("; ").append(i).append("++) {\n                    ").append(pattern).append(".append(\"0\");\n                  }\n                }\n                ").append(lastDValue).append(" = ").append((String)d).append(";\n                ").append(numberFormat).append(".applyLocalizedPattern(").append(pattern).append(".toString());\n              }\n              ").append(ev.value()).append(" = UTF8String.fromString(").append(numberFormat).append(".format(").append(this.typeHelper$1((String)num)).append("));\n            } else {\n              ").append(ev.value()).append(" = null;\n              ").append(ev.isNull()).append(" = true;\n            }\n           ").toString();
            } else if (StringType$.MODULE$.equals(dataType)) {
                String lastDValue = ctx.addMutableState("String", "lastDValue", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(8).append((String)v).append(" = null;").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String dValue = ctx.freshName("dValue");
                string = new StringBuilder(316).append("\n            String ").append(dValue).append(" = ").append((String)d).append(".toString();\n            if (!").append(dValue).append(".equals(").append(lastDValue).append(")) {\n              ").append(lastDValue).append(" = ").append(dValue).append(";\n              if (").append(dValue).append(".isEmpty()) {\n                ").append(numberFormat).append(".applyLocalizedPattern(\"").append(this.defaultFormat()).append("\");\n              } else {\n                ").append(numberFormat).append(".applyLocalizedPattern(").append(dValue).append(");\n              }\n            }\n            ").append(ev.value()).append(" = UTF8String.fromString(").append(numberFormat).append(".format(").append(this.typeHelper$1((String)num)).append("));\n           ").toString();
            } else {
                throw new MatchError((Object)dataType);
            }
            return string;
        });
    }

    @Override
    public String prettyName() {
        return "format_number";
    }

    public FormatNumber copy(Expression x, Expression d) {
        return new FormatNumber(x, d);
    }

    public Expression copy$default$1() {
        return this.x();
    }

    public Expression copy$default$2() {
        return this.d();
    }

    @Override
    public String productPrefix() {
        return "FormatNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.x();
                break;
            }
            case 1: {
                expression = this.d();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FormatNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FormatNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        FormatNumber formatNumber = (FormatNumber)x$1;
        Expression expression = this.x();
        Expression expression2 = formatNumber.x();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.d();
        Expression expression4 = formatNumber.d();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!formatNumber.canEqual(this)) return false;
        return true;
    }

    private final String typeHelper$1(String p) {
        DataType dataType = this.x().dataType();
        String string = dataType instanceof DecimalType ? new StringBuilder(19).append(p).append(".toJavaBigDecimal()").toString() : String.valueOf(p);
        return string;
    }

    public FormatNumber(Expression x, Expression d) {
        this.x = x;
        this.d = d;
        ExpectsInputTypes.$init$(this);
        this.defaultFormat = "#,###,###,###,###,###,##0";
        this.lastDIntValue = None$.MODULE$;
        this.lastDStringValue = None$.MODULE$;
    }
}

