/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringLPad$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, len[, pad]) - Returns `str`, left-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters.\n      If `pad` is not specified, `str` will be padded to the left with space characters.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       ???hi\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n      > SELECT _FUNC_('hi', 5);\n          hi\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001\u0002\u0012$\u0001BB\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011!I\u0005A!f\u0001\n\u0003\u0011\u0005\u0002\u0003&\u0001\u0005#\u0005\u000b\u0011B\"\t\u000b-\u0003A\u0011\u0001'\t\u000b-\u0003A\u0011A)\t\u000bQ\u0003A\u0011I+\t\u000b\t\u0004A\u0011I2\t\u000b)\u0004A\u0011I6\t\u000b5\u0004A\u0011\t8\t\u000bU\u0004A\u0011\u000b<\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!I\u0011Q\u0004\u0001\u0002\u0002\u0013\u0005\u0011q\u0004\u0005\n\u0003O\u0001\u0011\u0013!C\u0001\u0003SA\u0011\"a\u0010\u0001#\u0003%\t!!\u000b\t\u0013\u0005\u0005\u0003!%A\u0005\u0002\u0005%\u0002\"CA\"\u0001\u0005\u0005I\u0011IA#\u0011%\t)\u0006AA\u0001\n\u0003\t9\u0006C\u0005\u0002`\u0001\t\t\u0011\"\u0001\u0002b!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000e\u0005\n\u0003o\u0002\u0011\u0011!C\u0001\u0003sB\u0011\"a!\u0001\u0003\u0003%\t%!\"\b\u0013\u0005\r6%!A\t\u0002\u0005\u0015f\u0001\u0003\u0012$\u0003\u0003E\t!a*\t\r-SB\u0011AA[\u0011%\t9LGA\u0001\n\u000b\nI\fC\u0005\u0002<j\t\t\u0011\"!\u0002>\"I\u0011Q\u0019\u000e\u0012\u0002\u0013\u0005\u0011\u0011\u0006\u0005\n\u0003\u000fT\u0012\u0011!CA\u0003\u0013D\u0011\"a7\u001b#\u0003%\t!!\u000b\t\u0013\u0005u'$!A\u0005\n\u0005}'AC*ue&tw\r\u0014)bI*\u0011A%J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001cUBd\b\u0005\u00023g5\t1%\u0003\u00025G\t\tB+\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005I2\u0014BA\u001c$\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$a\u0002)s_\u0012,8\r\u001e\t\u0003s}J!\u0001\u0011\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0007M$(/F\u0001D!\t\u0011D)\u0003\u0002FG\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\tM$(\u000fI\u0001\u0004Y\u0016t\u0017\u0001\u00027f]\u0002\n1\u0001]1e\u0003\u0011\u0001\u0018\r\u001a\u0011\u0002\rqJg.\u001b;?)\u0011iej\u0014)\u0011\u0005I\u0002\u0001\"B!\b\u0001\u0004\u0019\u0005\"B$\b\u0001\u0004\u0019\u0005bB%\b!\u0003\u0005\ra\u0011\u000b\u0004\u001bJ\u001b\u0006\"B!\t\u0001\u0004\u0019\u0005\"B$\t\u0001\u0004\u0019\u0015\u0001C2iS2$'/\u001a8\u0016\u0003Y\u00032aV0D\u001d\tAVL\u0004\u0002Z96\t!L\u0003\u0002\\_\u00051AH]8pizJ\u0011aO\u0005\u0003=j\nq\u0001]1dW\u0006<W-\u0003\u0002aC\n\u00191+Z9\u000b\u0005yS\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0011\u0004\"!\u001a5\u000e\u0003\u0019T!aZ\u0014\u0002\u000bQL\b/Z:\n\u0005%4'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001m!\r9v\fZ\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005_J\u001cH\u000f\u0005\u0002:a&\u0011\u0011O\u000f\u0002\u0004\u0003:L\b\"B!\r\u0001\u0004y\u0007\"B$\r\u0001\u0004y\u0007\"B%\r\u0001\u0004y\u0017!\u00033p\u000f\u0016t7i\u001c3f)\u00119X0!\u0002\u0011\u0005a\\X\"A=\u000b\u0005i\u001c\u0013aB2pI\u0016<WM\\\u0005\u0003yf\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006}6\u0001\ra`\u0001\u0004GRD\bc\u0001=\u0002\u0002%\u0019\u00111A=\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u0011qA\u0007A\u0002]\f!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u000eA!\u0011qBA\f\u001d\u0011\t\t\"a\u0005\u0011\u0005eS\u0014bAA\u000bu\u00051\u0001K]3eK\u001aLA!!\u0007\u0002\u001c\t11\u000b\u001e:j]\u001eT1!!\u0006;\u0003\u0011\u0019w\u000e]=\u0015\u000f5\u000b\t#a\t\u0002&!9\u0011i\u0004I\u0001\u0002\u0004\u0019\u0005bB$\u0010!\u0003\u0005\ra\u0011\u0005\b\u0013>\u0001\n\u00111\u0001D\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u000b+\u0007\r\u000bic\u000b\u0002\u00020A!\u0011\u0011GA\u001e\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012!C;oG\",7m[3e\u0015\r\tIDO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001f\u0003g\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u000f\u0002B!!\u0013\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%\u0001\u0003mC:<'BAA)\u0003\u0011Q\u0017M^1\n\t\u0005e\u00111J\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00033\u00022!OA.\u0013\r\tiF\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004_\u0006\r\u0004\"CA3+\u0005\u0005\t\u0019AA-\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000e\t\u0006\u0003[\n\u0019h\\\u0007\u0003\u0003_R1!!\u001d;\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\nyG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA>\u0003\u0003\u00032!OA?\u0013\r\tyH\u000f\u0002\b\u0005>|G.Z1o\u0011!\t)gFA\u0001\u0002\u0004y\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002|\u0005\u001d\u0005\u0002CA31\u0005\u0005\t\u0019A8)\u001f\u0001\tY)!%\u0002\u0014\u0006]\u0015\u0011TAO\u0003?\u00032AMAG\u0013\r\tyi\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t)*\u0001B\u000f\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue2\u0002C.\u001a8\\Y\u0001\u0002\u0018\rZ/*A5\u0002#+\u001a;ve:\u001c\b\u0005Y:ue\u0002d\u0003\u0005\\3gi6\u0002\u0018\r\u001a3fI\u0002:\u0018\u000e\u001e5!AB\fG\r\u0019\u0011u_\u0002\n\u0007\u0005\\3oORD\u0007e\u001c4!A2,g\u000e\u0019\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011JM\u0002\u00027\u000f\u001e:aA%\u001c\b\u0005\\8oO\u0016\u0014\b\u0005\u001e5b]\u0002\u0002G.\u001a8aY\u0001\"\b.\u001a\u0011sKR,(O\u001c\u0011wC2,X\rI5tAMDwN\u001d;f]\u0016$\u0007\u0005^8!A2,g\u000e\u0019\u0011dQ\u0006\u0014\u0018m\u0019;feNt#\u0002\t\u0011!A\u0001\u0002\u0013J\u001a\u0011aa\u0006$\u0007\rI5tA9|G\u000fI:qK\u000eLg-[3eY\u0001\u00027\u000f\u001e:aA]LG\u000e\u001c\u0011cK\u0002\u0002\u0018\r\u001a3fI\u0002\"x\u000e\t;iK\u0002bWM\u001a;!o&$\b\u000eI:qC\u000e,\u0007e\u00195be\u0006\u001cG/\u001a:t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY*AA!\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003.[\u0014-AUb\u0003eJ @O%Z$\u0002\t\u0011!A\u0001\u0002\u0003eP @Q&T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n5jO1\u0002\u0013\u0007\f\u0011(\u007f}:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011i\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003.[\u0014-AUJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A!L'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0005\u0016!B\u0019/k9\u0002\u0014AC*ue&tw\r\u0014)bIB\u0011!GG\n\u00055\u0005%f\b\u0005\u0005\u0002,\u0006E6iQ\"N\u001b\t\tiKC\u0002\u00020j\nqA];oi&lW-\u0003\u0003\u00024\u00065&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011QU\u0001\ti>\u001cFO]5oOR\u0011\u0011qI\u0001\u0006CB\u0004H.\u001f\u000b\b\u001b\u0006}\u0016\u0011YAb\u0011\u0015\tU\u00041\u0001D\u0011\u00159U\u00041\u0001D\u0011\u001dIU\u0004%AA\u0002\r\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY-a6\u0011\u000be\ni-!5\n\u0007\u0005='H\u0001\u0004PaRLwN\u001c\t\u0007s\u0005M7iQ\"\n\u0007\u0005U'H\u0001\u0004UkBdWm\r\u0005\t\u00033|\u0012\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\b\u0003BA%\u0003GLA!!:\u0002L\t1qJ\u00196fGR\u0004")
public class StringLPad
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression str;
    private final Expression len;
    private final Expression pad;

    public static Expression $lessinit$greater$default$3() {
        return StringLPad$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringLPad stringLPad) {
        return StringLPad$.MODULE$.unapply(stringLPad);
    }

    public static Expression apply$default$3() {
        return StringLPad$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringLPad> tupled() {
        return StringLPad$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringLPad>>> curried() {
        return StringLPad$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression len() {
        return this.len;
    }

    public Expression pad() {
        return this.pad;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.len();
        Expression expression3 = this.pad();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object str, Object len, Object pad) {
        return ((UTF8String)str).lpad(BoxesRunTime.unboxToInt((Object)len), (UTF8String)pad);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, len, pad) -> new StringBuilder(9).append((String)str).append(".lpad(").append((String)len).append(", ").append((String)pad).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "lpad";
    }

    public StringLPad copy(Expression str, Expression len, Expression pad) {
        return new StringLPad(str, len, pad);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.len();
    }

    public Expression copy$default$3() {
        return this.pad();
    }

    @Override
    public String productPrefix() {
        return "StringLPad";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.len();
                break;
            }
            case 2: {
                expression = this.pad();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringLPad;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringLPad)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringLPad stringLPad = (StringLPad)x$1;
        Expression expression = this.str();
        Expression expression2 = stringLPad.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.len();
        Expression expression4 = stringLPad.len();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.pad();
        Expression expression6 = stringLPad.pad();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringLPad.canEqual(this)) return false;
        return true;
    }

    public StringLPad(Expression str, Expression len, Expression pad) {
        this.str = str;
        this.len = len;
        this.pad = pad;
        ExpectsInputTypes.$init$(this);
    }

    public StringLPad(Expression str, Expression len) {
        this(str, len, Literal$.MODULE$.apply(" "));
    }
}

