/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.SchemaOfJson$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(json[, options]) - Returns schema in the DDL format of JSON string.", examples="\n    Examples:\n      > SELECT _FUNC_('[{\"col\":0}]');\n       array<struct<col:bigint>>\n      > SELECT _FUNC_('[{\"col\":01}]', map('allowNumericLeadingZeros', 'true'));\n       array<struct<col:bigint>>\n  ", group="json_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u0011#\u0001>B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\"A\u0011\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Z\u0001\tE\t\u0015!\u0003L\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015Q\u0006\u0001\"\u0001`\u0011\u0015Q\u0006\u0001\"\u0001b\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015a\u0007\u0001\"\u0011n\u0011!\t\b\u0001#b\u0001\n\u0013\u0011\b\u0002C?\u0001\u0011\u000b\u0007I\u0011\u0002@\t\u0015\u0005e\u0001\u0001#b\u0001\n\u0013\tY\u0002C\u0005w\u0001!\u0015\r\u0011\"\u0003\u0002&!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003;\u0002A\u0011IA0\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002j\u0001\t\n\u0011\"\u0001\u0002l!I\u0011\u0011\u0011\u0001\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u0003\u000f\u0003\u0011\u0011!C!\u0003\u0013C\u0011\"!'\u0001\u0003\u0003%\t!a'\t\u0013\u0005\r\u0006!!A\u0005\u0002\u0005\u0015\u0006\"CAV\u0001\u0005\u0005I\u0011IAW\u0011%\tY\fAA\u0001\n\u0003\ti\fC\u0005\u0002B\u0002\t\t\u0011\"\u0011\u0002D\u001eI\u0011q\u001d\u0012\u0002\u0002#\u0005\u0011\u0011\u001e\u0004\tC\t\n\t\u0011#\u0001\u0002l\"1!l\u0007C\u0001\u0003sD\u0011\"a?\u001c\u0003\u0003%)%!@\t\u0013\u0005}8$!A\u0005\u0002\n\u0005\u0001\"\u0003B\u00047\u0005\u0005I\u0011\u0011B\u0005\u0011%\u0011YbGA\u0001\n\u0013\u0011iB\u0001\u0007TG\",W.Y(g\u0015N|gN\u0003\u0002$I\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)c%\u0001\u0005dCR\fG._:u\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0007\u000e\u001eA!\t\t$'D\u0001#\u0013\t\u0019$EA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t)\u0004(D\u00017\u0015\t9$%A\u0004d_\u0012,w-\u001a8\n\u0005e2$aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000fA\u0013x\u000eZ;diB\u00111(Q\u0005\u0003\u0005r\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012!\u0012\t\u0003c\u0019K!a\u0012\u0012\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\b_B$\u0018n\u001c8t+\u0005Y\u0005\u0003\u0002'T-Zs!!T)\u0011\u00059cT\"A(\u000b\u0005As\u0013A\u0002\u001fs_>$h(\u0003\u0002Sy\u00051\u0001K]3eK\u001aL!\u0001V+\u0003\u00075\u000b\u0007O\u0003\u0002SyA\u0011AjV\u0005\u00031V\u0013aa\u0015;sS:<\u0017\u0001C8qi&|gn\u001d\u0011\u0002\rqJg.\u001b;?)\raVL\u0018\t\u0003c\u0001AQaQ\u0003A\u0002\u0015CQ!S\u0003A\u0002-#\"\u0001\u00181\t\u000b\r3\u0001\u0019A#\u0015\u0007q\u00137\rC\u0003D\u000f\u0001\u0007Q\tC\u0003J\u000f\u0001\u0007Q)\u0001\u0005eCR\fG+\u001f9f+\u00051\u0007CA4k\u001b\u0005A'BA5'\u0003\u0015!\u0018\u0010]3t\u0013\tY\u0007N\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,W#\u00018\u0011\u0005mz\u0017B\u00019=\u0005\u001d\u0011un\u001c7fC:\f1B[:p]>\u0003H/[8ogV\t1\u000f\u0005\u0002uo6\tQO\u0003\u0002wI\u0005!!n]8o\u0013\tAXOA\u0006K'>su\n\u001d;j_:\u001c\bF\u0001\u0006{!\tY40\u0003\u0002}y\tIAO]1og&,g\u000e^\u0001\fUN|gNR1di>\u0014\u00180F\u0001\u0000!\u0011\t\t!a\u0005\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\tAaY8sK*!\u0011\u0011BA\u0006\u0003\u001dQ\u0017mY6t_:TA!!\u0004\u0002\u0010\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003#\t1aY8n\u0013\u0011\t)\"a\u0001\u0003\u0017)\u001bxN\u001c$bGR|'/\u001f\u0015\u0003\u0017i\fqB[:p]&sg-\u001a:TG\",W.Y\u000b\u0003\u0003;\u00012\u0001^A\u0010\u0013\r\t\t#\u001e\u0002\u0010\u0015N|g.\u00138gKJ\u001c6\r[3nC\"\u0012AB_\u000b\u0003\u0003O\u0001B!!\u000b\u000225\u0011\u00111\u0006\u0006\u0004S\u00065\"bAA\u0018Q\u00051QO\\:bM\u0016LA!a\r\u0002,\tQQ\u000b\u0016$9'R\u0014\u0018N\\4)\u00055Q\u0018aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!I\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002F\u0005}\"a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003\u0017\n\t\u0006E\u0002<\u0003\u001bJ1!a\u0014=\u0005\r\te.\u001f\u0005\n\u0003'z\u0001\u0013!a\u0001\u0003+\n\u0011A\u001e\t\u0005\u0003/\nI&D\u0001%\u0013\r\tY\u0006\n\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012AV\u0001\u0005G>\u0004\u0018\u0010F\u0003]\u0003K\n9\u0007C\u0004D#A\u0005\t\u0019A#\t\u000f%\u000b\u0002\u0013!a\u0001\u0017\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA7U\r)\u0015qN\u0016\u0003\u0003c\u0002B!a\u001d\u0002~5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0010\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0000\u0005U$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAACU\rY\u0015qN\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0005\u0003BAG\u0003/k!!a$\u000b\t\u0005E\u00151S\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0016\u0006!!.\u0019<b\u0013\rA\u0016qR\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003;\u00032aOAP\u0013\r\t\t\u000b\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\n9\u000bC\u0005\u0002*Z\t\t\u00111\u0001\u0002\u001e\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a,\u0011\r\u0005E\u0016qWA&\u001b\t\t\u0019LC\u0002\u00026r\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI,a-\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004]\u0006}\u0006\"CAU1\u0005\u0005\t\u0019AA&\u0003\u0019)\u0017/^1mgR\u0019a.!2\t\u0013\u0005%\u0016$!AA\u0002\u0005-\u0003f\u0005\u0001\u0002J\u0006=\u0017\u0011[Ak\u0003/\fY.!8\u0002b\u0006\r\bcA\u0019\u0002L&\u0019\u0011Q\u001a\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111[\u0001K?\u001a+fjQ0)UN|gn\u0017\u0017!_B$\u0018n\u001c8t;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011tG\",W.\u0019\u0011j]\u0002\"\b.\u001a\u0011E\t2\u0003cm\u001c:nCR\u0004sN\u001a\u0011K'>s\u0005e\u001d;sS:<g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tI.AAJ\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3l\u001f\u0012d_2\u0014#\bM?^O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u0019:sCfd4\u000f\u001e:vGRd4m\u001c7;E&<\u0017N\u001c;?})\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CseW>#G>d'E\u000f\u00192{v;C\u0006I7ba\":\u0013\r\u001c7po:+X.\u001a:jG2+\u0017\rZ5oOj+'o\\:(Y\u0001:CO];fO%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I1se\u0006LHh\u001d;sk\u000e$HhY8mu\tLw-\u001b8u}yR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003?\f!B[:p]~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t)/A\u00033]Qr\u0003'\u0001\u0007TG\",W.Y(g\u0015N|g\u000e\u0005\u000227M!1$!<A!\u001d\ty/!>F\u0017rk!!!=\u000b\u0007\u0005MH(A\u0004sk:$\u0018.\\3\n\t\u0005]\u0018\u0011\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAAu\u0003!!xn\u0015;sS:<GCAAF\u0003\u0015\t\u0007\u000f\u001d7z)\u0015a&1\u0001B\u0003\u0011\u0015\u0019e\u00041\u0001F\u0011\u0015Ie\u00041\u0001L\u0003\u001d)h.\u00199qYf$BAa\u0003\u0003\u0018A)1H!\u0004\u0003\u0012%\u0019!q\u0002\u001f\u0003\r=\u0003H/[8o!\u0015Y$1C#L\u0013\r\u0011)\u0002\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\teq$!AA\u0002q\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t}\u0001\u0003BAG\u0005CIAAa\t\u0002\u0010\n1qJ\u00196fGR\u0004")
public class SchemaOfJson
extends UnaryExpression
implements CodegenFallback,
scala.Serializable {
    private transient JSONOptions jsonOptions;
    private transient JsonFactory jsonFactory;
    private transient JsonInferSchema jsonInferSchema;
    private transient UTF8String json;
    private final Expression child;
    private final Map<String, String> options;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Map<String, String>>> unapply(SchemaOfJson schemaOfJson) {
        return SchemaOfJson$.MODULE$.unapply(schemaOfJson);
    }

    public static Function1<Tuple2<Expression, Map<String, String>>, SchemaOfJson> tupled() {
        return SchemaOfJson$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Map<String, String>, SchemaOfJson>> curried() {
        return SchemaOfJson$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private JSONOptions jsonOptions$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.jsonOptions = new JSONOptions(this.options(), "UTC", JSONOptions$.MODULE$.$lessinit$greater$default$3());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.jsonOptions;
    }

    private JSONOptions jsonOptions() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.jsonOptions$lzycompute() : this.jsonOptions;
    }

    private JsonFactory jsonFactory$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.jsonFactory = this.jsonOptions().buildJsonFactory();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.jsonFactory;
    }

    private JsonFactory jsonFactory() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.jsonFactory$lzycompute() : this.jsonFactory;
    }

    private JsonInferSchema jsonInferSchema$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.jsonInferSchema = new JsonInferSchema(this.jsonOptions());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.jsonInferSchema;
    }

    private JsonInferSchema jsonInferSchema() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.jsonInferSchema$lzycompute() : this.jsonInferSchema;
    }

    private UTF8String json$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.json = (UTF8String)this.child().eval(this.child().eval$default$1());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.json;
    }

    private UTF8String json() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.json$lzycompute() : this.json;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        Expression expression = this.child();
        if (!(expression instanceof Literal)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(70).append("The input json should be a string literal and not null; however, got ").append(this.child().sql()).append(".").toString());
        Literal literal = (Literal)expression;
        Object s = literal.value();
        DataType dataType = literal.dataType();
        if (!StringType$.MODULE$.equals(dataType)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(70).append("The input json should be a string literal and not null; however, got ").append(this.child().sql()).append(".").toString());
        if (s == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(70).append("The input json should be a string literal and not null; however, got ").append(this.child().sql()).append(".").toString());
        return super.checkInputDataTypes();
    }

    @Override
    public Object eval(InternalRow v) {
        DataType dt = (DataType)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(this.jsonFactory(), this.json()), (Function1 & Serializable & scala.Serializable)parser -> {
            ArrayType arrayType;
            DataType dataType;
            parser.nextToken();
            DataType dataType2 = this.jsonInferSchema().inferField((JsonParser)parser);
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                dataType = (DataType)this.jsonInferSchema().canonicalizeType(structType, this.jsonOptions()).getOrElse((Function0 & Serializable & scala.Serializable)() -> StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$));
            } else if (dataType2 instanceof ArrayType && (arrayType = (ArrayType)dataType2).elementType() instanceof StructType) {
                dataType = (DataType)this.jsonInferSchema().canonicalizeType(arrayType.elementType(), this.jsonOptions()).map((Function1 & Serializable & scala.Serializable)x$16 -> new ArrayType((DataType)x$16, arrayType.containsNull())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ArrayType(StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$), arrayType.containsNull()));
            } else if (dataType2 != null) {
                DataType dataType3 = dataType2;
                dataType = (DataType)this.jsonInferSchema().canonicalizeType(dataType3, this.jsonOptions()).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
            } else {
                throw new MatchError((Object)dataType2);
            }
            return dataType;
        });
        return UTF8String.fromString((String)dt.catalogString());
    }

    @Override
    public String prettyName() {
        return "schema_of_json";
    }

    public SchemaOfJson copy(Expression child, Map<String, String> options) {
        return new SchemaOfJson(child, options);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    @Override
    public String productPrefix() {
        return "SchemaOfJson";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Map<String, String> map;
        int n = x$1;
        switch (n) {
            case 0: {
                map = this.child();
                break;
            }
            case 1: {
                map = this.options();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return map;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SchemaOfJson;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SchemaOfJson)) return false;
        boolean bl = true;
        if (!bl) return false;
        SchemaOfJson schemaOfJson = (SchemaOfJson)x$1;
        Expression expression = this.child();
        Expression expression2 = schemaOfJson.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = schemaOfJson.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!schemaOfJson.canEqual(this)) return false;
        return true;
    }

    public SchemaOfJson(Expression child, Map<String, String> options) {
        this.child = child;
        this.options = options;
        CodegenFallback.$init$(this);
    }

    public SchemaOfJson(Expression child) {
        this(child, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public SchemaOfJson(Expression child, Expression options) {
        this(child, ExprUtils$.MODULE$.convertToMapData(options));
    }
}

