/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.ParseUrl$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(url, partToExtract[, key]) - Extracts a part from a URL.", examples="\n    Examples:\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'HOST');\n       spark.apache.org\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY');\n       query=1\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY', 'query');\n       1\n  ", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\t}t!B\u001b7\u0011\u0003\u0019e!B#7\u0011\u00031\u0005\"\u0002)\u0002\t\u0003\t\u0006b\u0002*\u0002\u0005\u0004%Ia\u0015\u0005\u00079\u0006\u0001\u000b\u0011\u0002+\t\u000fu\u000b!\u0019!C\u0005'\"1a,\u0001Q\u0001\nQCqaX\u0001C\u0002\u0013%1\u000b\u0003\u0004a\u0003\u0001\u0006I\u0001\u0016\u0005\bC\u0006\u0011\r\u0011\"\u0003T\u0011\u0019\u0011\u0017\u0001)A\u0005)\"91-\u0001b\u0001\n\u0013\u0019\u0006B\u00023\u0002A\u0003%A\u000bC\u0004f\u0003\t\u0007I\u0011B*\t\r\u0019\f\u0001\u0015!\u0003U\u0011\u001d9\u0017A1A\u0005\nMCa\u0001[\u0001!\u0002\u0013!\u0006bB5\u0002\u0005\u0004%Ia\u0015\u0005\u0007U\u0006\u0001\u000b\u0011\u0002+\t\u000f-\f!\u0019!C\u0005Y\"1Q/\u0001Q\u0001\n5DqA^\u0001C\u0002\u0013%A\u000e\u0003\u0004x\u0003\u0001\u0006I!\u001c\u0005\bq\u0006\t\t\u0011\"!z\u0011%\u00119'AA\u0001\n\u0003\u0013I\u0007C\u0005\u0003v\u0005\t\t\u0011\"\u0003\u0003x\u0019!QI\u000e!|\u0011)\t9B\u0007BK\u0002\u0013\u0005\u0011\u0011\u0004\u0005\u000b\u0003gQ\"\u0011#Q\u0001\n\u0005m\u0001B\u0002)\u001b\t\u0003\t)\u0004C\u0004\u0002:i!\t%a\u000f\t\u000f\u0005\r#\u0004\"\u0011\u0002F!9\u00111\u000b\u000e\u0005B\u0005U\u0003bBA,5\u0011\u0005\u0013\u0011\f\u0005\u000b\u0003SR\u0002R1A\u0005\n\u0005-\u0004BCAA5!\u0015\r\u0011\"\u0003\u0002\u0004\"Q\u0011q\u0013\u000e\t\u0006\u0004%I!!'\t\u000f\u0005\r&\u0004\"\u0011\u0002&\"9\u00111\u0017\u000e\u0005\n\u0005U\u0006bBA^5\u0011%\u0011Q\u0018\u0005\b\u0003\u0007TB\u0011BAc\u0011\u001d\tYM\u0007C\u0005\u0003\u001bDq!a6\u001b\t\u0013\tI\u000eC\u0004\u0002`j!I!!9\t\u000f\u0005\u001d(\u0004\"\u0011\u0002j\"I\u0011Q \u000e\u0002\u0002\u0013\u0005\u0011q \u0005\n\u0005\u0007Q\u0012\u0013!C\u0001\u0005\u000bA\u0001Ba\u0007\u001b\u0003\u0003%\t\u0005\u001c\u0005\n\u0005;Q\u0012\u0011!C\u0001\u0005?A\u0011Ba\n\u001b\u0003\u0003%\tA!\u000b\t\u0013\t=\"$!A\u0005B\tE\u0002\"\u0003B 5\u0005\u0005I\u0011\u0001B!\u0011%\u0011)EGA\u0001\n\u0003\u00129%\u0001\u0005QCJ\u001cX-\u0016:m\u0015\t9\u0004(A\u0006fqB\u0014Xm]:j_:\u001c(BA\u001d;\u0003!\u0019\u0017\r^1msN$(BA\u001e=\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003{y\nQa\u001d9be.T!a\u0010!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0015aA8sO\u000e\u0001\u0001C\u0001#\u0002\u001b\u00051$\u0001\u0003)beN,WK\u001d7\u0014\u0007\u00059U\n\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0011:K!aT%\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005\u0019\u0015\u0001\u0002%P'R+\u0012\u0001\u0016\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bQ\u0001^=qKNT!!\u0017\u001f\u0002\rUt7/\u00194f\u0013\tYfK\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001e\fQ\u0001S(T)\u0002\nA\u0001U!U\u0011\u0006)\u0001+\u0011+IA\u0005)\u0011+V#S3\u00061\u0011+V#S3\u0002\n1AU#G\u0003\u0011\u0011VI\u0012\u0011\u0002\u0011A\u0013v\nV(D\u001f2\u000b\u0011\u0002\u0015*P)>\u001bu\n\u0014\u0011\u0002\t\u0019KE*R\u0001\u0006\r&cU\tI\u0001\n\u0003V#\u0006j\u0014*J)f\u000b!\"Q+U\u0011>\u0013\u0016\nV-!\u0003!)6+\u0012*J\u001d\u001a{\u0015!C+T\u000bJKeJR(!\u0003-\u0011ViR#Y!J+e)\u0013-\u0016\u00035\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\t1\fgn\u001a\u0006\u0002e\u0006!!.\u0019<b\u0013\t!xN\u0001\u0004TiJLgnZ\u0001\r%\u0016;U\t\u0017)S\u000b\u001aK\u0005\fI\u0001\f%\u0016;U\tW*V\u0005\u001aK\u0005,\u0001\u0007S\u000b\u001e+\u0005lU+C\r&C\u0006%A\u0003baBd\u0017\u0010F\u0002{\u0005K\u0002\"\u0001\u0012\u000e\u0014\u0011iax0!\u0002\u0002\u00125\u0003\"\u0001R?\n\u0005y4$AC#yaJ,7o]5p]B\u0019A)!\u0001\n\u0007\u0005\raGA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u00171\u0014aB2pI\u0016<WM\\\u0005\u0005\u0003\u001f\tIAA\bD_\u0012,w-\u001a8GC2d'-Y2l!\rA\u00151C\u0005\u0004\u0003+I%a\u0002)s_\u0012,8\r^\u0001\tG\"LG\u000e\u001a:f]V\u0011\u00111\u0004\t\u0006\u0003;\ti\u0003 \b\u0005\u0003?\tIC\u0004\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)CQ\u0001\u0007yI|w\u000e\u001e \n\u0003)K1!a\u000bJ\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\f\u00022\t\u00191+Z9\u000b\u0007\u0005-\u0012*A\u0005dQ&dGM]3oAQ\u0019!0a\u000e\t\u000f\u0005]Q\u00041\u0001\u0002\u001c\u0005Aa.\u001e7mC\ndW-\u0006\u0002\u0002>A\u0019\u0001*a\u0010\n\u0007\u0005\u0005\u0013JA\u0004C_>dW-\u00198\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002HA1\u0011QDA\u0017\u0003\u0013\u0002B!a\u0013\u0002P5\u0011\u0011Q\n\u0006\u0003/jJA!!\u0015\u0002N\tAA)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\tI%\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0017\u0011\t\u0005u\u0013Q\r\b\u0005\u0003?\n\t\u0007E\u0002\u0002\"%K1!a\u0019J\u0003\u0019\u0001&/\u001a3fM&\u0019A/a\u001a\u000b\u0007\u0005\r\u0014*A\u0005dC\u000eDW\rZ+sYV\u0011\u0011Q\u000e\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111O9\u0002\u00079,G/\u0003\u0003\u0002x\u0005E$aA+S\u0013\"\u001a!%a\u001f\u0011\u0007!\u000bi(C\u0002\u0002\u0000%\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001b\r\f7\r[3e!\u0006$H/\u001a:o+\t\t)\t\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\u000bI,w-\u001a=\u000b\u0007\u0005=\u0015/\u0001\u0003vi&d\u0017\u0002BAJ\u0003\u0013\u0013q\u0001U1ui\u0016\u0014h\u000eK\u0002$\u0003w\nQcY1dQ\u0016$W\t\u001f;sC\u000e$\b+\u0019:u\rVt7-\u0006\u0002\u0002\u001cB9\u0001*!(\u0002n\u0005m\u0013bAAP\u0013\nIa)\u001e8di&|g.\r\u0015\u0004I\u0005m\u0014aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAAT!\u0011\tI+a,\u000e\u0005\u0005-&bAAWq\u0005A\u0011M\\1msNL7/\u0003\u0003\u00022\u0006-&a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0015\u001d,G\u000fU1ui\u0016\u0014h\u000e\u0006\u0003\u0002\u0006\u0006]\u0006BBA]M\u0001\u0007A+A\u0002lKf\faaZ3u+JdG\u0003BA7\u0003\u007fCa!!1(\u0001\u0004!\u0016aA;sY\u0006\u0011r-\u001a;FqR\u0014\u0018m\u0019;QCJ$h)\u001e8d)\u0011\tY*a2\t\r\u0005%\u0007\u00061\u0001U\u00035\u0001\u0018M\u001d;U_\u0016CHO]1di\u0006)R\r\u001f;sC\u000e$h+\u00197vK\u001a\u0013x.\\)vKJLH#\u0002+\u0002P\u0006M\u0007BBAiS\u0001\u0007A+A\u0003rk\u0016\u0014\u0018\u0010C\u0004\u0002V&\u0002\r!!\"\u0002\u000fA\fG\u000f^3s]\u0006qQ\r\u001f;sC\u000e$hI]8n+JdG#\u0002+\u0002\\\u0006u\u0007bBAaU\u0001\u0007\u0011Q\u000e\u0005\u0007\u0003\u0013T\u0003\u0019\u0001+\u0002%A\f'o]3Ve2<\u0016\u000e\u001e5pkR\\U-\u001f\u000b\u0006)\u0006\r\u0018Q\u001d\u0005\u0007\u0003\u0003\\\u0003\u0019\u0001+\t\r\u0005%7\u00061\u0001U\u0003\u0011)g/\u00197\u0015\t\u0005-\u0018\u0011\u001f\t\u0004\u0011\u00065\u0018bAAx\u0013\n\u0019\u0011I\\=\t\u0013\u0005MH\u0006%AA\u0002\u0005U\u0018!B5oaV$\b\u0003BA|\u0003sl\u0011\u0001O\u0005\u0004\u0003wD$aC%oi\u0016\u0014h.\u00197S_^\fAaY8qsR\u0019!P!\u0001\t\u0013\u0005]Q\u0006%AA\u0002\u0005m\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u000fQC!a\u0007\u0003\n-\u0012!1\u0002\t\u0005\u0005\u001b\u00119\"\u0004\u0002\u0003\u0010)!!\u0011\u0003B\n\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0016%\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IBa\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005C\u00012\u0001\u0013B\u0012\u0013\r\u0011)#\u0013\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003W\u0014Y\u0003C\u0005\u0003.E\n\t\u00111\u0001\u0003\"\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\r\u0011\r\tU\"1HAv\u001b\t\u00119DC\u0002\u0003:%\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iDa\u000e\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003{\u0011\u0019\u0005C\u0005\u0003.M\n\t\u00111\u0001\u0002l\u00061Q-];bYN$B!!\u0010\u0003J!I!Q\u0006\u001b\u0002\u0002\u0003\u0007\u00111\u001e\u0015\u00105\t5#1\u000bB+\u00053\u0012YFa\u0018\u0003bA\u0019AIa\u0014\n\u0007\tEcGA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t]\u0013aP0G+:\u001bu\fK;sY2\u0002\u0003/\u0019:u)>,\u0005\u0010\u001e:bGR\\F\u0006I6fsvK\u0003%\f\u0011FqR\u0014\u0018m\u0019;tA\u0005\u0004\u0003/\u0019:uA\u0019\u0014x.\u001c\u0011bAU\u0013FJL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!QL\u0001\u0003D)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\u001b;uajzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40a\u0006$\bnP9vKJLX(M\u0014-A\u001dBuj\u0015+(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000f]1sW:\n\u0007/Y2iK:z'o\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!$H\u000f\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006]1uQ~\nX/\u001a:z{E:C\u0006I\u0014R+\u0016\u0013\u0016lJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE,XM]=>c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\u001b;uajzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40a\u0006$\bnP9vKJLX(M\u0014-A\u001d\nV+\u0012*ZO1\u0002s%];fef<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B2\u0003\u0015\u0011d\u0006\r\u00181\u0011\u001d\t9b\u0006a\u0001\u00037\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003l\tE\u0004#\u0002%\u0003n\u0005m\u0011b\u0001B8\u0013\n1q\n\u001d;j_:D\u0001Ba\u001d\u0019\u0003\u0003\u0005\rA_\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u001f\u0011\u00079\u0014Y(C\u0002\u0003~=\u0014aa\u00142kK\u000e$\b")
public class ParseUrl
extends Expression
implements ExpectsInputTypes,
CodegenFallback,
scala.Serializable {
    private transient URI cachedUrl;
    private transient Pattern cachedPattern;
    private transient Function1<URI, String> cachedExtractPartFunc;
    private final Seq<Expression> children;
    private volatile transient byte bitmap$trans$0;

    public static Option<Seq<Expression>> unapply(ParseUrl parseUrl) {
        return ParseUrl$.MODULE$.unapply(parseUrl);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.fill(this.children().size(), (Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "parse_url";
    }

    private URI cachedUrl$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object url;
                Expression expression = (Expression)this.children().apply(0);
                URI uRI = expression instanceof Literal && (url = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)url) != null ? this.getUrl(uTF8String) : null;
                this.cachedUrl = uRI;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.cachedUrl;
    }

    private URI cachedUrl() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.cachedUrl$lzycompute() : this.cachedUrl;
    }

    private Pattern cachedPattern$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object key;
                Expression expression = (Expression)this.children().apply(2);
                Pattern pattern = expression instanceof Literal && (key = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)key) != null ? this.getPattern(uTF8String) : null;
                this.cachedPattern = pattern;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.cachedPattern;
    }

    private Pattern cachedPattern() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.cachedPattern$lzycompute() : this.cachedPattern;
    }

    private Function1<URI, String> cachedExtractPartFunc$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                Function1<URI, String> function1;
                Literal literal;
                Object part;
                Expression expression = (Expression)this.children().apply(1);
                if (expression instanceof Literal && (part = (literal = (Literal)expression).value()) instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)part;
                    function1 = this.getExtractPartFunc(uTF8String);
                } else {
                    function1 = null;
                }
                this.cachedExtractPartFunc = function1;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.cachedExtractPartFunc;
    }

    private Function1<URI, String> cachedExtractPartFunc() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.cachedExtractPartFunc$lzycompute() : this.cachedExtractPartFunc;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() > 3 || this.children().size() < 2 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(41).append(this.prettyName()).append(" function requires two or three arguments").toString()) : ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Pattern getPattern(UTF8String key) {
        return Pattern.compile(new StringBuilder(0).append(ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXPREFIX()).append(key.toString()).append(ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXSUBFIX()).toString());
    }

    private URI getUrl(UTF8String url) {
        URI uRI;
        try {
            uRI = new URI(url.toString());
        }
        catch (URISyntaxException e) {
            uRI = null;
        }
        return uRI;
    }

    private Function1<URI, String> getExtractPartFunc(UTF8String partToExtract) {
        Function1 & Serializable & scala.Serializable intersect;
        UTF8String uTF8String = partToExtract;
        UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$HOST();
        UTF8String uTF8String3 = uTF8String;
        if (!(uTF8String2 != null ? !uTF8String2.equals(uTF8String3) : uTF8String3 != null)) {
            intersect = (Function1 & Serializable & scala.Serializable)x$54 -> x$54.getHost();
        } else {
            UTF8String uTF8String4 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PATH();
            UTF8String uTF8String5 = uTF8String;
            if (!(uTF8String4 != null ? !uTF8String4.equals(uTF8String5) : uTF8String5 != null)) {
                intersect = (Function1 & Serializable & scala.Serializable)x$55 -> x$55.getRawPath();
            } else {
                UTF8String uTF8String6 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
                UTF8String uTF8String7 = uTF8String;
                if (!(uTF8String6 != null ? !uTF8String6.equals(uTF8String7) : uTF8String7 != null)) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$56 -> x$56.getRawQuery();
                } else {
                    UTF8String uTF8String8 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REF();
                    UTF8String uTF8String9 = uTF8String;
                    if (!(uTF8String8 != null ? !uTF8String8.equals(uTF8String9) : uTF8String9 != null)) {
                        intersect = (Function1 & Serializable & scala.Serializable)x$57 -> x$57.getRawFragment();
                    } else {
                        UTF8String uTF8String10 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PROTOCOL();
                        UTF8String uTF8String11 = uTF8String;
                        if (!(uTF8String10 != null ? !uTF8String10.equals(uTF8String11) : uTF8String11 != null)) {
                            intersect = (Function1 & Serializable & scala.Serializable)x$58 -> x$58.getScheme();
                        } else {
                            UTF8String uTF8String12 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$FILE();
                            UTF8String uTF8String13 = uTF8String;
                            if (!(uTF8String12 != null ? !uTF8String12.equals(uTF8String13) : uTF8String13 != null)) {
                                intersect = (Function1 & Serializable & scala.Serializable)url -> url.getRawQuery() != null ? new StringBuilder(1).append(url.getRawPath()).append("?").append(url.getRawQuery()).toString() : url.getRawPath();
                            } else {
                                UTF8String uTF8String14 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$AUTHORITY();
                                UTF8String uTF8String15 = uTF8String;
                                if (!(uTF8String14 != null ? !uTF8String14.equals(uTF8String15) : uTF8String15 != null)) {
                                    intersect = (Function1 & Serializable & scala.Serializable)x$59 -> x$59.getRawAuthority();
                                } else {
                                    UTF8String uTF8String16 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$USERINFO();
                                    UTF8String uTF8String17 = uTF8String;
                                    intersect = !(uTF8String16 != null ? !uTF8String16.equals(uTF8String17) : uTF8String17 != null) ? (Function1 & Serializable & scala.Serializable)x$60 -> x$60.getRawUserInfo() : (Function1 & Serializable & scala.Serializable)url -> null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return intersect;
    }

    private UTF8String extractValueFromQuery(UTF8String query, Pattern pattern) {
        Matcher m = pattern.matcher(query.toString());
        return m.find() ? UTF8String.fromString((String)m.group(2)) : null;
    }

    private UTF8String extractFromUrl(URI url, UTF8String partToExtract) {
        return this.cachedExtractPartFunc() != null ? UTF8String.fromString((String)((String)this.cachedExtractPartFunc().apply((Object)url))) : UTF8String.fromString((String)((String)this.getExtractPartFunc(partToExtract).apply((Object)url)));
    }

    private UTF8String parseUrlWithoutKey(UTF8String url, UTF8String partToExtract) {
        URI currentUrl;
        return this.cachedUrl() != null ? this.extractFromUrl(this.cachedUrl(), partToExtract) : ((currentUrl = this.getUrl(url)) != null ? this.extractFromUrl(currentUrl, partToExtract) : null);
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String uTF8String;
        Seq evaluated = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)e -> (UTF8String)e.eval(input), Seq$.MODULE$.canBuildFrom());
        if (evaluated.contains(null)) {
            return null;
        }
        if (evaluated.size() == 2) {
            uTF8String = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
        } else {
            Predef$.MODULE$.assert(evaluated.size() == 3);
            Object object = evaluated.apply(1);
            UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
            if (object == null ? uTF8String2 != null : !object.equals(uTF8String2)) {
                return null;
            }
            UTF8String query = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
            if (query == null) {
                return null;
            }
            uTF8String = this.cachedPattern() != null ? this.extractValueFromQuery(query, this.cachedPattern()) : this.extractValueFromQuery(query, this.getPattern((UTF8String)evaluated.apply(2)));
        }
        return uTF8String;
    }

    public ParseUrl copy(Seq<Expression> children2) {
        return new ParseUrl(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "ParseUrl";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseUrl)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseUrl parseUrl = (ParseUrl)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = parseUrl.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!parseUrl.canEqual(this)) return false;
        return true;
    }

    public ParseUrl(Seq<Expression> children2) {
        this.children = children2;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }
}

