/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", group="datetime_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0010!\u00016B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005J\u0001\tE\t\u0015!\u0003G\u0011!Q\u0005A!f\u0001\n\u0003y\u0004\u0002C&\u0001\u0005#\u0005\u000b\u0011\u0002!\t\u000b1\u0003A\u0011A'\t\u000b1\u0003A\u0011\u0001*\t\u000b1\u0003A\u0011A+\t\u000b]\u0003A\u0011\t-\t\u000b\u0015\u0002A\u0011\t5\t\u000bE\u0004A\u0011\t5\t\u000bI\u0004A\u0011I:\t\u000fi\u0004\u0011\u0011!C\u0001w\"Aq\u0010AI\u0001\n\u0003\t\t\u0001C\u0005\u0002\u0018\u0001\t\n\u0011\"\u0001\u0002\u001a!I\u0011Q\u0004\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0001\u0005\n\u0003?\u0001\u0011\u0011!C!\u0003CA\u0011\"!\r\u0001\u0003\u0003%\t!a\r\t\u0013\u0005m\u0002!!A\u0005\u0002\u0005u\u0002\"CA\"\u0001\u0005\u0005I\u0011IA#\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002^\u0001\t\t\u0011\"\u0011\u0002`\u001dI\u0011\u0011\u0012\u0011\u0002\u0002#\u0005\u00111\u0012\u0004\t?\u0001\n\t\u0011#\u0001\u0002\u000e\"1A*\u0007C\u0001\u00037C\u0011\"!(\u001a\u0003\u0003%)%a(\t\u0013\u0005\u0005\u0016$!A\u0005\u0002\u0006\r\u0006\"CAV3\u0005\u0005I\u0011QAW\u0011%\tY,GA\u0001\n\u0013\tiL\u0001\tQCJ\u001cX\rV8US6,7\u000f^1na*\u0011\u0011EI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002$I\u0005A1-\u0019;bYf\u001cHO\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001]I*4\b\u0005\u00020a5\t\u0001%\u0003\u00022A\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00020g%\u0011A\u0007\t\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0004Qe>$Wo\u0019;\u0011\u0005Yb\u0014BA\u001f8\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003\u0001\u0003\"aL!\n\u0005\t\u0003#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u00051am\u001c:nCR,\u0012A\u0012\t\u0004m\u001d\u0003\u0015B\u0001%8\u0005\u0019y\u0005\u000f^5p]\u00069am\u001c:nCR\u0004\u0013!B2iS2$\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001d>\u0003\u0016\u000b\u0005\u00020\u0001!)ah\u0002a\u0001\u0001\")Ai\u0002a\u0001\r\")!j\u0002a\u0001\u0001R\u0019aj\u0015+\t\u000byB\u0001\u0019\u0001!\t\u000b\u0011C\u0001\u0019\u0001!\u0015\u000593\u0006\"\u0002 \n\u0001\u0004\u0001\u0015!\u00044mCR\f%oZ;nK:$8/F\u0001Z!\rQ&-\u001a\b\u00037\u0002t!\u0001X0\u000e\u0003uS!A\u0018\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014BA18\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00193\u0003\u0011%#XM]1u_JT!!Y\u001c\u0011\u0005Y2\u0017BA48\u0005\r\te._\u000b\u0002SB\u0011!N\u001c\b\u0003W2\u0004\"\u0001X\u001c\n\u00055<\u0014A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\\\u001c\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u0005eCR\fG+\u001f9f+\u0005!\bCA;y\u001b\u00051(BA<%\u0003\u0015!\u0018\u0010]3t\u0013\tIhO\u0001\u0005ECR\fG+\u001f9f\u0003\u0011\u0019w\u000e]=\u0015\t9cXP \u0005\b}9\u0001\n\u00111\u0001A\u0011\u001d!e\u0002%AA\u0002\u0019CqA\u0013\b\u0011\u0002\u0003\u0007\u0001)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r!f\u0001!\u0002\u0006-\u0012\u0011q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0012]\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)\"a\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m!f\u0001$\u0002\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001\u00027b]\u001eT!!!\f\u0002\t)\fg/Y\u0005\u0004_\u0006\u001d\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u001b!\r1\u0014qG\u0005\u0004\u0003s9$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA3\u0002@!I\u0011\u0011\t\u000b\u0002\u0002\u0003\u0007\u0011QG\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0003#BA%\u0003\u001f*WBAA&\u0015\r\tieN\u0001\u000bG>dG.Z2uS>t\u0017bA2\u0002L\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002V\u0005m\u0003c\u0001\u001c\u0002X%\u0019\u0011\u0011L\u001c\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\t\f\u0002\u0002\u0003\u0007Q-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003+\n\t\u0007\u0003\u0005\u0002B]\t\t\u00111\u0001fQ]\u0001\u0011QMA6\u0003[\n\t(a\u001d\u0002x\u0005e\u0014QPA@\u0003\u0007\u000b)\tE\u00020\u0003OJ1!!\u001b!\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u001c\u0002\u0003CT\u0001\u0005\t\u0011!?\u001a+fjQ0)i&lWm\u001d;b[B|6\u000f\u001e:\\Y\u00012W\u000e^/*A5\u0002\u0003+\u0019:tKN\u0004C\u000f[3!ARLW.Z:uC6\u0004xl\u001d;sA\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011xSRD\u0007\u0005\u001e5fA\u00014W\u000e\u001e1!Kb\u0004(/Z:tS>t'\u0002\t\u0011!A\u0001\u0002Co\u001c\u0011bAQLW.Z:uC6\u0004h\u0006\t*fiV\u0014hn\u001d\u0011ok2d\u0007e^5uQ\u0002JgN^1mS\u0012\u0004\u0013N\u001c9vi:\u0002#)\u001f\u0011eK\u001a\fW\u000f\u001c;-A%$\bEZ8mY><8\u000fI2bgRLgn\u001a\u0011sk2,7\u000f\t;p\u0015\u0001\u0002\u0003\u0005\t\u0011!C\u0002\"\u0018.\\3ti\u0006l\u0007\u000fI5gAQDW\r\t1g[R\u0004\u0007%[:!_6LG\u000f^3e])\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011QO\u0001\u0003>)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003\u0005^5nKN$\u0018-\u001c9`gR\u0014\b%\f\u0011BAM$(/\u001b8hAQ|\u0007EY3!a\u0006\u00148/\u001a3!i>\u0004C/[7fgR\fW\u000e\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0019lG\u000fI\u0017!)&lWm\u001d;b[B\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt\u0007\u0005^8!M>dGn\\</AM+W\r\t\u001fbA!\u0014XMZ\u001f#QR$\bo\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006Z8dg>b\u0017\r^3ti>\u001a\u0018\u000f\\\u0017sK\u001alC-\u0019;fi&lW-\f9biR,'O\u001c\u0018ii6d'E\u0010#bi\u0016$\u0018.\\3!!\u0006$H/\u001a:ogrz\u0013M\u0010\u0011g_J\u0004c/\u00197jI*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0017\r^3!C:$\u0007\u0005^5nK\u00022wN]7bi\u0002\u0002\u0018\r\u001e;fe:\u001chF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA>\u0003\u0005E#\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T&\r\u001a.gE\u0002\u0003\u0007\r\u001e2ei\u0002\u0004gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014GN\u00172e5\u001a\u0014\u0007\t\u00191uE\u0012$\b\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004'\r\u001c.cIj3'M\u0014-A\u001dJ\u00180_=.\u001b6kC\rZ\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001c.cIj3'\r\u00111ai\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAA\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!a\"\u0002\u000bIr#G\f\u0019\u0002!A\u000b'o]3U_RKW.Z:uC6\u0004\bCA\u0018\u001a'\u0011I\u0012qR\u001e\u0011\u0011\u0005E\u0015q\u0013!G\u0001:k!!a%\u000b\u0007\u0005Uu'A\u0004sk:$\u0018.\\3\n\t\u0005e\u00151\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAAF\u0003!!xn\u0015;sS:<GCAA\u0012\u0003\u0015\t\u0007\u000f\u001d7z)\u001dq\u0015QUAT\u0003SCQA\u0010\u000fA\u0002\u0001CQ\u0001\u0012\u000fA\u0002\u0019CQA\u0013\u000fA\u0002\u0001\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u00020\u0006]\u0006\u0003\u0002\u001cH\u0003c\u0003bANAZ\u0001\u001a\u0003\u0015bAA[o\t1A+\u001e9mKNB\u0001\"!/\u001e\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a0\u0011\t\u0005\u0015\u0012\u0011Y\u0005\u0005\u0003\u0007\f9C\u0001\u0004PE*,7\r\u001e")
public class ParseToTimestamp
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToTimestamp parseToTimestamp) {
        return ParseToTimestamp$.MODULE$.unapply(parseToTimestamp);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToTimestamp> tupled() {
        return ParseToTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToTimestamp>>> curried() {
        return ParseToTimestamp$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return RuntimeReplaceable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public String sql() {
        return this.format().isDefined() ? new StringBuilder(4).append(this.prettyName()).append("(").append(this.left().sql()).append(", ").append(((Expression)this.format().get()).sql()).append(")").toString() : new StringBuilder(2).append(this.prettyName()).append("(").append(this.left().sql()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "to_timestamp";
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    public ParseToTimestamp copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToTimestamp(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestamp parseToTimestamp = (ParseToTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestamp.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToTimestamp.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToTimestamp.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestamp(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToTimestamp(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new GetTimestamp(left, format, GetTimestamp$.MODULE$.apply$default$3()));
    }

    public ParseToTimestamp(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }
}

