/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryMathExpression;
import org.apache.spark.sql.catalyst.expressions.EulerNumber;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Logarithm$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(base, expr) - Returns the logarithm of `expr` with `base`.", examples="\n    Examples:\n      > SELECT _FUNC_(10, 100);\n       2.0\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0012)A\u0005q!AA\b\u0001BK\u0002\u0013\u0005q\u0007\u0003\u0005>\u0001\tE\t\u0015!\u00039\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015q\u0004\u0001\"\u0001D\u0011\u00151\u0005\u0001\"\u0011H\u0011\u0015Y\u0005\u0001\"\u0015M\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u001d\u0019\u0007!!A\u0005\u0002\u0011Dqa\u001a\u0001\u0012\u0002\u0013\u0005\u0001\u000eC\u0004t\u0001E\u0005I\u0011\u00015\t\u000fQ\u0004\u0011\u0011!C!k\"9a\u0010AA\u0001\n\u0003y\b\"CA\u0004\u0001\u0005\u0005I\u0011AA\u0005\u0011%\ty\u0001AA\u0001\n\u0003\n\t\u0002C\u0005\u0002 \u0001\t\t\u0011\"\u0001\u0002\"!I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0013qE\u0004\n\u0003\u007fY\u0012\u0011!E\u0001\u0003\u00032\u0001BG\u000e\u0002\u0002#\u0005\u00111\t\u0005\u0007}Q!\t!!\u0015\t\u0013\u0005MC#!A\u0005F\u0005U\u0003\"CA,)\u0005\u0005I\u0011QA-\u0011%\ty\u0006FA\u0001\n\u0003\u000b\t\u0007C\u0005\u0002tQ\t\t\u0011\"\u0003\u0002v\tIAj\\4be&$\b.\u001c\u0006\u00039u\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011adH\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001%I\u0001\u0004gFd'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M!\u0001!K\u00174!\tQ3&D\u0001\u001c\u0013\ta3D\u0001\u000bCS:\f'/_'bi\",\u0005\u0010\u001d:fgNLwN\u001c\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\b!J|G-^2u!\tqC'\u0003\u00026_\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005A\u0004C\u0001\u0016:\u0013\tQ4D\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002A\u0003\n\u0003\"A\u000b\u0001\t\u000bY*\u0001\u0019\u0001\u001d\t\u000bq*\u0001\u0019\u0001\u001d\u0015\u0005\u0001#\u0005\"B#\u0007\u0001\u0004A\u0014!B2iS2$\u0017\u0001\u00038vY2\f'\r\\3\u0016\u0003!\u0003\"AL%\n\u0005){#a\u0002\"p_2,\u0017M\\\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004\u001bB\u0013\u0006C\u0001\u0018O\u0013\tyuFA\u0002B]fDQ!\u0015\u0005A\u00025\u000ba!\u001b8qkR\f\u0004\"B*\t\u0001\u0004i\u0015AB5oaV$('A\u0005e_\u001e+gnQ8eKR\u0019a\u000bX1\u0011\u0005]SV\"\u0001-\u000b\u0005e[\u0012aB2pI\u0016<WM\\\u0005\u00037b\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006;&\u0001\rAX\u0001\u0004GRD\bCA,`\u0013\t\u0001\u0007L\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000b\tL\u0001\u0019\u0001,\u0002\u0005\u00154\u0018\u0001B2paf$2\u0001Q3g\u0011\u001d1$\u0002%AA\u0002aBq\u0001\u0010\u0006\u0011\u0002\u0003\u0007\u0001(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003%T#\u0001\u000f6,\u0003-\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\u0013Ut7\r[3dW\u0016$'B\u000190\u0003)\tgN\\8uCRLwN\\\u0005\u0003e6\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001<\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018\u0001\u00027b]\u001eT\u0011a_\u0001\u0005U\u00064\u0018-\u0003\u0002~q\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0001\u0011\u00079\n\u0019!C\u0002\u0002\u0006=\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!TA\u0006\u0011%\tiaDA\u0001\u0002\u0004\t\t!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003'\u0001R!!\u0006\u0002\u001c5k!!a\u0006\u000b\u0007\u0005eq&\u0001\u0006d_2dWm\u0019;j_:LA!!\b\u0002\u0018\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rA\u00151\u0005\u0005\t\u0003\u001b\t\u0012\u0011!a\u0001\u001b\u00061Q-];bYN$2\u0001SA\u0015\u0011!\tiAEA\u0001\u0002\u0004i\u0005f\u0003\u0001\u0002.\u0005M\u0012QGA\u001d\u0003w\u00012AKA\u0018\u0013\r\t\td\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9$A!`\rVs5i\u0018\u0015cCN,G\u0006I3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005\\8hCJLG\u000f[7!_\u001a\u0004\u0003-\u001a=qe\u0002\u0004s/\u001b;iA\u0001\u0014\u0017m]3a]\u0005AQ\r_1na2,7/\t\u0002\u0002>\u0005a$\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00191Y\u0001\n\u0004\u0007M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AIr\u0003G\u0003\u0011!\u0003%aunZ1sSRDW\u000e\u0005\u0002+)M!A#!\u00124!\u001d\t9%!\u00149q\u0001k!!!\u0013\u000b\u0007\u0005-s&A\u0004sk:$\u0018.\\3\n\t\u0005=\u0013\u0011\n\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA!\u0003!!xn\u0015;sS:<G#\u0001<\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0001\u000bY&!\u0018\t\u000bY:\u0002\u0019\u0001\u001d\t\u000bq:\u0002\u0019\u0001\u001d\u0002\u000fUt\u0017\r\u001d9msR!\u00111MA8!\u0015q\u0013QMA5\u0013\r\t9g\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b9\nY\u0007\u000f\u001d\n\u0007\u00055tF\u0001\u0004UkBdWM\r\u0005\t\u0003cB\u0012\u0011!a\u0001\u0001\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003o\u00022a^A=\u0013\r\tY\b\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class Logarithm
extends BinaryMathExpression {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Logarithm logarithm) {
        return Logarithm$.MODULE$.unapply(logarithm);
    }

    public static Function1<Tuple2<Expression, Expression>, Logarithm> tupled() {
        return Logarithm$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Logarithm>> curried() {
        return Logarithm$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        double dLeft = BoxesRunTime.unboxToDouble((Object)input1);
        double dRight = BoxesRunTime.unboxToDouble((Object)input2);
        return dLeft <= 0.0 || dRight <= 0.0 ? null : BoxesRunTime.boxToDouble((double)(StrictMath.log(dRight) / StrictMath.log(dLeft)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.left() instanceof EulerNumber ? this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(c1, c2) -> new StringBuilder(129).append("\n          if (").append((String)c2).append(" <= 0.0) {\n            ").append(ev.isNull()).append(" = true;\n          } else {\n            ").append(ev.value()).append(" = java.lang.StrictMath.log(").append((String)c2).append(");\n          }\n        ").toString()) : this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(c1, c2) -> new StringBuilder(169).append("\n          if (").append((String)c1).append(" <= 0.0 || ").append((String)c2).append(" <= 0.0) {\n            ").append(ev.isNull()).append(" = true;\n          } else {\n            ").append(ev.value()).append(" = java.lang.StrictMath.log(").append((String)c2).append(") / java.lang.StrictMath.log(").append((String)c1).append(");\n          }\n        ").toString());
    }

    public Logarithm copy(Expression left, Expression right) {
        return new Logarithm(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Logarithm";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Logarithm;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Logarithm)) return false;
        boolean bl = true;
        if (!bl) return false;
        Logarithm logarithm = (Logarithm)x$1;
        Expression expression = this.left();
        Expression expression2 = logarithm.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = logarithm.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!logarithm.canEqual(this)) return false;
        return true;
    }

    public Logarithm(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super((Function2<Object, Object, Object>)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double c1, double c2) {
                return this.apply$mcDDD$sp(c1, c2);
            }

            public double apply$mcDDD$sp(double c1, double c2) {
                return StrictMath.log(c2) / StrictMath.log(c1);
            }
        }, "LOG");
    }

    public Logarithm(Expression child) {
        this(new EulerNumber(), child);
    }
}

