/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading space characters from `str`.\n\n    _FUNC_(trimStr, str) - Removes the leading string contains the characters from the trim string\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('Sp', 'SSparkSQLS');\n       arkSQLS\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005mv!\u0002\u0010 \u0011\u0003ac!\u0002\u0018 \u0011\u0003y\u0003\"B\u001d\u0002\t\u0003Q\u0004\"B\u001e\u0002\t\u0003a\u0004BB\u001e\u0002\t\u0003\t\u0019\n\u0003\u0005<\u0003\u0005\u0005I\u0011QAL\u0011%\ti*AI\u0001\n\u0003\t\u0019\u0003C\u0005\u0002 \u0006\t\t\u0011\"!\u0002\"\"I\u0011qV\u0001\u0012\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003c\u000b\u0011\u0011!C\u0005\u0003g3AAL\u0010A}!A\u0001J\u0003BK\u0002\u0013\u0005\u0011\n\u0003\u0005K\u0015\tE\t\u0015!\u0003@\u0011!Y%B!f\u0001\n\u0003a\u0005\u0002\u0003)\u000b\u0005#\u0005\u000b\u0011B'\t\u000beRA\u0011A)\t\u000beRA\u0011\u0001+\t\u000beRA\u0011A,\t\u000beSA\u0011\t.\t\u000b\u0019TA\u0011I4\t\u000bETA\u0011\u000b:\t\u0013\u0005\u0005!\"!A\u0005\u0002\u0005\r\u0001\"CA\u0005\u0015E\u0005I\u0011AA\u0006\u0011%\t\tCCI\u0001\n\u0003\t\u0019\u0003C\u0005\u0002()\t\t\u0011\"\u0011\u0002*!I\u0011\u0011\b\u0006\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007R\u0011\u0011!C\u0001\u0003\u000bB\u0011\"a\u0013\u000b\u0003\u0003%\t%!\u0014\t\u0013\u0005m#\"!A\u0005\u0002\u0005u\u0003\"CA4\u0015\u0005\u0005I\u0011IA5\u00039\u0019FO]5oOR\u0013\u0018.\u001c'fMRT!\u0001I\u0011\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003E\r\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003I\u0015\n1a]9m\u0015\t1s%A\u0003ta\u0006\u00148N\u0003\u0002)S\u00051\u0011\r]1dQ\u0016T\u0011AK\u0001\u0004_J<7\u0001\u0001\t\u0003[\u0005i\u0011a\b\u0002\u000f'R\u0014\u0018N\\4Ue&lG*\u001a4u'\r\t\u0001G\u000e\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E:\u0014B\u0001\u001d3\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\tA&A\u0003baBd\u0017\u0010F\u0003>\u0003\u001b\u000b\t\n\u0005\u0002.\u0015M)!b\u0010\"FmA\u0011Q\u0006Q\u0005\u0003\u0003~\u0011!\"\u0012=qe\u0016\u001c8/[8o!\ti3)\u0003\u0002E?\t)2\u000b\u001e:j]\u001e\u0014DK]5n\u000bb\u0004(/Z:tS>t\u0007CA\u0019G\u0013\t9%GA\u0004Qe>$Wo\u0019;\u0002\rM\u00148m\u0015;s+\u0005y\u0014aB:sGN#(\u000fI\u0001\biJLWn\u0015;s+\u0005i\u0005cA\u0019O\u007f%\u0011qJ\r\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0011Q\u0014\u0018.\\*ue\u0002\"2!\u0010*T\u0011\u0015Au\u00021\u0001@\u0011\u001dYu\u0002%AA\u00025#2!P+W\u0011\u0015Y\u0005\u00031\u0001@\u0011\u0015A\u0005\u00031\u0001@)\ti\u0004\fC\u0003I#\u0001\u0007q(\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012a\u0017\t\u00039\u000et!!X1\u0011\u0005y\u0013T\"A0\u000b\u0005\u0001\\\u0013A\u0002\u001fs_>$h(\u0003\u0002ce\u00051\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u0011''\u0001\u0003fm\u0006dGC\u00015l!\t\t\u0014.\u0003\u0002ke\t\u0019\u0011I\\=\t\u000f1\u001c\u0002\u0013!a\u0001[\u0006)\u0011N\u001c9viB\u0011an\\\u0007\u0002C%\u0011\u0001/\t\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR\u00191/\u001f@\u0011\u0005Q<X\"A;\u000b\u0005Y|\u0012aB2pI\u0016<WM\\\u0005\u0003qV\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006uR\u0001\ra_\u0001\u0004GRD\bC\u0001;}\u0013\tiXO\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000b}$\u0002\u0019A:\u0002\u0005\u00154\u0018\u0001B2paf$R!PA\u0003\u0003\u000fAq\u0001S\u000b\u0011\u0002\u0003\u0007q\bC\u0004L+A\u0005\t\u0019A'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0002\u0016\u0004\u007f\u0005=1FAA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m!'\u0001\u0006b]:|G/\u0019;j_:LA!a\b\u0002\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0005\u0016\u0004\u001b\u0006=\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002,A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012\u0001\u00027b]\u001eT!!!\u000e\u0002\t)\fg/Y\u0005\u0004I\u0006=\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u001f!\r\t\u0014qH\u0005\u0004\u0003\u0003\u0012$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00015\u0002H!I\u0011\u0011\n\u000e\u0002\u0002\u0003\u0007\u0011QH\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0003#BA)\u0003/BWBAA*\u0015\r\t)FM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA-\u0003'\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qLA3!\r\t\u0014\u0011M\u0005\u0004\u0003G\u0012$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u0013b\u0012\u0011!a\u0001Q\u00061Q-];bYN$B!a\u0018\u0002l!A\u0011\u0011J\u000f\u0002\u0002\u0003\u0007\u0001\u000eK\n\u000b\u0003_\n)(a\u001e\u0002|\u0005u\u0014\u0011QAB\u0003\u000f\u000bI\tE\u0002.\u0003cJ1!a\u001d \u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u001f\u0002\u0003+R\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3tAQDW\r\t7fC\u0012Lgn\u001a\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b;sS6\u001cFO\u001d\u0017!gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3tAQDW\r\t7fC\u0012Lgn\u001a\u0011tiJLgn\u001a\u0011d_:$\u0018-\u001b8tAQDW\rI2iCJ\f7\r^3sg\u00022'o\\7!i\",\u0007\u0005\u001e:j[\u0002\u001aHO]5oO*\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011qP\u0001\u0002\u001e)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e\u001d;sA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]*\u0001\u0003\u0005\t\u0011!A)\u0002CO]5n'R\u0014\b%\f\u0011uQ\u0016\u0004CO]5nAM$(/\u001b8hA\rD\u0017M]1di\u0016\u00148\u000f\t;pAQ\u0014\u0018.\u001c\u0017!i\",\u0007\u0005Z3gCVdG\u000f\t<bYV,\u0007%[:!C\u0002\u001a\u0018N\\4mK\u0002\u001a\b/Y2f\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0015\u0015!a\u0003\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0002\u0003\u0005\t\u0011Ta\u0006\u00148nU)MA\u0001\u0002s%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!'B\f'o[*R\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u00159(Y\u0001:3k\u00159be.\u001c\u0016\u000bT*(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013M]6T#2\u001b&\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005-\u0015!B\u0019/k9\u0002\u0004BBAH\u0007\u0001\u0007q(A\u0002tiJDQaS\u0002A\u0002}\"2!PAK\u0011\u0019\ty\t\u0002a\u0001\u007fQ)Q(!'\u0002\u001c\")\u0001*\u0002a\u0001\u007f!91*\u0002I\u0001\u0002\u0004i\u0015aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u00111UAV!\u0011\td*!*\u0011\u000bE\n9kP'\n\u0007\u0005%&G\u0001\u0004UkBdWM\r\u0005\t\u0003[;\u0011\u0011!a\u0001{\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\u0006\u0003BA\u0017\u0003oKA!!/\u00020\t1qJ\u00196fGR\u0004")
public class StringTrimLeft
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimLeft$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimLeft stringTrimLeft) {
        return StringTrimLeft$.MODULE$.unapply(stringTrimLeft);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimLeft$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "ltrim";
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trimLeft((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trimLeft());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimLeft();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimLeftFunction = new StringBuilder(88).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trimLeft(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimLeftFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrimLeft copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimLeft(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimLeft";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimLeft;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimLeft)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimLeft stringTrimLeft = (StringTrimLeft)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimLeft.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimLeft.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimLeft.canEqual(this)) return false;
        return true;
    }

    public StringTrimLeft(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrimLeft(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimLeft(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

