/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(BOTH trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`\n\n    _FUNC_(LEADING trimStr FROM str) - Remove the leading `trimStr` characters from `str`\n\n    _FUNC_(TRAILING trimStr FROM str) - Remove the trailing `trimStr` characters from `str`\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n      * BOTH, FROM - these are keywords to specify trimming string characters from both ends of\n          the string\n      * LEADING, FROM - these are keywords to specify trimming string characters from the left\n          end of the string\n      * TRAILING, FROM - these are keywords to specify trimming string characters from the right\n          end of the string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('SL', 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(BOTH 'SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(LEADING 'SL' FROM 'SSparkSQLS');\n       parkSQLS\n      > SELECT _FUNC_(TRAILING 'SL' FROM 'SSparkSQLS');\n       SSparkSQ\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005mv!\u0002\u0010 \u0011\u0003ac!\u0002\u0018 \u0011\u0003y\u0003\"B\u001d\u0002\t\u0003Q\u0004\"B\u001e\u0002\t\u0003a\u0004BB\u001e\u0002\t\u0003\t\u0019\n\u0003\u0005<\u0003\u0005\u0005I\u0011QAL\u0011%\ti*AI\u0001\n\u0003\t\u0019\u0003C\u0005\u0002 \u0006\t\t\u0011\"!\u0002\"\"I\u0011qV\u0001\u0012\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003c\u000b\u0011\u0011!C\u0005\u0003g3AAL\u0010A}!A\u0001J\u0003BK\u0002\u0013\u0005\u0011\n\u0003\u0005K\u0015\tE\t\u0015!\u0003@\u0011!Y%B!f\u0001\n\u0003a\u0005\u0002\u0003)\u000b\u0005#\u0005\u000b\u0011B'\t\u000beRA\u0011A)\t\u000beRA\u0011\u0001+\t\u000beRA\u0011A,\t\u000beSA\u0011\t.\t\u000b\u0019TA\u0011I4\t\u000bETA\u0011\t:\t\u0013\u0005\u0005!\"!A\u0005\u0002\u0005\r\u0001\"CA\u0005\u0015E\u0005I\u0011AA\u0006\u0011%\t\tCCI\u0001\n\u0003\t\u0019\u0003C\u0005\u0002()\t\t\u0011\"\u0011\u0002*!I\u0011\u0011\b\u0006\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007R\u0011\u0011!C\u0001\u0003\u000bB\u0011\"a\u0013\u000b\u0003\u0003%\t%!\u0014\t\u0013\u0005m#\"!A\u0005\u0002\u0005u\u0003\"CA4\u0015\u0005\u0005I\u0011IA5\u0003)\u0019FO]5oOR\u0013\u0018.\u001c\u0006\u0003A\u0005\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011!eI\u0001\tG\u0006$\u0018\r\\=ti*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001A\u0011Q&A\u0007\u0002?\tQ1\u000b\u001e:j]\u001e$&/[7\u0014\u0007\u0005\u0001d\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VM\u001a\t\u0003c]J!\u0001\u000f\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005a\u0013!B1qa2LH#B\u001f\u0002\u000e\u0006E\u0005CA\u0017\u000b'\u0015QqHQ#7!\ti\u0003)\u0003\u0002B?\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00055\u001a\u0015B\u0001# \u0005U\u0019FO]5oOJ\"&/[7FqB\u0014Xm]:j_:\u0004\"!\r$\n\u0005\u001d\u0013$a\u0002)s_\u0012,8\r^\u0001\u0007gJ\u001c7\u000b\u001e:\u0016\u0003}\nqa\u001d:d'R\u0014\b%A\u0004ue&l7\u000b\u001e:\u0016\u00035\u00032!\r(@\u0013\ty%G\u0001\u0004PaRLwN\\\u0001\tiJLWn\u0015;sAQ\u0019QHU*\t\u000b!{\u0001\u0019A \t\u000f-{\u0001\u0013!a\u0001\u001bR\u0019Q(\u0016,\t\u000b-\u0003\u0002\u0019A \t\u000b!\u0003\u0002\u0019A \u0015\u0005uB\u0006\"\u0002%\u0012\u0001\u0004y\u0014A\u00039sKR$\u0018PT1nKV\t1\f\u0005\u0002]G:\u0011Q,\u0019\t\u0003=Jj\u0011a\u0018\u0006\u0003A.\na\u0001\u0010:p_Rt\u0014B\u000123\u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u0014\u0014\u0001B3wC2$\"\u0001[6\u0011\u0005EJ\u0017B\u000163\u0005\r\te.\u001f\u0005\bYN\u0001\n\u00111\u0001n\u0003\u0015Ig\u000e];u!\tqw.D\u0001\"\u0013\t\u0001\u0018EA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\r\u0019\u0018P \t\u0003i^l\u0011!\u001e\u0006\u0003m~\tqaY8eK\u001e,g.\u0003\u0002yk\nAQ\t\u001f9s\u0007>$W\rC\u0003{)\u0001\u000710A\u0002dib\u0004\"\u0001\u001e?\n\u0005u,(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006\u007fR\u0001\ra]\u0001\u0003KZ\fAaY8qsR)Q(!\u0002\u0002\b!9\u0001*\u0006I\u0001\u0002\u0004y\u0004bB&\u0016!\u0003\u0005\r!T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiAK\u0002@\u0003\u001fY#!!\u0005\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037\u0011\u0014AC1o]>$\u0018\r^5p]&!\u0011qDA\u000b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)CK\u0002N\u0003\u001f\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0016!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\tA\u0001\\1oO*\u0011\u0011QG\u0001\u0005U\u00064\u0018-C\u0002e\u0003_\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0010\u0011\u0007E\ny$C\u0002\u0002BI\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001[A$\u0011%\tIEGA\u0001\u0002\u0004\ti$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u001f\u0002R!!\u0015\u0002X!l!!a\u0015\u000b\u0007\u0005U#'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0017\u0002T\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty&!\u001a\u0011\u0007E\n\t'C\u0002\u0002dI\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002Jq\t\t\u00111\u0001i\u0003\u0019)\u0017/^1mgR!\u0011qLA6\u0011!\tI%HA\u0001\u0002\u0004A\u0007f\u0005\u0006\u0002p\u0005U\u0014qOA>\u0003{\n\t)a!\u0002\b\u0006%\u0005cA\u0017\u0002r%\u0019\u00111O\u0010\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011P\u0001\u0003b*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJL\u0003%\f\u0011SK6|g/Z:!i\",\u0007\u0005\\3bI&tw\rI1oI\u0002\"(/Y5mS:<\u0007e\u001d9bG\u0016\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t1tiJ\u0004gF\u0003\u0006!A\u0001\u0002sLR+O\u0007~C#i\u0014+IAQ\u0014\u0018.\\*ue\u00022%kT'!gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3!i\",\u0007\u0005\\3bI&tw\rI1oI\u0002\"(/Y5mS:<\u0007\u0005\u0019;sS6\u001cFO\u001d1!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\u00027\u000f\u001e:a\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015M\u000b\u0006#\u0015JT$!iJLWn\u0015;sA\u0019\u0013v*\u0014\u0011tiJL\u0003%\f\u0011SK6|g/\u001a\u0011uQ\u0016\u0004C.Z1eS:<\u0007\u0005\u0019;sS6\u001cFO\u001d1!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\u00027\u000f\u001e:a\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015U%\u0006KE*\u0013(HAQ\u0014\u0018.\\*ue\u00022%kT'!gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3!i\",\u0007\u0005\u001e:bS2Lgn\u001a\u0011aiJLWn\u0015;sA\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002T\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!a \u0002\u0007oT\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003\u0005\u001e:j[N#(\u000fI\u0017!i\",\u0007\u0005\u001e:j[\u0002\u001aHO]5oO\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011u_\u0002\"(/[7-AQDW\r\t3fM\u0006,H\u000e\u001e\u0011wC2,X\rI5tA\u0005\u00043/\u001b8hY\u0016\u00043\u000f]1dK*\u0001\u0003\u0005\t\u0011!A)\u0002#i\u0014+IY\u00012%kT'![\u0001\"\b.Z:fA\u0005\u0014X\rI6fs^|'\u000fZ:!i>\u00043\u000f]3dS\u001aL\b\u0005\u001e:j[6Lgn\u001a\u0011tiJLgn\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\t|G\u000f\u001b\u0011f]\u0012\u001c\be\u001c4\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u000f[3!gR\u0014\u0018N\\4\u000bA\u0001\u0002\u0003\u0005\t\u0011+A1+\u0015\tR%O\u000f2\u0002cIU(NA5\u0002C\u000f[3tK\u0002\n'/\u001a\u0011lKf<xN\u001d3tAQ|\u0007e\u001d9fG&4\u0017\u0010\t;sS6l\u0017N\\4!gR\u0014\u0018N\\4!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\"\b.\u001a\u0011mK\u001a$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!K:$\u0007e\u001c4!i\",\u0007e\u001d;sS:<'\u0002\t\u0011!A\u0001\u0002#\u0006\t+S\u0003&c\u0015JT$-A\u0019\u0013v*\u0014\u0011.AQDWm]3!CJ,\u0007e[3zo>\u0014Hm\u001d\u0011u_\u0002\u001a\b/Z2jMf\u0004CO]5n[&tw\rI:ue&tw\rI2iCJ\f7\r^3sg\u00022'o\\7!i\",\u0007E]5hQRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011f]\u0012\u0004sN\u001a\u0011uQ\u0016\u00043\u000f\u001e:j]\u001eT\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QQ\u0001\u0003,*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\t\u0011!AM\u0003\u0018M]6T#2\u0003\u0003\u0005I\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0006/\u0019:l'Fc%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014T\u0019\u001eb\u0003eJ*Ta\u0006\u00148nU)M'\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t9be.\u001c\u0016K\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015C\u001fRC\u0005eJ*MO\u00012%kT'!OM\u001b\u0006/\u0019:l'Fc5kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AA\f'o[*R\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"bU)\u0011#J\u001d\u001e\u0003se\u0015'(A\u0019\u0013v*\u0014\u0011('N\u0003\u0018M]6T#2\u001bv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148nU)M'*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CCKU!J\u0019&su\tI\u0014T\u0019\u001e\u0002cIU(NA\u001d\u001a6\u000b]1sWN\u000bFjU\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a6\u000b]1sWN\u000b&\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005-\u0015!B\u0019/k9\u0002\u0004BBAH\u0007\u0001\u0007q(A\u0002tiJDQaS\u0002A\u0002}\"2!PAK\u0011\u0019\ty\t\u0002a\u0001\u007fQ)Q(!'\u0002\u001c\")\u0001*\u0002a\u0001\u007f!91*\u0002I\u0001\u0002\u0004i\u0015aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u00111UAV!\u0011\td*!*\u0011\u000bE\n9kP'\n\u0007\u0005%&G\u0001\u0004UkBdWM\r\u0005\t\u0003[;\u0011\u0011!a\u0001{\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\u0006\u0003BA\u0017\u0003oKA!!/\u00020\t1qJ\u00196fGR\u0004")
public class StringTrim
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrim$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrim stringTrim) {
        return StringTrim$.MODULE$.unapply(stringTrim);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrim$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "trim";
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trim((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trim());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trim();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimFunction = new StringBuilder(84).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trim(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrim copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrim(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrim";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrim)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrim stringTrim = (StringTrim)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrim.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrim.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrim.canEqual(this)) return false;
        return true;
    }

    public StringTrim(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrim(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrim(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

