/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ExpressionDescription(usage="_FUNC_(unix_time, format) - Returns `unix_time` in the specified `format`.", arguments="\n    Arguments:\n      * unix_time - UNIX Timestamp to be converted to the provided format.\n      * format - Date/time format pattern to follow. See `java.text.SimpleDateFormat`\n                 for valid date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 'yyyy-MM-dd HH:mm:ss');\n       1970-01-01 00:00:00\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\rc\u0001\u0002\u0015*\u0001ZB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u00051\n\u0003\u0005R\u0001\tE\t\u0015!\u0003M\u0011!\u0011\u0006A!f\u0001\n\u0003\u0019\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u000b\r\u0004A\u0011\u00013\t\u000b\r\u0004A\u0011A5\t\u000b1\u0004A\u0011I&\t\u000b5\u0004A\u0011I&\t\u000b9\u0004A\u0011I8\t\u000b\r\u0004A\u0011\u00019\t\u000bM\u0004A\u0011\t;\t\u000bm\u0004A\u0011\t?\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011Q\u0004\u0001\u0005B\u0005}\u0001BCA\u0012\u0001!\u0015\r\u0011\"\u0003\u0002&!Q\u0011Q\u0007\u0001\t\u0006\u0004%I!a\u000e\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\t9\tAI\u0001\n\u0003\tI\tC\u0005\u0002 \u0002\t\n\u0011\"\u0001\u0002\n\"I\u0011\u0011\u0015\u0001\u0012\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003O\u0003\u0011\u0011!C!\u0003SC\u0011\"!.\u0001\u0003\u0003%\t!a.\t\u0013\u0005}\u0006!!A\u0005\u0002\u0005\u0005\u0007\"CAd\u0001\u0005\u0005I\u0011IAe\u0011%\t9\u000eAA\u0001\n\u0003\tI\u000eC\u0005\u0002^\u0002\t\t\u0011\"\u0011\u0002`\u001eI!1A\u0015\u0002\u0002#\u0005!Q\u0001\u0004\tQ%\n\t\u0011#\u0001\u0003\b!11\r\tC\u0001\u0005+A\u0011Ba\u0006!\u0003\u0003%)E!\u0007\t\u0013\tm\u0001%!A\u0005\u0002\nu\u0001\"\u0003B\u0013AE\u0005I\u0011AAR\u0011%\u00119\u0003IA\u0001\n\u0003\u0013I\u0003C\u0005\u00038\u0001\n\n\u0011\"\u0001\u0002$\"I!\u0011\b\u0011\u0002\u0002\u0013%!1\b\u0002\r\rJ|W.\u00168jqRKW.\u001a\u0006\u0003U-\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A&L\u0001\tG\u0006$\u0018\r\\=ti*\u0011afL\u0001\u0004gFd'B\u0001\u00192\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0004\u0001M1\u0001aN\u001e?\u0003\u001e\u0003\"\u0001O\u001d\u000e\u0003%J!AO\u0015\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001d=\u0013\ti\u0014FA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011\u0001hP\u0005\u0003\u0001&\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\b!J|G-^2u!\t\u0011\u0005*\u0003\u0002J\u0007\na1+\u001a:jC2L'0\u00192mK\u0006\u00191/Z2\u0016\u00031\u0003\"\u0001O'\n\u00059K#AC#yaJ,7o]5p]\u0006!1/Z2!\u0003\u00191wN]7bi\u00069am\u001c:nCR\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\tA\u000bE\u0002C+^K!AV\"\u0003\r=\u0003H/[8o!\tAvL\u0004\u0002Z;B\u0011!lQ\u0007\u00027*\u0011A,N\u0001\u0007yI|w\u000e\u001e \n\u0005y\u001b\u0015A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!AX\"\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u00154w\r\u001b\t\u0003q\u0001AQAS\u0004A\u00021CQ\u0001U\u0004A\u00021CqAU\u0004\u0011\u0002\u0003\u0007A\u000bF\u0002fU.DQA\u0013\u0005A\u00021CQ\u0001\u0015\u0005A\u00021\u000bA\u0001\\3gi\u0006)!/[4ii\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003]#\"!Z9\t\u000bId\u0001\u0019\u0001'\u0002\tUt\u0017\u000e_\u0001\tI\u0006$\u0018\rV=qKV\tQ\u000f\u0005\u0002ws6\tqO\u0003\u0002y[\u0005)A/\u001f9fg&\u0011!p\u001e\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-F\u0001~!\t\u0011e0\u0003\u0002\u0000\u0007\n9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\u0011\u0011Q\u0001\t\u0007\u0003\u000f\t\t\"a\u0006\u000f\t\u0005%\u0011Q\u0002\b\u00045\u0006-\u0011\"\u0001#\n\u0007\u0005=1)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0011Q\u0003\u0002\u0004'\u0016\f(bAA\b\u0007B\u0019a/!\u0007\n\u0007\u0005mqO\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006aq/\u001b;i)&lWMW8oKR\u00191(!\t\t\u000bI\u0003\u0002\u0019A,\u0002\u0017\r|gn\u001d;G_Jl\u0017\r^\u000b\u0003\u0003O\u0001B!!\u000b\u000225\u0011\u00111\u0006\u0006\u0004q\u00065\"bAA\u0018_\u00051QO\\:bM\u0016LA!a\r\u0002,\tQQ\u000b\u0016$9'R\u0014\u0018N\\4\u0002\u0013\u0019|'/\\1ui\u0016\u0014XCAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nA\u0001^3yi*\u0011\u00111I\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002H\u0005u\"A\u0003#bi\u00164uN]7bi\u0006!QM^1m)\u0011\ti%a\u0015\u0011\u0007\t\u000by%C\u0002\u0002R\r\u00131!\u00118z\u0011%\t)f\u0005I\u0001\u0002\u0004\t9&A\u0003j]B,H\u000f\u0005\u0003\u0002Z\u0005mS\"A\u0016\n\u0007\u0005u3FA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\u0019'a\u001c\u0002zA!\u0011QMA6\u001b\t\t9GC\u0002\u0002j%\nqaY8eK\u001e,g.\u0003\u0003\u0002n\u0005\u001d$\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005ED\u00031\u0001\u0002t\u0005\u00191\r\u001e=\u0011\t\u0005\u0015\u0014QO\u0005\u0005\u0003o\n9G\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005mD\u00031\u0001\u0002d\u0005\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0004f\u0003\u0003\u000b\u0019)!\"\t\u000f)+\u0002\u0013!a\u0001\u0019\"9\u0001+\u0006I\u0001\u0002\u0004a\u0005b\u0002*\u0016!\u0003\u0005\r\u0001V\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYIK\u0002M\u0003\u001b[#!a$\u0011\t\u0005E\u00151T\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033\u001b\u0015AC1o]>$\u0018\r^5p]&!\u0011QTAJ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!*+\u0007Q\u000bi)A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003W\u0003B!!,\u000246\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\t%\u0001\u0003mC:<\u0017b\u00011\u00020\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0018\t\u0004\u0005\u0006m\u0016bAA_\u0007\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QJAb\u0011%\t)mGA\u0001\u0002\u0004\tI,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0017\u0004b!!4\u0002T\u00065SBAAh\u0015\r\t\tnQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAk\u0003\u001f\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019Q0a7\t\u0013\u0005\u0015W$!AA\u0002\u00055\u0013AB3rk\u0006d7\u000fF\u0002~\u0003CD\u0011\"!2\u001f\u0003\u0003\u0005\r!!\u0014)'\u0001\t)/a;\u0002n\u0006E\u00181_A|\u0003s\fi0a@\u0011\u0007a\n9/C\u0002\u0002j&\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002p\u0006QuLR+O\u0007~CSO\\5y?RLW.\u001a\u0017!M>\u0014X.\u0019;*A5\u0002#+\u001a;ve:\u001c\b\u0005Y;oSb|F/[7fA\u0002Jg\u000e\t;iK\u0002\u001a\b/Z2jM&,G\r\t1g_Jl\u0017\r\u001e1/\u0003%\t'oZ;nK:$8/\t\u0002\u0002v\u0006\tYN\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!k:L\u0007p\u0018;j[\u0016\u0004S\u0006I+O\u0013b\u0003C+[7fgR\fW\u000e\u001d\u0011u_\u0002\u0012W\rI2p]Z,'\u000f^3eAQ|\u0007\u0005\u001e5fAA\u0014xN^5eK\u0012\u0004cm\u001c:nCRt#\u0002\t\u0011!A\u0001\u0002#\u0006\t4pe6\fG\u000fI\u0017!\t\u0006$Xm\f;j[\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt\u0007\u0005^8!M>dGn\\</AM+W\r\t1kCZ\fg\u0006^3yi:\u001a\u0016.\u001c9mK\u0012\u000bG/\u001a$pe6\fG\u000f\u0019\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012wN\u001d\u0011wC2LG\r\t3bi\u0016\u0004\u0013M\u001c3!i&lW\r\t4pe6\fG\u000f\t9biR,'O\\:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005m\u0018!\u0018\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)a1\u0002s%_=zs6jU*\f3eA!C%(\\7;gN<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112s]\u0002T\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011\t!A\u00032]Ur\u0003'\u0001\u0007Ge>lWK\\5y)&lW\r\u0005\u00029AM!\u0001E!\u0003H!!\u0011YA!\u0005M\u0019R+WB\u0001B\u0007\u0015\r\u0011yaQ\u0001\beVtG/[7f\u0013\u0011\u0011\u0019B!\u0004\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003\u0006\u0005AAo\\*ue&tw\r\u0006\u0002\u0002,\u0006)\u0011\r\u001d9msR9QMa\b\u0003\"\t\r\u0002\"\u0002&$\u0001\u0004a\u0005\"\u0002)$\u0001\u0004a\u0005b\u0002*$!\u0003\u0005\r\u0001V\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003\u0002B\u0016\u0005g\u0001BAQ+\u0003.A1!Ia\fM\u0019RK1A!\rD\u0005\u0019!V\u000f\u001d7fg!A!QG\u0013\u0002\u0002\u0003\u0007Q-A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0010\u0011\t\u00055&qH\u0005\u0005\u0005\u0003\nyK\u0001\u0004PE*,7\r\u001e")
public class FromUnixTime
extends BinaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private UTF8String constFormat;
    private DateFormat formatter;
    private final Expression sec;
    private final Expression format;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return FromUnixTime$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(FromUnixTime fromUnixTime) {
        return FromUnixTime$.MODULE$.unapply(fromUnixTime);
    }

    public static Option<String> apply$default$3() {
        return FromUnixTime$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, FromUnixTime> tupled() {
        return FromUnixTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, FromUnixTime>>> curried() {
        return FromUnixTime$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return !this.bitmap$trans$0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public Expression sec() {
        return this.sec;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.sec();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public String prettyName() {
        return "from_unixtime";
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{LongType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    private UTF8String constFormat$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Expression qual$1 = this.right();
                InternalRow x$1 = qual$1.eval$default$1();
                this.constFormat = (UTF8String)qual$1.eval(x$1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.constFormat;
    }

    private UTF8String constFormat() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.constFormat$lzycompute() : this.constFormat;
    }

    private DateFormat formatter$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.formatter = this.liftedTree2$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.formatter;
    }

    private DateFormat formatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.formatter$lzycompute() : this.formatter;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String uTF8String;
        Object time = this.left().eval(input);
        if (time == null) {
            uTF8String = null;
        } else if (this.format().foldable()) {
            if (this.constFormat() == null || this.formatter() == null) {
                uTF8String = null;
            } else {
                try {
                    uTF8String = UTF8String.fromString((String)this.formatter().format(new Date(BoxesRunTime.unboxToLong((Object)time) * 1000L)));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Object var3_6 = null;
                    uTF8String = var3_6;
                }
            }
        } else {
            Object f = this.format().eval(input);
            if (f == null) {
                uTF8String = null;
            } else {
                try {
                    uTF8String = UTF8String.fromString((String)DateTimeUtils$.MODULE$.newDateFormat(f.toString(), this.timeZone()).format(new Date(BoxesRunTime.unboxToLong((Object)time) * 1000L)));
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable3);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Object var2_11 = null;
                    uTF8String = var2_11;
                }
            }
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String df = DateFormat.class.getName();
        if (this.format().foldable()) {
            if (this.formatter() == null) {
                exprCode = ExprCode$.MODULE$.forNullValue(StringType$.MODULE$);
            } else {
                String formatterName = ctx.addReferenceObj("formatter", this.formatter(), df);
                ExprCode t = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            try {\n              ", " = UTF8String.fromString(", ".format(\n                new java.util.Date(", " * 1000L)));\n            } catch (java.lang.IllegalArgumentException e) {\n              ", " = true;\n            }\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.code(), ev.isNull(), t.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), formatterName, t.value(), ev.isNull()})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
            String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(seconds, f) -> new StringBuilder(217).append("\n        try {\n          ").append(ev.value()).append(" = UTF8String.fromString(").append(dtu).append(".newDateFormat(").append((String)f).append(".toString(), ").append(tz).append(").format(\n            new java.util.Date(").append((String)seconds).append(" * 1000L)));\n        } catch (java.lang.IllegalArgumentException e) {\n          ").append(ev.isNull()).append(" = true;\n        }").toString());
        }
        return exprCode;
    }

    public FromUnixTime copy(Expression sec, Expression format, Option<String> timeZoneId) {
        return new FromUnixTime(sec, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.sec();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "FromUnixTime";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.sec();
                break;
            }
            case 1: {
                option = this.format();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromUnixTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromUnixTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromUnixTime fromUnixTime = (FromUnixTime)x$1;
        Expression expression = this.sec();
        Expression expression2 = fromUnixTime.sec();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = fromUnixTime.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = fromUnixTime.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!fromUnixTime.canEqual(this)) return false;
        return true;
    }

    private final DateFormat liftedTree2$1() {
        DateFormat dateFormat;
        try {
            dateFormat = DateTimeUtils$.MODULE$.newDateFormat(this.constFormat().toString(), this.timeZone());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var1_4 = null;
            dateFormat = var1_4;
        }
        return dateFormat;
    }

    public FromUnixTime(Expression sec, Expression format, Option<String> timeZoneId) {
        this.sec = sec;
        this.format = format;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public FromUnixTime(Expression sec, Expression format) {
        this(sec, format, (Option<String>)None$.MODULE$);
    }

    public FromUnixTime(Expression unix) {
        this(unix, Literal$.MODULE$.apply("yyyy-MM-dd HH:mm:ss"));
    }
}

