/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ToUTCTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, timezone) - Given a timestamp like '2017-07-14 02:40:00.0', interprets it as a time in the given time zone, and renders that time as a timestamp in UTC. For example, 'GMT+1' would yield '2017-07-14 01:40:00.0'.", examples="\n    Examples:\n      > SELECT _FUNC_('2016-08-31', 'Asia/Seoul');\n       2016-08-30 15:00:00\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u000e\u001d\u0001&B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!A\u0001\t\u0001BK\u0002\u0013\u00051\b\u0003\u0005B\u0001\tE\t\u0015!\u0003=\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015\u0019\b\u0001\"\u0011u\u0011%\t)\u0001AA\u0001\n\u0003\t9\u0001C\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003O\u0001\u0011\u0011!C!\u0003SA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA&\u0001\u0005\u0005I\u0011IA'\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j\u001dI\u0011q\u0011\u000f\u0002\u0002#\u0005\u0011\u0011\u0012\u0004\t7q\t\t\u0011#\u0001\u0002\f\"1!)\u0006C\u0001\u00033C\u0011\"a'\u0016\u0003\u0003%)%!(\t\u0013\u0005}U#!A\u0005\u0002\u0006\u0005\u0006\"CAT+\u0005\u0005I\u0011QAU\u0011%\tY,FA\u0001\n\u0013\tiL\u0001\bU_V#6\tV5nKN$\u0018-\u001c9\u000b\u0005uq\u0012aC3yaJ,7o]5p]NT!a\b\u0011\u0002\u0011\r\fG/\u00197zgRT!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u0016/c]\u0002\"a\u000b\u0017\u000e\u0003qI!!\f\u000f\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00160\u0013\t\u0001DD\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\r\u001d\n\u0005e\u001a$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012\u0001\u0010\t\u0003WuJ!A\u0010\u000f\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0011+e\t\u0005\u0002,\u0001!)!(\u0002a\u0001y!)\u0001)\u0002a\u0001y\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0003%\u00032A\u0013*V\u001d\tY\u0005K\u0004\u0002M\u001f6\tQJ\u0003\u0002OQ\u00051AH]8pizJ\u0011\u0001N\u0005\u0003#N\nq\u0001]1dW\u0006<W-\u0003\u0002T)\n\u00191+Z9\u000b\u0005E\u001b\u0004C\u0001,Z\u001b\u00059&B\u0001-!\u0003\u0015!\u0018\u0010]3t\u0013\tQvK\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001^!\t1f,\u0003\u0002`/\nAA)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u0019\t\u0003G\u001et!\u0001Z3\u0011\u00051\u001b\u0014B\u000144\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\u001c\u0014\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGc\u00017pcB\u0011!'\\\u0005\u0003]N\u00121!\u00118z\u0011\u0015\u0001\u0018\u00021\u0001m\u0003\u0011!\u0018.\\3\t\u000bIL\u0001\u0019\u00017\u0002\u0011QLW.\u001a>p]\u0016\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\tU\\\u0018\u0011\u0001\t\u0003mfl\u0011a\u001e\u0006\u0003qr\tqaY8eK\u001e,g.\u0003\u0002{o\nAQ\t\u001f9s\u0007>$W\rC\u0003}\u0015\u0001\u0007Q0A\u0002dib\u0004\"A\u001e@\n\u0005}<(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u0007Q\u0001\u0019A;\u0002\u0005\u00154\u0018\u0001B2paf$R\u0001RA\u0005\u0003\u0017AqAO\u0006\u0011\u0002\u0003\u0007A\bC\u0004A\u0017A\u0005\t\u0019\u0001\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0003\u0016\u0004y\u0005M1FAA\u000b!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}1'\u0001\u0006b]:|G/\u0019;j_:LA!a\t\u0002\u001a\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u000b\u0011\t\u00055\u0012qG\u0007\u0003\u0003_QA!!\r\u00024\u0005!A.\u00198h\u0015\t\t)$\u0001\u0003kCZ\f\u0017b\u00015\u00020\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\b\t\u0004e\u0005}\u0012bAA!g\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019A.a\u0012\t\u0013\u0005%\u0003#!AA\u0002\u0005u\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002PA)\u0011\u0011KA,Y6\u0011\u00111\u000b\u0006\u0004\u0003+\u001a\u0014AC2pY2,7\r^5p]&!\u0011\u0011LA*\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0013Q\r\t\u0004e\u0005\u0005\u0014bAA2g\t9!i\\8mK\u0006t\u0007\u0002CA%%\u0005\u0005\t\u0019\u00017\u0002\r\u0015\fX/\u00197t)\u0011\ty&a\u001b\t\u0011\u0005%3#!AA\u00021Ds\u0002AA8\u0003k\n9(a\u001f\u0002~\u0005\u0005\u00151\u0011\t\u0004W\u0005E\u0014bAA:9\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA=\u0003\u0005%wLR+O\u0007~CC/[7fgR\fW\u000e\u001d\u0017!i&lWM_8oK&\u0002S\u0006I$jm\u0016t\u0007%\u0019\u0011uS6,7\u000f^1na\u0002b\u0017n[3!OI\u0002\u0014gN\u00171o5\nD\u0007\t\u00193uQ\u0002$\b\r\u0019/a\u001db\u0003%\u001b8uKJ\u0004(/\u001a;tA%$\b%Y:!C\u0002\"\u0018.\\3!S:\u0004C\u000f[3!O&4XM\u001c\u0011uS6,\u0007E_8oK2\u0002\u0013M\u001c3!e\u0016tG-\u001a:tAQD\u0017\r\u001e\u0011uS6,\u0007%Y:!C\u0002\"\u0018.\\3ti\u0006l\u0007\u000fI5oAU#6I\f\u0011G_J\u0004S\r_1na2,G\u0006I\u0014H\u001bR[\u0013g\n\u0011x_VdG\rI=jK2$\u0007e\n\u001a1c]j\u0003gN\u00172i\u0001\u0002\u0014G\u000f\u001b1uA\u0002d\u0006M\u0014/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA@\u0003}S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0003\u0007O\u00174c\u001db\u0003eJ!tS\u0006|3+Z8vY\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYj\u0003\u0007O\u00174a\u0001\nTG\u000f\u00191uA\u0002$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0015\u0015!B\u0019/k9\u0002\u0014A\u0004+p+R\u001bE+[7fgR\fW\u000e\u001d\t\u0003WU\u0019B!FAGoA9\u0011qRAKyq\"UBAAI\u0015\r\t\u0019jM\u0001\beVtG/[7f\u0013\u0011\t9*!%\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002\n\u0006AAo\\*ue&tw\r\u0006\u0002\u0002,\u0005)\u0011\r\u001d9msR)A)a)\u0002&\")!\b\u0007a\u0001y!)\u0001\t\u0007a\u0001y\u00059QO\\1qa2LH\u0003BAV\u0003o\u0003RAMAW\u0003cK1!a,4\u0005\u0019y\u0005\u000f^5p]B)!'a-=y%\u0019\u0011QW\u001a\u0003\rQ+\b\u000f\\33\u0011!\tI,GA\u0001\u0002\u0004!\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\f\u0005\u0003\u0002.\u0005\u0005\u0017\u0002BAb\u0003_\u0011aa\u00142kK\u000e$\b")
public class ToUTCTimestamp
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(ToUTCTimestamp toUTCTimestamp) {
        return ToUTCTimestamp$.MODULE$.unapply(toUTCTimestamp);
    }

    public static Function1<Tuple2<Expression, Expression>, ToUTCTimestamp> tupled() {
        return ToUTCTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ToUTCTimestamp>> curried() {
        return ToUTCTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "to_utc_timestamp";
    }

    @Override
    public Object nullSafeEval(Object time, Object timezone) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.toUTCTime(BoxesRunTime.unboxToLong((Object)time), ((UTF8String)timezone).toString()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        if (this.right().foldable()) {
            UTF8String tz = (UTF8String)this.right().eval(this.right().eval$default$1());
            if (tz == null) {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |long ", " = 0;\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String tzClass = TimeZone.class.getName();
                String dtu2 = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
                String escapedTz = StringEscapeUtils.escapeJava((String)tz.toString());
                String tzTerm = ctx.addMutableState(tzClass, "tz", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(20).append((String)v).append(" = ").append(dtu2).append(".getTimeZone(\"").append(escapedTz).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String utcTerm = "tzUTC";
                ctx.addImmutableStateIfNotExists(tzClass, utcTerm, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(23).append((String)v).append(" = ").append(dtu2).append(".getTimeZone(\"UTC\");").toString());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |boolean ", " = ", ";\n           |long ", " = 0;\n           |if (!", ") {\n           |  ", " = ", ".convertTz(", ", ", ", ", ");\n           |}\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), ev.value(), ev.isNull(), ev.value(), dtu2, eval.value(), tzTerm, utcTerm})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, format) -> new StringBuilder(25).append(dtu).append(".toUTCTime(").append((String)timestamp).append(", ").append((String)format).append(".toString())").toString());
        }
        return exprCode;
    }

    public ToUTCTimestamp copy(Expression left, Expression right) {
        return new ToUTCTimestamp(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ToUTCTimestamp";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToUTCTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToUTCTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToUTCTimestamp toUTCTimestamp = (ToUTCTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = toUTCTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = toUTCTimestamp.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!toUTCTimestamp.canEqual(this)) return false;
        return true;
    }

    public ToUTCTimestamp(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

