/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FindInSet$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, str_array) - Returns the index (1-based) of the given string (`str`) in the comma-delimited list (`str_array`).\n      Returns 0, if the string was not found or if the given string (`str`) contains a comma.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ab','abc,b,ab,c,def');\n       3\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u000e\u001d\u0001&B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!A\u0001\t\u0001BK\u0002\u0013\u00051\b\u0003\u0005B\u0001\tE\t\u0015!\u0003=\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015Y\u0006\u0001\"\u0015]\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u0015A\b\u0001\"\u0011z\u0011%\t)\u0001AA\u0001\n\u0003\t9\u0001C\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003O\u0001\u0011\u0011!C!\u0003SA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA&\u0001\u0005\u0005I\u0011IA'\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j\u001dI\u0011q\u0011\u000f\u0002\u0002#\u0005\u0011\u0011\u0012\u0004\t7q\t\t\u0011#\u0001\u0002\f\"1!)\u0006C\u0001\u00033C\u0011\"a'\u0016\u0003\u0003%)%!(\t\u0013\u0005}U#!A\u0005\u0002\u0006\u0005\u0006\"CAT+\u0005\u0005I\u0011QAU\u0011%\tY,FA\u0001\n\u0013\tiLA\u0005GS:$\u0017J\\*fi*\u0011QDH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002 A\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001U9\nt\u0007\u0005\u0002,Y5\tA$\u0003\u0002.9\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003W=J!\u0001\r\u000f\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00023q%\u0011\u0011h\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u0001=!\tYS(\u0003\u0002?9\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019A)\u0012$\u0011\u0005-\u0002\u0001\"\u0002\u001e\u0006\u0001\u0004a\u0004\"\u0002!\u0006\u0001\u0004a\u0014AC5oaV$H+\u001f9fgV\t\u0011\nE\u0002K%Vs!a\u0013)\u000f\u00051{U\"A'\u000b\u00059C\u0013A\u0002\u001fs_>$h(C\u00015\u0013\t\t6'A\u0004qC\u000e\\\u0017mZ3\n\u0005M#&aA*fc*\u0011\u0011k\r\t\u0003-fk\u0011a\u0016\u0006\u00031\u0002\nQ\u0001^=qKNL!AW,\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA/aEB\u0011!GX\u0005\u0003?N\u00121!\u00118z\u0011\u0015\tw\u00011\u0001^\u0003\u00119xN\u001d3\t\u000b\r<\u0001\u0019A/\u0002\u0007M,G/A\u0005e_\u001e+gnQ8eKR\u0019a\r\\9\u0011\u0005\u001dTW\"\u00015\u000b\u0005%d\u0012aB2pI\u0016<WM\\\u0005\u0003W\"\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006[\"\u0001\rA\\\u0001\u0004GRD\bCA4p\u0013\t\u0001\bN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000bID\u0001\u0019\u00014\u0002\u0005\u00154\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003U\u0004\"A\u0016<\n\u0005]<&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001{!\tYxP\u0004\u0002}{B\u0011AjM\u0005\u0003}N\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@4\u0003\u0011\u0019w\u000e]=\u0015\u000b\u0011\u000bI!a\u0003\t\u000fiZ\u0001\u0013!a\u0001y!9\u0001i\u0003I\u0001\u0002\u0004a\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#Q3\u0001PA\nW\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0010g\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0012\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\u0005Y\u0006twM\u0003\u0002\u00026\u0005!!.\u0019<b\u0013\u0011\t\t!a\f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0002c\u0001\u001a\u0002@%\u0019\u0011\u0011I\u001a\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007u\u000b9\u0005C\u0005\u0002JA\t\t\u00111\u0001\u0002>\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0014\u0011\u000b\u0005E\u0013qK/\u000e\u0005\u0005M#bAA+g\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00131\u000b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002`\u0005\u0015\u0004c\u0001\u001a\u0002b%\u0019\u00111M\u001a\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\n\n\u0002\u0002\u0003\u0007Q,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003?\nY\u0007\u0003\u0005\u0002JM\t\t\u00111\u0001^Q=\u0001\u0011qNA;\u0003o\nY(! \u0002\u0002\u0006\r\u0005cA\u0016\u0002r%\u0019\u00111\u000f\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011P\u0001\u0002D*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJd\u0003e\u001d;s?\u0006\u0014(/Y=*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA%tG-\u001a=!QEj#-Y:fI&\u0002sN\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u001aHO]5oO\u0002B\u0003m\u001d;sA&\u0002\u0013N\u001c\u0011uQ\u0016\u00043m\\7nC6\"W\r\\5nSR,G\r\t7jgR\u0004\u0003\u0006Y:ue~\u000b'O]1zA&r#\u0002\t\u0011!A\u0001\u0002#+\u001a;ve:\u001c\b\u0005\r\u0017!S\u001a\u0004C\u000f[3!gR\u0014\u0018N\\4!o\u0006\u001c\bE\\8uA\u0019|WO\u001c3!_J\u0004\u0013N\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u001aHO]5oO\u0002B\u0003m\u001d;sA&\u00023m\u001c8uC&t7\u000fI1!G>lW.\u0019\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u007f\n\u0001J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(C\n<CfJ1cG2\u0012G&\u00192-G2\"WMZ\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0015\u0015!B\u0019/k9\u0002\u0014!\u0003$j]\u0012LenU3u!\tYSc\u0005\u0003\u0016\u0003\u001b;\u0004cBAH\u0003+cD\bR\u0007\u0003\u0003#S1!a%4\u0003\u001d\u0011XO\u001c;j[\u0016LA!a&\u0002\u0012\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005%\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0012!B1qa2LH#\u0002#\u0002$\u0006\u0015\u0006\"\u0002\u001e\u0019\u0001\u0004a\u0004\"\u0002!\u0019\u0001\u0004a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003W\u000b9\fE\u00033\u0003[\u000b\t,C\u0002\u00020N\u0012aa\u00149uS>t\u0007#\u0002\u001a\u00024rb\u0014bAA[g\t1A+\u001e9mKJB\u0001\"!/\u001a\u0003\u0003\u0005\r\u0001R\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a0\u0011\t\u00055\u0012\u0011Y\u0005\u0005\u0003\u0007\fyC\u0001\u0004PE*,7\r\u001e")
public class FindInSet
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(FindInSet findInSet) {
        return FindInSet$.MODULE$.unapply(findInSet);
    }

    public static Function1<Tuple2<Expression, Expression>, FindInSet> tupled() {
        return FindInSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FindInSet>> curried() {
        return FindInSet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object word, Object set) {
        return BoxesRunTime.boxToInteger((int)((UTF8String)set).findInSet((UTF8String)word));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(word, set) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)set).append(".findInSet(").append((String)word).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "find_in_set";
    }

    public FindInSet copy(Expression left, Expression right) {
        return new FindInSet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FindInSet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FindInSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FindInSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        FindInSet findInSet = (FindInSet)x$1;
        Expression expression = this.left();
        Expression expression2 = findInSet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = findInSet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!findInSet.canEqual(this)) return false;
        return true;
    }

    public FindInSet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

