/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.CheckOverflow;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.objects.AssertNotNull;
import org.apache.spark.sql.catalyst.expressions.objects.CreateExternalRow;
import org.apache.spark.sql.catalyst.expressions.objects.GetExternalRowField;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.catalyst.expressions.objects.MapObjects;
import org.apache.spark.sql.catalyst.expressions.objects.MapObjects$;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance$;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.expressions.objects.ValidateExternalType;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UDTRegistration$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RowEncoder$ {
    public static RowEncoder$ MODULE$;

    static {
        new RowEncoder$();
    }

    public ExpressionEncoder<Row> apply(StructType schema) {
        Class<Row> cls = Row.class;
        BoundReference inputObject = new BoundReference(0, new ObjectType(cls), true);
        Expression serializer = this.serializerFor(new AssertNotNull(inputObject, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"top level row object"})))), schema);
        Expression deserializer = this.deserializerFor(schema);
        return new ExpressionEncoder<Row>(schema, false, ((CreateNamedStruct)serializer).flatten(), deserializer, ClassTag$.MODULE$.apply(cls));
    }

    private Expression serializerFor(Expression inputObject, DataType inputType) {
        Expression expression;
        block20: {
            DataType dataType;
            while (true) {
                if (ScalaReflection$.MODULE$.isNativeType(dataType = inputType)) {
                    expression = inputObject;
                    break block20;
                }
                if (!(dataType instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType;
                inputType = pythonUserDefinedType.sqlType();
            }
            if (dataType instanceof UserDefinedType) {
                NewInstance obj;
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                SQLUserDefinedType annotation = userDefinedType.userClass().getAnnotation(SQLUserDefinedType.class);
                Class udtClass = annotation != null ? annotation.udt() : (Class)UDTRegistration$.MODULE$.getUDTFor(userDefinedType.userClass().getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new SparkException(new StringBuilder(79).append(userDefinedType.userClass().getName()).append(" is not annotated with ").append("SQLUserDefinedType nor registered with UDTRegistration.}").toString());
                });
                NewInstance x$1 = obj = NewInstance$.MODULE$.apply(udtClass, (Seq<Expression>)Nil$.MODULE$, new ObjectType(udtClass), false);
                String x$2 = "serialize";
                UserDefinedType x$3 = userDefinedType;
                Expression expression2 = inputObject;
                List x$4 = Nil$.MODULE$.$colon$colon((Object)expression2);
                boolean x$5 = false;
                boolean x$6 = Invoke$.MODULE$.apply$default$5();
                expression = new Invoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$5);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                Class<?> x$7 = DateTimeUtils$.MODULE$.getClass();
                TimestampType$ x$8 = TimestampType$.MODULE$;
                String x$9 = "fromJavaTimestamp";
                Expression expression3 = inputObject;
                List x$10 = Nil$.MODULE$.$colon$colon((Object)expression3);
                boolean x$11 = false;
                boolean x$12 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$7, x$8, x$9, (Seq<Expression>)x$10, x$12, x$11);
            } else if (DateType$.MODULE$.equals(dataType)) {
                Class<?> x$13 = DateTimeUtils$.MODULE$.getClass();
                DateType$ x$14 = DateType$.MODULE$;
                String x$15 = "fromJavaDate";
                Expression expression4 = inputObject;
                List x$16 = Nil$.MODULE$.$colon$colon((Object)expression4);
                boolean x$17 = false;
                boolean x$18 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$13, x$14, x$15, (Seq<Expression>)x$16, x$18, x$17);
            } else if (dataType instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType;
                Class<?> x$19 = Decimal$.MODULE$.getClass();
                DecimalType x$20 = decimalType;
                String x$21 = "fromDecimal";
                Expression expression5 = inputObject;
                List x$22 = Nil$.MODULE$.$colon$colon((Object)expression5);
                boolean x$23 = false;
                boolean x$24 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new CheckOverflow(new StaticInvoke(x$19, x$20, x$21, (Seq<Expression>)x$22, x$24, x$23), decimalType);
            } else if (StringType$.MODULE$.equals(dataType)) {
                Class<UTF8String> x$25 = UTF8String.class;
                StringType$ x$26 = StringType$.MODULE$;
                String x$27 = "fromString";
                Expression expression6 = inputObject;
                List x$28 = Nil$.MODULE$.$colon$colon((Object)expression6);
                boolean x$29 = false;
                boolean x$30 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$25, x$26, x$27, (Seq<Expression>)x$28, x$30, x$29);
            } else if (dataType instanceof ArrayType) {
                Expression expression7;
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                DataType dataType2 = et;
                boolean bl = BooleanType$.MODULE$.equals(dataType2) ? true : (ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2))))));
                if (bl) {
                    Class<ArrayData> x$31 = ArrayData.class;
                    ArrayType x$32 = arrayType;
                    String x$33 = "toArrayData";
                    Expression expression8 = inputObject;
                    List x$34 = Nil$.MODULE$.$colon$colon((Object)expression8);
                    boolean x$35 = false;
                    boolean x$36 = StaticInvoke$.MODULE$.apply$default$5();
                    expression7 = new StaticInvoke(x$31, x$32, x$33, (Seq<Expression>)x$34, x$36, x$35);
                } else {
                    expression7 = MapObjects$.MODULE$.apply((Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)element -> {
                        void var3_3;
                        Expression value = MODULE$.serializerFor(new ValidateExternalType((Expression)element, et), et);
                        return !containsNull ? new AssertNotNull(value, (Seq<String>)((Seq)Seq$.MODULE$.empty())) : var3_3;
                    }, inputObject, new ObjectType(Object.class), MapObjects$.MODULE$.apply$default$4(), MapObjects$.MODULE$.apply$default$5());
                }
                expression = expression7;
            } else if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueNullable = mapType.valueContainsNull();
                Expression x$37 = inputObject;
                String x$38 = "keysIterator";
                ObjectType x$39 = new ObjectType(Iterator.class);
                boolean x$40 = false;
                Seq<Expression> x$41 = Invoke$.MODULE$.apply$default$4();
                boolean x$42 = Invoke$.MODULE$.apply$default$5();
                Invoke x$43 = new Invoke(x$37, x$38, x$39, x$41, x$42, x$40);
                String x$44 = "toSeq";
                ObjectType x$45 = new ObjectType(Seq.class);
                boolean x$46 = false;
                Seq<Expression> x$47 = Invoke$.MODULE$.apply$default$4();
                boolean x$48 = Invoke$.MODULE$.apply$default$5();
                Invoke keys = new Invoke(x$43, x$44, x$45, x$47, x$48, x$46);
                Expression convertedKeys = this.serializerFor(keys, new ArrayType(kt, false));
                Expression x$49 = inputObject;
                String x$50 = "valuesIterator";
                ObjectType x$51 = new ObjectType(Iterator.class);
                boolean x$52 = false;
                Seq<Expression> x$53 = Invoke$.MODULE$.apply$default$4();
                boolean x$54 = Invoke$.MODULE$.apply$default$5();
                Invoke x$55 = new Invoke(x$49, x$50, x$51, x$53, x$54, x$52);
                String x$56 = "toSeq";
                ObjectType x$57 = new ObjectType(Seq.class);
                boolean x$58 = false;
                Seq<Expression> x$59 = Invoke$.MODULE$.apply$default$4();
                boolean x$60 = Invoke$.MODULE$.apply$default$5();
                Invoke values = new Invoke(x$55, x$56, x$57, x$59, x$60, x$58);
                Expression convertedValues = this.serializerFor(values, new ArrayType(vt, valueNullable));
                Expression expression9 = convertedKeys;
                Expression expression10 = convertedValues;
                NewInstance nonNullOutput = NewInstance$.MODULE$.apply(ArrayBasedMapData.class, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression10).$colon$colon((Object)expression9), mapType, false);
                expression = inputObject.nullable() ? new If(new IsNull(inputObject), Literal$.MODULE$.create(null, inputType), nonNullOutput) : nonNullOutput;
            } else if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                CreateNamedStruct nonNullOutput = new CreateNamedStruct((Seq<Expression>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Expression expression;
                    StructField field;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        field = (StructField)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Expression fieldValue = MODULE$.serializerFor(new ValidateExternalType(new GetExternalRowField(inputObject, index, field.name()), field.dataType()), field.dataType());
                        if (field.nullable()) {
                            Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)index));
                            If if_ = new If(new Invoke(inputObject, "isNullAt", BooleanType$.MODULE$, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)literal), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6()), Literal$.MODULE$.create(null, field.dataType()), fieldValue);
                            expression = if_;
                        } else {
                            expression = fieldValue;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Expression convertedField = expression;
                    Literal literal = Literal$.MODULE$.apply(field.name());
                    Expression expression2 = convertedField;
                    List list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)literal);
                    return list;
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                expression = inputObject.nullable() ? new If(new IsNull(inputObject), Literal$.MODULE$.create(null, inputType), nonNullOutput) : nonNullOutput;
            } else {
                throw new MatchError((Object)dataType);
            }
        }
        return expression;
    }

    public DataType externalDataTypeForInput(DataType dt) {
        DataType dataType = dt;
        DataType dataType2 = dataType instanceof DecimalType ? new ObjectType(Object.class) : (dataType instanceof ArrayType ? new ObjectType(Object.class) : this.externalDataTypeFor(dt));
        return dataType2;
    }

    public DataType externalDataTypeFor(DataType dt) {
        DataType dataType;
        block11: {
            DataType dataType2;
            while (true) {
                dataType2 = dt;
                if (ScalaReflection$.MODULE$.isNativeType(dt)) {
                    dataType = dt;
                    break block11;
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    dataType = new ObjectType(Timestamp.class);
                    break block11;
                }
                if (DateType$.MODULE$.equals(dataType2)) {
                    dataType = new ObjectType(Date.class);
                    break block11;
                }
                if (dataType2 instanceof DecimalType) {
                    dataType = new ObjectType(BigDecimal.class);
                    break block11;
                }
                if (StringType$.MODULE$.equals(dataType2)) {
                    dataType = new ObjectType(String.class);
                    break block11;
                }
                if (dataType2 instanceof ArrayType) {
                    dataType = new ObjectType(Seq.class);
                    break block11;
                }
                if (dataType2 instanceof MapType) {
                    dataType = new ObjectType(Map.class);
                    break block11;
                }
                if (dataType2 instanceof StructType) {
                    dataType = new ObjectType(Row.class);
                    break block11;
                }
                if (!(dataType2 instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType2;
                dt = pythonUserDefinedType.sqlType();
            }
            if (dataType2 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = new ObjectType(userDefinedType.userClass());
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
        return dataType;
    }

    private Expression deserializerFor(StructType schema) {
        Seq fields = (Seq)((TraversableLike)schema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DataType dataType;
            int i;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField f = (StructField)tuple2._1();
                i = tuple2._2$mcI$sp();
                DataType dataType2 = f.dataType();
                if (dataType2 instanceof PythonUserDefinedType) {
                    PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType2;
                    dataType = pythonUserDefinedType.sqlType();
                } else {
                    dataType = dataType2;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            DataType dt = dataType;
            Expression expression = MODULE$.deserializerFor(new GetColumnByOrdinal(i, dt));
            return expression;
        }, Seq$.MODULE$.canBuildFrom());
        return new CreateExternalRow((Seq<Expression>)fields, schema);
    }

    private Expression deserializerFor(Expression input) {
        return this.deserializerFor(input, input.dataType());
    }

    private Expression deserializerFor(Expression input, DataType dataType) {
        Expression expression;
        block18: {
            DataType dataType2;
            while (true) {
                if (ScalaReflection$.MODULE$.isNativeType(dataType2 = dataType)) {
                    expression = input;
                    break block18;
                }
                if (!(dataType2 instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType2;
                dataType = pythonUserDefinedType.sqlType();
            }
            if (dataType2 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                SQLUserDefinedType annotation = userDefinedType.userClass().getAnnotation(SQLUserDefinedType.class);
                Class udtClass = annotation != null ? annotation.udt() : (Class)UDTRegistration$.MODULE$.getUDTFor(userDefinedType.userClass().getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new SparkException(new StringBuilder(79).append(userDefinedType.userClass().getName()).append(" is not annotated with ").append("SQLUserDefinedType nor registered with UDTRegistration.}").toString());
                });
                NewInstance obj = NewInstance$.MODULE$.apply(udtClass, (Seq<Expression>)Nil$.MODULE$, new ObjectType(udtClass), NewInstance$.MODULE$.apply$default$4());
                Expression expression2 = input;
                expression = new Invoke(obj, "deserialize", new ObjectType(userDefinedType.userClass()), (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression2), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6());
            } else if (TimestampType$.MODULE$.equals(dataType2)) {
                Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
                ObjectType x$2 = new ObjectType(Timestamp.class);
                String x$3 = "toJavaTimestamp";
                Expression expression3 = input;
                List x$4 = Nil$.MODULE$.$colon$colon((Object)expression3);
                boolean x$5 = false;
                boolean x$6 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$5);
            } else if (DateType$.MODULE$.equals(dataType2)) {
                Class<?> x$7 = DateTimeUtils$.MODULE$.getClass();
                ObjectType x$8 = new ObjectType(Date.class);
                String x$9 = "toJavaDate";
                Expression expression4 = input;
                List x$10 = Nil$.MODULE$.$colon$colon((Object)expression4);
                boolean x$11 = false;
                boolean x$12 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$7, x$8, x$9, (Seq<Expression>)x$10, x$12, x$11);
            } else if (dataType2 instanceof DecimalType) {
                Expression x$13 = input;
                String x$14 = "toJavaBigDecimal";
                ObjectType x$152 = new ObjectType(BigDecimal.class);
                boolean x$16 = false;
                Seq<Expression> x$17 = Invoke$.MODULE$.apply$default$4();
                boolean x$18 = Invoke$.MODULE$.apply$default$5();
                expression = new Invoke(x$13, x$14, x$152, x$17, x$18, x$16);
            } else if (StringType$.MODULE$.equals(dataType2)) {
                Expression x$19 = input;
                String x$20 = "toString";
                ObjectType x$21 = new ObjectType(String.class);
                boolean x$22 = false;
                Seq<Expression> x$23 = Invoke$.MODULE$.apply$default$4();
                boolean x$24 = Invoke$.MODULE$.apply$default$5();
                expression = new Invoke(x$19, x$20, x$21, x$23, x$24, x$22);
            } else if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                DataType et = arrayType.elementType();
                MapObjects x$25 = MapObjects$.MODULE$.apply((Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x$15 -> MODULE$.deserializerFor((Expression)x$15), input, et, MapObjects$.MODULE$.apply$default$4(), MapObjects$.MODULE$.apply$default$5());
                String x$26 = "array";
                ObjectType x$27 = new ObjectType(Object.class);
                boolean x$28 = false;
                Seq<Expression> x$29 = Invoke$.MODULE$.apply$default$4();
                boolean x$30 = Invoke$.MODULE$.apply$default$5();
                Invoke arrayData = new Invoke(x$25, x$26, x$27, x$29, x$30, x$28);
                Class x$31 = WrappedArray$.MODULE$.getClass();
                ObjectType x$32 = new ObjectType(Seq.class);
                String x$33 = "make";
                Invoke invoke = arrayData;
                List x$34 = Nil$.MODULE$.$colon$colon((Object)invoke);
                boolean x$35 = false;
                boolean x$36 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$31, x$32, x$33, (Seq<Expression>)x$34, x$36, x$35);
            } else if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueNullable = mapType.valueContainsNull();
                ArrayType keyArrayType = new ArrayType(kt, false);
                Expression keyData = this.deserializerFor(new Invoke(input, "keyArray", keyArrayType, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6()));
                ArrayType valueArrayType = new ArrayType(vt, valueNullable);
                Expression valueData = this.deserializerFor(new Invoke(input, "valueArray", valueArrayType, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6()));
                Class<?> x$37 = ArrayBasedMapData$.MODULE$.getClass();
                ObjectType x$38 = new ObjectType(Map.class);
                String x$39 = "toScalaMap";
                Expression expression5 = keyData;
                Expression expression6 = valueData;
                List x$40 = Nil$.MODULE$.$colon$colon((Object)expression6).$colon$colon((Object)expression5);
                boolean x$41 = false;
                boolean x$42 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$37, x$38, x$39, (Seq<Expression>)x$40, x$42, x$41);
            } else if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                StructField[] fields = structType.fields();
                If[] convertedFields = (If[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StructField f = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)i));
                    If if_ = new If(new Invoke(input, "isNullAt", BooleanType$.MODULE$, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)literal), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6()), Literal$.MODULE$.create(null, MODULE$.externalDataTypeFor(f.dataType())), MODULE$.deserializerFor(new GetStructField(input, i, GetStructField$.MODULE$.apply$default$3())));
                    return if_;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(If.class)));
                expression = new If(new IsNull(input), Literal$.MODULE$.create(null, this.externalDataTypeFor(input.dataType())), new CreateExternalRow((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])convertedFields), structType));
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
        return expression;
    }

    private RowEncoder$() {
        MODULE$ = this;
    }
}

