/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper$class;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001f\t!\u0012j]89mA\nD)\u0019;f\r>\u0014X.\u0019;uKJT!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A1\"\u0004\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/ai\u0011AA\u0005\u00033\t\u0011Q\u0002R1uK\u001a{'/\\1ui\u0016\u0014\bCA\f\u001c\u0013\ta\"AA\fECR,G+[7f\r>\u0014X.\u0019;uKJDU\r\u001c9fe\"Aa\u0004\u0001B\u0001B\u0003%q$A\u0004qCR$XM\u001d8\u0011\u0005\u0001\u001acBA\t\"\u0013\t\u0011##\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0015\u0012aa\u0015;sS:<'B\u0001\u0012\u0013\u0011!9\u0003A!A!\u0002\u0013A\u0013A\u00027pG\u0006dW\r\u0005\u0002*[5\t!F\u0003\u0002\u0004W)\tA&\u0001\u0003kCZ\f\u0017B\u0001\u0018+\u0005\u0019aunY1mK\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"2AM\u001a5!\t9\u0002\u0001C\u0003\u001f_\u0001\u0007q\u0004C\u0003(_\u0001\u0007\u0001\u0006\u0003\u00057\u0001!\u0015\r\u0011\"\u00038\u0003%1wN]7biR,'/F\u00019!\tId(D\u0001;\u0015\tYD(\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003{-\nA\u0001^5nK&\u0011qH\u000f\u0002\u0012\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\b\u0002C!\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u001d\u0002\u0015\u0019|'/\\1ui\u0016\u0014\b\u0005\u000b\u0002A\u0007B\u0011\u0011\u0003R\u0005\u0003\u000bJ\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000f\u001d\u0003!\u0019!C\u0005\u0011\u0006\u0019Q\u000bV\"\u0016\u0003%\u0003\"AS&\u000e\u0003qJ!\u0001\u0014\u001f\u0003\ri{g.Z%e\u0011\u0019q\u0005\u0001)A\u0005\u0013\u0006!Q\u000bV\"!\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0003%!x.\u00138ti\u0006tG\u000f\u0006\u0002S+B\u0011!jU\u0005\u0003)r\u0012q!\u00138ti\u0006tG\u000fC\u0003W\u001f\u0002\u0007q$A\u0001t\u0011\u0015A\u0006\u0001\"\u0011Z\u0003\u0015\u0001\u0018M]:f)\tQV\f\u0005\u0002\u00127&\u0011AL\u0005\u0002\u0004\u0013:$\b\"\u0002,X\u0001\u0004y\u0002\"B\u001e\u0001\t\u0003zFCA\u0010a\u0011\u0015\tg\f1\u0001[\u0003\u0011!\u0017-_:")
public class Iso8601DateFormatter
implements DateFormatter,
DateTimeFormatterHelper {
    private final String pattern;
    private final Locale locale;
    private transient DateTimeFormatter formatter;
    private final ZoneId UTC;
    private volatile transient boolean bitmap$trans$0;

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601DateFormatter iso8601DateFormatter = this;
        synchronized (iso8601DateFormatter) {
            if (!this.bitmap$trans$0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale);
                this.bitmap$trans$0 = true;
            }
            return this.formatter;
        }
    }

    @Override
    public Instant toInstantWithZoneId(TemporalAccessor temporalAccessor, ZoneId zoneId) {
        return DateTimeFormatterHelper$class.toInstantWithZoneId(this, temporalAccessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale) {
        return DateTimeFormatterHelper$class.getOrCreateFormatter(this, pattern, locale);
    }

    private DateTimeFormatter formatter() {
        return this.bitmap$trans$0 ? this.formatter : this.formatter$lzycompute();
    }

    private ZoneId UTC() {
        return this.UTC;
    }

    private Instant toInstant(String s) {
        TemporalAccessor temporalAccessor = this.formatter().parse(s);
        return this.toInstantWithZoneId(temporalAccessor, this.UTC());
    }

    @Override
    public int parse(String s) {
        return DateTimeUtils$.MODULE$.instantToDays(this.toInstant(s));
    }

    @Override
    public String format(int days) {
        Instant instant = Instant.ofEpochSecond((long)days * 86400L);
        return this.formatter().withZone(this.UTC()).format(instant);
    }

    public Iso8601DateFormatter(String pattern, Locale locale) {
        this.pattern = pattern;
        this.locale = locale;
        DateTimeFormatterHelper$class.$init$(this);
        this.UTC = ZoneId.of("UTC");
    }
}

