/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, search[, replace]) - Replaces all occurrences of `search` with `replace`.", arguments="\n    Arguments:\n      * str - a string expression\n      * search - a string expression. If `search` is not found in `str`, `str` is returned unchanged.\n      * replace - a string expression. If `replace` is not specified or is an empty string, nothing replaces\n          the string that is removed from `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ABCabc', 'abc', 'DEF');\n       ABCDEF\n  ", since="2.3.0")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0001\u0003\u0001>\u0011Qb\u0015;sS:<'+\u001a9mC\u000e,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0004te\u000e,\u0005\u0010\u001d:\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0005te\u000e,\u0005\u0010\u001d:!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013AC:fCJ\u001c\u0007.\u0012=qe\"A1\u0006\u0001B\tB\u0003%1%A\u0006tK\u0006\u00148\r[#yaJ\u0004\u0003\u0002C\u0017\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u0017I,\u0007\u000f\\1dK\u0016C\bO\u001d\u0005\t_\u0001\u0011\t\u0012)A\u0005G\u0005a!/\u001a9mC\u000e,W\t\u001f9sA!)\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"Ba\r\u001b6mA\u0011\u0011\u0003\u0001\u0005\u0006CA\u0002\ra\t\u0005\u0006SA\u0002\ra\t\u0005\u0006[A\u0002\ra\t\u0005\u0006c\u0001!\t\u0001\u000f\u000b\u0004geR\u0004\"B\u00118\u0001\u0004\u0019\u0003\"B\u00158\u0001\u0004\u0019\u0003\"\u0002\u001f\u0001\t\u0003j\u0014\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003\u0002 B\u0007\u0016\u0003\"\u0001G \n\u0005\u0001K\"aA!os\")!i\u000fa\u0001}\u000591O]2Fm\u0006d\u0007\"\u0002#<\u0001\u0004q\u0014AC:fCJ\u001c\u0007.\u0012<bY\")ai\u000fa\u0001}\u0005Y!/\u001a9mC\u000e,WI^1m\u0011\u0015A\u0005\u0001\"\u0011J\u0003%!wnR3o\u0007>$W\rF\u0002K!V\u0003\"a\u0013(\u000e\u00031S!!\u0014\u0002\u0002\u000f\r|G-Z4f]&\u0011q\n\u0014\u0002\t\u000bb\u0004(oQ8eK\")\u0011k\u0012a\u0001%\u0006\u00191\r\u001e=\u0011\u0005-\u001b\u0016B\u0001+M\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQAV$A\u0002)\u000b!!\u001a<\t\u000ba\u0003A\u0011I-\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u001a\tQ\u0001^=qKNL!a\u0018/\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ!\u0019\u0001\u0005B\t\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0019\u0007c\u00013m5:\u0011QM\u001b\b\u0003M&l\u0011a\u001a\u0006\u0003Q:\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005-L\u0012a\u00029bG.\fw-Z\u0005\u0003[:\u00141aU3r\u0015\tY\u0017\u0004C\u0003q\u0001\u0011\u0005\u0013/\u0001\u0005dQ&dGM]3o+\u0005\u0011\bc\u00013mG!)A\u000f\u0001C!k\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003Y\u0004\"a\u001e>\u000f\u0005aA\u0018BA=\u001a\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005eL\u0002b\u0002@\u0001\u0003\u0003%\ta`\u0001\u0005G>\u0004\u0018\u0010F\u00044\u0003\u0003\t\u0019!!\u0002\t\u000f\u0005j\b\u0013!a\u0001G!9\u0011& I\u0001\u0002\u0004\u0019\u0003bB\u0017~!\u0003\u0005\ra\t\u0005\n\u0003\u0013\u0001\u0011\u0013!C\u0001\u0003\u0017\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u000e)\u001a1%a\u0004,\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0007\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\t)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\t\u0001#\u0003%\t!a\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011q\u0005\u0001\u0012\u0002\u0013\u0005\u00111B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\tY\u0003AA\u0001\n\u0003\ni#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$\u0001\u0003mC:<'BAA\u001d\u0003\u0011Q\u0017M^1\n\u0007m\f\u0019\u0004C\u0005\u0002@\u0001\t\t\u0011\"\u0001\u0002B\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\t\t\u00041\u0005\u0015\u0013bAA$3\t\u0019\u0011J\u001c;\t\u0013\u0005-\u0003!!A\u0005\u0002\u00055\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004}\u0005=\u0003BCA)\u0003\u0013\n\t\u00111\u0001\u0002D\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005U\u0003!!A\u0005B\u0005]\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0003#BA.\u0003CrTBAA/\u0015\r\ty&G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA2\u0003;\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003O\u0002\u0011\u0011!C\u0001\u0003S\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003W\n\t\bE\u0002\u0019\u0003[J1!a\u001c\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0015\u0002f\u0005\u0005\t\u0019\u0001 \t\u0013\u0005U\u0004!!A\u0005B\u0005]\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002l\u0005e\u0004\"CA)\u0003g\n\t\u00111\u0001?QM\u0001\u0011QPAB\u0003\u000b\u000bI)a#\u0002\u0010\u0006E\u0015QSAL!\r\t\u0012qP\u0005\u0004\u0003\u0003\u0013!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u000f\u000bQk\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\u001aX-\u0019:dQnc\u0003E]3qY\u0006\u001cW-X\u0015![\u0001\u0012V\r\u001d7bG\u0016\u001c\b%\u00197mA=\u001c7-\u001e:sK:\u001cWm\u001d\u0011pM\u0002\u00027/Z1sG\"\u0004\u0007e^5uQ\u0002\u0002'/\u001a9mC\u000e,\u0007ML\u0001\nCJ<W/\\3oiN\f#!!$\u0002\u0005cR\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003e]3be\u000eD\u0007%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\f\u0011JM\u0002\u00027/Z1sG\"\u0004\u0007%[:!]>$\bEZ8v]\u0012\u0004\u0013N\u001c\u0011agR\u0014\b\r\f\u0011agR\u0014\b\rI5tAI,G/\u001e:oK\u0012\u0004SO\\2iC:<W\r\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AI,\u0007\u000f\\1dK\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:t\u0003%\u00134!AJ,\u0007\u000f\\1dK\u0002\u0004\u0013n\u001d\u0011o_R\u00043\u000f]3dS\u001aLW\r\u001a\u0011pe\u0002J7\u000fI1oA\u0015l\u0007\u000f^=!gR\u0014\u0018N\\4-A9|G\u000f[5oO\u0002\u0012X\r\u001d7bG\u0016\u001c(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i\",\u0007e\u001d;sS:<\u0007\u0005\u001e5bi\u0002J7\u000f\t:f[>4X\r\u001a\u0011ge>l\u0007\u0005Y:ue\u0002t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a%\u0002\u001d*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\u0011\"DC\n\u001cw\u0005\f\u0011(C\n\u001cw\u0005\f\u0011(\t\u00163u%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003\n\u001bE)\u0012$\u000bA\u0001\nQa]5oG\u0016\f#!!'\u0002\u000bIr3G\f\u0019\b\u0013\u0005u%!!A\t\u0002\u0005}\u0015!D*ue&twMU3qY\u0006\u001cW\rE\u0002\u0012\u0003C3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u00111U\n\u0006\u0003C\u000b)+\b\t\t\u0003O\u000bikI\u0012$g5\u0011\u0011\u0011\u0016\u0006\u0004\u0003WK\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003_\u000bIKA\tBEN$(/Y2u\rVt7\r^5p]NBq!MAQ\t\u0003\t\u0019\f\u0006\u0002\u0002 \"Q\u0011qWAQ\u0003\u0003%)%!/\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\f\t\u0015\u0005u\u0016\u0011UA\u0001\n\u0003\u000by,A\u0003baBd\u0017\u0010F\u00044\u0003\u0003\f\u0019-!2\t\r\u0005\nY\f1\u0001$\u0011\u0019I\u00131\u0018a\u0001G!1Q&a/A\u0002\rB!\"!3\u0002\"\u0006\u0005I\u0011QAf\u0003\u001d)h.\u00199qYf$B!!4\u0002ZB)\u0001$a4\u0002T&\u0019\u0011\u0011[\r\u0003\r=\u0003H/[8o!\u0019A\u0012Q[\u0012$G%\u0019\u0011q[\r\u0003\rQ+\b\u000f\\34\u0011%\tY.a2\u0002\u0002\u0003\u00071'A\u0002yIAB!\"a8\u0002\"\u0006\u0005I\u0011BAq\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\r\b\u0003BA\u0019\u0003KLA!a:\u00024\t1qJ\u00196fGR\u0004")
public class StringReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression srcExpr;
    private final Expression searchExpr;
    private final Expression replaceExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringReplace stringReplace) {
        return StringReplace$.MODULE$.unapply(stringReplace);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringReplace> tupled() {
        return StringReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringReplace>>> curried() {
        return StringReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression srcExpr() {
        return this.srcExpr;
    }

    public Expression searchExpr() {
        return this.searchExpr;
    }

    public Expression replaceExpr() {
        return this.replaceExpr;
    }

    @Override
    public Object nullSafeEval(Object srcEval, Object searchEval, Object replaceEval) {
        return ((UTF8String)srcEval).replace((UTF8String)searchEval, (UTF8String)replaceEval);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)new Serializable(this, ev){
            public static final long serialVersionUID = 0L;
            private final ExprCode ev$1;

            public final String apply(String src, String search2, String replace) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".replace(", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ev$1.value(), src, search2, replace}));
            }
            {
                this.ev$1 = ev$1;
            }
        });
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.srcExpr();
        Expression expression2 = this.searchExpr();
        Expression expression3 = this.replaceExpr();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "replace";
    }

    public StringReplace copy(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        return new StringReplace(srcExpr, searchExpr, replaceExpr);
    }

    public Expression copy$default$1() {
        return this.srcExpr();
    }

    public Expression copy$default$2() {
        return this.searchExpr();
    }

    public Expression copy$default$3() {
        return this.replaceExpr();
    }

    @Override
    public String productPrefix() {
        return "StringReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.replaceExpr();
                break;
            }
            case 1: {
                expression = this.searchExpr();
                break;
            }
            case 0: {
                expression = this.srcExpr();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringReplace stringReplace = (StringReplace)x$1;
        Expression expression = this.srcExpr();
        Expression expression2 = stringReplace.srcExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.searchExpr();
        Expression expression4 = stringReplace.searchExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replaceExpr();
        Expression expression6 = stringReplace.replaceExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringReplace.canEqual(this)) return false;
        return true;
    }

    public StringReplace(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        this.srcExpr = srcExpr;
        this.searchExpr = searchExpr;
        this.replaceExpr = replaceExpr;
        ExpectsInputTypes$class.$init$(this);
    }

    public StringReplace(Expression srcExpr, Expression searchExpr) {
        this(srcExpr, searchExpr, Literal$.MODULE$.apply(""));
    }
}

