/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper$class;
import org.apache.spark.sql.catalyst.optimizer.JoinReorderDP$;
import org.apache.spark.sql.catalyst.optimizer.OrderedJoin;
import org.apache.spark.sql.catalyst.plans.InnerLike;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;

public final class CostBasedJoinReorder$
extends Rule<LogicalPlan>
implements PredicateHelper {
    public static final CostBasedJoinReorder$ MODULE$;

    static {
        new CostBasedJoinReorder$();
    }

    @Override
    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper$class.splitConjunctivePredicates(this, condition);
    }

    @Override
    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper$class.splitDisjunctivePredicates(this, condition);
    }

    @Override
    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper$class.replaceAlias(this, condition, aliases);
    }

    @Override
    public boolean canEvaluate(Expression expr, LogicalPlan plan2) {
        return PredicateHelper$class.canEvaluate(this, expr, plan2);
    }

    @Override
    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper$class.canEvaluateWithinJoin(this, expr);
    }

    private SQLConf conf() {
        return SQLConf$.MODULE$.get();
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        TreeNode treeNode;
        if (this.conf().cboEnabled() && this.conf().joinReorderEnabled()) {
            TreeNode result = plan2.transformDown((PartialFunction)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Join) {
                        Join join = (Join)A1;
                        Option<Expression> option = join.condition();
                        if (join.joinType() instanceof InnerLike && option instanceof Some) {
                            object = CostBasedJoinReorder$.MODULE$.org$apache$spark$sql$catalyst$optimizer$CostBasedJoinReorder$$reorder(join, join.output());
                            return (B1)object;
                        }
                    }
                    if (A1 instanceof Project) {
                        Project project = (Project)A1;
                        Seq<NamedExpression> projectList = project.projectList();
                        LogicalPlan logicalPlan = project.child();
                        if (logicalPlan instanceof Join) {
                            Join join = (Join)logicalPlan;
                            Option<Expression> option = join.condition();
                            if (join.joinType() instanceof InnerLike && option instanceof Some && projectList.forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(NamedExpression x$1) {
                                    return x$1 instanceof Attribute;
                                }
                            })) {
                                object = CostBasedJoinReorder$.MODULE$.org$apache$spark$sql$catalyst$optimizer$CostBasedJoinReorder$$reorder(project, project.output());
                                return (B1)object;
                            }
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    if (logicalPlan instanceof Join) {
                        Join join = (Join)logicalPlan;
                        Option<Expression> option = join.condition();
                        if (join.joinType() instanceof InnerLike && option instanceof Some) {
                            return true;
                        }
                    }
                    if (!(logicalPlan instanceof Project)) return false;
                    Project project = (Project)logicalPlan;
                    Seq<NamedExpression> projectList = project.projectList();
                    LogicalPlan logicalPlan2 = project.child();
                    if (!(logicalPlan2 instanceof Join)) return false;
                    Join join = (Join)logicalPlan2;
                    Option<Expression> option = join.condition();
                    if (!(join.joinType() instanceof InnerLike)) return false;
                    if (!(option instanceof Some)) return false;
                    if (!projectList.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(NamedExpression x$1) {
                            return x$1 instanceof Attribute;
                        }
                    })) return false;
                    return true;
                }
            });
            treeNode = ((LogicalPlan)result).transformDown((PartialFunction)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof OrderedJoin) {
                        OrderedJoin orderedJoin = (OrderedJoin)A1;
                        LogicalPlan left = orderedJoin.left();
                        LogicalPlan right = orderedJoin.right();
                        JoinType jt = orderedJoin.joinType();
                        Option<Expression> cond = orderedJoin.condition();
                        object = new Join(left, right, jt, cond);
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x2) {
                    LogicalPlan logicalPlan = x2;
                    boolean bl = logicalPlan instanceof OrderedJoin;
                    return bl;
                }
            });
        } else {
            treeNode = plan2;
        }
        return treeNode;
    }

    public LogicalPlan org$apache$spark$sql$catalyst$optimizer$CostBasedJoinReorder$$reorder(LogicalPlan plan2, Seq<Attribute> output2) {
        Tuple2<Seq<LogicalPlan>, Set<Expression>> tuple2 = this.extractInnerJoins(plan2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq items = (Seq)tuple2._1();
            Set conditions = (Set)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)items, (Object)conditions);
            Seq items2 = (Seq)tuple23._1();
            Set conditions2 = (Set)tuple23._2();
            LogicalPlan result = items2.size() > 2 && items2.size() <= this.conf().joinReorderDPThreshold() && conditions2.nonEmpty() && items2.forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(LogicalPlan x$3) {
                    return x$3.stats().rowCount().isDefined();
                }
            }) ? JoinReorderDP$.MODULE$.search(this.conf(), (Seq<LogicalPlan>)items2, (Set<Expression>)conditions2, output2) : plan2;
            return this.replaceWithOrderedJoin(result);
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Seq<LogicalPlan>, Set<Expression>> extractInnerJoins(LogicalPlan plan2) {
        Tuple2 tuple2;
        block5: {
            while (true) {
                LogicalPlan logicalPlan;
                if ((logicalPlan = plan2) instanceof Join) {
                    Join join = (Join)logicalPlan;
                    LogicalPlan left = join.left();
                    LogicalPlan right = join.right();
                    Option<Expression> option = join.condition();
                    if (join.joinType() instanceof InnerLike && option instanceof Some) {
                        Some some = (Some)option;
                        Expression cond = (Expression)some.x();
                        Tuple2<Seq<LogicalPlan>, Set<Expression>> tuple22 = this.extractInnerJoins(left);
                        if (tuple22 != null) {
                            Tuple2 tuple23;
                            Seq leftPlans = (Seq)tuple22._1();
                            Set leftConditions = (Set)tuple22._2();
                            Tuple2 tuple24 = tuple23 = new Tuple2((Object)leftPlans, (Object)leftConditions);
                            Seq leftPlans2 = (Seq)tuple24._1();
                            Set leftConditions2 = (Set)tuple24._2();
                            Tuple2<Seq<LogicalPlan>, Set<Expression>> tuple25 = this.extractInnerJoins(right);
                            if (tuple25 != null) {
                                Tuple2 tuple26;
                                Seq rightPlans = (Seq)tuple25._1();
                                Set rightConditions = (Set)tuple25._2();
                                Tuple2 tuple27 = tuple26 = new Tuple2((Object)rightPlans, (Object)rightConditions);
                                Seq rightPlans2 = (Seq)tuple27._1();
                                Set rightConditions2 = (Set)tuple27._2();
                                tuple2 = new Tuple2(leftPlans2.$plus$plus((GenTraversableOnce)rightPlans2, Seq$.MODULE$.canBuildFrom()), (Object)this.splitConjunctivePredicates(cond).toSet().$plus$plus((GenTraversableOnce)leftConditions2).$plus$plus((GenTraversableOnce)rightConditions2));
                                break block5;
                            }
                            throw new MatchError(tuple25);
                        }
                        throw new MatchError(tuple22);
                    }
                }
                if (!(logicalPlan instanceof Project)) break;
                Project project = (Project)logicalPlan;
                Seq<NamedExpression> projectList = project.projectList();
                LogicalPlan j = project.child();
                if (!(j instanceof Join)) break;
                Join join = (Join)j;
                Option<Expression> option = join.condition();
                if (!(join.joinType() instanceof InnerLike) || !(option instanceof Some) || !projectList.forall((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(NamedExpression x$6) {
                        return x$6 instanceof Attribute;
                    }
                })) break;
                plan2 = join;
            }
            tuple2 = new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogicalPlan[]{plan2})), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
        }
        return tuple2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LogicalPlan replaceWithOrderedJoin(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            LogicalPlan left = join.left();
            LogicalPlan right = join.right();
            JoinType jt = join.joinType();
            Option<Expression> option = join.condition();
            if (jt instanceof InnerLike) {
                InnerLike innerLike = (InnerLike)jt;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Expression cond = (Expression)some.x();
                    LogicalPlan replacedLeft = this.replaceWithOrderedJoin(left);
                    LogicalPlan replacedRight = this.replaceWithOrderedJoin(right);
                    return new OrderedJoin(replacedLeft, replacedRight, innerLike, (Option<Expression>)new Some((Object)cond));
                }
            }
        }
        if (!(logicalPlan instanceof Project)) return plan2;
        Project project = (Project)logicalPlan;
        LogicalPlan j = project.child();
        if (!(j instanceof Join)) return plan2;
        Join join = (Join)j;
        Option<Expression> option = join.condition();
        if (!(join.joinType() instanceof InnerLike)) return plan2;
        if (!(option instanceof Some)) return plan2;
        LogicalPlan x$11 = this.replaceWithOrderedJoin(join);
        Seq<NamedExpression> x$12 = project.copy$default$1();
        return project.copy(x$12, x$11);
    }

    private CostBasedJoinReorder$() {
        MODULE$ = this;
        PredicateHelper$class.$init$(this);
    }
}

