/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression$class;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(BOTH trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`\n\n    _FUNC_(LEADING trimStr FROM str) - Remove the leading `trimStr` characters from `str`\n\n    _FUNC_(TRAILING trimStr FROM str) - Remove the trailing `trimStr` characters from `str`\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n      * BOTH, FROM - these are keywords to specify trimming string characters from both ends of\n          the string\n      * LEADING, FROM - these are keywords to specify trimming string characters from the left\n          end of the string\n      * TRAILING, FROM - these are keywords to specify trimming string characters from the right\n          end of the string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('SL', 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(BOTH 'SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(LEADING 'SL' FROM 'SSparkSQLS');\n       parkSQLS\n      > SELECT _FUNC_(TRAILING 'SL' FROM 'SSparkSQLS');\n       SSparkSQ\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mv!B\u0001\u0003\u0011\u0003y\u0011AC*ue&tw\r\u0016:j[*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051C\u0001\u0006TiJLgn\u001a+sS6\u001c2!\u0005\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u0011QcG\u0005\u00039Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAH\t\u0005\u0002}\ta\u0001P5oSRtD#A\b\t\u000b\u0005\nB\u0011\u0001\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\r\nI(! \u0011\u0005A!c\u0001\u0002\n\u0003\u0001\u0016\u001aR\u0001\n\u0014*Yi\u0001\"\u0001E\u0014\n\u0005!\u0012!AC#yaJ,7o]5p]B\u0011\u0001CK\u0005\u0003W\t\u0011Qc\u0015;sS:<'\u0007\u0016:j[\u0016C\bO]3tg&|g\u000e\u0005\u0002\u0016[%\u0011aF\u0006\u0002\b!J|G-^2u\u0011!\u0001DE!f\u0001\n\u0003\t\u0014AB:sGN#(/F\u0001'\u0011!\u0019DE!E!\u0002\u00131\u0013aB:sGN#(\u000f\t\u0005\tk\u0011\u0012)\u001a!C\u0001m\u00059AO]5n'R\u0014X#A\u001c\u0011\u0007UAd%\u0003\u0002:-\t1q\n\u001d;j_:D\u0001b\u000f\u0013\u0003\u0012\u0003\u0006IaN\u0001\tiJLWn\u0015;sA!)a\u0004\nC\u0001{Q\u00191EP \t\u000bAb\u0004\u0019\u0001\u0014\t\u000fUb\u0004\u0013!a\u0001o!)a\u0004\nC\u0001\u0003R\u00191EQ\"\t\u000bU\u0002\u0005\u0019\u0001\u0014\t\u000bA\u0002\u0005\u0019\u0001\u0014\t\u000by!C\u0011A#\u0015\u0005\r2\u0005\"\u0002\u0019E\u0001\u00041\u0003\"\u0002%%\t\u0003J\u0015A\u00039sKR$\u0018PT1nKV\t!\n\u0005\u0002L\u001d:\u0011Q\u0003T\u0005\u0003\u001bZ\ta\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011QJ\u0006\u0005\u0006%\u0012\"\teU\u0001\u0005KZ\fG\u000e\u0006\u0002U/B\u0011Q#V\u0005\u0003-Z\u00111!\u00118z\u0011\u001dA\u0016\u000b%AA\u0002e\u000bQ!\u001b8qkR\u0004\"AW.\u000e\u0003\u0011I!\u0001\u0018\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006=\u0012\"\teX\u0001\nI><UM\\\"pI\u0016$2\u0001\u00194l!\t\tG-D\u0001c\u0015\t\u0019'!A\u0004d_\u0012,w-\u001a8\n\u0005\u0015\u0014'\u0001C#yaJ\u001cu\u000eZ3\t\u000b\u001dl\u0006\u0019\u00015\u0002\u0007\r$\b\u0010\u0005\u0002bS&\u0011!N\u0019\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015aW\f1\u0001a\u0003\t)g\u000fC\u0004oI\u0005\u0005I\u0011A8\u0002\t\r|\u0007/\u001f\u000b\u0004GA\f\bb\u0002\u0019n!\u0003\u0005\rA\n\u0005\bk5\u0004\n\u00111\u00018\u0011\u001d\u0019H%%A\u0005\u0002Q\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001vU\t1coK\u0001x!\tAX0D\u0001z\u0015\tQ80A\u0005v]\u000eDWmY6fI*\u0011APF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001@z\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u0003!\u0013\u0013!C\u0001\u0003\u0007\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0006)\u0012qG\u001e\u0005\n\u0003\u0013!\u0013\u0011!C!\u0003\u0017\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0007!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\tA\u0001\\1oO*\u0011\u0011qC\u0001\u0005U\u00064\u0018-C\u0002P\u0003#A\u0011\"!\b%\u0003\u0003%\t!a\b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0005\u0002cA\u000b\u0002$%\u0019\u0011Q\u0005\f\u0003\u0007%sG\u000fC\u0005\u0002*\u0011\n\t\u0011\"\u0001\u0002,\u0005q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001+\u0002.!Q\u0011qFA\u0014\u0003\u0003\u0005\r!!\t\u0002\u0007a$\u0013\u0007C\u0005\u00024\u0011\n\t\u0011\"\u0011\u00026\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00028A)\u0011\u0011HA )6\u0011\u00111\b\u0006\u0004\u0003{1\u0012AC2pY2,7\r^5p]&!\u0011\u0011IA\u001e\u0005!IE/\u001a:bi>\u0014\b\"CA#I\u0005\u0005I\u0011AA$\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA%\u0003\u001f\u00022!FA&\u0013\r\tiE\u0006\u0002\b\u0005>|G.Z1o\u0011%\ty#a\u0011\u0002\u0002\u0003\u0007A\u000bC\u0005\u0002T\u0011\n\t\u0011\"\u0011\u0002V\u00051Q-];bYN$B!!\u0013\u0002X!I\u0011qFA)\u0003\u0003\u0005\r\u0001\u0016\u0015\u0014I\u0005m\u0013\u0011MA2\u0003O\nI'!\u001c\u0002p\u0005M\u0014Q\u000f\t\u0004!\u0005u\u0013bAA0\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA3\u0003\t\u0005(\u0002\t\u0011!A}3UKT\"`QM$(/\u000b\u0011.AI+Wn\u001c<fg\u0002\"\b.\u001a\u0011mK\u0006$\u0017N\\4!C:$\u0007\u0005\u001e:bS2Lgn\u001a\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b\"P)\"\u0003CO]5n'R\u0014\bE\u0012*P\u001b\u0002\u001aHO]\u0015![\u0001\u0012V-\\8wK\u0002\"\b.\u001a\u0011mK\u0006$\u0017N\\4!C:$\u0007\u0005\u001e:bS2Lgn\u001a\u0011aiJLWn\u0015;sA\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002T!\u0002\t\u0011!A}3UKT\"`Q1+\u0015\tR%O\u000f\u0002\"(/[7TiJ\u0004cIU(NAM$(/\u000b\u0011.AI+Wn\u001c<fAQDW\r\t7fC\u0012Lgn\u001a\u0011aiJLWn\u0015;sA\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002T!\u0002\t\u0011!A}3UKT\"`QQ\u0013\u0016)\u0013'J\u001d\u001e\u0003CO]5n'R\u0014\bE\u0012*P\u001b\u0002\u001aHO]\u0015![\u0001\u0012V-\\8wK\u0002\"\b.\u001a\u0011ue\u0006LG.\u001b8hA\u0001$(/[7TiJ\u0004\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011agR\u0014\bM\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002l\u0005\u00199P\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011ue&l7\u000b\u001e:![\u0001\"\b.\u001a\u0011ue&l\u0007e\u001d;sS:<\u0007e\u00195be\u0006\u001cG/\u001a:tAQ|\u0007\u0005\u001e:j[2\u0002C\u000f[3!I\u00164\u0017-\u001e7uAY\fG.^3!SN\u0004\u0013\rI:j]\u001edW\rI:qC\u000e,'\u0002\t\u0011!A\u0001\u0002#\u0006\t\"P)\"c\u0003E\u0012*P\u001b\u0002j\u0003\u0005\u001e5fg\u0016\u0004\u0013M]3!W\u0016Lxo\u001c:eg\u0002\"x\u000eI:qK\u000eLg-\u001f\u0011ue&lW.\u001b8hAM$(/\u001b8hA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004#m\u001c;iA\u0015tGm\u001d\u0011pM*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t;iK\u0002\u001aHO]5oO*\u0001\u0003\u0005\t\u0011!A)\u0002C*R!E\u0013:;E\u0006\t$S\u001f6\u0003S\u0006\t;iKN,\u0007%\u0019:fA-,\u0017p^8sIN\u0004Co\u001c\u0011ta\u0016\u001c\u0017NZ=!iJLW.\\5oO\u0002\u001aHO]5oO\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005\u001e5fA1,g\r\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001*g\u000e\u001a\u0011pM\u0002\"\b.\u001a\u0011tiJLgn\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0016!)J\u000b\u0015\nT%O\u000f2\u0002cIU(NA5\u0002C\u000f[3tK\u0002\n'/\u001a\u0011lKf<xN\u001d3tAQ|\u0007e\u001d9fG&4\u0017\u0010\t;sS6l\u0017N\\4!gR\u0014\u0018N\\4!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\"\b.\u001a\u0011sS\u001eDGO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0015tG\rI8gAQDW\rI:ue&twM\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA9\u0003\t-&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014!A\u0001\u00023\u000b]1sWN\u000bF\n\t\u0011!O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OMcu\u0005\f\u0011('N\u0003\u0018M]6T#2\u001bv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148nU)\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\t{E\u000b\u0013\u0011('2;\u0003E\u0012*P\u001b\u0002:3k\u00159be.\u001c\u0016\u000bT*(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003/\u0019:l'FS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006T#B\t&su\tI\u0014T\u0019\u001e\u0002cIU(NA\u001d\u001a6\u000b]1sWN\u000bFjU\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0018M]6T#2\u001b&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b+S\u0003&c\u0015JT$!OMcu\u0005\t$S\u001f6\u0003seU*qCJ\\7+\u0015'TO%Z$\u0002\t\u0011!A\u0001\u0002\u0003eU*qCJ\\7+\u0015\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qO\u0001\u0006c9*d\u0006\r\u0005\u0007\u0003w\u0002\u0003\u0019\u0001\u0014\u0002\u0007M$(\u000fC\u00036A\u0001\u0007a\u0005\u0003\u0004\"#\u0011\u0005\u0011\u0011\u0011\u000b\u0004G\u0005\r\u0005bBA>\u0003\u007f\u0002\rA\n\u0005\tCE\t\t\u0011\"!\u0002\bR)1%!#\u0002\f\"1\u0001'!\"A\u0002\u0019B\u0001\"NAC!\u0003\u0005\ra\u000e\u0005\n\u0003\u001f\u000b\u0012\u0011!CA\u0003#\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0014\u0006m\u0005\u0003B\u000b9\u0003+\u0003R!FALM]J1!!'\u0017\u0005\u0019!V\u000f\u001d7fe!I\u0011QTAG\u0003\u0003\u0005\raI\u0001\u0004q\u0012\u0002\u0004\"CAQ#E\u0005I\u0011AA\u0002\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011QU\t\u0012\u0002\u0013\u0005\u00111A\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011\u0011V\t\u0002\u0002\u0013%\u00111V\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002.B!\u0011qBAX\u0013\u0011\t\t,!\u0005\u0003\r=\u0013'.Z2u\u0001")
public class StringTrim
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> apply$default$2() {
        return StringTrim$.MODULE$.apply$default$2();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrim$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrim stringTrim) {
        return StringTrim$.MODULE$.unapply(stringTrim);
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression$class.children(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression$class.dataType(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression$class.inputTypes(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression$class.nullable(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression$class.foldable(this);
    }

    @Override
    public String sql() {
        return String2TrimExpression$class.sql(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "trim";
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trim((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trim());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final CodegenContext ctx$3;

            public final ExprCode apply(Expression x$30) {
                return x$30.genCode(this.ctx$3);
            }
            {
                this.ctx$3 = ctx$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Block apply(ExprCode x$31) {
                    return x$31.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trim();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimFunction = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trim(", ");\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trimString.isNull(), ev.isNull(), ev.value(), srcString.value(), trimString.value()}));
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Block apply(ExprCode x$32) {
                    return x$32.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrim copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrim(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrim";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.trimStr();
                break;
            }
            case 0: {
                object = this.srcStr();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrim)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrim stringTrim = (StringTrim)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrim.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrim.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrim.canEqual(this)) return false;
        return true;
    }

    public StringTrim(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes$class.$init$(this);
        String2TrimExpression$class.$init$(this);
    }

    public StringTrim(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrim(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

