/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringLPad$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, len, pad) - Returns `str`, left-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       ???hi\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u0001>\u0011!b\u0015;sS:<G\nU1e\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u0011)]i\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0019=%\u0011q$\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005\u00191\u000f\u001e:\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0003tiJ\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u00071,g\u000e\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u0011aWM\u001c\u0011\t\u00115\u0002!Q3A\u0005\u0002\t\n1\u0001]1e\u0011!y\u0003A!E!\u0002\u0013\u0019\u0013\u0001\u00029bI\u0002BQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtD\u0003B\u001a5kY\u0002\"!\u0005\u0001\t\u000b\u0005\u0002\u0004\u0019A\u0012\t\u000b%\u0002\u0004\u0019A\u0012\t\u000b5\u0002\u0004\u0019A\u0012\t\u000ba\u0002A\u0011I\u001d\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A\u000f\t\u0004w\r\u001bcB\u0001\u001fB\u001d\ti\u0004)D\u0001?\u0015\tyd\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011!)G\u0001\ba\u0006\u001c7.Y4f\u0013\t!UIA\u0002TKFT!AQ\r\t\u000b\u001d\u0003A\u0011\t%\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u001a\tQ\u0001^=qKNL!AT&\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ\u0001\u0015\u0001\u0005BE\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0011\u0006cA\u001eD\u0013\")A\u000b\u0001C!+\u0006aa.\u001e7m'\u00064W-\u0012<bYR!a+\u0017.\\!\tAr+\u0003\u0002Y3\t\u0019\u0011I\\=\t\u000b\u0005\u001a\u0006\u0019\u0001,\t\u000b%\u001a\u0006\u0019\u0001,\t\u000b5\u001a\u0006\u0019\u0001,\t\u000bu\u0003A\u0011\u000b0\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA0fUB\u0011\u0001mY\u0007\u0002C*\u0011!MA\u0001\bG>$WmZ3o\u0013\t!\u0017M\u0001\u0005FqB\u00148i\u001c3f\u0011\u00151G\f1\u0001h\u0003\r\u0019G\u000f\u001f\t\u0003A\"L!![1\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")1\u000e\u0018a\u0001?\u0006\u0011QM\u001e\u0005\u0006[\u0002!\tE\\\u0001\u000baJ,G\u000f^=OC6,W#A8\u0011\u0005A\u001chB\u0001\rr\u0013\t\u0011\u0018$\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:\u001a\u0011\u001d9\b!!A\u0005\u0002a\fAaY8qsR!1'\u001f>|\u0011\u001d\tc\u000f%AA\u0002\rBq!\u000b<\u0011\u0002\u0003\u00071\u0005C\u0004.mB\u0005\t\u0019A\u0012\t\u000fu\u0004\u0011\u0013!C\u0001}\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A@+\u0007\r\n\ta\u000b\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011!C;oG\",7m[3e\u0015\r\ti!G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\t\u0003\u000f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011!\t)\u0002AI\u0001\n\u0003q\u0018AD2paf$C-\u001a4bk2$HE\r\u0005\t\u00033\u0001\u0011\u0013!C\u0001}\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\"CA\u000f\u0001\u0005\u0005I\u0011IA\u0010\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0005\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0012\u0001\u00026bm\u0006L1\u0001^A\u0013\u0011%\t\t\u0004AA\u0001\n\u0003\t\u0019$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00026A\u0019\u0001$a\u000e\n\u0007\u0005e\u0012DA\u0002J]RD\u0011\"!\u0010\u0001\u0003\u0003%\t!a\u0010\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a+!\u0011\t\u0015\u0005\r\u00131HA\u0001\u0002\u0004\t)$A\u0002yIEB\u0011\"a\u0012\u0001\u0003\u0003%\t%!\u0013\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0013\u0011\u000b\u00055\u00131\u000b,\u000e\u0005\u0005=#bAA)3\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0013q\n\u0002\t\u0013R,'/\u0019;pe\"I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00111L\u0001\tG\u0006tW)];bYR!\u0011QLA2!\rA\u0012qL\u0005\u0004\u0003CJ\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0007\n9&!AA\u0002YC\u0011\"a\u001a\u0001\u0003\u0003%\t%!\u001b\u0002\r\u0015\fX/\u00197t)\u0011\ti&a\u001b\t\u0013\u0005\r\u0013QMA\u0001\u0002\u00041\u0006f\u0003\u0001\u0002p\u0005U\u0014qOA>\u0003{\u00022!EA9\u0013\r\t\u0019H\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tI(AA4\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue2\u0002C.\u001a8-AA\fG-\u000b\u0011.AI+G/\u001e:og\u0002\u00027\u000f\u001e:aY\u0001bWM\u001a;.a\u0006$G-\u001a3!o&$\b\u000e\t1qC\u0012\u0004\u0007\u0005^8!C\u0002bWM\\4uQ\u0002zg\r\t1mK:\u0004gF\u0003\u0011!A\u0001\u0002\u0003%\u00134!AN$(\u000f\u0019\u0011jg\u0002bwN\\4fe\u0002\"\b.\u00198!A2,g\u000e\u0019\u0017!i\",\u0007E]3ukJt\u0007E^1mk\u0016\u0004\u0013n\u001d\u0011tQ>\u0014H/\u001a8fI\u0002\"x\u000e\t1mK:\u0004\u0007e\u00195be\u0006\u001cG/\u001a:t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty(A:\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dB\u0017n\n\u0017!k1\u0002seP (SmR\u0001\u0005\t\u0011!A\u0001\u0002shP iS*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005[5(Y\u0001\nD\u0006I\u0014@\u007f\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t5\u000bA\u0001:\u0011\"a!\u0003\u0003\u0003E\t!!\"\u0002\u0015M#(/\u001b8h\u0019B\u000bG\rE\u0002\u0012\u0003\u000f3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011R\n\u0006\u0003\u000f\u000bY)\b\t\t\u0003\u001b\u000b\u0019jI\u0012$g5\u0011\u0011q\u0012\u0006\u0004\u0003#K\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003+\u000byIA\tBEN$(/Y2u\rVt7\r^5p]NBq!MAD\t\u0003\tI\n\u0006\u0002\u0002\u0006\"Q\u0011QTAD\u0003\u0003%)%a(\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\t\t\u0015\u0005\r\u0016qQA\u0001\n\u0003\u000b)+A\u0003baBd\u0017\u0010F\u00044\u0003O\u000bI+a+\t\r\u0005\n\t\u000b1\u0001$\u0011\u0019I\u0013\u0011\u0015a\u0001G!1Q&!)A\u0002\rB!\"a,\u0002\b\u0006\u0005I\u0011QAY\u0003\u001d)h.\u00199qYf$B!a-\u0002@B)\u0001$!.\u0002:&\u0019\u0011qW\r\u0003\r=\u0003H/[8o!\u0019A\u00121X\u0012$G%\u0019\u0011QX\r\u0003\rQ+\b\u000f\\34\u0011%\t\t-!,\u0002\u0002\u0003\u00071'A\u0002yIAB!\"!2\u0002\b\u0006\u0005I\u0011BAd\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005%\u0007\u0003BA\u0012\u0003\u0017LA!!4\u0002&\t1qJ\u00196fGR\u0004")
public class StringLPad
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression str;
    private final Expression len;
    private final Expression pad;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringLPad stringLPad) {
        return StringLPad$.MODULE$.unapply(stringLPad);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringLPad> tupled() {
        return StringLPad$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringLPad>>> curried() {
        return StringLPad$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression len() {
        return this.len;
    }

    public Expression pad() {
        return this.pad;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.len();
        Expression expression3 = this.pad();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object str, Object len, Object pad) {
        return ((UTF8String)str).lpad(BoxesRunTime.unboxToInt((Object)len), (UTF8String)pad);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String str, String len, String pad) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".lpad(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str, len, pad}));
            }
        });
    }

    @Override
    public String prettyName() {
        return "lpad";
    }

    public StringLPad copy(Expression str, Expression len, Expression pad) {
        return new StringLPad(str, len, pad);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.len();
    }

    public Expression copy$default$3() {
        return this.pad();
    }

    @Override
    public String productPrefix() {
        return "StringLPad";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.pad();
                break;
            }
            case 1: {
                expression = this.len();
                break;
            }
            case 0: {
                expression = this.str();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringLPad;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringLPad)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringLPad stringLPad = (StringLPad)x$1;
        Expression expression = this.str();
        Expression expression2 = stringLPad.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.len();
        Expression expression4 = stringLPad.len();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.pad();
        Expression expression6 = stringLPad.pad();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringLPad.canEqual(this)) return false;
        return true;
    }

    public StringLPad(Expression str, Expression len, Expression pad) {
        this.str = str;
        this.len = len;
        this.pad = pad;
        ExpectsInputTypes$class.$init$(this);
    }
}

