/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RLike$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ regexp - Returns true if `str` matches `regexp`, or false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * regexp - a string expression. The pattern string should be a Java regular expression.\n\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".\n\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n  ", examples="\n    Examples:\n      When spark.sql.parser.escapedStringLiterals is disabled (default).\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '%SystemDrive%\\\\Users.*'\n      true\n\n      When spark.sql.parser.escapedStringLiterals is enabled.\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '%SystemDrive%\\Users.*'\n      true\n  ", note="\n    Use LIKE to match with simple string pattern.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001>\u0011QA\u0015'jW\u0016T!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A!\"\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t)2\u000b\u001e:j]\u001e\u0014VmZ3y\u000bb\u0004(/Z:tS>t\u0007CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"a\u0002)s_\u0012,8\r\u001e\t\u0003+mI!\u0001\b\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011y\u0001!Q3A\u0005\u0002}\tA\u0001\\3giV\t\u0001\u0005\u0005\u0002\u0012C%\u0011!E\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u0013\u0001\u0005#\u0005\u000b\u0011\u0002\u0011\u0002\u000b1,g\r\u001e\u0011\t\u0011\u0019\u0002!Q3A\u0005\u0002}\tQA]5hQRD\u0001\u0002\u000b\u0001\u0003\u0012\u0003\u0006I\u0001I\u0001\u0007e&<\u0007\u000e\u001e\u0011\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\raSF\f\t\u0003#\u0001AQAH\u0015A\u0002\u0001BQAJ\u0015A\u0002\u0001BQ\u0001\r\u0001\u0005BE\na!Z:dCB,GC\u0001\u001a:!\t\u0019dG\u0004\u0002\u0016i%\u0011QGF\u0001\u0007!J,G-\u001a4\n\u0005]B$AB*ue&twM\u0003\u00026-!)!h\fa\u0001e\u0005\ta\u000fC\u0003=\u0001\u0011\u0005S(A\u0004nCR\u001c\u0007.Z:\u0015\u0007y\nE\n\u0005\u0002\u0016\u007f%\u0011\u0001I\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015\u00115\b1\u0001D\u0003\u0015\u0011XmZ3y!\t!%*D\u0001F\u0015\t\u0011eI\u0003\u0002H\u0011\u0006!Q\u000f^5m\u0015\u0005I\u0015\u0001\u00026bm\u0006L!aS#\u0003\u000fA\u000bG\u000f^3s]\")Qj\u000fa\u0001e\u0005\u00191\u000f\u001e:\t\u000b=\u0003A\u0011\t)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\r\u0005\u0006%\u0002!\tfU\u0001\nI><UM\\\"pI\u0016$2\u0001\u0016.`!\t)\u0006,D\u0001W\u0015\t9&!A\u0004d_\u0012,w-\u001a8\n\u0005e3&\u0001C#yaJ\u001cu\u000eZ3\t\u000bm\u000b\u0006\u0019\u0001/\u0002\u0007\r$\b\u0010\u0005\u0002V;&\u0011aL\u0016\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015\u0001\u0017\u000b1\u0001U\u0003\t)g\u000fC\u0004c\u0001\u0005\u0005I\u0011A2\u0002\t\r|\u0007/\u001f\u000b\u0004Y\u0011,\u0007b\u0002\u0010b!\u0003\u0005\r\u0001\t\u0005\bM\u0005\u0004\n\u00111\u0001!\u0011\u001d9\u0007!%A\u0005\u0002!\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001jU\t\u0001#nK\u0001l!\ta\u0017/D\u0001n\u0015\tqw.A\u0005v]\u000eDWmY6fI*\u0011\u0001OF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001:n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\bi\u0002\t\n\u0011\"\u0001i\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIBqA\u001e\u0001\u0002\u0002\u0013\u0005s/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002qB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010S\u0001\u0005Y\u0006tw-\u0003\u00028u\"9a\u0010AA\u0001\n\u0003y\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0001!\r)\u00121A\u0005\u0004\u0003\u000b1\"aA%oi\"I\u0011\u0011\u0002\u0001\u0002\u0002\u0013\u0005\u00111B\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti!a\u0005\u0011\u0007U\ty!C\u0002\u0002\u0012Y\u00111!\u00118z\u0011)\t)\"a\u0002\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0004q\u0012\n\u0004\"CA\r\u0001\u0005\u0005I\u0011IA\u000e\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u000f!\u0019\ty\"!\n\u0002\u000e5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G1\u0012AC2pY2,7\r^5p]&!\u0011qEA\u0011\u0005!IE/\u001a:bi>\u0014\b\"CA\u0016\u0001\u0005\u0005I\u0011AA\u0017\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001 \u00020!Q\u0011QCA\u0015\u0003\u0003\u0005\r!!\u0004\t\u0013\u0005M\u0002!!A\u0005B\u0005U\u0012AB3rk\u0006d7\u000fF\u0002?\u0003oA!\"!\u0006\u00022\u0005\u0005\t\u0019AA\u0007QM\u0001\u00111HA!\u0003\u0007\n9%!\u0013\u0002N\u0005=\u00131KA+!\r\t\u0012QH\u0005\u0004\u0003\u007f\u0011!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u000b\nqj\u001d;sA}3UKT\"`AI,w-\u001a=qA5\u0002#+\u001a;ve:\u001c\b\u0005\u001e:vK\u0002Jg\r\t1tiJ\u0004\u0007%\\1uG\",7\u000f\t1sK\u001e,\u0007\u0010\u001d1-A=\u0014\bEZ1mg\u0016\u0004s\u000e\u001e5fe^L7/\u001a\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA&\u0003\u0011u'\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tiJ\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t'\u0002\t\u0011!A\u0001\u0002#\u0006\t:fO\u0016D\b\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!)\",\u0007\u0005]1ui\u0016\u0014h\u000eI:ue&tw\rI:i_VdG\r\t2fA\u0005\u0004#*\u0019<bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018\u000b\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003eU5oG\u0016\u00043\u000b]1sW\u0002\u0012d\u0006\r\u0017!gR\u0014\u0018N\\4!Y&$XM]1mg\u0002B\u0013N\\2mk\u0012Lgn\u001a\u0011sK\u001e,\u0007\u0010\t9biR,'O\\:*A\u0005\u0014X\rI;oKN\u001c\u0017\r]3eA%t\u0007e\\;sAM\u000bFJ\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AA\f'o]3s]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-AQ|\u0007%\\1uG\"\u0004#\u0005X1cG\nb\u0003%\u0019\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t\u0007EZ8sA\u0001\u0014XmZ3ya\u0002\u00043-\u00198!E\u0016T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011#=rc\u0016MY2%E9R!\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!)\",'/\u001a\u0011jg\u0002\n\u0007eU)MA\r|gNZ5hA\u001d\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u0014!i\"\fG\u000fI2b]\u0002\u0012W\rI;tK\u0012\u0004Co\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012\u0017\r\u001c7cC\u000e\\\u0007\u0005^8!i\",\u0007e\u00159be.\u0004\u0013G\f\u001c!E\u0016D\u0017M^5pe\u0002\u0012XmZ1sI&tw\rI:ue&tw\r\t7ji\u0016\u0014\u0018\r\u001c\u0011qCJ\u001c\u0018N\\4/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013N\u001a\u0011uQ\u0016\u00043m\u001c8gS\u001e\u0004\u0013n\u001d\u0011f]\u0006\u0014G.\u001a3-AQDW\r\t1sK\u001e,\u0007\u0010\u001d1!i\"\fG\u000fI2b]\u0002j\u0017\r^2iA\tb\u0016MY2#A%\u001c\bE\t0]C\n\u001cGE\t\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003#\n!Q\u0011\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005I,iK:\u00043\u000f]1sW:\u001a\u0018\u000f\u001c\u0018qCJ\u001cXM\u001d\u0018fg\u000e\f\u0007/\u001a3TiJLgn\u001a'ji\u0016\u0014\u0018\r\\:!SN\u0004C-[:bE2,G\r\t\u0015eK\u001a\fW\u000f\u001c;*])\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003s%J*zgR,W\u000e\u0012:jm\u0016,C,V:feNd&j\u001c5oO\u0001zf)\u0016(D?\u0002:SeU=ti\u0016lGI]5wK\u0016bF,V:feNt#f\n\u0006!A\u0001\u0002\u0003\u0005\t;sk\u0016T!\u0002\t\u0011!A\u0001\u0002s\u000b[3oAM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7\u000fI5tA\u0015t\u0017M\u00197fI:R\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006eJ\u0013TsN$X-\u001c#sSZ,W\u0005X+tKJ\u001cHLS8i]\u001e\u0002sLR+O\u0007~\u0003s%J*zgR,W\u000e\u0012:jm\u0016,C,V:feNt#f\n\u0006!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002X\u0005)$\u0002\t\u0011!AU\u001bX\r\t'J\u0017\u0016\u0003Co\u001c\u0011nCR\u001c\u0007\u000eI<ji\"\u00043/[7qY\u0016\u00043\u000f\u001e:j]\u001e\u0004\u0003/\u0019;uKJtgF\u0003\u0011!\u000f%\tYFAA\u0001\u0012\u0003\ti&A\u0003S\u0019&\\W\rE\u0002\u0012\u0003?2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011M\n\u0006\u0003?\n\u0019G\u0007\t\b\u0003K\nY\u0007\t\u0011-\u001b\t\t9GC\u0002\u0002jY\tqA];oi&lW-\u0003\u0003\u0002n\u0005\u001d$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9!&a\u0018\u0005\u0002\u0005EDCAA/\u0011%y\u0015qLA\u0001\n\u000b\n)\bF\u0001y\u0011)\tI(a\u0018\u0002\u0002\u0013\u0005\u00151P\u0001\u0006CB\u0004H.\u001f\u000b\u0006Y\u0005u\u0014q\u0010\u0005\u0007=\u0005]\u0004\u0019\u0001\u0011\t\r\u0019\n9\b1\u0001!\u0011)\t\u0019)a\u0018\u0002\u0002\u0013\u0005\u0015QQ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9)a%\u0011\u000bU\tI)!$\n\u0007\u0005-eC\u0001\u0004PaRLwN\u001c\t\u0006+\u0005=\u0005\u0005I\u0005\u0004\u0003#3\"A\u0002+va2,'\u0007C\u0005\u0002\u0016\u0006\u0005\u0015\u0011!a\u0001Y\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005e\u0015qLA\u0001\n\u0013\tY*A\u0006sK\u0006$'+Z:pYZ,GCAAO!\rI\u0018qT\u0005\u0004\u0003CS(AB(cU\u0016\u001cG\u000f")
public class RLike
extends StringRegexExpression
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(RLike rLike) {
        return RLike$.MODULE$.unapply(rLike);
    }

    public static Function1<Tuple2<Expression, Expression>, RLike> tupled() {
        return RLike$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RLike>> curried() {
        return RLike$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return v;
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).find(0);
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " RLIKE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left(), this.right()}));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal == null) {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String regexStr = StringEscapeUtils.escapeJava((String)((UTF8String)rVal).toString());
                String pattern = ctx.addMutableState(patternClass, "patternRLike", (Function1<String, String>)new Serializable(this, patternClass, regexStr){
                    public static final long serialVersionUID = 0L;
                    private final String patternClass$2;
                    private final String regexStr$2;

                    public final String apply(String v) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".compile(\"", "\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v, this.patternClass$2, this.regexStr$2}));
                    }
                    {
                        this.patternClass$2 = patternClass$2;
                        this.regexStr$2 = regexStr$2;
                    }
                }, ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval2 = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).find(0);\n          }\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), eval2.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval2.value()})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String rightStr = ctx.freshName("rightStr");
            String pattern = ctx.freshName("pattern");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev, patternClass, rightStr, pattern){
                public static final long serialVersionUID = 0L;
                private final ExprCode ev$2;
                private final String patternClass$2;
                private final String rightStr$2;
                private final String pattern$2;

                public final String apply(String eval1, String eval2) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          String ", " = ", ".toString();\n          ", " ", " = ", ".compile(", ");\n          ", " = ", ".matcher(", ".toString()).find(0);\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rightStr$2, eval2, this.patternClass$2, this.pattern$2, this.patternClass$2, this.rightStr$2, this.ev$2.value(), this.pattern$2, eval1}));
                }
                {
                    this.ev$2 = ev$2;
                    this.patternClass$2 = patternClass$2;
                    this.rightStr$2 = rightStr$2;
                    this.pattern$2 = pattern$2;
                }
            });
        }
        return exprCode;
    }

    public RLike copy(Expression left, Expression right) {
        return new RLike(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RLike";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RLike;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RLike)) return false;
        boolean bl = true;
        if (!bl) return false;
        RLike rLike = (RLike)x$1;
        Expression expression = this.left();
        Expression expression2 = rLike.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = rLike.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!rLike.canEqual(this)) return false;
        return true;
    }

    public RLike(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

