/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import org.apache.spark.sql.catalyst.JavaTypeInference$;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedExtractValue;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$$anonfun$5$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.objects.AssertNotNull;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class ExpressionEncoder$
implements Serializable {
    public static final ExpressionEncoder$ MODULE$;

    static {
        new ExpressionEncoder$();
    }

    public <T> ExpressionEncoder<T> apply(TypeTags.TypeTag<T> evidence$1) {
        JavaUniverse.JavaMirror mirror = ScalaReflection$.MODULE$.mirror();
        Types.TypeApi tpe = ((TypeTags)package$.MODULE$.universe()).typeTag(evidence$1).in((Mirror)mirror).tpe();
        if (ScalaReflection$.MODULE$.optionOfProductType(tpe)) {
            throw new UnsupportedOperationException("Cannot create encoder for Option of Product type, because Product type is represented as a row, and the entire row can not be null in Spark SQL like normal databases. You can wrap your type with Tuple1 if you do want top level null Product objects, e.g. instead of creating `Dataset[Option[MyClass]]`, you can do something like `val ds: Dataset[Tuple1[MyClass]] = Seq(Tuple1(MyClass(...)), Tuple1(null)).toDS`");
        }
        Class cls = (Class)mirror.runtimeClass(tpe);
        boolean flat = !ScalaReflection$.MODULE$.definedByConstructorParams(tpe);
        BoundReference inputObject = new BoundReference(0, ScalaReflection$.MODULE$.dataTypeFor(evidence$1), !cls.isPrimitive());
        Expression nullSafeInput = flat ? inputObject : new AssertNotNull(inputObject, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"top level Product input object"}))));
        CreateNamedStruct serializer = ScalaReflection$.MODULE$.serializerFor(nullSafeInput, evidence$1);
        Expression deserializer = ScalaReflection$.MODULE$.deserializerFor(evidence$1);
        StructType schema = serializer.dataType();
        return new ExpressionEncoder(schema, flat, serializer.flatten(), deserializer, ClassTag$.MODULE$.apply(cls));
    }

    public <T> ExpressionEncoder<T> javaBean(Class<T> beanClass) {
        DataType schema = (DataType)JavaTypeInference$.MODULE$.inferDataType(beanClass)._1();
        Predef$.MODULE$.assert(schema instanceof StructType);
        CreateNamedStruct serializer = JavaTypeInference$.MODULE$.serializerFor(beanClass);
        Expression deserializer = JavaTypeInference$.MODULE$.deserializerFor(beanClass);
        return new ExpressionEncoder((StructType)schema, false, serializer.flatten(), deserializer, ClassTag$.MODULE$.apply(beanClass));
    }

    public ExpressionEncoder<?> tuple(Seq<ExpressionEncoder<?>> encoders) {
        encoders.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ExpressionEncoder<?> x$1) {
                x$1.assertUnresolved();
            }
        });
        StructType schema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)((TraversableLike)encoders.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(Tuple2<ExpressionEncoder<?>, Object> x0$1) {
                Tuple2<ExpressionEncoder<?>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    ExpressionEncoder e = (ExpressionEncoder)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Tuple2 tuple23 = tuple22 = e.flat() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((StructField)e.schema().head()).dataType()), (Object)BoxesRunTime.boxToBoolean((boolean)((StructField)e.schema().head()).nullable())) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.schema()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    if (tuple22 != null) {
                        Tuple2 tuple24;
                        DataType dataType2 = (DataType)tuple22._1();
                        boolean nullable2 = tuple22._2$mcZ$sp();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)dataType2, (Object)BoxesRunTime.boxToBoolean((boolean)nullable2));
                        DataType dataType3 = (DataType)tuple25._1();
                        boolean nullable3 = tuple25._2$mcZ$sp();
                        StructField structField2 = new StructField(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1))})), dataType3, nullable3, StructField$.MODULE$.apply$default$4());
                        return structField2;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())));
        Class<?> cls = Utils$.MODULE$.getContextOrSparkClassLoader().loadClass(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala.Tuple", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)encoders.size())})));
        Seq serializer = (Seq)((TraversableLike)encoders.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(cls){
            public static final long serialVersionUID = 0L;
            private final Class cls$1;

            public final Alias apply(Tuple2<ExpressionEncoder<?>, Object> x0$2) {
                Tuple2<ExpressionEncoder<?>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Expression serializerExpr;
                    Expression expression;
                    ExpressionEncoder enc = (ExpressionEncoder)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    BoundReference originalInputObject = (BoundReference)((TreeNode)enc.serializer().head()).collect(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof BoundReference) {
                                BoundReference boundReference = (BoundReference)A1;
                                object = boundReference;
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Expression expression = x1;
                            boolean bl = expression instanceof BoundReference;
                            return bl;
                        }
                    }).head();
                    Invoke newInputObject = new Invoke(new BoundReference(0, new ObjectType(this.cls$1), true), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(index + 1))})), originalInputObject.dataType(), Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6());
                    Seq newSerializer = (Seq)enc.serializer().map((Function1)new Serializable(this, originalInputObject, newInputObject){
                        public static final long serialVersionUID = 0L;
                        public final BoundReference originalInputObject$1;
                        public final Invoke newInputObject$1;

                        public final Expression apply(Expression x$3) {
                            return (Expression)x$3.transformUp(new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$5$$anonfun$6 $outer;

                                /*
                                 * Enabled aggressive block sorting
                                 */
                                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                    Object object;
                                    A1 A1 = x2;
                                    if (A1 instanceof BoundReference) {
                                        BoundReference boundReference;
                                        BoundReference boundReference2 = boundReference = (BoundReference)A1;
                                        BoundReference boundReference3 = this.$outer.originalInputObject$1;
                                        if (!(boundReference2 != null ? !((Object)boundReference2).equals(boundReference3) : boundReference3 != null)) {
                                            object = this.$outer.newInputObject$1;
                                            return (B1)object;
                                        }
                                    }
                                    object = function1.apply(x2);
                                    return (B1)object;
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final boolean isDefinedAt(Expression x2) {
                                    BoundReference boundReference;
                                    Expression expression = x2;
                                    if (!(expression instanceof BoundReference)) return false;
                                    BoundReference boundReference2 = boundReference = (BoundReference)expression;
                                    BoundReference boundReference3 = this.$outer.originalInputObject$1;
                                    if (boundReference2 != null) {
                                        if (!((Object)boundReference2).equals(boundReference3)) return false;
                                        return true;
                                    }
                                    if (boundReference3 == null) return true;
                                    return false;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.originalInputObject$1 = originalInputObject$1;
                            this.newInputObject$1 = newInputObject$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    if (enc.flat()) {
                        expression = (Expression)newSerializer.head();
                    } else {
                        CreateNamedStruct struct = CreateStruct$.MODULE$.apply((Seq<Expression>)newSerializer);
                        Invoke invoke2 = newInputObject;
                        Or nullCheck = new Or(new IsNull(newInputObject), new Invoke(Literal$.MODULE$.fromObject(None$.MODULE$), "equals", BooleanType$.MODULE$, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)invoke2), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6()));
                        expression = new If(nullCheck, Literal$.MODULE$.create(null, struct.dataType()), struct);
                    }
                    Expression x$12 = serializerExpr = expression;
                    String x$13 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(index + 1))}));
                    ExprId x$14 = Alias$.MODULE$.apply$default$3(x$12, x$13);
                    Seq<String> x$15 = Alias$.MODULE$.apply$default$4(x$12, x$13);
                    Option<Metadata> x$16 = Alias$.MODULE$.apply$default$5(x$12, x$13);
                    Alias alias = new Alias(x$12, x$13, x$14, x$15, x$16);
                    return alias;
                }
                throw new MatchError(tuple2);
            }
            {
                this.cls$1 = cls$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq childrenDeserializers = (Seq)((TraversableLike)encoders.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Expression apply(Tuple2<ExpressionEncoder<?>, Object> x0$3) {
                Tuple2<ExpressionEncoder<?>, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Expression expression;
                    ExpressionEncoder enc = (ExpressionEncoder)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (enc.flat()) {
                        expression = (Expression)enc.deserializer().transform(new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final int index$1;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x3;
                                if (A1 instanceof GetColumnByOrdinal) {
                                    GetColumnByOrdinal getColumnByOrdinal = (GetColumnByOrdinal)A1;
                                    object = getColumnByOrdinal.copy(this.index$1, getColumnByOrdinal.copy$default$2());
                                } else {
                                    object = function1.apply(x3);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Expression x3) {
                                Expression expression = x3;
                                boolean bl = expression instanceof GetColumnByOrdinal;
                                return bl;
                            }
                            {
                                this.index$1 = index$1;
                            }
                        });
                    } else {
                        GetColumnByOrdinal input = new GetColumnByOrdinal(index, enc.schema());
                        Expression deserialized = (Expression)enc.deserializer().transformUp(new Serializable(this, input){
                            public static final long serialVersionUID = 0L;
                            private final GetColumnByOrdinal input$1;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x4;
                                if (A1 instanceof UnresolvedAttribute) {
                                    UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)A1;
                                    Seq<String> nameParts = unresolvedAttribute.nameParts();
                                    Predef$.MODULE$.assert(nameParts.length() == 1);
                                    object = new UnresolvedExtractValue(this.input$1, Literal$.MODULE$.apply(nameParts.head()));
                                } else if (A1 instanceof GetColumnByOrdinal) {
                                    GetColumnByOrdinal getColumnByOrdinal = (GetColumnByOrdinal)A1;
                                    int ordinal = getColumnByOrdinal.ordinal();
                                    object = new GetStructField(this.input$1, ordinal, GetStructField$.MODULE$.apply$default$3());
                                } else {
                                    object = function1.apply(x4);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Expression x4) {
                                Expression expression = x4;
                                boolean bl = expression instanceof UnresolvedAttribute ? true : expression instanceof GetColumnByOrdinal;
                                return bl;
                            }
                            {
                                this.input$1 = input$1;
                            }
                        });
                        expression = new If(new IsNull(input), Literal$.MODULE$.create(null, deserialized.dataType()), deserialized);
                    }
                    Expression expression2 = expression;
                    return expression2;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        NewInstance deserializer = NewInstance$.MODULE$.apply(cls, (Seq<Expression>)childrenDeserializers, new ObjectType(cls), false);
        return new ExpressionEncoder(schema, false, (Seq<Expression>)serializer, deserializer, ClassTag$.MODULE$.apply(cls));
    }

    public <T> ExpressionEncoder<Tuple1<T>> tuple(ExpressionEncoder<T> e) {
        return this.tuple((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExpressionEncoder[]{e})));
    }

    public <T1, T2> ExpressionEncoder<Tuple2<T1, T2>> tuple(ExpressionEncoder<T1> e1, ExpressionEncoder<T2> e2) {
        return this.tuple((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExpressionEncoder[]{e1, e2})));
    }

    public <T1, T2, T3> ExpressionEncoder<Tuple3<T1, T2, T3>> tuple(ExpressionEncoder<T1> e1, ExpressionEncoder<T2> e2, ExpressionEncoder<T3> e3) {
        return this.tuple((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExpressionEncoder[]{e1, e2, e3})));
    }

    public <T1, T2, T3, T4> ExpressionEncoder<Tuple4<T1, T2, T3, T4>> tuple(ExpressionEncoder<T1> e1, ExpressionEncoder<T2> e2, ExpressionEncoder<T3> e3, ExpressionEncoder<T4> e4) {
        return this.tuple((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExpressionEncoder[]{e1, e2, e3, e4})));
    }

    public <T1, T2, T3, T4, T5> ExpressionEncoder<Tuple5<T1, T2, T3, T4, T5>> tuple(ExpressionEncoder<T1> e1, ExpressionEncoder<T2> e2, ExpressionEncoder<T3> e3, ExpressionEncoder<T4> e4, ExpressionEncoder<T5> e5) {
        return this.tuple((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExpressionEncoder[]{e1, e2, e3, e4, e5})));
    }

    public <T> ExpressionEncoder<T> apply(StructType schema, boolean flat, Seq<Expression> serializer, Expression deserializer, ClassTag<T> clsTag) {
        return new ExpressionEncoder<T>(schema, flat, serializer, deserializer, clsTag);
    }

    public <T> Option<Tuple5<StructType, Object, Seq<Expression>, Expression, ClassTag<T>>> unapply(ExpressionEncoder<T> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.schema(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.flat()), x$0.serializer(), (Object)x$0.deserializer(), x$0.clsTag()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ExpressionEncoder$() {
        MODULE$ = this;
    }
}

