/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.StreamingJoinHelper$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestampConversion;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper$class;
import org.apache.spark.sql.catalyst.expressions.PromotePrecision;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.TimeAdd;
import org.apache.spark.sql.catalyst.expressions.TimeSub;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.planning.ExtractEquiJoinKeys$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class StreamingJoinHelper$
implements PredicateHelper,
Logging {
    public static final StreamingJoinHelper$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StreamingJoinHelper$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    @Override
    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper$class.splitConjunctivePredicates(this, condition);
    }

    @Override
    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper$class.splitDisjunctivePredicates(this, condition);
    }

    @Override
    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper$class.replaceAlias(this, condition, aliases);
    }

    @Override
    public boolean canEvaluate(Expression expr, LogicalPlan plan2) {
        return PredicateHelper$class.canEvaluate(this, expr, plan2);
    }

    @Override
    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper$class.canEvaluateWithinJoin(this, expr);
    }

    public boolean isWatermarkInJoinKeys(LogicalPlan plan2) {
        boolean bl;
        LogicalPlan logicalPlan = plan2;
        Option<Tuple6<JoinType, Seq<Expression>, Seq<Expression>, Option<Expression>, LogicalPlan, LogicalPlan>> option = ExtractEquiJoinKeys$.MODULE$.unapply(logicalPlan);
        if (option.isEmpty()) {
            bl = false;
        } else {
            Seq leftKeys = (Seq)((Tuple6)option.get())._2();
            Seq rightKeys = (Seq)((Tuple6)option.get())._3();
            bl = ((IterableLike)leftKeys.$plus$plus((GenTraversableOnce)rightKeys, Seq$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Expression x0$1) {
                    boolean bl;
                    Expression expression = x0$1;
                    if (expression instanceof AttributeReference) {
                        AttributeReference attributeReference = (AttributeReference)expression;
                        bl = attributeReference.metadata().contains(EventTimeWatermark$.MODULE$.delayKey());
                    } else {
                        bl = false;
                    }
                    return bl;
                }
            });
        }
        return bl;
    }

    public Option<Object> getStateValueWatermark(AttributeSet attributesToFindStateWatermarkFor, AttributeSet attributesWithEventWatermark, Option<Expression> joinCondition, Option<Object> eventWatermark) {
        if (joinCondition.isEmpty() || eventWatermark.isEmpty()) {
            return None$.MODULE$;
        }
        if (attributesWithEventWatermark.exists((Function1<Attribute, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Attribute x$1) {
                return x$1.metadata().contains(EventTimeWatermark$.MODULE$.delayKey());
            }
        })) {
            Seq allStateWatermarks = (Seq)this.splitConjunctivePredicates((Expression)joinCondition.get()).flatMap((Function1)new Serializable(attributesToFindStateWatermarkFor, attributesWithEventWatermark, joinCondition, eventWatermark){
                public static final long serialVersionUID = 0L;
                private final AttributeSet attributesToFindStateWatermarkFor$1;
                private final AttributeSet attributesWithEventWatermark$1;
                public final Option joinCondition$1;
                private final Option eventWatermark$1;

                public final Iterable<Object> apply(Expression predicate) {
                    None$ none$;
                    Expression expression = predicate;
                    if (expression instanceof LessThan) {
                        LessThan lessThan = (LessThan)expression;
                        Expression l = lessThan.left();
                        Expression r = lessThan.right();
                        none$ = StreamingJoinHelper$.MODULE$.org$apache$spark$sql$catalyst$analysis$StreamingJoinHelper$$getStateWatermarkSafely$1(l, r, this.attributesToFindStateWatermarkFor$1, this.attributesWithEventWatermark$1, this.joinCondition$1, this.eventWatermark$1);
                    } else if (expression instanceof LessThanOrEqual) {
                        LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression;
                        Expression l = lessThanOrEqual.left();
                        Expression r = lessThanOrEqual.right();
                        none$ = StreamingJoinHelper$.MODULE$.org$apache$spark$sql$catalyst$analysis$StreamingJoinHelper$$getStateWatermarkSafely$1(l, r, this.attributesToFindStateWatermarkFor$1, this.attributesWithEventWatermark$1, this.joinCondition$1, this.eventWatermark$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(long x$2) {
                                return this.apply$mcJJ$sp(x$2);
                            }

                            public long apply$mcJJ$sp(long x$2) {
                                return x$2 - 1L;
                            }
                        });
                    } else if (expression instanceof GreaterThan) {
                        GreaterThan greaterThan = (GreaterThan)expression;
                        Expression l = greaterThan.left();
                        Expression r = greaterThan.right();
                        none$ = StreamingJoinHelper$.MODULE$.org$apache$spark$sql$catalyst$analysis$StreamingJoinHelper$$getStateWatermarkSafely$1(r, l, this.attributesToFindStateWatermarkFor$1, this.attributesWithEventWatermark$1, this.joinCondition$1, this.eventWatermark$1);
                    } else if (expression instanceof GreaterThanOrEqual) {
                        GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression;
                        Expression l = greaterThanOrEqual.left();
                        Expression r = greaterThanOrEqual.right();
                        none$ = StreamingJoinHelper$.MODULE$.org$apache$spark$sql$catalyst$analysis$StreamingJoinHelper$$getStateWatermarkSafely$1(r, l, this.attributesToFindStateWatermarkFor$1, this.attributesWithEventWatermark$1, this.joinCondition$1, this.eventWatermark$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(long x$3) {
                                return this.apply$mcJJ$sp(x$3);
                            }

                            public long apply$mcJJ$sp(long x$3) {
                                return x$3 - 1L;
                            }
                        });
                    } else {
                        none$ = None$.MODULE$;
                    }
                    None$ stateWatermark = none$;
                    if (stateWatermark.nonEmpty()) {
                        StreamingJoinHelper$.MODULE$.logInfo((Function0<String>)new Serializable(this, (Option)stateWatermark){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.5 $outer;
                            private final Option stateWatermark$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Condition ", " generated watermark constraint = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.joinCondition$1, this.stateWatermark$1.get()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.stateWatermark$1 = stateWatermark$1;
                            }
                        });
                    }
                    return Option$.MODULE$.option2Iterable((Option)stateWatermark);
                }
                {
                    this.attributesToFindStateWatermarkFor$1 = attributesToFindStateWatermarkFor$1;
                    this.attributesWithEventWatermark$1 = attributesWithEventWatermark$1;
                    this.joinCondition$1 = joinCondition$1;
                    this.eventWatermark$1 = eventWatermark$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            return allStateWatermarks.reduceOption((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(long x, long y) {
                    return this.apply$mcJJJ$sp(x, y);
                }

                public long apply$mcJJJ$sp(long x, long y) {
                    return Math.min(x, y);
                }
            });
        }
        return None$.MODULE$;
    }

    private Option<Object> getStateWatermarkFromLessThenPredicate(Expression leftExpr, Expression rightExpr, AttributeSet attributesToFindStateWatermarkFor, AttributeSet attributesWithEventWatermark, Option<Object> eventWatermark) {
        AttributeSet attributesInCondition = AttributeSet$.MODULE$.apply((Iterable<Expression>)((Iterable)leftExpr.collect(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    object = attributeReference;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof AttributeReference;
                return bl;
            }
        }).$plus$plus(rightExpr.collect(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    object = attributeReference;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof AttributeReference;
                return bl;
            }
        }), Seq$.MODULE$.canBuildFrom())));
        if (((AttributeSet)attributesInCondition.filter((Function1)new Serializable(attributesToFindStateWatermarkFor){
            public static final long serialVersionUID = 0L;
            private final AttributeSet attributesToFindStateWatermarkFor$2;

            public final boolean apply(Attribute x$4) {
                return this.attributesToFindStateWatermarkFor$2.contains(x$4);
            }
            {
                this.attributesToFindStateWatermarkFor$2 = attributesToFindStateWatermarkFor$2;
            }
        })).size() > 1 || ((AttributeSet)attributesInCondition.filter((Function1)new Serializable(attributesWithEventWatermark){
            public static final long serialVersionUID = 0L;
            private final AttributeSet attributesWithEventWatermark$2;

            public final boolean apply(Attribute x$5) {
                return this.attributesWithEventWatermark$2.contains(x$5);
            }
            {
                this.attributesWithEventWatermark$2 = attributesWithEventWatermark$2;
            }
        })).size() > 1) {
            return None$.MODULE$;
        }
        Subtract allOnLeftExpr = new Subtract(leftExpr, rightExpr);
        this.logDebug((Function0<String>)new Serializable(allOnLeftExpr){
            public static final long serialVersionUID = 0L;
            private final Subtract allOnLeftExpr$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All on Left:\\n", "\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.allOnLeftExpr$1.treeString(true, this.allOnLeftExpr$1.treeString$default$2()), this.allOnLeftExpr$1.asCode()}));
            }
            {
                this.allOnLeftExpr$1 = allOnLeftExpr$1;
            }
        });
        ExpressionSet terms = ExpressionSet$.MODULE$.apply((TraversableOnce<Expression>)this.collectTerms(allOnLeftExpr));
        this.logDebug((Function0<String>)new Serializable(terms){
            public static final long serialVersionUID = 0L;
            private final ExpressionSet terms$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Terms extracted from join condition:\n\t").append((Object)this.terms$1.mkString("\n\t")).toString();
            }
            {
                this.terms$1 = terms$1;
            }
        });
        Set constraintTerms = (Set)terms.filter((Function1)new Serializable(attributesToFindStateWatermarkFor){
            public static final long serialVersionUID = 0L;
            private final AttributeSet attributesToFindStateWatermarkFor$2;

            public final boolean apply(Expression e) {
                return StreamingJoinHelper$.MODULE$.org$apache$spark$sql$catalyst$analysis$StreamingJoinHelper$$containsAttributeToFindStateConstraintFor$1(e, this.attributesToFindStateWatermarkFor$2);
            }
            {
                this.attributesToFindStateWatermarkFor$2 = attributesToFindStateWatermarkFor$2;
            }
        });
        if (constraintTerms.size() > 1) {
            this.logWarning((Function0<String>)new Serializable(terms){
                public static final long serialVersionUID = 0L;
                private final ExpressionSet terms$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to extract state constraint terms: multiple time terms in condition\n\t").append((Object)this.terms$1.mkString("\n\t")).toString();
                }
                {
                    this.terms$1 = terms$1;
                }
            });
            return None$.MODULE$;
        }
        if (constraintTerms.isEmpty()) {
            this.logDebug((Function0<String>)new Serializable(terms){
                public static final long serialVersionUID = 0L;
                private final ExpressionSet terms$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to extract state constraint terms: no time terms in condition\n\t").append((Object)this.terms$1.mkString("\n\t")).toString();
                }
                {
                    this.terms$1 = terms$1;
                }
            });
            return None$.MODULE$;
        }
        Expression constraintTerm = (Expression)constraintTerms.head();
        if (constraintTerm.collectFirst(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof UnaryMinus) {
                    UnaryMinus unaryMinus = (UnaryMinus)A1;
                    object = unaryMinus;
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x4) {
                Expression expression = x4;
                boolean bl = expression instanceof UnaryMinus;
                return bl;
            }
        }).isEmpty()) {
            return None$.MODULE$;
        }
        this.logDebug((Function0<String>)new Serializable(constraintTerm){
            public static final long serialVersionUID = 0L;
            private final Expression constraintTerm$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Constraint term from join condition:\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.constraintTerm$1}));
            }
            {
                this.constraintTerm$1 = constraintTerm$1;
            }
        });
        Expression exprWithWatermarkSubstituted = (Expression)((TraversableOnce)terms.$minus(constraintTerm).map(new Serializable(attributesWithEventWatermark, eventWatermark){
            public static final long serialVersionUID = 0L;
            public final AttributeSet attributesWithEventWatermark$2;
            public final Option eventWatermark$2;

            public final Expression apply(Expression term) {
                return (Expression)term.transform(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.7 $outer;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x5;
                        if (A1 instanceof AttributeReference) {
                            AttributeReference attributeReference = (AttributeReference)A1;
                            Metadata metadata2 = attributeReference.metadata();
                            if (this.$outer.attributesWithEventWatermark$2.contains(attributeReference) && metadata2.contains(EventTimeWatermark$.MODULE$.delayKey())) {
                                object = new Multiply(Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToLong((Object)this.$outer.eventWatermark$2.get()))), Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)1000.0)));
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x5);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Expression x5) {
                        Expression expression = x5;
                        if (!(expression instanceof AttributeReference)) return false;
                        AttributeReference attributeReference = (AttributeReference)expression;
                        Metadata metadata2 = attributeReference.metadata();
                        if (!this.$outer.attributesWithEventWatermark$2.contains(attributeReference)) return false;
                        if (!metadata2.contains(EventTimeWatermark$.MODULE$.delayKey())) return false;
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.attributesWithEventWatermark$2 = attributesWithEventWatermark$2;
                this.eventWatermark$2 = eventWatermark$2;
            }
        }, Set$.MODULE$.canBuildFrom())).reduceLeft((Function2)Add$.MODULE$);
        this.logInfo((Function0<String>)new Serializable(exprWithWatermarkSubstituted){
            public static final long serialVersionUID = 0L;
            private final Expression exprWithWatermarkSubstituted$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Final expression to evaluate constraint:\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.exprWithWatermarkSubstituted$1}));
            }
            {
                this.exprWithWatermarkSubstituted$1 = exprWithWatermarkSubstituted$1;
            }
        });
        Double constraintValue = (Double)exprWithWatermarkSubstituted.eval(exprWithWatermarkSubstituted.eval$default$1());
        return new Some((Object)BoxesRunTime.boxToLong((long)((long)(Predef$.MODULE$.Double2double(constraintValue) / 1000.0))));
    }

    private Seq<Expression> collectTerms(Expression exprToCollectFrom) {
        BooleanRef invalid = BooleanRef.create((boolean)false);
        Seq terms = this.collect$1(exprToCollectFrom, false, exprToCollectFrom, invalid);
        return invalid.elem ? (Seq)Seq$.MODULE$.empty() : terms;
    }

    public final Option org$apache$spark$sql$catalyst$analysis$StreamingJoinHelper$$getStateWatermarkSafely$1(Expression l, Expression r, AttributeSet attributesToFindStateWatermarkFor$1, AttributeSet attributesWithEventWatermark$1, Option joinCondition$1, Option eventWatermark$1) {
        None$ none$;
        try {
            none$ = this.getStateWatermarkFromLessThenPredicate(l, r, attributesToFindStateWatermarkFor$1, attributesWithEventWatermark$1, (Option<Object>)eventWatermark$1);
        }
        catch (Throwable throwable) {
            None$ none$2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)new Serializable(joinCondition$1){
                public static final long serialVersionUID = 0L;
                private final Option joinCondition$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error trying to extract state constraint from condition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.joinCondition$1}));
                }
                {
                    this.joinCondition$1 = joinCondition$1;
                }
            }, e);
            none$ = none$2 = None$.MODULE$;
        }
        return none$;
    }

    public final boolean org$apache$spark$sql$catalyst$analysis$StreamingJoinHelper$$containsAttributeToFindStateConstraintFor$1(Expression e, AttributeSet attributesToFindStateWatermarkFor$2) {
        return e.collectLeaves().collectFirst((PartialFunction)new Serializable(attributesToFindStateWatermarkFor$2){
            public static final long serialVersionUID = 0L;
            private final AttributeSet attributesToFindStateWatermarkFor$2;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                AttributeReference attributeReference;
                A1 A1 = x3;
                Object object = A1 instanceof AttributeReference && this.attributesToFindStateWatermarkFor$2.contains(attributeReference = (AttributeReference)A1) ? attributeReference : function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x3) {
                AttributeReference attributeReference;
                Expression expression = x3;
                boolean bl = expression instanceof AttributeReference && this.attributesToFindStateWatermarkFor$2.contains(attributeReference = (AttributeReference)expression);
                return bl;
            }
            {
                this.attributesToFindStateWatermarkFor$2 = attributesToFindStateWatermarkFor$2;
            }
        }).nonEmpty();
    }

    private final Expression negateIfNeeded$1(Expression expr, boolean minus2) {
        return minus2 ? new UnaryMinus(expr) : expr;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Seq collect$1(Expression expr, boolean negate, Expression exprToCollectFrom$1, BooleanRef invalid$1) {
        Expression expression;
        block18: {
            while (true) {
                if ((expression = expr) instanceof Add) {
                    Add add = (Add)expression;
                    Expression left = add.left();
                    Expression right = add.right();
                    return (Seq)this.collect$1(left, negate, exprToCollectFrom$1, invalid$1).$plus$plus((GenTraversableOnce)this.collect$1(right, negate, exprToCollectFrom$1, invalid$1), Seq$.MODULE$.canBuildFrom());
                }
                if (expression instanceof Subtract) {
                    Subtract subtract = (Subtract)expression;
                    Expression left = subtract.left();
                    Expression right = subtract.right();
                    return (Seq)this.collect$1(left, negate, exprToCollectFrom$1, invalid$1).$plus$plus((GenTraversableOnce)this.collect$1(right, !negate, exprToCollectFrom$1, invalid$1), Seq$.MODULE$.canBuildFrom());
                }
                if (expression instanceof TimeAdd) {
                    TimeAdd timeAdd = (TimeAdd)expression;
                    Expression left = timeAdd.start();
                    Expression right = timeAdd.interval();
                    return (Seq)this.collect$1(left, negate, exprToCollectFrom$1, invalid$1).$plus$plus((GenTraversableOnce)this.collect$1(right, negate, exprToCollectFrom$1, invalid$1), Seq$.MODULE$.canBuildFrom());
                }
                if (expression instanceof TimeSub) {
                    TimeSub timeSub = (TimeSub)expression;
                    Expression left = timeSub.start();
                    Expression right = timeSub.interval();
                    return (Seq)this.collect$1(left, negate, exprToCollectFrom$1, invalid$1).$plus$plus((GenTraversableOnce)this.collect$1(right, !negate, exprToCollectFrom$1, invalid$1), Seq$.MODULE$.canBuildFrom());
                }
                if (expression instanceof UnaryMinus) {
                    UnaryMinus unaryMinus = (UnaryMinus)expression;
                    Expression child = unaryMinus.child();
                    negate = !negate;
                    expr = child;
                    continue;
                }
                if (expression instanceof CheckOverflow) {
                    Expression child;
                    CheckOverflow checkOverflow = (CheckOverflow)expression;
                    expr = child = checkOverflow.child();
                    continue;
                }
                if (expression instanceof PromotePrecision) {
                    Expression child;
                    PromotePrecision promotePrecision = (PromotePrecision)expression;
                    expr = child = promotePrecision.child();
                    continue;
                }
                if (!(expression instanceof Cast)) break block18;
                Cast cast2 = (Cast)expression;
                Expression child = cast2.child();
                DataType dataType2 = cast2.dataType();
                DataType dataType3 = dataType2;
                boolean bl = dataType3 instanceof NumericType ? true : dataType3 instanceof TimestampType;
                if (!bl) break;
                expr = child;
            }
            invalid$1.elem = true;
            Seq seq = (Seq)Seq$.MODULE$.empty();
            return seq;
        }
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            DataType dataType4 = attributeReference.dataType();
            DoubleType$ doubleType$ = DoubleType$.MODULE$;
            Expression expression2 = !(dataType4 != null ? !dataType4.equals(doubleType$) : doubleType$ != null) ? attributeReference : new Cast(attributeReference, DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3());
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.negateIfNeeded$1(expression2, negate)}));
        }
        if (expression instanceof Literal) {
            void var38_41;
            Literal literal = (Literal)expression;
            DataType dataType5 = literal.dataType();
            if (CalendarIntervalType$.MODULE$.equals(dataType5)) {
                Literal literal2;
                CalendarInterval calendarInterval = (CalendarInterval)literal.value();
                if (calendarInterval.months > 0) {
                    invalid$1.elem = true;
                    this.logWarning((Function0<String>)new Serializable(exprToCollectFrom$1){
                        public static final long serialVersionUID = 0L;
                        private final Expression exprToCollectFrom$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to extract state value watermark from condition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.exprToCollectFrom$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"as imprecise intervals like months and years cannot be used for"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"watermark calculation. Use interval in terms of day instead."})).s((Seq)Nil$.MODULE$)).toString();
                        }
                        {
                            this.exprToCollectFrom$1 = exprToCollectFrom$1;
                        }
                    });
                    literal2 = Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)0.0));
                } else {
                    literal2 = Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)calendarInterval.microseconds));
                }
                Literal literal3 = literal2;
            } else if (DoubleType$.MODULE$.equals(dataType5)) {
                Multiply multiply = new Multiply(literal, Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)1000000.0)));
            } else if (dataType5 instanceof NumericType) {
                Multiply multiply = new Multiply(new Cast(literal, DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3()), Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)1000000.0)));
            } else {
                if (!(dataType5 instanceof TimestampType)) throw new MatchError((Object)dataType5);
                Multiply multiply = new Multiply(new PreciseTimestampConversion(literal, TimestampType$.MODULE$, LongType$.MODULE$), Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)1000000.0)));
            }
            void var36_42 = var38_41;
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.negateIfNeeded$1((Expression)var36_42, negate)}));
        }
        this.logWarning((Function0<String>)new Serializable(exprToCollectFrom$1, expression){
            public static final long serialVersionUID = 0L;
            private final Expression exprToCollectFrom$1;
            private final Expression x1$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to extract state value watermark from condition ", " due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.exprToCollectFrom$1, this.x1$1}));
            }
            {
                this.exprToCollectFrom$1 = exprToCollectFrom$1;
                this.x1$1 = x1$1;
            }
        });
        invalid$1.elem = true;
        return (Seq)Seq$.MODULE$.empty();
    }

    private StreamingJoinHelper$() {
        MODULE$ = this;
        PredicateHelper$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }
}

