/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;

public final class HistogramSerializer$ {
    public static final HistogramSerializer$ MODULE$;

    static {
        new HistogramSerializer$();
    }

    public final String serialize(Histogram histogram) {
        int i;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream((OutputStream)new LZ4BlockOutputStream((OutputStream)bos));
        out.writeDouble(histogram.height());
        out.writeInt(histogram.bins().length);
        for (i = 0; i < histogram.bins().length; ++i) {
            out.writeDouble(histogram.bins()[i].lo());
        }
        for (i = 0; i < histogram.bins().length; ++i) {
            out.writeDouble(histogram.bins()[i].hi());
        }
        for (i = 0; i < histogram.bins().length; ++i) {
            out.writeLong(histogram.bins()[i].ndv());
        }
        out.writeInt(-1);
        out.flush();
        out.close();
        return Base64.encodeBase64String((byte[])bos.toByteArray());
    }

    public final Histogram deserialize(String str) {
        int i;
        byte[] bytes = Base64.decodeBase64((String)str);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream ins = new DataInputStream((InputStream)new LZ4BlockInputStream((InputStream)bis));
        double height = ins.readDouble();
        int numBins = ins.readInt();
        double[] los = new double[numBins];
        for (i = 0; i < numBins; ++i) {
            los[i] = ins.readDouble();
        }
        double[] his = new double[numBins];
        for (i = 0; i < numBins; ++i) {
            his[i] = ins.readDouble();
        }
        long[] ndvs = new long[numBins];
        for (i = 0; i < numBins; ++i) {
            ndvs[i] = ins.readLong();
        }
        ins.close();
        HistogramBin[] bins = new HistogramBin[numBins];
        for (i = 0; i < numBins; ++i) {
            bins[i] = new HistogramBin(los[i], his[i], ndvs[i]);
        }
        return new Histogram(height, bins);
    }

    private HistogramSerializer$() {
        MODULE$ = this;
    }
}

