/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;

public class BufferHolder {
    private static final int ARRAY_MAX = ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH;
    public byte[] buffer;
    public int cursor = Platform.BYTE_ARRAY_OFFSET;
    private final UnsafeRow row;
    private final int fixedSize;

    public BufferHolder(UnsafeRow row) {
        this(row, 64);
    }

    public BufferHolder(UnsafeRow row, int initialSize) {
        int bitsetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(row.numFields());
        if (row.numFields() > (ARRAY_MAX - initialSize - bitsetWidthInBytes) / 8) {
            throw new UnsupportedOperationException("Cannot create BufferHolder for input UnsafeRow because there are too many fields (number of fields: " + row.numFields() + ")");
        }
        this.fixedSize = bitsetWidthInBytes + 8 * row.numFields();
        this.buffer = new byte[this.fixedSize + initialSize];
        this.row = row;
        this.row.pointTo(this.buffer, this.buffer.length);
    }

    public void grow(int neededSize) {
        if (neededSize > ARRAY_MAX - this.totalSize()) {
            throw new UnsupportedOperationException("Cannot grow BufferHolder by size " + neededSize + " because the size after growing exceeds size limitation " + ARRAY_MAX);
        }
        int length = this.totalSize() + neededSize;
        if (this.buffer.length < length) {
            int newLength = length < ARRAY_MAX / 2 ? length * 2 : ARRAY_MAX;
            byte[] tmp = new byte[newLength];
            Platform.copyMemory((Object)this.buffer, (long)Platform.BYTE_ARRAY_OFFSET, (Object)tmp, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.totalSize());
            this.buffer = tmp;
            this.row.pointTo(this.buffer, this.buffer.length);
        }
    }

    public void reset() {
        this.cursor = Platform.BYTE_ARRAY_OFFSET + this.fixedSize;
    }

    public int totalSize() {
        return this.cursor - Platform.BYTE_ARRAY_OFFSET;
    }
}

