/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.IOException;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.AbstractScalaRowIterator;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import org.apache.spark.util.collection.unsafe.sort.UnsafeExternalSorter;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;
import org.spark-project.guava.annotations.VisibleForTesting;
import scala.collection.Iterator;
import scala.math.Ordering;

final class UnsafeExternalRowSorter {
    private int testSpillFrequency = 0;
    private long numRowsInserted = 0L;
    private final StructType schema;
    private final PrefixComputer prefixComputer;
    private final UnsafeExternalSorter sorter;

    public UnsafeExternalRowSorter(StructType schema, Ordering<InternalRow> ordering2, PrefixComparator prefixComparator, PrefixComputer prefixComputer, long pageSizeBytes) throws IOException {
        this.schema = schema;
        this.prefixComputer = prefixComputer;
        SparkEnv sparkEnv = SparkEnv.get();
        TaskContext taskContext = TaskContext.get();
        this.sorter = UnsafeExternalSorter.create((TaskMemoryManager)taskContext.taskMemoryManager(), (BlockManager)sparkEnv.blockManager(), (TaskContext)taskContext, (RecordComparator)new RowComparator(ordering2, schema.length()), (PrefixComparator)prefixComparator, (int)4096, (long)pageSizeBytes);
    }

    @VisibleForTesting
    void setTestSpillFrequency(int frequency) {
        assert (frequency > 0) : "Frequency must be positive";
        this.testSpillFrequency = frequency;
    }

    @VisibleForTesting
    void insertRow(UnsafeRow row) throws IOException {
        long prefix = this.prefixComputer.computePrefix(row);
        this.sorter.insertRecord(row.getBaseObject(), row.getBaseOffset(), row.getSizeInBytes(), prefix);
        ++this.numRowsInserted;
        if (this.testSpillFrequency > 0 && this.numRowsInserted % (long)this.testSpillFrequency == 0L) {
            this.sorter.spill();
        }
    }

    public long getPeakMemoryUsage() {
        return this.sorter.getPeakMemoryUsedBytes();
    }

    private void cleanupResources() {
        this.sorter.cleanupResources();
    }

    @VisibleForTesting
    Iterator<UnsafeRow> sort() throws IOException {
        try {
            final UnsafeSorterIterator sortedIterator = this.sorter.getSortedIterator();
            if (!sortedIterator.hasNext()) {
                this.cleanupResources();
            }
            return new AbstractScalaRowIterator<UnsafeRow>(){
                private final int numFields;
                private UnsafeRow row;
                {
                    this.numFields = UnsafeExternalRowSorter.this.schema.length();
                    this.row = new UnsafeRow();
                }

                @Override
                public boolean hasNext() {
                    return sortedIterator.hasNext();
                }

                @Override
                public UnsafeRow next() {
                    try {
                        sortedIterator.loadNext();
                        this.row.pointTo(sortedIterator.getBaseObject(), sortedIterator.getBaseOffset(), this.numFields, sortedIterator.getRecordLength());
                        if (!this.hasNext()) {
                            UnsafeRow copy2 = this.row.copy();
                            this.row = null;
                            UnsafeExternalRowSorter.this.cleanupResources();
                            return copy2;
                        }
                        return this.row;
                    }
                    catch (IOException e) {
                        UnsafeExternalRowSorter.this.cleanupResources();
                        Platform.throwException((Throwable)e);
                        throw new RuntimeException("Exception should have been re-thrown in next()");
                    }
                }
            };
        }
        catch (IOException e) {
            this.cleanupResources();
            throw e;
        }
    }

    public Iterator<UnsafeRow> sort(Iterator<UnsafeRow> inputIterator) throws IOException {
        while (inputIterator.hasNext()) {
            this.insertRow((UnsafeRow)inputIterator.next());
        }
        return this.sort();
    }

    private static final class RowComparator
    extends RecordComparator {
        private final Ordering<InternalRow> ordering;
        private final int numFields;
        private final UnsafeRow row1 = new UnsafeRow();
        private final UnsafeRow row2 = new UnsafeRow();

        public RowComparator(Ordering<InternalRow> ordering2, int numFields) {
            this.numFields = numFields;
            this.ordering = ordering2;
        }

        public int compare(Object baseObj1, long baseOff1, Object baseObj2, long baseOff2) {
            this.row1.pointTo(baseObj1, baseOff1, this.numFields, -1);
            this.row2.pointTo(baseObj2, baseOff2, this.numFields, -1);
            return this.ordering.compare((Object)this.row1, (Object)this.row2);
        }
    }

    public static abstract class PrefixComputer {
        abstract long computePrefix(InternalRow var1);
    }
}

