/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ed!B\u0001\u0003\u0003\u0003\t\"\u0001E\"f]R\u0014\u0018\r\\'p[\u0016tG/Q4h\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003'%k\u0007/\u001a:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011u\u0001!\u0011!Q\u0001\ny\tQa\u00195jY\u0012\u0004\"a\b\u0011\u000e\u0003\u0011I!!\t\u0003\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0003$\u0001\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0003K\u0019\u0002\"a\u0005\u0001\t\u000bu\u0011\u0003\u0019\u0001\u0010\t\u000b!\u0002a\u0011C\u0015\u0002\u00175|W.\u001a8u\u001fJ$WM]\u000b\u0002UA\u0011qcK\u0005\u0003Ya\u00111!\u00138u\u0011\u0015q\u0003\u0001\"\u00110\u0003!\u0019\u0007.\u001b7ee\u0016tW#\u0001\u0019\u0011\u0007EJdD\u0004\u00023o9\u00111GN\u0007\u0002i)\u0011Q\u0007E\u0001\u0007yI|w\u000e\u001e \n\u0003eI!\u0001\u000f\r\u0002\u000fA\f7m[1hK&\u0011!h\u000f\u0002\u0004'\u0016\f(B\u0001\u001d\u0019\u0011\u0015i\u0004\u0001\"\u0011?\u0003!qW\u000f\u001c7bE2,W#A \u0011\u0005]\u0001\u0015BA!\u0019\u0005\u001d\u0011un\u001c7fC:DQa\u0011\u0001\u0005B\u0011\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0002\u000bB\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nC\u0001\u0006if\u0004Xm]\u0005\u0003\u0015\u001e\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\u0006\u0019\u0002!\t%T\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001(\u0011\u0007EJt\n\u0005\u0002G!&\u0011\u0011k\u0012\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016DQa\u0015\u0001\u0005BQ\u000b1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031\u001a\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u00035^\u0013q\u0002V=qK\u000eCWmY6SKN,H\u000e\u001e\u0005\u00069\u0002!\t%X\u0001\u0010C\u001e<')\u001e4gKJ\u001c6\r[3nCV\ta\f\u0005\u0002G?&\u0011\u0001m\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007B\u00022\u0001A\u0003%!&\u0001\u0006ck\u001a4WM]*ju\u0016Dq\u0001\u001a\u0001C\u0002\u0013\u0005S-A\nbO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7/F\u0001g!\r\t\u0014h\u001a\t\u0003?!L!!\u001b\u0003\u0003%\u0005#HO]5ckR,'+\u001a4fe\u0016t7-\u001a\u0005\u0007W\u0002\u0001\u000b\u0011\u00024\u0002)\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:!\u0011\u001di\u0007A1A\u0005B\u0015\f\u0001$\u001b8qkR\fum\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3t\u0011\u0019y\u0007\u0001)A\u0005M\u0006I\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:!\u0011\u0019\t\b\u0001)A\u0005U\u00059an\u00144gg\u0016$\bBB:\u0001A\u0003%!&\u0001\u0006nK\u0006twJ\u001a4tKRDa!\u001e\u0001!\u0002\u0013Q\u0013AE:fG>tG-T8nK:$xJ\u001a4tKRDaa\u001e\u0001!\u0002\u0013Q\u0013!\u0005;iSJ$Wj\\7f]R|eMZ:fi\"1\u0011\u0010\u0001Q\u0001\n)\n!CZ8veRDWj\\7f]R|eMZ:fi\"11\u0010\u0001Q!\nq\fQ\u0001Z3mi\u0006\u0004\"aF?\n\u0005yD\"A\u0002#pk\ndW\rC\u0004\u0002\u0002\u0001\u0001\u000b\u0015\u0002?\u0002\r\u0011,G\u000e^1O\u0011\u001d\t)\u0001\u0001Q!\nq\fa\u0001Z3mi\u0006\u0014\u0004bBA\u0005\u0001\u0001\u0006K\u0001`\u0001\bI\u0016dG/\u0019(3\u0011\u001d\ti\u0001\u0001Q!\nq\f\u0011A\u001c\u0005\b\u0003#\u0001\u0001\u0015)\u0003}\u0003\u0011iW-\u00198\t\u000f\u0005U\u0001\u0001)Q\u0005y\u0006\u0011QN\r\u0005\b\u00033\u0001\u0001\u0015)\u0003}\u0003\ti7\u0007C\u0004\u0002\u001e\u0001\u0001\u000b\u0015\u0002?\u0002\u00055$\u0004bBA\u0011\u0001\u0011\u0005\u00131E\u0001\u000bS:LG/[1mSj,G\u0003BA\u0013\u0003W\u00012aFA\u0014\u0013\r\tI\u0003\u0007\u0002\u0005+:LG\u000f\u0003\u0005\u0002.\u0005}\u0001\u0019AA\u0018\u0003\u0019\u0011WO\u001a4feB\u0019q$!\r\n\u0007\u0005MBA\u0001\u0006NkR\f'\r\\3S_^Dq!a\u000e\u0001\t\u0003\nI$\u0001\u0004va\u0012\fG/\u001a\u000b\u0007\u0003K\tY$!\u0010\t\u0011\u00055\u0012Q\u0007a\u0001\u0003_A\u0001\"a\u0010\u00026\u0001\u0007\u0011\u0011I\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003\u0007\n)%D\u0001\u0007\u0013\r\t9E\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0004\u0002L\u0001!\t%!\u0014\u0002\u000b5,'oZ3\u0015\r\u0005\u0015\u0012qJA*\u0011!\t\t&!\u0013A\u0002\u0005=\u0012a\u00022vM\u001a,'/\r\u0005\t\u0003+\nI\u00051\u0001\u0002B\u00059!-\u001e4gKJ\u0014\u0004bBA-\u0001\u0019\u0005\u00111L\u0001\rO\u0016$8\u000b^1uSN$\u0018n\u0019\u000b\t\u0003;\n\u0019'!\u001a\u0002hA\u0019q#a\u0018\n\u0007\u0005\u0005\u0004DA\u0002B]fDq!!\u0004\u0002X\u0001\u0007A\u0010C\u0004\u0002\u0012\u0005]\u0003\u0019\u0001?\t\u0011\u0005%\u0014q\u000ba\u0001\u0003W\nabY3oiJ\fG.T8nK:$8\u000f\u0005\u0003\u0018\u0003[b\u0018bAA81\t)\u0011I\u001d:bs\"9\u00111\u000f\u0001\u0005F\u0005U\u0014\u0001B3wC2$B!!\u0018\u0002x!Q\u0011QFA9!\u0003\u0005\r!!\u0011")
public abstract class CentralMomentAgg
extends ImperativeAggregate
implements Serializable {
    private final Expression child;
    private final int bufferSize;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<AttributeReference> inputAggBufferAttributes;
    private final int nOffset;
    private final int meanOffset;
    private final int secondMomentOffset;
    private final int thirdMomentOffset;
    private final int fourthMomentOffset;
    private double delta;
    private double deltaN;
    private double delta2;
    private double deltaN2;
    private double n;
    private double mean;
    private double m2;
    private double m3;
    private double m4;

    public abstract int momentOrder();

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType$[]{NumericType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForNumericExpr(this.child.dataType(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"function ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()})));
    }

    @Override
    public StructType aggBufferSchema() {
        return StructType$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(MutableRow buffer) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bufferSize).foreach$mVc$sp((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CentralMomentAgg $outer;
            private final MutableRow buffer$1;

            public final void apply(int aggIndex) {
                this.apply$mcVI$sp(aggIndex);
            }

            public void apply$mcVI$sp(int aggIndex) {
                this.buffer$1.setDouble(this.$outer.mutableAggBufferOffset() + aggIndex, 0.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.buffer$1 = buffer$1;
            }
        });
    }

    @Override
    public void update(MutableRow buffer, InternalRow input) {
        Object object;
        block7: {
            block6: {
                double d;
                double d2;
                Object v = new Cast(this.child, DoubleType$.MODULE$).eval(input);
                if (v == null) break block6;
                object = v;
                if (!(object instanceof Double)) break block7;
                double updateValue = d2 = (d = BoxesRunTime.unboxToDouble((Object)object));
                this.n = buffer.getDouble(this.nOffset);
                this.mean = buffer.getDouble(this.meanOffset);
                this.n += 1.0;
                buffer.setDouble(this.nOffset, this.n);
                this.delta = updateValue - this.mean;
                this.deltaN = this.delta / this.n;
                this.mean += this.deltaN;
                buffer.setDouble(this.meanOffset, this.mean);
                if (this.momentOrder() >= 2) {
                    this.m2 = buffer.getDouble(this.secondMomentOffset);
                    this.m2 += this.delta * (this.delta - this.deltaN);
                    buffer.setDouble(this.secondMomentOffset, this.m2);
                }
                if (this.momentOrder() >= 3) {
                    this.delta2 = this.delta * this.delta;
                    this.deltaN2 = this.deltaN * this.deltaN;
                    this.m3 = buffer.getDouble(this.thirdMomentOffset);
                    this.m3 += -3.0 * this.deltaN * this.m2 + this.delta * (this.delta2 - this.deltaN2);
                    buffer.setDouble(this.thirdMomentOffset, this.m3);
                }
                if (this.momentOrder() >= 4) {
                    this.m4 = buffer.getDouble(this.fourthMomentOffset);
                    this.m4 += -4.0 * this.deltaN * this.m3 - 6.0 * this.deltaN2 * this.m2 + this.delta * (this.delta * this.delta2 - this.deltaN * this.deltaN2);
                    buffer.setDouble(this.fourthMomentOffset, this.m4);
                }
            }
            return;
        }
        throw new MatchError(object);
    }

    @Override
    public void merge(MutableRow buffer1, InternalRow buffer2) {
        double n1 = buffer1.getDouble(this.nOffset);
        double n2 = buffer2.getDouble(this.inputAggBufferOffset());
        double mean1 = buffer1.getDouble(this.meanOffset);
        double mean2 = buffer2.getDouble(this.inputAggBufferOffset() + 1);
        double secondMoment1 = 0.0;
        double secondMoment2 = 0.0;
        double thirdMoment1 = 0.0;
        double thirdMoment2 = 0.0;
        double fourthMoment1 = 0.0;
        double fourthMoment2 = 0.0;
        this.n = n1 + n2;
        buffer1.setDouble(this.nOffset, this.n);
        this.delta = mean2 - mean1;
        this.deltaN = this.n == 0.0 ? 0.0 : this.delta / this.n;
        this.mean = mean1 + this.deltaN * n2;
        buffer1.setDouble(this.mutableAggBufferOffset() + 1, this.mean);
        if (this.momentOrder() >= 2) {
            secondMoment1 = buffer1.getDouble(this.secondMomentOffset);
            secondMoment2 = buffer2.getDouble(this.inputAggBufferOffset() + 2);
            this.m2 = secondMoment1 + secondMoment2 + this.delta * this.deltaN * n1 * n2;
            buffer1.setDouble(this.secondMomentOffset, this.m2);
        }
        if (this.momentOrder() >= 3) {
            thirdMoment1 = buffer1.getDouble(this.thirdMomentOffset);
            thirdMoment2 = buffer2.getDouble(this.inputAggBufferOffset() + 3);
            this.m3 = thirdMoment1 + thirdMoment2 + this.deltaN * this.deltaN * this.delta * n1 * n2 * (n1 - n2) + 3.0 * this.deltaN * (n1 * secondMoment2 - n2 * secondMoment1);
            buffer1.setDouble(this.thirdMomentOffset, this.m3);
        }
        if (this.momentOrder() >= 4) {
            fourthMoment1 = buffer1.getDouble(this.fourthMomentOffset);
            fourthMoment2 = buffer2.getDouble(this.inputAggBufferOffset() + 4);
            this.m4 = fourthMoment1 + fourthMoment2 + this.deltaN * this.deltaN * this.deltaN * this.delta * n1 * n2 * (n1 * n1 - n1 * n2 + n2 * n2) + this.deltaN * this.deltaN * 6.0 * (n1 * n1 * secondMoment2 + n2 * n2 * secondMoment1) + 4.0 * this.deltaN * (n1 * thirdMoment2 - n2 * thirdMoment1);
            buffer1.setDouble(this.fourthMomentOffset, this.m4);
        }
    }

    public abstract Object getStatistic(double var1, double var3, double[] var5);

    @Override
    public final Object eval(InternalRow buffer) {
        double n = buffer.getDouble(this.nOffset);
        double mean = buffer.getDouble(this.meanOffset);
        double[] moments = (double[])Array$.MODULE$.ofDim(this.momentOrder() + 1, ClassTag$.MODULE$.Double());
        moments[0] = 1.0;
        moments[1] = 0.0;
        if (this.momentOrder() >= 2) {
            moments[2] = buffer.getDouble(this.secondMomentOffset);
        }
        if (this.momentOrder() >= 3) {
            moments[3] = buffer.getDouble(this.thirdMomentOffset);
        }
        if (this.momentOrder() >= 4) {
            moments[4] = buffer.getDouble(this.fourthMomentOffset);
        }
        return this.getStatistic(n, mean, moments);
    }

    public CentralMomentAgg(Expression child) {
        this.child = child;
        this.bufferSize = 5;
        this.aggBufferAttributes = (Seq)Seq$.MODULE$.tabulate(this.bufferSize, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(int i) {
                String x$2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"M", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
                DoubleType$ x$3 = DoubleType$.MODULE$;
                boolean x$4 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$5 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$6 = AttributeReference$.MODULE$.apply$default$5(x$2, x$3, x$4, x$5);
                Seq<String> x$7 = AttributeReference$.MODULE$.apply$default$6(x$2, x$3, x$4, x$5);
                return new AttributeReference(x$2, x$3, x$4, x$5, x$6, x$7);
            }
        });
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(AttributeReference x$1) {
                return x$1.newInstance();
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.nOffset = this.mutableAggBufferOffset();
        this.meanOffset = this.mutableAggBufferOffset() + 1;
        this.secondMomentOffset = this.mutableAggBufferOffset() + 2;
        this.thirdMomentOffset = this.mutableAggBufferOffset() + 3;
        this.fourthMomentOffset = this.mutableAggBufferOffset() + 4;
        this.delta = 0.0;
        this.deltaN = 0.0;
        this.delta2 = 0.0;
        this.deltaN2 = 0.0;
        this.n = 0.0;
        this.mean = 0.0;
        this.m2 = 0.0;
        this.m3 = 0.0;
        this.m4 = 0.0;
    }
}

