/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([expr[, pattern]]) - Returns the UNIX timestamp of current or specified time.", extended="\n    Examples:\n      > SELECT _FUNC_();\n       1476884637\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460041200\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u0001\u0003\u0001>\u0011Q\"\u00168jqRKW.Z:uC6\u0004(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001BC\u0007\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001\"\u00168jqRKW.\u001a\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\b!J|G-^2u!\t)2$\u0003\u0002\u001d-\ta1+\u001a:jC2L'0\u00192mK\"Aa\u0004\u0001BK\u0002\u0013\u0005q$A\u0004uS6,W\t\u001f9\u0016\u0003\u0001\u0002\"!E\u0011\n\u0005\t\u0012!AC#yaJ,7o]5p]\"AA\u0005\u0001B\tB\u0003%\u0001%\u0001\u0005uS6,W\t\u001f9!\u0011!1\u0003A!f\u0001\n\u0003y\u0012A\u00024pe6\fG\u000f\u0003\u0005)\u0001\tE\t\u0015!\u0003!\u0003\u001d1wN]7bi\u0002B\u0001B\u000b\u0001\u0003\u0016\u0004%\taK\u0001\u000bi&lWMW8oK&#W#\u0001\u0017\u0011\u0007Uis&\u0003\u0002/-\t1q\n\u001d;j_:\u0004\"\u0001M\u001a\u000f\u0005U\t\u0014B\u0001\u001a\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I2\u0002\u0002C\u001c\u0001\u0005#\u0005\u000b\u0011\u0002\u0017\u0002\u0017QLW.\u001a.p]\u0016LE\r\t\u0005\u0006s\u0001!\tAO\u0001\u0007y%t\u0017\u000e\u001e \u0015\tmbTH\u0010\t\u0003#\u0001AQA\b\u001dA\u0002\u0001BQA\n\u001dA\u0002\u0001BqA\u000b\u001d\u0011\u0002\u0003\u0007A\u0006C\u0003:\u0001\u0011\u0005\u0001\tF\u0002<\u0003\nCQAH A\u0002\u0001BQAJ A\u0002\u0001BQ\u0001\u0012\u0001\u0005B}\tA\u0001\\3gi\")a\t\u0001C!?\u0005)!/[4ii\")\u0001\n\u0001C!\u0013\u0006aq/\u001b;i)&lWMW8oKR\u0011!*\u0014\t\u0003#-K!\u0001\u0014\u0002\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007\"\u0002\u0016H\u0001\u0004y\u0003\"B\u001d\u0001\t\u0003yECA\u001eQ\u0011\u0015\tf\n1\u0001!\u0003\u0011!\u0018.\\3\t\u000be\u0002A\u0011A*\u0015\u0003mBQ!\u0016\u0001\u0005BY\u000b!\u0002\u001d:fiRLh*Y7f+\u0005y\u0003b\u0002-\u0001\u0003\u0003%\t!W\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003<5nc\u0006b\u0002\u0010X!\u0003\u0005\r\u0001\t\u0005\bM]\u0003\n\u00111\u0001!\u0011\u001dQs\u000b%AA\u00021BqA\u0018\u0001\u0012\u0002\u0013\u0005q,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003\u0001T#\u0001I1,\u0003\t\u0004\"a\u00195\u000e\u0003\u0011T!!\u001a4\u0002\u0013Ut7\r[3dW\u0016$'BA4\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u0003S\u0012\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001dY\u0007!%A\u0005\u0002}\u000babY8qs\u0012\"WMZ1vYR$#\u0007C\u0004n\u0001E\u0005I\u0011\u00018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\tqN\u000b\u0002-C\"9\u0011\u000fAA\u0001\n\u0003\u0012\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001t!\t!\u00180D\u0001v\u0015\t1x/\u0001\u0003mC:<'\"\u0001=\u0002\t)\fg/Y\u0005\u0003iUDqa\u001f\u0001\u0002\u0002\u0013\u0005A0\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001~!\t)b0\u0003\u0002\u0000-\t\u0019\u0011J\u001c;\t\u0013\u0005\r\u0001!!A\u0005\u0002\u0005\u0015\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000f\ti\u0001E\u0002\u0016\u0003\u0013I1!a\u0003\u0017\u0005\r\te.\u001f\u0005\n\u0003\u001f\t\t!!AA\u0002u\f1\u0001\u001f\u00132\u0011%\t\u0019\u0002AA\u0001\n\u0003\n)\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u0002\u0005\u0004\u0002\u001a\u0005}\u0011qA\u0007\u0003\u00037Q1!!\b\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\tYB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t)\u0003AA\u0001\n\u0003\t9#\u0001\u0005dC:,\u0015/^1m)\u0011\tI#a\f\u0011\u0007U\tY#C\u0002\u0002.Y\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002\u0010\u0005\r\u0012\u0011!a\u0001\u0003\u000fA\u0011\"a\r\u0001\u0003\u0003%\t%!\u000e\u0002\r\u0015\fX/\u00197t)\u0011\tI#a\u000e\t\u0015\u0005=\u0011\u0011GA\u0001\u0002\u0004\t9\u0001K\u0006\u0001\u0003w\t\t%a\u0011\u0002H\u0005%\u0003cA\t\u0002>%\u0019\u0011q\b\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QI\u0001U?\u001a+fjQ0)7\u0016D\bO].-AA\fG\u000f^3s]vk\u0016\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI+O\u0013b\u0003C/[7fgR\fW\u000e\u001d\u0011pM\u0002\u001aWO\u001d:f]R\u0004sN\u001d\u0011ta\u0016\u001c\u0017NZ5fI\u0002\"\u0018.\\3/\u0003!)\u0007\u0010^3oI\u0016$\u0017EAA&\u0003\u0005\r!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\"tG\u000e\u001d9iY\u001atG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'\f\u00195[ABt\u0005\f\u0011(sfL\u00180L'N[\u0011$w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cQ2\u0004\u0007\r\u001b2eA\u0002$\u0002\t\u0011\b\u0013\u0005=#!!A\t\u0002\u0005E\u0013!D+oSb$\u0016.\\3ti\u0006l\u0007\u000fE\u0002\u0012\u0003'2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QK\n\u0006\u0003'\n9F\u0007\t\t\u00033\ny\u0006\t\u0011-w5\u0011\u00111\f\u0006\u0004\u0003;2\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003C\nYFA\tBEN$(/Y2u\rVt7\r^5p]NBq!OA*\t\u0003\t)\u0007\u0006\u0002\u0002R!Q\u0011\u0011NA*\u0003\u0003%)%a\u001b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u001d\u0005\u000b\u0003_\n\u0019&!A\u0005\u0002\u0006E\u0014!B1qa2LHcB\u001e\u0002t\u0005U\u0014q\u000f\u0005\u0007=\u00055\u0004\u0019\u0001\u0011\t\r\u0019\ni\u00071\u0001!\u0011!Q\u0013Q\u000eI\u0001\u0002\u0004a\u0003BCA>\u0003'\n\t\u0011\"!\u0002~\u00059QO\\1qa2LH\u0003BA@\u0003\u000f\u0003B!F\u0017\u0002\u0002B1Q#a!!A1J1!!\"\u0017\u0005\u0019!V\u000f\u001d7fg!I\u0011\u0011RA=\u0003\u0003\u0005\raO\u0001\u0004q\u0012\u0002\u0004\"CAG\u0003'\n\n\u0011\"\u0001o\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011\u0011SA*#\u0003%\tA\\\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q\u0011QSA*\u0003\u0003%I!a&\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00033\u00032\u0001^AN\u0013\r\ti*\u001e\u0002\u0007\u001f\nTWm\u0019;")
public class UnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;
    private final Option<String> timeZoneId;

    public static Option<String> apply$default$3() {
        return UnixTimestamp$.MODULE$.apply$default$3();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return UnixTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, UnixTimestamp> tupled() {
        return UnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, UnixTimestamp>>> curried() {
        return UnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$16 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$17 = this.copy$default$1();
        Expression x$18 = this.copy$default$2();
        return this.copy(x$17, x$18, (Option<String>)x$16);
    }

    @Override
    public String prettyName() {
        return "unix_timestamp";
    }

    public UnixTimestamp copy(Expression timeExp, Expression format2, Option<String> timeZoneId) {
        return new UnixTimestamp(timeExp, format2, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "UnixTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 0: {
                object = this.timeExp();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnixTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnixTimestamp unixTimestamp = (UnixTimestamp)x$1;
        Expression expression = this.timeExp();
        Expression expression2 = unixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = unixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = unixTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!unixTimestamp.canEqual(this)) return false;
        return true;
    }

    public UnixTimestamp(Expression timeExp, Expression format2, Option<String> timeZoneId) {
        this.timeExp = timeExp;
        this.format = format2;
        this.timeZoneId = timeZoneId;
    }

    public UnixTimestamp(Expression timeExp, Expression format2) {
        this(timeExp, format2, (Option<String>)None$.MODULE$);
    }

    public UnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply("yyyy-MM-dd HH:mm:ss"));
    }

    public UnixTimestamp() {
        this(new CurrentTimestamp());
    }
}

