/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.text.BreakIterator;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Sentences$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback$class;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str[, lang, country]) - Splits `str` into an array of array of words.", extended="\n    Examples:\n      > SELECT _FUNC_('Hi there! Good morning.');\n       [[\"Hi\",\"there\"],[\"Good\",\"morning\"]]\n  ")
@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0001\u0003\u0001>\u0011\u0011bU3oi\u0016t7-Z:\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\t\u0015/u\u0019\u0003CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0002\u0002\u000f\r|G-Z4f]&\u0011A$\u0007\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t9\u0001K]8ek\u000e$\bC\u0001\u0010%\u0013\t)sD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005(\u0001\tU\r\u0011\"\u0001)\u0003\r\u0019HO]\u000b\u0002!!A!\u0006\u0001B\tB\u0003%\u0001#\u0001\u0003tiJ\u0004\u0003\u0002\u0003\u0017\u0001\u0005+\u0007I\u0011\u0001\u0015\u0002\u00111\fgnZ;bO\u0016D\u0001B\f\u0001\u0003\u0012\u0003\u0006I\u0001E\u0001\nY\u0006tw-^1hK\u0002B\u0001\u0002\r\u0001\u0003\u0016\u0004%\t\u0001K\u0001\bG>,h\u000e\u001e:z\u0011!\u0011\u0004A!E!\u0002\u0013\u0001\u0012\u0001C2pk:$(/\u001f\u0011\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\u00111t\u0007O\u001d\u0011\u0005E\u0001\u0001\"B\u00144\u0001\u0004\u0001\u0002b\u0002\u00174!\u0003\u0005\r\u0001\u0005\u0005\baM\u0002\n\u00111\u0001\u0011\u0011\u0015!\u0004\u0001\"\u0001<)\t1D\bC\u0003(u\u0001\u0007\u0001\u0003C\u00035\u0001\u0011\u0005a\bF\u00027\u007f\u0001CQaJ\u001fA\u0002AAQ\u0001L\u001fA\u0002AAQA\u0011\u0001\u0005B\r\u000b\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002\tB\u0011a$R\u0005\u0003\r~\u0011qAQ8pY\u0016\fg\u000eC\u0003I\u0001\u0011\u0005\u0013*\u0001\u0005eCR\fG+\u001f9f+\u0005Q\u0005CA&O\u001b\u0005a%BA'\u0007\u0003\u0015!\u0018\u0010]3t\u0013\tyEJ\u0001\u0005ECR\fG+\u001f9f\u0011\u0015\t\u0006\u0001\"\u0011S\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002'B\u0019A\u000bX0\u000f\u0005USfB\u0001,Z\u001b\u00059&B\u0001-\u000f\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002\\?\u00059\u0001/Y2lC\u001e,\u0017BA/_\u0005\r\u0019V-\u001d\u0006\u00037~\u0001\"a\u00131\n\u0005\u0005d%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003!\u0019\u0007.\u001b7ee\u0016tW#A3\u0011\u0007Qc\u0006\u0003C\u0003h\u0001\u0011\u0005\u0003.\u0001\u0003fm\u0006dGCA5m!\tq\".\u0003\u0002l?\t\u0019\u0011I\\=\t\u000f54\u0007\u0013!a\u0001]\u0006)\u0011N\u001c9viB\u0011q\u000e]\u0007\u0002\t%\u0011\u0011\u000f\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003t\u0001\u0011%A/\u0001\u0007hKR\u001cVM\u001c;f]\u000e,7\u000f\u0006\u0003vw\u0006%\u0001C\u0001<z\u001b\u00059(B\u0001=\u0005\u0003\u0011)H/\u001b7\n\u0005i<(\u0001E$f]\u0016\u0014\u0018nY!se\u0006LH)\u0019;b\u0011\u0015a(\u000f1\u0001~\u0003%\u0019XM\u001c;f]\u000e,7\u000fE\u0002\u007f\u0003\u0007q!AH@\n\u0007\u0005\u0005q$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\t9A\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003y\u0002bBA\u0006e\u0002\u0007\u0011QB\u0001\u0007Y>\u001c\u0017\r\\3\u0011\t\u0005=\u0011qC\u0007\u0003\u0003#Q1\u0001_A\n\u0015\t\t)\"\u0001\u0003kCZ\f\u0017\u0002BA\r\u0003#\u0011a\u0001T8dC2,\u0007\"CA\u000f\u0001\u0005\u0005I\u0011AA\u0010\u0003\u0011\u0019w\u000e]=\u0015\u000fY\n\t#a\t\u0002&!Aq%a\u0007\u0011\u0002\u0003\u0007\u0001\u0003\u0003\u0005-\u00037\u0001\n\u00111\u0001\u0011\u0011!\u0001\u00141\u0004I\u0001\u0002\u0004\u0001\u0002\"CA\u0015\u0001E\u0005I\u0011AA\u0016\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\f+\u0007A\tyc\u000b\u0002\u00022A!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012!C;oG\",7m[3e\u0015\r\tYdH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA \u0003k\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\u0019\u0005AI\u0001\n\u0003\tY#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005\u001d\u0003!%A\u0005\u0002\u0005-\u0012AD2paf$C-\u001a4bk2$He\r\u0005\n\u0003\u0017\u0002\u0011\u0011!C!\u0003\u001b\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA(!\u0011\t\t&a\u0016\u000e\u0005\u0005M#\u0002BA+\u0003'\tA\u0001\\1oO&!\u0011QAA*\u0011%\tY\u0006AA\u0001\n\u0003\ti&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002`A\u0019a$!\u0019\n\u0007\u0005\rtDA\u0002J]RD\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0011.a\u001b\t\u0015\u00055\u0014QMA\u0001\u0002\u0004\ty&A\u0002yIEB\u0011\"!\u001d\u0001\u0003\u0003%\t%a\u001d\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001e\u0011\u000b\u0005]\u0014QP5\u000e\u0005\u0005e$bAA>?\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0014\u0011\u0010\u0002\t\u0013R,'/\u0019;pe\"I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0011QQ\u0001\tG\u0006tW)];bYR\u0019A)a\"\t\u0013\u00055\u0014\u0011QA\u0001\u0002\u0004I\u0007\"CAF\u0001\u0005\u0005I\u0011IAG\u0003\u0019)\u0017/^1mgR\u0019A)a$\t\u0013\u00055\u0014\u0011RA\u0001\u0002\u0004I\u0007f\u0003\u0001\u0002\u0014\u0006e\u00151TAP\u0003C\u00032!EAK\u0013\r\t9J\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti*\u0001'`\rVs5i\u0018\u0015tiJ\\F\u0006\t7b]\u001ed\u0003eY8v]R\u0014\u00180X\u0015![\u0001\u001a\u0006\u000f\\5ug\u0002\u00027\u000f\u001e:aA%tGo\u001c\u0011b]\u0002\n'O]1zA=4\u0007%\u0019:sCf\u0004sN\u001a\u0011x_J$7OL\u0001\tKb$XM\u001c3fI\u0006\u0012\u00111U\u0001o\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003*\u001b\u0011uQ\u0016\u0014X-\t\u0011H_>$\u0007%\\8s]&twML\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6L\t%jE1\u0012C\u000f[3sK\njFf\u0017\u0012H_>$'\u0005\f\u0012n_Jt\u0017N\\4#;vS\u0001\u0005I\u0004\n\u0003O\u0013\u0011\u0011!E\u0001\u0003S\u000b\u0011bU3oi\u0016t7-Z:\u0011\u0007E\tYK\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAW'\u0015\tY+a,$!!\t\t,a.\u0011!A1TBAAZ\u0015\r\t)lH\u0001\beVtG/[7f\u0013\u0011\tI,a-\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u00045\u0003W#\t!!0\u0015\u0005\u0005%\u0006BCAa\u0003W\u000b\t\u0011\"\u0012\u0002D\u0006AAo\\*ue&tw\r\u0006\u0002\u0002P!Q\u0011qYAV\u0003\u0003%\t)!3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fY\nY-!4\u0002P\"1q%!2A\u0002AA\u0001\u0002LAc!\u0003\u0005\r\u0001\u0005\u0005\ta\u0005\u0015\u0007\u0013!a\u0001!!Q\u00111[AV\u0003\u0003%\t)!6\u0002\u000fUt\u0017\r\u001d9msR!\u0011q[Ar!\u0015q\u0012\u0011\\Ao\u0013\r\tYn\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ry\ty\u000e\u0005\t\u0011\u0013\r\t\to\b\u0002\u0007)V\u0004H.Z\u001a\t\u0013\u0005\u0015\u0018\u0011[A\u0001\u0002\u00041\u0014a\u0001=%a!Q\u0011\u0011^AV#\u0003%\t!a\u000b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011)\ti/a+\u0012\u0002\u0013\u0005\u00111F\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\t\u0015\u0005E\u00181VI\u0001\n\u0003\tY#A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011)\t)0a+\u0012\u0002\u0013\u0005\u00111F\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q\u0011\u0011`AV\u0003\u0003%I!a?\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003{\u0004B!!\u0015\u0002\u0000&!!\u0011AA*\u0005\u0019y%M[3di\u0002")
public class Sentences
extends Expression
implements ImplicitCastInputTypes,
CodegenFallback,
Serializable {
    private final Expression str;
    private final Expression language;
    private final Expression country;

    public static Expression apply$default$3() {
        return Sentences$.MODULE$.apply$default$3();
    }

    public static Expression apply$default$2() {
        return Sentences$.MODULE$.apply$default$2();
    }

    public static Expression $lessinit$greater$default$3() {
        return Sentences$.MODULE$.$lessinit$greater$default$3();
    }

    public static Expression $lessinit$greater$default$2() {
        return Sentences$.MODULE$.$lessinit$greater$default$2();
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Sentences> tupled() {
        return Sentences$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Sentences>>> curried() {
        return Sentences$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback$class.doGenCode(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression language() {
        return this.language;
    }

    public Expression country() {
        return this.country;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType(new ArrayType(StringType$.MODULE$, false), false);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.language();
        Expression expression3 = this.country();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Object string = this.str().eval(input);
        if (string == null) {
            genericArrayData = null;
        } else {
            UTF8String languageStr = (UTF8String)this.language().eval(input);
            UTF8String countryStr = (UTF8String)this.country().eval(input);
            Locale locale = languageStr == null || countryStr == null ? Locale.US : new Locale(languageStr.toString(), countryStr.toString());
            genericArrayData = this.getSentences(((UTF8String)string).toString(), locale);
        }
        return genericArrayData;
    }

    private GenericArrayData getSentences(String sentences, Locale locale) {
        BreakIterator bi = BreakIterator.getSentenceInstance(locale);
        bi.setText(sentences);
        int idx = 0;
        ArrayBuffer result = new ArrayBuffer();
        while (bi.next() != -1) {
            String sentence = sentences.substring(idx, bi.current());
            idx = bi.current();
            BreakIterator wi = BreakIterator.getWordInstance(locale);
            int widx = 0;
            wi.setText(sentence);
            ArrayBuffer words = new ArrayBuffer();
            while (wi.next() != -1) {
                String word = sentence.substring(widx, wi.current());
                widx = wi.current();
                Object object = Character.isLetterOrDigit(word.charAt(0)) ? words.$plus$eq((Object)UTF8String.fromString((String)word)) : BoxedUnit.UNIT;
            }
            result.$plus$eq((Object)new GenericArrayData((Seq<Object>)words));
        }
        return new GenericArrayData((Seq<Object>)result);
    }

    public Sentences copy(Expression str, Expression language, Expression country) {
        return new Sentences(str, language, country);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.language();
    }

    public Expression copy$default$3() {
        return this.country();
    }

    @Override
    public String productPrefix() {
        return "Sentences";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.country();
                break;
            }
            case 1: {
                expression = this.language();
                break;
            }
            case 0: {
                expression = this.str();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sentences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sentences)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sentences sentences = (Sentences)x$1;
        Expression expression = this.str();
        Expression expression2 = sentences.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.language();
        Expression expression4 = sentences.language();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.country();
        Expression expression6 = sentences.country();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!sentences.canEqual(this)) return false;
        return true;
    }

    public Sentences(Expression str, Expression language, Expression country) {
        this.str = str;
        this.language = language;
        this.country = country;
        ExpectsInputTypes$class.$init$(this);
        CodegenFallback$class.$init$(this);
    }

    public Sentences(Expression str) {
        this(str, Literal$.MODULE$.apply(""), Literal$.MODULE$.apply(""));
    }

    public Sentences(Expression str, Expression language) {
        this(str, language, Literal$.MODULE$.apply(""));
    }
}

