/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp1, timestamp2) - Returns number of months between `timestamp1` and `timestamp2`.", extended="\n    Examples:\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30');\n       3.94959677\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0001\u0003\u0001>\u0011Q\"T8oi\"\u001c()\u001a;xK\u0016t'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001Bc\u0006\u000e!!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005EA\u0012BA\r\u0003\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"a\u0002)s_\u0012,8\r\u001e\t\u00037\u0005J!A\t\u000f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0011\u0002!Q3A\u0005\u0002\u0015\nQ\u0001Z1uKF*\u0012A\n\t\u0003#\u001dJ!\u0001\u000b\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005+\u0001\tE\t\u0015!\u0003'\u0003\u0019!\u0017\r^32A!AA\u0006\u0001BK\u0002\u0013\u0005Q%A\u0003eCR,'\u0007\u0003\u0005/\u0001\tE\t\u0015!\u0003'\u0003\u0019!\u0017\r^33A!A\u0001\u0007\u0001BK\u0002\u0013\u0005\u0011'\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012A\r\t\u00047M*\u0014B\u0001\u001b\u001d\u0005\u0019y\u0005\u000f^5p]B\u0011a'\u000f\b\u00037]J!\u0001\u000f\u000f\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qqA\u0001\"\u0010\u0001\u0003\u0012\u0003\u0006IAM\u0001\fi&lWMW8oK&#\u0007\u0005C\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004=S:LGO\u0010\u000b\u0005\u0003\n\u001bE\t\u0005\u0002\u0012\u0001!)AE\u0010a\u0001M!)AF\u0010a\u0001M!9\u0001G\u0010I\u0001\u0002\u0004\u0011\u0004\"B \u0001\t\u00031EcA!H\u0011\")A%\u0012a\u0001M!)A&\u0012a\u0001M!)!\n\u0001C!K\u0005!A.\u001a4u\u0011\u0015a\u0005\u0001\"\u0011&\u0003\u0015\u0011\u0018n\u001a5u\u0011\u0015q\u0005\u0001\"\u0011P\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002!B\u0019\u0011+\u0017/\u000f\u0005I;fBA*W\u001b\u0005!&BA+\u000f\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002Y9\u00059\u0001/Y2lC\u001e,\u0017B\u0001.\\\u0005\r\u0019V-\u001d\u0006\u00031r\u0001\"!\u00181\u000e\u0003yS!a\u0018\u0004\u0002\u000bQL\b/Z:\n\u0005\u0005t&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003!!\u0017\r^1UsB,W#A3\u0011\u0005u3\u0017BA4_\u0005!!\u0015\r^1UsB,\u0007\"B5\u0001\t\u0003R\u0017\u0001D<ji\"$\u0016.\\3[_:,GC\u0001\u000bl\u0011\u0015\u0001\u0004\u000e1\u00016\u0011\u0015i\u0007\u0001\"\u0011o\u00031qW\u000f\u001c7TC\u001a,WI^1m)\ry'\u000f\u001e\t\u00037AL!!\u001d\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003tY\u0002\u0007q.\u0001\u0002uc!)Q\u000f\u001ca\u0001_\u0006\u0011AO\r\u0005\u0006o\u0002!\t\u0005_\u0001\nI><UM\\\"pI\u0016$B!_@\u0002\nA\u0011!0`\u0007\u0002w*\u0011APA\u0001\bG>$WmZ3o\u0013\tq8P\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\tA\u001ea\u0001\u0003\u0007\t1a\u0019;y!\rQ\u0018QA\u0005\u0004\u0003\u000fY(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u00171\b\u0019A=\u0002\u0005\u00154\bbBA\b\u0001\u0011\u0005\u0013\u0011C\u0001\u000baJ,G\u000f^=OC6,W#A\u001b\t\u0013\u0005U\u0001!!A\u0005\u0002\u0005]\u0011\u0001B2paf$r!QA\r\u00037\ti\u0002\u0003\u0005%\u0003'\u0001\n\u00111\u0001'\u0011!a\u00131\u0003I\u0001\u0002\u00041\u0003\u0002\u0003\u0019\u0002\u0014A\u0005\t\u0019\u0001\u001a\t\u0013\u0005\u0005\u0002!%A\u0005\u0002\u0005\r\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003KQ3AJA\u0014W\t\tI\u0003\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001a9\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0012Q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u001e\u0001E\u0005I\u0011AA\u0012\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"a\u0010\u0001#\u0003%\t!!\u0011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\t\u0016\u0004e\u0005\u001d\u0002\"CA$\u0001\u0005\u0005I\u0011IA%\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\n\t\u0005\u0003\u001b\n9&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0013\u0001\u00026bm\u0006L1AOA(\u0011%\tY\u0006AA\u0001\n\u0003\ti&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002`A\u00191$!\u0019\n\u0007\u0005\rDDA\u0002J]RD\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019q.a\u001b\t\u0015\u00055\u0014QMA\u0001\u0002\u0004\ty&A\u0002yIEB\u0011\"!\u001d\u0001\u0003\u0003%\t%a\u001d\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001e\u0011\u000b\u0005]\u0014QP8\u000e\u0005\u0005e$bAA>9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0014\u0011\u0010\u0002\t\u0013R,'/\u0019;pe\"I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0011QQ\u0001\tG\u0006tW)];bYR!\u0011qQAG!\rY\u0012\u0011R\u0005\u0004\u0003\u0017c\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003[\n\t)!AA\u0002=D\u0011\"!%\u0001\u0003\u0003%\t%a%\u0002\r\u0015\fX/\u00197t)\u0011\t9)!&\t\u0013\u00055\u0014qRA\u0001\u0002\u0004y\u0007f\u0003\u0001\u0002\u001a\u0006}\u0015\u0011UAS\u0003O\u00032!EAN\u0013\r\tiJ\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019+\u00011`\rVs5i\u0018\u0015uS6,7\u000f^1naFb\u0003\u0005^5nKN$\u0018-\u001c93S\u0001j\u0003EU3ukJt7\u000f\t8v[\n,'\u000fI8gA5|g\u000e\u001e5tA\t,Go^3f]\u0002\u0002G/[7fgR\fW\u000e]\u0019aA\u0005tG\r\t1uS6,7\u000f^1naJ\u0002g&\u0001\u0005fqR,g\u000eZ3eC\t\tI+A0\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n\u0014(O\u001c.aIj#\u0007\u000f\u00112ai\u001a\u0004G\u000f\u00191O1\u0002s%M\u001d:m5\n\u0004'L\u001a1O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0018:ie*\u0014HN\u001c8\u0015\u0001\u0002s!CAW\u0005\u0005\u0005\t\u0012AAX\u00035iuN\u001c;ig\n+Go^3f]B\u0019\u0011#!-\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003g\u001bR!!-\u00026\u0002\u0002\u0002\"a.\u0002>\u001a2#'Q\u0007\u0003\u0003sS1!a/\u001d\u0003\u001d\u0011XO\u001c;j[\u0016LA!a0\u0002:\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000f}\n\t\f\"\u0001\u0002DR\u0011\u0011q\u0016\u0005\u000b\u0003\u000f\f\t,!A\u0005F\u0005%\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0003BCAg\u0003c\u000b\t\u0011\"!\u0002P\u0006)\u0011\r\u001d9msR9\u0011)!5\u0002T\u0006U\u0007B\u0002\u0013\u0002L\u0002\u0007a\u0005\u0003\u0004-\u0003\u0017\u0004\rA\n\u0005\ta\u0005-\u0007\u0013!a\u0001e!Q\u0011\u0011\\AY\u0003\u0003%\t)a7\u0002\u000fUt\u0017\r\u001d9msR!\u0011Q\\As!\u0011Y2'a8\u0011\rm\t\tO\n\u00143\u0013\r\t\u0019\u000f\b\u0002\u0007)V\u0004H.Z\u001a\t\u0013\u0005\u001d\u0018q[A\u0001\u0002\u0004\t\u0015a\u0001=%a!Q\u00111^AY#\u0003%\t!!\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0011)\ty/!-\u0012\u0002\u0013\u0005\u0011\u0011I\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q\u00111_AY\u0003\u0003%I!!>\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003o\u0004B!!\u0014\u0002z&!\u00111`A(\u0005\u0019y%M[3di\u0002")
public class MonthsBetween
extends BinaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression date1;
    private final Expression date2;
    private final Option<String> timeZoneId;
    private final boolean resolved;
    private final transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$3() {
        return MonthsBetween$.MODULE$.apply$default$3();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return MonthsBetween$.MODULE$.$lessinit$greater$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, MonthsBetween> tupled() {
        return MonthsBetween$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, MonthsBetween>>> curried() {
        return MonthsBetween$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    private boolean resolved$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression$class.resolved(this);
                this.bitmap$0 = true;
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return this.bitmap$0 ? this.resolved : this.resolved$lzycompute();
    }

    private TimeZone timeZone$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = true;
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return this.bitmap$trans$0 ? this.timeZone : this.timeZone$lzycompute();
    }

    public Expression date1() {
        return this.date1;
    }

    public Expression date2() {
        return this.date2;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.date1();
    }

    @Override
    public Expression right() {
        return this.date2();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType$[]{TimestampType$.MODULE$, TimestampType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$30 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$31 = this.copy$default$1();
        Expression x$32 = this.copy$default$2();
        return this.copy(x$31, x$32, (Option<String>)x$30);
    }

    @Override
    public Object nullSafeEval(Object t1, Object t2) {
        return BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(BoxesRunTime.unboxToLong((Object)t1), BoxesRunTime.unboxToLong((Object)t2), this.timeZone()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceMinorObj(this.timeZone(), ctx.addReferenceMinorObj$default$2());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, tz, dtu){
            public static final long serialVersionUID = 0L;
            private final String tz$9;
            private final String dtu$17;

            public final String apply(String l, String r) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".monthsBetween(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dtu$17, l, r, this.tz$9}));
            }
            {
                this.tz$9 = tz$9;
                this.dtu$17 = dtu$17;
            }
        });
    }

    @Override
    public String prettyName() {
        return "months_between";
    }

    public MonthsBetween copy(Expression date1, Expression date2, Option<String> timeZoneId) {
        return new MonthsBetween(date1, date2, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.date1();
    }

    public Expression copy$default$2() {
        return this.date2();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "MonthsBetween";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 1: {
                object = this.date2();
                break;
            }
            case 0: {
                object = this.date1();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonthsBetween;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MonthsBetween)) return false;
        boolean bl = true;
        if (!bl) return false;
        MonthsBetween monthsBetween = (MonthsBetween)x$1;
        Expression expression = this.date1();
        Expression expression2 = monthsBetween.date1();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.date2();
        Expression expression4 = monthsBetween.date2();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = monthsBetween.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!monthsBetween.canEqual(this)) return false;
        return true;
    }

    public MonthsBetween(Expression date1, Expression date2, Option<String> timeZoneId) {
        this.date1 = date1;
        this.date2 = date2;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression$class.$init$(this);
        ExpectsInputTypes$class.$init$(this);
    }

    public MonthsBetween(Expression date1, Expression date2) {
        this(date1, date2, (Option<String>)None$.MODULE$);
    }
}

