/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.UnsafeColumnWriter;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.UTF8String;
import org.apache.spark.unsafe.PlatformDependent;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}:Q!\u0001\u0002\t\n=\t\u0001d\u0015;sS:<WK\\:bM\u0016\u001cu\u000e\\;n]^\u0013\u0018\u000e^3s\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u0001\u0001C\u0001\t\u0012\u001b\u0005\u0011a!\u0002\n\u0003\u0011\u0013\u0019\"\u0001G*ue&tw-\u00168tC\u001a,7i\u001c7v[:<&/\u001b;feN\u0011\u0011\u0003\u0006\t\u0003!U1AA\u0005\u0002\u0005-M\u0011Qc\u0006\t\u0003!aI!!\u0007\u0002\u0003%Us7/\u00194f\u0007>dW/\u001c8Xe&$XM\u001d\u0005\u00067U!I\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003QAQAH\u000b\u0005\u0002}\tqaZ3u'&TX\rF\u0002!M=\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u00121!\u00138u\u0011\u00159S\u00041\u0001)\u0003\u0019\u0019x.\u001e:dKB\u0011\u0011\u0006\f\b\u0003!)J!a\u000b\u0002\u0002\u000fA\f7m[1hK&\u0011QF\f\u0002\u0004%><(BA\u0016\u0003\u0011\u0015\u0001T\u00041\u0001!\u0003\u0019\u0019w\u000e\\;n]\")!'\u0006C!g\u0005)qO]5uKR)\u0001\u0005N\u001b;w!)q%\ra\u0001Q!)a'\ra\u0001o\u00051A/\u0019:hKR\u0004\"\u0001\u0005\u001d\n\u0005e\u0012!!C+og\u00064WMU8x\u0011\u0015\u0001\u0014\u00071\u0001!\u0011\u0015a\u0014\u00071\u0001!\u00031\t\u0007\u000f]3oI\u000e+(o]8s\u0011\u0015Y\u0012\u0003\"\u0001?)\u0005y\u0001")
public class StringUnsafeColumnWriter
extends UnsafeColumnWriter {
    @Override
    public int getSize(Row source, int column) {
        int numBytes = ((UTF8String)source.get(column)).getBytes().length;
        return 8 + ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
    }

    @Override
    public int write(Row source, UnsafeRow target, int column, int appendCursor) {
        UTF8String value = (UTF8String)source.get(column);
        Object baseObject = target.getBaseObject();
        long baseOffset = target.getBaseOffset();
        int numBytes = value.getBytes().length;
        PlatformDependent.UNSAFE.putLong((Object)baseObject, (long)(baseOffset + (long)appendCursor), (long)numBytes);
        PlatformDependent.copyMemory((Object)value.getBytes(), (long)PlatformDependent.BYTE_ARRAY_OFFSET, (Object)baseObject, (long)(baseOffset + (long)appendCursor + 8L), (long)numBytes);
        target.setLong(column, appendCursor);
        return 8 + ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
    }
}

