/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.PageTool;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrParamResourceLoader;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.SolrVelocityResourceLoader;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.ComparisonDateTool;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.ListTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.SortTool;

public class VelocityResponseWriter
implements QueryResponseWriter {
    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        boolean wrap_response;
        VelocityEngine engine = this.getEngine(request);
        Template template = this.getTemplate(engine, request);
        VelocityContext context = new VelocityContext();
        context.put("request", (Object)request);
        QueryResponse rsp = new QueryResponse();
        NamedList parsedResponse = BinaryResponseWriter.getParsedResponse((SolrQueryRequest)request, (SolrQueryResponse)response);
        try {
            rsp.setResponse(parsedResponse);
            context.put("page", (Object)new PageTool(request, response));
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            rsp = new SolrResponseBase();
            rsp.setResponse(parsedResponse);
        }
        context.put("response", (Object)rsp);
        context.put("esc", (Object)new EscapeTool());
        context.put("date", (Object)new ComparisonDateTool());
        context.put("list", (Object)new ListTool());
        context.put("math", (Object)new MathTool());
        context.put("number", (Object)new NumberTool());
        context.put("sort", (Object)new SortTool());
        context.put("engine", (Object)engine);
        HashMap<String, String> mimeToExt = new HashMap<String, String>(){
            {
                this.put("application/x-7z-compressed", "7z");
                this.put("application/postscript", "ai");
                this.put("application/pgp-signature", "asc");
                this.put("application/octet-stream", "bin");
                this.put("application/x-bzip2", "bz2");
                this.put("text/x-c", "c");
                this.put("application/vnd.ms-htmlhelp", "chm");
                this.put("application/java-vm", "class");
                this.put("text/css", "css");
                this.put("text/csv", "csv");
                this.put("application/x-debian-package", "deb");
                this.put("application/msword", "doc");
                this.put("message/rfc822", "eml");
                this.put("image/gif", "gif");
                this.put("application/winhlp", "hlp");
                this.put("text/html", "html");
                this.put("application/java-archive", "jar");
                this.put("text/x-java-source", "java");
                this.put("image/jpeg", "jpeg");
                this.put("application/javascript", "js");
                this.put("application/vnd.oasis.opendocument.chart", "odc");
                this.put("application/vnd.oasis.opendocument.formula", "odf");
                this.put("application/vnd.oasis.opendocument.graphics", "odg");
                this.put("application/vnd.oasis.opendocument.image", "odi");
                this.put("application/vnd.oasis.opendocument.presentation", "odp");
                this.put("application/vnd.oasis.opendocument.spreadsheet", "ods");
                this.put("application/vnd.oasis.opendocument.text", "odt");
                this.put("application/pdf", "pdf");
                this.put("application/pgp-encrypted", "pgp");
                this.put("image/png", "png");
                this.put("application/vnd.ms-powerpoint", "ppt");
                this.put("audio/x-pn-realaudio", "ram");
                this.put("application/x-rar-compressed", "rar");
                this.put("application/vnd.rn-realmedia", "rm");
                this.put("application/rtf", "rtf");
                this.put("application/x-shockwave-flash", "swf");
                this.put("application/vnd.sun.xml.calc", "sxc");
                this.put("application/vnd.sun.xml.draw", "sxd");
                this.put("application/vnd.sun.xml.impress", "sxi");
                this.put("application/vnd.sun.xml.writer", "sxw");
                this.put("application/x-tar", "tar");
                this.put("application/x-tex", "tex");
                this.put("text/plain", "txt");
                this.put("text/x-vcard", "vcf");
                this.put("application/vnd.visio", "vsd");
                this.put("audio/x-wav", "wav");
                this.put("audio/x-ms-wma", "wma");
                this.put("video/x-ms-wmv", "wmv");
                this.put("application/vnd.ms-excel", "xls");
                this.put("application/xml", "xml");
                this.put("application/x-xpinstall", "xpi");
                this.put("application/zip", "zip");
            }
        };
        context.put("mimeToExt", (Object)mimeToExt);
        String layout_template = request.getParams().get("v.layout");
        String json_wrapper = request.getParams().get("v.json");
        boolean bl = wrap_response = layout_template != null || json_wrapper != null;
        if (wrap_response) {
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)context, (Writer)stringWriter);
            if (layout_template != null) {
                context.put("content", (Object)stringWriter.toString());
                stringWriter = new StringWriter();
                try {
                    engine.getTemplate(layout_template + ".vm").merge((Context)context, (Writer)stringWriter);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            if (json_wrapper != null) {
                writer.write(request.getParams().get("v.json") + "(");
                writer.write(this.getJSONWrap(stringWriter.toString()));
                writer.write(41);
            } else {
                writer.write(stringWriter.toString());
            }
        } else {
            template.merge((Context)context, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VelocityEngine getEngine(SolrQueryRequest request) {
        VelocityEngine engine;
        block12: {
            engine = new VelocityEngine();
            engine.setProperty("params.resource.loader.instance", (Object)new SolrParamResourceLoader(request));
            SolrVelocityResourceLoader resourceLoader = new SolrVelocityResourceLoader(request.getCore().getSolrConfig().getResourceLoader());
            engine.setProperty("solr.resource.loader.instance", (Object)resourceLoader);
            File fileResourceLoaderBaseDir = null;
            try {
                String template_root = request.getParams().get("v.base_dir");
                fileResourceLoaderBaseDir = new File(request.getCore().getResourceLoader().getConfigDir(), "velocity");
                if (template_root != null) {
                    fileResourceLoaderBaseDir = new File(template_root);
                }
            }
            catch (SolrException e) {
                // empty catch block
            }
            if (fileResourceLoaderBaseDir != null) {
                engine.setProperty("file.resource.loader.path", (Object)fileResourceLoaderBaseDir.getAbsolutePath());
                engine.setProperty("resource.loader", (Object)"params,file,solr");
            } else {
                engine.setProperty("resource.loader", (Object)"params,solr");
            }
            String propFile = request.getParams().get("v.properties");
            try {
                if (propFile == null) {
                    engine.init();
                    break block12;
                }
                InputStream is = null;
                try {
                    is = resourceLoader.getResourceStream(propFile);
                    Properties props = new Properties();
                    props.load(is);
                    engine.init(props);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return engine;
    }

    private Template getTemplate(VelocityEngine engine, SolrQueryRequest request) throws IOException {
        Template template;
        String template_name = request.getParams().get("v.template");
        String qt = request.getParams().get("qt");
        String path = (String)request.getContext().get("path");
        if (template_name == null && path != null) {
            template_name = path;
        }
        if (template_name == null && qt != null) {
            template_name = qt;
        }
        if (template_name == null) {
            template_name = "index";
        }
        try {
            template = engine.getTemplate(template_name + ".vm");
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return template;
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return request.getParams().get("v.contentType", "text/html;charset=UTF-8");
    }

    private String getJSONWrap(String xmlResult) {
        String replace1 = xmlResult.replaceAll("\\\\", "\\\\\\\\");
        replace1 = replace1.replaceAll("\\n", "\\\\n");
        replace1 = replace1.replaceAll("\\r", "\\\\r");
        String replaced = replace1.replaceAll("\"", "\\\\\"");
        return "{\"result\":\"" + replaced + "\"}";
    }

    public void init(NamedList args) {
    }
}

