/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.PageTool;
import org.apache.solr.request.QueryResponseWriter;
import org.apache.solr.request.SolrParamResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.SolrVelocityResourceLoader;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.ComparisonDateTool;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.ListTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.SortTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityResponseWriter
implements QueryResponseWriter {
    private static final Logger log = LoggerFactory.getLogger(VelocityResponseWriter.class);

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        boolean wrap_response;
        VelocityEngine engine = this.getEngine(request);
        Template template = this.getTemplate(engine, request);
        VelocityContext context = new VelocityContext();
        context.put("request", (Object)request);
        QueryResponse rsp = new QueryResponse();
        NamedList parsedResponse = new EmbeddedSolrServer(request.getCore()).getParsedResponse(request, response);
        try {
            rsp.setResponse(parsedResponse);
            context.put("page", (Object)new PageTool(request, response));
        }
        catch (ClassCastException e) {
            rsp = new SolrResponseBase();
            rsp.setResponse(parsedResponse);
        }
        context.put("response", (Object)rsp);
        context.put("esc", (Object)new EscapeTool());
        context.put("sort", (Object)new SortTool());
        context.put("number", (Object)new NumberTool());
        context.put("list", (Object)new ListTool());
        context.put("date", (Object)new ComparisonDateTool());
        context.put("math", (Object)new MathTool());
        context.put("engine", (Object)engine);
        String layout_template = request.getParams().get("v.layout");
        String json_wrapper = request.getParams().get("v.json");
        boolean bl = wrap_response = layout_template != null || json_wrapper != null;
        if (wrap_response) {
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)context, (Writer)stringWriter);
            if (layout_template != null) {
                context.put("content", (Object)stringWriter.toString());
                stringWriter = new StringWriter();
                try {
                    engine.getTemplate(layout_template + ".vm").merge((Context)context, (Writer)stringWriter);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            if (json_wrapper != null) {
                writer.write(request.getParams().get("v.json") + "(");
                writer.write(this.getJSONWrap(stringWriter.toString()));
                writer.write(41);
            } else {
                writer.write(stringWriter.toString());
            }
        } else {
            template.merge((Context)context, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VelocityEngine getEngine(SolrQueryRequest request) {
        VelocityEngine engine;
        block8: {
            engine = new VelocityEngine();
            String template_root = request.getParams().get("v.base_dir");
            File baseDir = new File(request.getCore().getResourceLoader().getConfigDir(), "velocity");
            if (template_root != null) {
                baseDir = new File(template_root);
            }
            engine.setProperty("file.resource.loader.path", (Object)baseDir.getAbsolutePath());
            engine.setProperty("params.resource.loader.instance", (Object)new SolrParamResourceLoader(request));
            SolrVelocityResourceLoader resourceLoader = new SolrVelocityResourceLoader(request.getCore().getSolrConfig().getResourceLoader());
            engine.setProperty("solr.resource.loader.instance", (Object)resourceLoader);
            engine.setProperty("resource.loader", (Object)"params,file,solr");
            String propFile = request.getParams().get("v.properties");
            try {
                if (propFile == null) {
                    engine.init();
                    break block8;
                }
                InputStream is = null;
                try {
                    is = resourceLoader.getResourceStream(propFile);
                    Properties props = new Properties();
                    props.load(is);
                    engine.init(props);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return engine;
    }

    private Template getTemplate(VelocityEngine engine, SolrQueryRequest request) throws IOException {
        Template template;
        String template_name = request.getParams().get("v.template");
        String qt = request.getParams().get("qt");
        String path = (String)request.getContext().get("path");
        if (template_name == null && path != null) {
            template_name = path;
        }
        if (template_name == null && qt != null) {
            template_name = qt;
        }
        if (template_name == null) {
            template_name = "index";
        }
        try {
            template = engine.getTemplate(template_name + ".vm");
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return template;
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return request.getParams().get("v.contentType", "text/html");
    }

    private String getJSONWrap(String xmlResult) {
        String replace1 = xmlResult.replaceAll("\\\\", "\\\\\\\\");
        replace1 = replace1.replaceAll("\\n", "\\\\n");
        replace1 = replace1.replaceAll("\\r", "\\\\r");
        String replaced = replace1.replaceAll("\"", "\\\\\"");
        return "{\"result\":\"" + replaced + "\"}";
    }

    public void init(NamedList args) {
    }
}

