/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.XML;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class BaseTestHarness {
    private static final ThreadLocal<DocumentBuilder> builderTL = new ThreadLocal();
    private static final ThreadLocal<XPath> xpathTL = new ThreadLocal();

    public static DocumentBuilder getXmlDocumentBuilder() {
        try {
            DocumentBuilder builder = builderTL.get();
            if (builder == null) {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                builderTL.set(builder);
            }
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static XPath getXpath() {
        try {
            XPath xpath = xpathTL.get();
            if (xpath == null) {
                xpath = XPathFactory.newInstance().newXPath();
                xpathTL.set(xpath);
            }
            return xpath;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String validateXPath(String xml, String ... tests) throws XPathExpressionException, SAXException {
        Document document;
        if (tests == null || tests.length == 0) {
            return null;
        }
        try {
            document = BaseTestHarness.getXmlDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException("Totally weird UTF-8 exception", e1);
        }
        catch (IOException e2) {
            throw new RuntimeException("Totally weird io exception", e2);
        }
        for (String xp : tests) {
            xp = xp.trim();
            Boolean bool = (Boolean)BaseTestHarness.getXpath().evaluate(xp, document, XPathConstants.BOOLEAN);
            if (bool.booleanValue()) continue;
            return xp;
        }
        return null;
    }

    public static Object evaluateXPath(String xml, String xpath, QName returnType) throws XPathExpressionException, SAXException {
        Document document;
        if (null == xpath) {
            return null;
        }
        try {
            document = BaseTestHarness.getXmlDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException("Totally weird UTF-8 exception", e1);
        }
        catch (IOException e2) {
            throw new RuntimeException("Totally weird io exception", e2);
        }
        xpath = xpath.trim();
        return BaseTestHarness.getXpath().evaluate(xpath.trim(), document, returnType);
    }

    public static String makeSimpleDoc(String ... fieldsAndValues) {
        try {
            StringWriter w = new StringWriter();
            w.append("<doc>");
            for (int i = 0; i < fieldsAndValues.length; i += 2) {
                XML.writeXML((Writer)w, (String)"field", (String)fieldsAndValues[i + 1], (Object[])new Object[]{"name", fieldsAndValues[i]});
            }
            w.append("</doc>");
            return w.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String deleteByQuery(String q, String ... args) {
        try {
            StringWriter r = new StringWriter();
            XML.writeXML((Writer)r, (String)"query", (String)q, (Object[])new Object[0]);
            return BaseTestHarness.delete(r.getBuffer().toString(), args);
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String deleteById(String id, String ... args) {
        try {
            StringWriter r = new StringWriter();
            XML.writeXML((Writer)r, (String)"id", (String)id, (Object[])new Object[0]);
            return BaseTestHarness.delete(r.getBuffer().toString(), args);
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    private static String delete(String val, String ... args) {
        try {
            StringWriter r = new StringWriter();
            XML.writeUnescapedXML((Writer)r, (String)"delete", (String)val, (Object[])args);
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String optimize(String ... args) {
        return BaseTestHarness.simpleTag("optimize", args);
    }

    public static String simpleTag(String tag, String ... args) {
        try {
            StringWriter writer = new StringWriter();
            XML.writeXML((Writer)writer, (String)tag, (String)null, (Object[])args);
            return writer.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String commit(String ... args) {
        return BaseTestHarness.simpleTag("commit", args);
    }

    public abstract void reload() throws Exception;

    public abstract String update(String var1);

    public String validateUpdate(String xml) throws SAXException {
        return this.checkUpdateStatus(xml, "0");
    }

    public String validateErrorUpdate(String xml) throws SAXException {
        try {
            return this.checkUpdateStatus(xml, "1");
        }
        catch (SolrException e) {
            return null;
        }
    }

    public String checkUpdateStatus(String xml, String code) throws SAXException {
        try {
            String res = this.update(xml);
            String valid = BaseTestHarness.validateXPath(res, "//int[@name='status']=" + code);
            return null == valid ? null : res;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("?!? static xpath has bug?", e);
        }
    }
}

