/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.cloud.CloudInspectUtil;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.util.LogLevel;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LogLevel(value="org.apache.solr.update.processor.DistributedZkUpdateProcessor=WARN")
public abstract class AbstractSyncSliceTestBase
extends AbstractFullDistribZkTestBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean success = false;

    @Override
    public void distribTearDown() throws Exception {
        if (!this.success) {
            this.printLayoutOnTearDown = true;
        }
        super.distribTearDown();
    }

    public AbstractSyncSliceTestBase() {
        this.sliceCount = 1;
        this.fixShardCount(TEST_NIGHTLY ? 7 : 4);
    }

    @Test
    public void test() throws Exception {
        this.handle.clear();
        this.handle.put("timestamp", 4);
        this.waitForThingsToLevelOut(30, TimeUnit.SECONDS);
        this.del("*:*");
        List<AbstractFullDistribZkTestBase.CloudJettyRunner> skipServers = new ArrayList<AbstractFullDistribZkTestBase.CloudJettyRunner>();
        int docId = 0;
        this.indexDoc(skipServers, this.id, docId++, this.i1, 50, this.tlong, 50, this.t1, "to come to the aid of their country.");
        this.indexDoc(skipServers, this.id, docId++, this.i1, 50, this.tlong, 50, this.t1, "old haven was blue.");
        skipServers.add((AbstractFullDistribZkTestBase.CloudJettyRunner)((List)this.shardToJetty.get("shard1")).get(1));
        this.indexDoc(skipServers, this.id, docId++, this.i1, 50, this.tlong, 50, this.t1, "but the song was fancy.");
        skipServers.add((AbstractFullDistribZkTestBase.CloudJettyRunner)((List)this.shardToJetty.get("shard1")).get(2));
        this.indexDoc(skipServers, this.id, docId++, this.i1, 50, this.tlong, 50, this.t1, "under the moon and over the lake");
        this.commit();
        this.waitForRecoveriesToFinish(false);
        String shardFailMessage = this.checkShardConsistency("shard1", true, false);
        AbstractSyncSliceTestBase.assertNotNull((Object)shardFailMessage);
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CollectionParams.CollectionAction.SYNCSHARD.toString()});
        params.set("collection", new String[]{"collection1"});
        params.set("shard", new String[]{"shard1"});
        GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/collections", (SolrParams)params);
        String baseUrl = ((AbstractFullDistribZkTestBase.CloudJettyRunner)((List)this.shardToJetty.get((Object)"shard1")).get((int)2)).jetty.getBaseUrl().toString();
        try (HttpSolrClient baseClient = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(baseUrl).withConnectionTimeout(30000, TimeUnit.MILLISECONDS)).build();){
            baseClient.request((SolrRequest)request);
        }
        this.waitForThingsToLevelOut(15, TimeUnit.SECONDS);
        this.checkShardConsistency(false, true);
        long cloudClientDocs = this.cloudClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        AbstractSyncSliceTestBase.assertEquals((long)4L, (long)cloudClientDocs);
        AbstractFullDistribZkTestBase.CloudJettyRunner leaderJetty = (AbstractFullDistribZkTestBase.CloudJettyRunner)this.shardToLeaderJetty.get("shard1");
        skipServers = this.getRandomOtherJetty(leaderJetty, null);
        this.indexDoc(skipServers, this.id, docId++, this.i1, 50, this.tlong, 50, this.t1, "to come to the aid of their country.");
        this.commit();
        HashSet jetties = new HashSet();
        jetties.addAll((Collection)this.shardToJetty.get("shard1"));
        jetties.remove(leaderJetty);
        AbstractSyncSliceTestBase.assertEquals((long)(this.getShardCount() - 1), (long)jetties.size());
        leaderJetty.jetty.stop();
        Thread.sleep(3000L);
        this.waitForNoShardInconsistency();
        Thread.sleep(1000L);
        this.checkShardConsistency(false, true);
        cloudClientDocs = this.cloudClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        AbstractSyncSliceTestBase.assertEquals((long)5L, (long)cloudClientDocs);
        AbstractFullDistribZkTestBase.CloudJettyRunner deadJetty = leaderJetty;
        while (deadJetty.equals(leaderJetty)) {
            this.updateMappingsFromZk(this.jettys, this.clients);
            leaderJetty = (AbstractFullDistribZkTestBase.CloudJettyRunner)this.shardToLeaderJetty.get("shard1");
        }
        deadJetty.jetty.start();
        this.waitTillAllNodesActive();
        skipServers = this.getRandomOtherJetty(leaderJetty, deadJetty);
        skipServers.addAll(this.getRandomOtherJetty(leaderJetty, deadJetty));
        AbstractSyncSliceTestBase.assertEquals((long)2L, (long)skipServers.size());
        for (int i = 0; i < 300; ++i) {
            this.indexDoc(skipServers, this.id, docId++, this.i1, 50, this.tlong, 50, this.t1, "to come to the aid of their country.");
        }
        this.commit();
        this.waitForRecoveriesToFinish(false);
        shardFailMessage = this.waitTillInconsistent();
        AbstractSyncSliceTestBase.assertNotNull((String)("Test Setup Failure: shard1 should have just been set up to be inconsistent - but it's still consistent. Leader:" + leaderJetty.url + " Dead Guy:" + deadJetty.url + "skip list:" + skipServers), (Object)shardFailMessage);
        boolean shouldFail = CloudInspectUtil.compareResults(this.controlClient, (SolrClient)this.cloudClient);
        AbstractSyncSliceTestBase.assertTrue((String)"A test that compareResults is working correctly failed", (boolean)shouldFail);
        jetties = new HashSet();
        jetties.addAll((Collection)this.shardToJetty.get("shard1"));
        jetties.remove(leaderJetty);
        AbstractSyncSliceTestBase.assertEquals((long)(this.getShardCount() - 1), (long)jetties.size());
        leaderJetty.jetty.stop();
        this.waitForNoShardInconsistency();
        this.checkShardConsistency(true, true);
        this.success = true;
    }

    private void waitTillAllNodesActive() throws InterruptedException, TimeoutException {
        ZkStateReader zkStateReader = ZkStateReader.from((CloudSolrClient)this.cloudClient);
        zkStateReader.waitForState("collection1", 3L, TimeUnit.MINUTES, (n, c) -> {
            Collection replicas = c.getSlice("shard1").getReplicas();
            Set nodes = replicas.stream().map(Replica::getNodeName).collect(Collectors.toSet());
            return replicas.stream().map(Replica::getState).allMatch(arg_0 -> Replica.State.ACTIVE.equals(arg_0)) && n.containsAll(nodes);
        });
    }

    private String waitTillInconsistent() throws Exception, InterruptedException {
        String shardFailMessage = null;
        shardFailMessage = this.pollConsistency(shardFailMessage, 0);
        shardFailMessage = this.pollConsistency(shardFailMessage, 3000);
        shardFailMessage = this.pollConsistency(shardFailMessage, 5000);
        shardFailMessage = this.pollConsistency(shardFailMessage, 15000);
        return shardFailMessage;
    }

    private String pollConsistency(String shardFailMessage, int sleep) throws InterruptedException, Exception {
        try {
            this.commit();
        }
        catch (Throwable t) {
            log.error("commit error", t);
        }
        if (shardFailMessage == null) {
            Thread.sleep(sleep);
            shardFailMessage = this.checkShardConsistency("shard1", true, false);
        }
        return shardFailMessage;
    }

    private List<AbstractFullDistribZkTestBase.CloudJettyRunner> getRandomOtherJetty(AbstractFullDistribZkTestBase.CloudJettyRunner leader, AbstractFullDistribZkTestBase.CloudJettyRunner down) {
        ArrayList<AbstractFullDistribZkTestBase.CloudJettyRunner> skipServers = new ArrayList<AbstractFullDistribZkTestBase.CloudJettyRunner>();
        ArrayList candidates = new ArrayList();
        candidates.addAll((Collection)this.shardToJetty.get("shard1"));
        if (leader != null) {
            candidates.remove(leader);
        }
        if (down != null) {
            candidates.remove(down);
        }
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty = (AbstractFullDistribZkTestBase.CloudJettyRunner)candidates.get(AbstractSyncSliceTestBase.random().nextInt(candidates.size()));
        skipServers.add(cjetty);
        return skipServers;
    }

    protected void indexDoc(List<AbstractFullDistribZkTestBase.CloudJettyRunner> skipServers, Object ... fields) throws IOException, SolrServerException {
        SolrInputDocument doc = new SolrInputDocument();
        AbstractSyncSliceTestBase.addFields(doc, fields);
        AbstractSyncSliceTestBase.addFields(doc, "rnd_b", true);
        this.controlClient.add(doc);
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(doc);
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (AbstractFullDistribZkTestBase.CloudJettyRunner skip : skipServers) {
            params.add("test.distrib.skip.servers", new String[]{skip.url + "/"});
        }
        ureq.setParams(params);
        ureq.process((SolrClient)this.cloudClient);
    }

    @Override
    protected void indexr(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        AbstractSyncSliceTestBase.addFields(doc, fields);
        AbstractSyncSliceTestBase.addFields(doc, "rnd_b", true);
        this.indexDoc(doc);
    }
}

