/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.api.model.CloneConfigsetRequestBody;
import org.apache.solr.client.api.model.ListConfigsetsResponse;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class ConfigsetsApi {

    public static class UploadConfigSetFile
    extends SolrRequest<UploadConfigSetFileResponse> {
        private final Object requestBody;
        private final String configSetName;
        private final String filePath;
        private Boolean overwrite;
        private Boolean cleanup;

        public UploadConfigSetFile(String configSetName, String filePath) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/configsets/{configSetName}/{filePath}".replace("{configSetName}", configSetName).replace("{filePath}", filePath));
            this.configSetName = configSetName;
            this.filePath = filePath;
            this.requestBody = new HashMap();
        }

        public void setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
        }

        public void setCleanup(Boolean cleanup) {
            this.cleanup = cleanup;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.overwrite != null) {
                params.add("overwrite", this.overwrite.toString());
            }
            if (this.cleanup != null) {
                params.add("cleanup", this.cleanup.toString());
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("overwrite");
            queryParams.add("cleanup");
            return queryParams;
        }

        @Override
        protected UploadConfigSetFileResponse createResponse(SolrClient client) {
            return new UploadConfigSetFileResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class UploadConfigSetFileResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public UploadConfigSetFileResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class UploadConfigSet
    extends SolrRequest<UploadConfigSetResponse> {
        private final Object requestBody;
        private final String configSetName;
        private Boolean overwrite;
        private Boolean cleanup;

        public UploadConfigSet(String configSetName) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/configsets/{configSetName}".replace("{configSetName}", configSetName));
            this.configSetName = configSetName;
            this.requestBody = new HashMap();
        }

        public void setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
        }

        public void setCleanup(Boolean cleanup) {
            this.cleanup = cleanup;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.overwrite != null) {
                params.add("overwrite", this.overwrite.toString());
            }
            if (this.cleanup != null) {
                params.add("cleanup", this.cleanup.toString());
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("overwrite");
            queryParams.add("cleanup");
            return queryParams;
        }

        @Override
        protected UploadConfigSetResponse createResponse(SolrClient client) {
            return new UploadConfigSetResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class UploadConfigSetResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public UploadConfigSetResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class ListConfigSet
    extends SolrRequest<ListConfigSetResponse> {
        public ListConfigSet() {
            super(SolrRequest.METHOD.valueOf("GET"), "/configsets");
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ListConfigSetResponse createResponse(SolrClient client) {
            return new ListConfigSetResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListConfigSetResponse
    extends JacksonParsingResponse<ListConfigsetsResponse> {
        public ListConfigSetResponse() {
            super(ListConfigsetsResponse.class);
        }
    }

    public static class DeleteConfigSet
    extends SolrRequest<DeleteConfigSetResponse> {
        private final String configSetName;

        public DeleteConfigSet(String configSetName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/configsets/{configSetName}".replace("{configSetName}", configSetName));
            this.configSetName = configSetName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected DeleteConfigSetResponse createResponse(SolrClient client) {
            return new DeleteConfigSetResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteConfigSetResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public DeleteConfigSetResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class CloneExistingConfigSet
    extends SolrRequest<CloneExistingConfigSetResponse> {
        private final CloneConfigsetRequestBody requestBody = new CloneConfigsetRequestBody();

        public CloneExistingConfigSet() {
            super(SolrRequest.METHOD.valueOf("POST"), "/configsets");
        }

        public void setName(String name) {
            this.requestBody.name = name;
        }

        public void setBaseConfigSet(String baseConfigSet) {
            this.requestBody.baseConfigSet = baseConfigSet;
        }

        public void setProperties(Map<String, Object> properties) {
            this.requestBody.properties = properties;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected CloneExistingConfigSetResponse createResponse(SolrClient client) {
            return new CloneExistingConfigSetResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CloneExistingConfigSetResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public CloneExistingConfigSetResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

